"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..network_type import NetworkType


class VMWExternalNetworkType(NetworkType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vim_port_group_ref': 'VimObjectRefType',
        'vim_port_group_refs': 'VimObjectRefsType'
    }

    attribute_map = {
        'vim_port_group_ref': 'vimPortGroupRef',
        'vim_port_group_refs': 'vimPortGroupRefs'
    }

    def __init__(self, vim_port_group_ref=None,vim_port_group_refs=None):
        self._vim_port_group_ref = None
        self._vim_port_group_refs = None

        if vim_port_group_ref is not None:
            self.vim_port_group_ref = vim_port_group_ref
        if vim_port_group_refs is not None:
            self.vim_port_group_refs = vim_port_group_refs

    @property
    def vim_port_group_ref(self):
        return self._vim_port_group_ref
    
    @vim_port_group_ref.setter
    def vim_port_group_ref(self, vim_port_group_ref):
        self._vim_port_group_ref = vim_port_group_ref

    @property
    def vim_port_group_refs(self):
        return self._vim_port_group_refs
    
    @vim_port_group_refs.setter
    def vim_port_group_refs(self, vim_port_group_refs):
        self._vim_port_group_refs = vim_port_group_refs


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWExternalNetworkType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
