"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class VMWDiscoveredResourcePoolType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'resource_pool_vim_object_ref': 'VimObjectRefType',
        'name': 'str',
        'valid_candidate': 'bool'
    }

    attribute_map = {
        'resource_pool_vim_object_ref': 'resourcePoolVimObjectRef',
        'name': 'name',
        'valid_candidate': 'validCandidate'
    }

    def __init__(self, resource_pool_vim_object_ref=None,name=None,valid_candidate=None):
        self._resource_pool_vim_object_ref = None
        self._name = None
        self._valid_candidate = None

        if resource_pool_vim_object_ref is not None:
            self.resource_pool_vim_object_ref = resource_pool_vim_object_ref
        if name is not None:
            self.name = name
        if valid_candidate is not None:
            self.valid_candidate = valid_candidate

    @property
    def resource_pool_vim_object_ref(self):
        return self._resource_pool_vim_object_ref
    
    @resource_pool_vim_object_ref.setter
    def resource_pool_vim_object_ref(self, resource_pool_vim_object_ref):
        self._resource_pool_vim_object_ref = resource_pool_vim_object_ref

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name

    @property
    def valid_candidate(self):
        return self._valid_candidate
    
    @valid_candidate.setter
    def valid_candidate(self, valid_candidate):
        self._valid_candidate = valid_candidate


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VMWDiscoveredResourcePoolType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
