"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re


class StrandedItemVimObjectType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'error_message': 'str',
        'vim_object_ref': 'VimObjectRefType',
        'name': 'str'
    }

    attribute_map = {
        'error_message': 'errorMessage',
        'vim_object_ref': 'vimObjectRef',
        'name': 'name'
    }

    def __init__(self, error_message=None,vim_object_ref=None,name=None):
        self._error_message = None
        self._vim_object_ref = None
        self._name = None

        if error_message is not None:
            self.error_message = error_message
        if vim_object_ref is not None:
            self.vim_object_ref = vim_object_ref
        if name is not None:
            self.name = name

    @property
    def error_message(self):
        return self._error_message
    
    @error_message.setter
    def error_message(self, error_message):
        self._error_message = error_message

    @property
    def vim_object_ref(self):
        return self._vim_object_ref
    
    @vim_object_ref.setter
    def vim_object_ref(self, vim_object_ref):
        self._vim_object_ref = vim_object_ref

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StrandedItemVimObjectType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
