"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..entity_type import EntityType


class ResourceClassType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'mime_type': 'str',
        'url_template': 'str',
        'nid': 'str',
        'urn_pattern': 'str',
        'service_resources': 'ServiceResourcesType',
        'resource_class_actions': 'ResourceClassActionsType'
    }

    attribute_map = {
        'mime_type': 'mimeType',
        'url_template': 'urlTemplate',
        'nid': 'nid',
        'urn_pattern': 'urnPattern',
        'service_resources': 'serviceResources',
        'resource_class_actions': 'resourceClassActions'
    }

    def __init__(self, mime_type=None,url_template=None,nid=None,urn_pattern=None,service_resources=None,resource_class_actions=None):
        self._mime_type = None
        self._url_template = None
        self._nid = None
        self._urn_pattern = None
        self._service_resources = None
        self._resource_class_actions = None

        if mime_type is not None:
            self.mime_type = mime_type
        if url_template is not None:
            self.url_template = url_template
        if nid is not None:
            self.nid = nid
        if urn_pattern is not None:
            self.urn_pattern = urn_pattern
        if service_resources is not None:
            self.service_resources = service_resources
        if resource_class_actions is not None:
            self.resource_class_actions = resource_class_actions

    @property
    def mime_type(self):
        return self._mime_type
    
    @mime_type.setter
    def mime_type(self, mime_type):
        self._mime_type = mime_type

    @property
    def url_template(self):
        return self._url_template
    
    @url_template.setter
    def url_template(self, url_template):
        self._url_template = url_template

    @property
    def nid(self):
        return self._nid
    
    @nid.setter
    def nid(self, nid):
        self._nid = nid

    @property
    def urn_pattern(self):
        return self._urn_pattern
    
    @urn_pattern.setter
    def urn_pattern(self, urn_pattern):
        self._urn_pattern = urn_pattern

    @property
    def service_resources(self):
        return self._service_resources
    
    @service_resources.setter
    def service_resources(self, service_resources):
        self._service_resources = service_resources

    @property
    def resource_class_actions(self):
        return self._resource_class_actions
    
    @resource_class_actions.setter
    def resource_class_actions(self, resource_class_actions):
        self._resource_class_actions = resource_class_actions


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ResourceClassType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
