"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..v_cloud_extensible_type import VCloudExtensibleType


class RealmType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'domain': 'list[str]',
        'kdc': 'str',
        'name': 'str'
    }

    attribute_map = {
        'domain': 'domain',
        'kdc': 'kdc',
        'name': 'name'
    }

    def __init__(self, domain=None,kdc=None,name=None):
        self._domain = None
        self._kdc = None
        self._name = None

        if domain is not None:
            self.domain = domain
        if kdc is not None:
            self.kdc = kdc
        if name is not None:
            self.name = name

    @property
    def domain(self):
        return self._domain
    
    @domain.setter
    def domain(self, domain):
        self._domain = domain

    @property
    def kdc(self):
        return self._kdc
    
    @kdc.setter
    def kdc(self, kdc):
        self._kdc = kdc

    @property
    def name(self):
        return self._name
    
    @name.setter
    def name(self, name):
        self._name = name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RealmType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
