"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .vmw_network_pool_type import VMWNetworkPoolType


class PortGroupPoolType(VMWNetworkPoolType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'port_group_refs': 'VimObjectRefsType',
        'vim_server': 'ReferenceType',
        'used_networks_count': 'int'
    }

    attribute_map = {
        'port_group_refs': 'portGroupRefs',
        'vim_server': 'vimServer',
        'used_networks_count': 'usedNetworksCount'
    }

    def __init__(self, port_group_refs=None,vim_server=None,used_networks_count=None):
        self._port_group_refs = None
        self._vim_server = None
        self._used_networks_count = None

        if port_group_refs is not None:
            self.port_group_refs = port_group_refs
        if vim_server is not None:
            self.vim_server = vim_server
        if used_networks_count is not None:
            self.used_networks_count = used_networks_count

    @property
    def port_group_refs(self):
        return self._port_group_refs
    
    @port_group_refs.setter
    def port_group_refs(self, port_group_refs):
        self._port_group_refs = port_group_refs

    @property
    def vim_server(self):
        return self._vim_server
    
    @vim_server.setter
    def vim_server(self, vim_server):
        self._vim_server = vim_server

    @property
    def used_networks_count(self):
        return self._used_networks_count
    
    @used_networks_count.setter
    def used_networks_count(self, used_networks_count):
        self._used_networks_count = used_networks_count


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PortGroupPoolType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
