"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class OperationLimitsSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'running_per_user': 'int',
        'running_per_org': 'int',
        'queued_operations_per_user': 'int',
        'queued_operations_per_org': 'int'
    }

    attribute_map = {
        'running_per_user': 'runningPerUser',
        'running_per_org': 'runningPerOrg',
        'queued_operations_per_user': 'queuedOperationsPerUser',
        'queued_operations_per_org': 'queuedOperationsPerOrg'
    }

    def __init__(self, running_per_user=None,running_per_org=None,queued_operations_per_user=None,queued_operations_per_org=None):
        self._running_per_user = None
        self._running_per_org = None
        self._queued_operations_per_user = None
        self._queued_operations_per_org = None

        if running_per_user is not None:
            self.running_per_user = running_per_user
        if running_per_org is not None:
            self.running_per_org = running_per_org
        if queued_operations_per_user is not None:
            self.queued_operations_per_user = queued_operations_per_user
        if queued_operations_per_org is not None:
            self.queued_operations_per_org = queued_operations_per_org

    @property
    def running_per_user(self):
        return self._running_per_user
    
    @running_per_user.setter
    def running_per_user(self, running_per_user):
        self._running_per_user = running_per_user

    @property
    def running_per_org(self):
        return self._running_per_org
    
    @running_per_org.setter
    def running_per_org(self, running_per_org):
        self._running_per_org = running_per_org

    @property
    def queued_operations_per_user(self):
        return self._queued_operations_per_user
    
    @queued_operations_per_user.setter
    def queued_operations_per_user(self, queued_operations_per_user):
        self._queued_operations_per_user = queued_operations_per_user

    @property
    def queued_operations_per_org(self):
        return self._queued_operations_per_org
    
    @queued_operations_per_org.setter
    def queued_operations_per_org(self, queued_operations_per_org):
        self._queued_operations_per_org = queued_operations_per_org


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OperationLimitsSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
