"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class KerberosSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'realm': 'list[RealmType]',
        'allow_lower_case_realms': 'bool'
    }

    attribute_map = {
        'realm': 'realm',
        'allow_lower_case_realms': 'allowLowerCaseRealms'
    }

    def __init__(self, realm=None,allow_lower_case_realms=None):
        self._realm = None
        self._allow_lower_case_realms = None

        if realm is not None:
            self.realm = realm
        if allow_lower_case_realms is not None:
            self.allow_lower_case_realms = allow_lower_case_realms

    @property
    def realm(self):
        return self._realm
    
    @realm.setter
    def realm(self, realm):
        self._realm = realm

    @property
    def allow_lower_case_realms(self):
        return self._allow_lower_case_realms
    
    @allow_lower_case_realms.setter
    def allow_lower_case_realms(self, allow_lower_case_realms):
        self._allow_lower_case_realms = allow_lower_case_realms


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KerberosSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
