"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..params_type import ParamsType


class ImportMediaParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'datastore_mo_ref': 'str',
        'source_path': 'str',
        'vdc': 'ReferenceType',
        'catalog': 'ReferenceType',
        'vdc_storage_profile': 'ReferenceType',
        'source_move': 'bool'
    }

    attribute_map = {
        'datastore_mo_ref': 'datastoreMoRef',
        'source_path': 'sourcePath',
        'vdc': 'vdc',
        'catalog': 'catalog',
        'vdc_storage_profile': 'vdcStorageProfile',
        'source_move': 'sourceMove'
    }

    def __init__(self, datastore_mo_ref=None,source_path=None,vdc=None,catalog=None,vdc_storage_profile=None,source_move=None):
        self._datastore_mo_ref = None
        self._source_path = None
        self._vdc = None
        self._catalog = None
        self._vdc_storage_profile = None
        self._source_move = None

        if datastore_mo_ref is not None:
            self.datastore_mo_ref = datastore_mo_ref
        if source_path is not None:
            self.source_path = source_path
        if vdc is not None:
            self.vdc = vdc
        if catalog is not None:
            self.catalog = catalog
        if vdc_storage_profile is not None:
            self.vdc_storage_profile = vdc_storage_profile
        if source_move is not None:
            self.source_move = source_move

    @property
    def datastore_mo_ref(self):
        return self._datastore_mo_ref
    
    @datastore_mo_ref.setter
    def datastore_mo_ref(self, datastore_mo_ref):
        self._datastore_mo_ref = datastore_mo_ref

    @property
    def source_path(self):
        return self._source_path
    
    @source_path.setter
    def source_path(self, source_path):
        self._source_path = source_path

    @property
    def vdc(self):
        return self._vdc
    
    @vdc.setter
    def vdc(self, vdc):
        self._vdc = vdc

    @property
    def catalog(self):
        return self._catalog
    
    @catalog.setter
    def catalog(self, catalog):
        self._catalog = catalog

    @property
    def vdc_storage_profile(self):
        return self._vdc_storage_profile
    
    @vdc_storage_profile.setter
    def vdc_storage_profile(self, vdc_storage_profile):
        self._vdc_storage_profile = vdc_storage_profile

    @property
    def source_move(self):
        return self._source_move
    
    @source_move.setter
    def source_move(self, source_move):
        self._source_move = source_move


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ImportMediaParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
