"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class GeneralSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'absolute_session_timeout_minutes': 'int',
        'activity_log_display_days': 'int',
        'activity_log_keep_days': 'int',
        'allow_overlapping_ext_nets': 'bool',
        'chargeback_events_keep_days': 'int',
        'chargeback_tables_cleanup_job_time_in_seconds': 'int',
        'console_proxy_external_address': 'str',
        'host_check_delay_in_seconds': 'int',
        'host_check_timeout_seconds': 'int',
        'installation_id': 'int',
        'ip_reservation_timeout_seconds': 'int',
        'syslog_server_settings': 'SyslogServerSettingsType',
        'login_name_only': 'bool',
        'pre_pop_default_name': 'bool',
        'quarantine_enabled': 'bool',
        'quarantine_response_timeout_seconds': 'int',
        'rest_api_base_http_uri': 'str',
        'rest_api_base_uri': 'str',
        'rest_api_base_uri_public_cert_chain': 'str',
        'session_timeout_minutes': 'int',
        'show_stack_traces': 'bool',
        'sync_start_date': 'str',
        'sync_interval_in_hours': 'int',
        'system_external_http_address': 'str',
        'system_external_address': 'str',
        'system_external_address_public_cert_chain': 'str',
        'tenant_portal_external_http_address': 'str',
        'tenant_portal_external_address': 'str',
        'tenant_portal_public_cert_chain': 'str',
        'transfer_session_timeout_seconds': 'int',
        'verify_vc_certificates': 'bool',
        'vc_truststore_password': 'str',
        'vc_truststore_contents': 'list[str]',
        'vc_truststore_type': 'str',
        'vmrc_version': 'str',
        'verify_vsm_certificates': 'bool',
        'elastic_allocation_pool': 'bool',
        'advanced_networking_enabled': 'bool',
        'advanced_networking_dfw_api_url': 'str',
        'advanced_networking_dfw_ui_url': 'str',
        'advanced_networking_gateway_api_url': 'str',
        'advanced_networking_gateway_ui_url': 'str',
        'max_vdc_quota': 'int',
        'sub_interfaces_enabled': 'bool',
        'vm_discovery_enabled': 'bool',
        'allow_fips_mode_for_edge_gateways': 'bool'
    }

    attribute_map = {
        'absolute_session_timeout_minutes': 'absoluteSessionTimeoutMinutes',
        'activity_log_display_days': 'activityLogDisplayDays',
        'activity_log_keep_days': 'activityLogKeepDays',
        'allow_overlapping_ext_nets': 'allowOverlappingExtNets',
        'chargeback_events_keep_days': 'chargebackEventsKeepDays',
        'chargeback_tables_cleanup_job_time_in_seconds': 'chargebackTablesCleanupJobTimeInSeconds',
        'console_proxy_external_address': 'consoleProxyExternalAddress',
        'host_check_delay_in_seconds': 'hostCheckDelayInSeconds',
        'host_check_timeout_seconds': 'hostCheckTimeoutSeconds',
        'installation_id': 'installationId',
        'ip_reservation_timeout_seconds': 'ipReservationTimeoutSeconds',
        'syslog_server_settings': 'syslogServerSettings',
        'login_name_only': 'loginNameOnly',
        'pre_pop_default_name': 'prePopDefaultName',
        'quarantine_enabled': 'quarantineEnabled',
        'quarantine_response_timeout_seconds': 'quarantineResponseTimeoutSeconds',
        'rest_api_base_http_uri': 'restApiBaseHttpUri',
        'rest_api_base_uri': 'restApiBaseUri',
        'rest_api_base_uri_public_cert_chain': 'restApiBaseUriPublicCertChain',
        'session_timeout_minutes': 'sessionTimeoutMinutes',
        'show_stack_traces': 'showStackTraces',
        'sync_start_date': 'syncStartDate',
        'sync_interval_in_hours': 'syncIntervalInHours',
        'system_external_http_address': 'systemExternalHttpAddress',
        'system_external_address': 'systemExternalAddress',
        'system_external_address_public_cert_chain': 'systemExternalAddressPublicCertChain',
        'tenant_portal_external_http_address': 'tenantPortalExternalHttpAddress',
        'tenant_portal_external_address': 'tenantPortalExternalAddress',
        'tenant_portal_public_cert_chain': 'tenantPortalPublicCertChain',
        'transfer_session_timeout_seconds': 'transferSessionTimeoutSeconds',
        'verify_vc_certificates': 'verifyVcCertificates',
        'vc_truststore_password': 'vcTruststorePassword',
        'vc_truststore_contents': 'vcTruststoreContents',
        'vc_truststore_type': 'vcTruststoreType',
        'vmrc_version': 'vmrcVersion',
        'verify_vsm_certificates': 'verifyVsmCertificates',
        'elastic_allocation_pool': 'elasticAllocationPool',
        'advanced_networking_enabled': 'advancedNetworkingEnabled',
        'advanced_networking_dfw_api_url': 'advancedNetworkingDfwApiUrl',
        'advanced_networking_dfw_ui_url': 'advancedNetworkingDfwUiUrl',
        'advanced_networking_gateway_api_url': 'advancedNetworkingGatewayApiUrl',
        'advanced_networking_gateway_ui_url': 'advancedNetworkingGatewayUiUrl',
        'max_vdc_quota': 'maxVdcQuota',
        'sub_interfaces_enabled': 'subInterfacesEnabled',
        'vm_discovery_enabled': 'vmDiscoveryEnabled',
        'allow_fips_mode_for_edge_gateways': 'allowFipsModeForEdgeGateways'
    }

    def __init__(self, absolute_session_timeout_minutes=None,activity_log_display_days=None,activity_log_keep_days=None,allow_overlapping_ext_nets=None,chargeback_events_keep_days=None,chargeback_tables_cleanup_job_time_in_seconds=None,console_proxy_external_address=None,host_check_delay_in_seconds=None,host_check_timeout_seconds=None,installation_id=None,ip_reservation_timeout_seconds=None,syslog_server_settings=None,login_name_only=None,pre_pop_default_name=None,quarantine_enabled=None,quarantine_response_timeout_seconds=None,rest_api_base_http_uri=None,rest_api_base_uri=None,rest_api_base_uri_public_cert_chain=None,session_timeout_minutes=None,show_stack_traces=None,sync_start_date=None,sync_interval_in_hours=None,system_external_http_address=None,system_external_address=None,system_external_address_public_cert_chain=None,tenant_portal_external_http_address=None,tenant_portal_external_address=None,tenant_portal_public_cert_chain=None,transfer_session_timeout_seconds=None,verify_vc_certificates=None,vc_truststore_password=None,vc_truststore_contents=None,vc_truststore_type=None,vmrc_version=None,verify_vsm_certificates=None,elastic_allocation_pool=None,advanced_networking_enabled=None,advanced_networking_dfw_api_url=None,advanced_networking_dfw_ui_url=None,advanced_networking_gateway_api_url=None,advanced_networking_gateway_ui_url=None,max_vdc_quota=None,sub_interfaces_enabled=None,vm_discovery_enabled=None,allow_fips_mode_for_edge_gateways=None):
        self._absolute_session_timeout_minutes = None
        self._activity_log_display_days = None
        self._activity_log_keep_days = None
        self._allow_overlapping_ext_nets = None
        self._chargeback_events_keep_days = None
        self._chargeback_tables_cleanup_job_time_in_seconds = None
        self._console_proxy_external_address = None
        self._host_check_delay_in_seconds = None
        self._host_check_timeout_seconds = None
        self._installation_id = None
        self._ip_reservation_timeout_seconds = None
        self._syslog_server_settings = None
        self._login_name_only = None
        self._pre_pop_default_name = None
        self._quarantine_enabled = None
        self._quarantine_response_timeout_seconds = None
        self._rest_api_base_http_uri = None
        self._rest_api_base_uri = None
        self._rest_api_base_uri_public_cert_chain = None
        self._session_timeout_minutes = None
        self._show_stack_traces = None
        self._sync_start_date = None
        self._sync_interval_in_hours = None
        self._system_external_http_address = None
        self._system_external_address = None
        self._system_external_address_public_cert_chain = None
        self._tenant_portal_external_http_address = None
        self._tenant_portal_external_address = None
        self._tenant_portal_public_cert_chain = None
        self._transfer_session_timeout_seconds = None
        self._verify_vc_certificates = None
        self._vc_truststore_password = None
        self._vc_truststore_contents = None
        self._vc_truststore_type = None
        self._vmrc_version = None
        self._verify_vsm_certificates = None
        self._elastic_allocation_pool = None
        self._advanced_networking_enabled = None
        self._advanced_networking_dfw_api_url = None
        self._advanced_networking_dfw_ui_url = None
        self._advanced_networking_gateway_api_url = None
        self._advanced_networking_gateway_ui_url = None
        self._max_vdc_quota = None
        self._sub_interfaces_enabled = None
        self._vm_discovery_enabled = None
        self._allow_fips_mode_for_edge_gateways = None

        if absolute_session_timeout_minutes is not None:
            self.absolute_session_timeout_minutes = absolute_session_timeout_minutes
        if activity_log_display_days is not None:
            self.activity_log_display_days = activity_log_display_days
        if activity_log_keep_days is not None:
            self.activity_log_keep_days = activity_log_keep_days
        if allow_overlapping_ext_nets is not None:
            self.allow_overlapping_ext_nets = allow_overlapping_ext_nets
        if chargeback_events_keep_days is not None:
            self.chargeback_events_keep_days = chargeback_events_keep_days
        if chargeback_tables_cleanup_job_time_in_seconds is not None:
            self.chargeback_tables_cleanup_job_time_in_seconds = chargeback_tables_cleanup_job_time_in_seconds
        if console_proxy_external_address is not None:
            self.console_proxy_external_address = console_proxy_external_address
        if host_check_delay_in_seconds is not None:
            self.host_check_delay_in_seconds = host_check_delay_in_seconds
        if host_check_timeout_seconds is not None:
            self.host_check_timeout_seconds = host_check_timeout_seconds
        if installation_id is not None:
            self.installation_id = installation_id
        if ip_reservation_timeout_seconds is not None:
            self.ip_reservation_timeout_seconds = ip_reservation_timeout_seconds
        if syslog_server_settings is not None:
            self.syslog_server_settings = syslog_server_settings
        if login_name_only is not None:
            self.login_name_only = login_name_only
        if pre_pop_default_name is not None:
            self.pre_pop_default_name = pre_pop_default_name
        if quarantine_enabled is not None:
            self.quarantine_enabled = quarantine_enabled
        if quarantine_response_timeout_seconds is not None:
            self.quarantine_response_timeout_seconds = quarantine_response_timeout_seconds
        if rest_api_base_http_uri is not None:
            self.rest_api_base_http_uri = rest_api_base_http_uri
        if rest_api_base_uri is not None:
            self.rest_api_base_uri = rest_api_base_uri
        if rest_api_base_uri_public_cert_chain is not None:
            self.rest_api_base_uri_public_cert_chain = rest_api_base_uri_public_cert_chain
        if session_timeout_minutes is not None:
            self.session_timeout_minutes = session_timeout_minutes
        if show_stack_traces is not None:
            self.show_stack_traces = show_stack_traces
        if sync_start_date is not None:
            self.sync_start_date = sync_start_date
        if sync_interval_in_hours is not None:
            self.sync_interval_in_hours = sync_interval_in_hours
        if system_external_http_address is not None:
            self.system_external_http_address = system_external_http_address
        if system_external_address is not None:
            self.system_external_address = system_external_address
        if system_external_address_public_cert_chain is not None:
            self.system_external_address_public_cert_chain = system_external_address_public_cert_chain
        if tenant_portal_external_http_address is not None:
            self.tenant_portal_external_http_address = tenant_portal_external_http_address
        if tenant_portal_external_address is not None:
            self.tenant_portal_external_address = tenant_portal_external_address
        if tenant_portal_public_cert_chain is not None:
            self.tenant_portal_public_cert_chain = tenant_portal_public_cert_chain
        if transfer_session_timeout_seconds is not None:
            self.transfer_session_timeout_seconds = transfer_session_timeout_seconds
        if verify_vc_certificates is not None:
            self.verify_vc_certificates = verify_vc_certificates
        if vc_truststore_password is not None:
            self.vc_truststore_password = vc_truststore_password
        if vc_truststore_contents is not None:
            self.vc_truststore_contents = vc_truststore_contents
        if vc_truststore_type is not None:
            self.vc_truststore_type = vc_truststore_type
        if vmrc_version is not None:
            self.vmrc_version = vmrc_version
        if verify_vsm_certificates is not None:
            self.verify_vsm_certificates = verify_vsm_certificates
        if elastic_allocation_pool is not None:
            self.elastic_allocation_pool = elastic_allocation_pool
        if advanced_networking_enabled is not None:
            self.advanced_networking_enabled = advanced_networking_enabled
        if advanced_networking_dfw_api_url is not None:
            self.advanced_networking_dfw_api_url = advanced_networking_dfw_api_url
        if advanced_networking_dfw_ui_url is not None:
            self.advanced_networking_dfw_ui_url = advanced_networking_dfw_ui_url
        if advanced_networking_gateway_api_url is not None:
            self.advanced_networking_gateway_api_url = advanced_networking_gateway_api_url
        if advanced_networking_gateway_ui_url is not None:
            self.advanced_networking_gateway_ui_url = advanced_networking_gateway_ui_url
        if max_vdc_quota is not None:
            self.max_vdc_quota = max_vdc_quota
        if sub_interfaces_enabled is not None:
            self.sub_interfaces_enabled = sub_interfaces_enabled
        if vm_discovery_enabled is not None:
            self.vm_discovery_enabled = vm_discovery_enabled
        if allow_fips_mode_for_edge_gateways is not None:
            self.allow_fips_mode_for_edge_gateways = allow_fips_mode_for_edge_gateways

    @property
    def absolute_session_timeout_minutes(self):
        return self._absolute_session_timeout_minutes
    
    @absolute_session_timeout_minutes.setter
    def absolute_session_timeout_minutes(self, absolute_session_timeout_minutes):
        self._absolute_session_timeout_minutes = absolute_session_timeout_minutes

    @property
    def activity_log_display_days(self):
        return self._activity_log_display_days
    
    @activity_log_display_days.setter
    def activity_log_display_days(self, activity_log_display_days):
        self._activity_log_display_days = activity_log_display_days

    @property
    def activity_log_keep_days(self):
        return self._activity_log_keep_days
    
    @activity_log_keep_days.setter
    def activity_log_keep_days(self, activity_log_keep_days):
        self._activity_log_keep_days = activity_log_keep_days

    @property
    def allow_overlapping_ext_nets(self):
        return self._allow_overlapping_ext_nets
    
    @allow_overlapping_ext_nets.setter
    def allow_overlapping_ext_nets(self, allow_overlapping_ext_nets):
        self._allow_overlapping_ext_nets = allow_overlapping_ext_nets

    @property
    def chargeback_events_keep_days(self):
        return self._chargeback_events_keep_days
    
    @chargeback_events_keep_days.setter
    def chargeback_events_keep_days(self, chargeback_events_keep_days):
        self._chargeback_events_keep_days = chargeback_events_keep_days

    @property
    def chargeback_tables_cleanup_job_time_in_seconds(self):
        return self._chargeback_tables_cleanup_job_time_in_seconds
    
    @chargeback_tables_cleanup_job_time_in_seconds.setter
    def chargeback_tables_cleanup_job_time_in_seconds(self, chargeback_tables_cleanup_job_time_in_seconds):
        self._chargeback_tables_cleanup_job_time_in_seconds = chargeback_tables_cleanup_job_time_in_seconds

    @property
    def console_proxy_external_address(self):
        return self._console_proxy_external_address
    
    @console_proxy_external_address.setter
    def console_proxy_external_address(self, console_proxy_external_address):
        self._console_proxy_external_address = console_proxy_external_address

    @property
    def host_check_delay_in_seconds(self):
        return self._host_check_delay_in_seconds
    
    @host_check_delay_in_seconds.setter
    def host_check_delay_in_seconds(self, host_check_delay_in_seconds):
        self._host_check_delay_in_seconds = host_check_delay_in_seconds

    @property
    def host_check_timeout_seconds(self):
        return self._host_check_timeout_seconds
    
    @host_check_timeout_seconds.setter
    def host_check_timeout_seconds(self, host_check_timeout_seconds):
        self._host_check_timeout_seconds = host_check_timeout_seconds

    @property
    def installation_id(self):
        return self._installation_id
    
    @installation_id.setter
    def installation_id(self, installation_id):
        self._installation_id = installation_id

    @property
    def ip_reservation_timeout_seconds(self):
        return self._ip_reservation_timeout_seconds
    
    @ip_reservation_timeout_seconds.setter
    def ip_reservation_timeout_seconds(self, ip_reservation_timeout_seconds):
        self._ip_reservation_timeout_seconds = ip_reservation_timeout_seconds

    @property
    def syslog_server_settings(self):
        return self._syslog_server_settings
    
    @syslog_server_settings.setter
    def syslog_server_settings(self, syslog_server_settings):
        self._syslog_server_settings = syslog_server_settings

    @property
    def login_name_only(self):
        return self._login_name_only
    
    @login_name_only.setter
    def login_name_only(self, login_name_only):
        self._login_name_only = login_name_only

    @property
    def pre_pop_default_name(self):
        return self._pre_pop_default_name
    
    @pre_pop_default_name.setter
    def pre_pop_default_name(self, pre_pop_default_name):
        self._pre_pop_default_name = pre_pop_default_name

    @property
    def quarantine_enabled(self):
        return self._quarantine_enabled
    
    @quarantine_enabled.setter
    def quarantine_enabled(self, quarantine_enabled):
        self._quarantine_enabled = quarantine_enabled

    @property
    def quarantine_response_timeout_seconds(self):
        return self._quarantine_response_timeout_seconds
    
    @quarantine_response_timeout_seconds.setter
    def quarantine_response_timeout_seconds(self, quarantine_response_timeout_seconds):
        self._quarantine_response_timeout_seconds = quarantine_response_timeout_seconds

    @property
    def rest_api_base_http_uri(self):
        return self._rest_api_base_http_uri
    
    @rest_api_base_http_uri.setter
    def rest_api_base_http_uri(self, rest_api_base_http_uri):
        self._rest_api_base_http_uri = rest_api_base_http_uri

    @property
    def rest_api_base_uri(self):
        return self._rest_api_base_uri
    
    @rest_api_base_uri.setter
    def rest_api_base_uri(self, rest_api_base_uri):
        self._rest_api_base_uri = rest_api_base_uri

    @property
    def rest_api_base_uri_public_cert_chain(self):
        return self._rest_api_base_uri_public_cert_chain
    
    @rest_api_base_uri_public_cert_chain.setter
    def rest_api_base_uri_public_cert_chain(self, rest_api_base_uri_public_cert_chain):
        self._rest_api_base_uri_public_cert_chain = rest_api_base_uri_public_cert_chain

    @property
    def session_timeout_minutes(self):
        return self._session_timeout_minutes
    
    @session_timeout_minutes.setter
    def session_timeout_minutes(self, session_timeout_minutes):
        self._session_timeout_minutes = session_timeout_minutes

    @property
    def show_stack_traces(self):
        return self._show_stack_traces
    
    @show_stack_traces.setter
    def show_stack_traces(self, show_stack_traces):
        self._show_stack_traces = show_stack_traces

    @property
    def sync_start_date(self):
        return self._sync_start_date
    
    @sync_start_date.setter
    def sync_start_date(self, sync_start_date):
        self._sync_start_date = sync_start_date

    @property
    def sync_interval_in_hours(self):
        return self._sync_interval_in_hours
    
    @sync_interval_in_hours.setter
    def sync_interval_in_hours(self, sync_interval_in_hours):
        self._sync_interval_in_hours = sync_interval_in_hours

    @property
    def system_external_http_address(self):
        return self._system_external_http_address
    
    @system_external_http_address.setter
    def system_external_http_address(self, system_external_http_address):
        self._system_external_http_address = system_external_http_address

    @property
    def system_external_address(self):
        return self._system_external_address
    
    @system_external_address.setter
    def system_external_address(self, system_external_address):
        self._system_external_address = system_external_address

    @property
    def system_external_address_public_cert_chain(self):
        return self._system_external_address_public_cert_chain
    
    @system_external_address_public_cert_chain.setter
    def system_external_address_public_cert_chain(self, system_external_address_public_cert_chain):
        self._system_external_address_public_cert_chain = system_external_address_public_cert_chain

    @property
    def tenant_portal_external_http_address(self):
        return self._tenant_portal_external_http_address
    
    @tenant_portal_external_http_address.setter
    def tenant_portal_external_http_address(self, tenant_portal_external_http_address):
        self._tenant_portal_external_http_address = tenant_portal_external_http_address

    @property
    def tenant_portal_external_address(self):
        return self._tenant_portal_external_address
    
    @tenant_portal_external_address.setter
    def tenant_portal_external_address(self, tenant_portal_external_address):
        self._tenant_portal_external_address = tenant_portal_external_address

    @property
    def tenant_portal_public_cert_chain(self):
        return self._tenant_portal_public_cert_chain
    
    @tenant_portal_public_cert_chain.setter
    def tenant_portal_public_cert_chain(self, tenant_portal_public_cert_chain):
        self._tenant_portal_public_cert_chain = tenant_portal_public_cert_chain

    @property
    def transfer_session_timeout_seconds(self):
        return self._transfer_session_timeout_seconds
    
    @transfer_session_timeout_seconds.setter
    def transfer_session_timeout_seconds(self, transfer_session_timeout_seconds):
        self._transfer_session_timeout_seconds = transfer_session_timeout_seconds

    @property
    def verify_vc_certificates(self):
        return self._verify_vc_certificates
    
    @verify_vc_certificates.setter
    def verify_vc_certificates(self, verify_vc_certificates):
        self._verify_vc_certificates = verify_vc_certificates

    @property
    def vc_truststore_password(self):
        return self._vc_truststore_password
    
    @vc_truststore_password.setter
    def vc_truststore_password(self, vc_truststore_password):
        self._vc_truststore_password = vc_truststore_password

    @property
    def vc_truststore_contents(self):
        return self._vc_truststore_contents
    
    @vc_truststore_contents.setter
    def vc_truststore_contents(self, vc_truststore_contents):
        self._vc_truststore_contents = vc_truststore_contents

    @property
    def vc_truststore_type(self):
        return self._vc_truststore_type
    
    @vc_truststore_type.setter
    def vc_truststore_type(self, vc_truststore_type):
        self._vc_truststore_type = vc_truststore_type

    @property
    def vmrc_version(self):
        return self._vmrc_version
    
    @vmrc_version.setter
    def vmrc_version(self, vmrc_version):
        self._vmrc_version = vmrc_version

    @property
    def verify_vsm_certificates(self):
        return self._verify_vsm_certificates
    
    @verify_vsm_certificates.setter
    def verify_vsm_certificates(self, verify_vsm_certificates):
        self._verify_vsm_certificates = verify_vsm_certificates

    @property
    def elastic_allocation_pool(self):
        return self._elastic_allocation_pool
    
    @elastic_allocation_pool.setter
    def elastic_allocation_pool(self, elastic_allocation_pool):
        self._elastic_allocation_pool = elastic_allocation_pool

    @property
    def advanced_networking_enabled(self):
        return self._advanced_networking_enabled
    
    @advanced_networking_enabled.setter
    def advanced_networking_enabled(self, advanced_networking_enabled):
        self._advanced_networking_enabled = advanced_networking_enabled

    @property
    def advanced_networking_dfw_api_url(self):
        return self._advanced_networking_dfw_api_url
    
    @advanced_networking_dfw_api_url.setter
    def advanced_networking_dfw_api_url(self, advanced_networking_dfw_api_url):
        self._advanced_networking_dfw_api_url = advanced_networking_dfw_api_url

    @property
    def advanced_networking_dfw_ui_url(self):
        return self._advanced_networking_dfw_ui_url
    
    @advanced_networking_dfw_ui_url.setter
    def advanced_networking_dfw_ui_url(self, advanced_networking_dfw_ui_url):
        self._advanced_networking_dfw_ui_url = advanced_networking_dfw_ui_url

    @property
    def advanced_networking_gateway_api_url(self):
        return self._advanced_networking_gateway_api_url
    
    @advanced_networking_gateway_api_url.setter
    def advanced_networking_gateway_api_url(self, advanced_networking_gateway_api_url):
        self._advanced_networking_gateway_api_url = advanced_networking_gateway_api_url

    @property
    def advanced_networking_gateway_ui_url(self):
        return self._advanced_networking_gateway_ui_url
    
    @advanced_networking_gateway_ui_url.setter
    def advanced_networking_gateway_ui_url(self, advanced_networking_gateway_ui_url):
        self._advanced_networking_gateway_ui_url = advanced_networking_gateway_ui_url

    @property
    def max_vdc_quota(self):
        return self._max_vdc_quota
    
    @max_vdc_quota.setter
    def max_vdc_quota(self, max_vdc_quota):
        self._max_vdc_quota = max_vdc_quota

    @property
    def sub_interfaces_enabled(self):
        return self._sub_interfaces_enabled
    
    @sub_interfaces_enabled.setter
    def sub_interfaces_enabled(self, sub_interfaces_enabled):
        self._sub_interfaces_enabled = sub_interfaces_enabled

    @property
    def vm_discovery_enabled(self):
        return self._vm_discovery_enabled
    
    @vm_discovery_enabled.setter
    def vm_discovery_enabled(self, vm_discovery_enabled):
        self._vm_discovery_enabled = vm_discovery_enabled

    @property
    def allow_fips_mode_for_edge_gateways(self):
        return self._allow_fips_mode_for_edge_gateways
    
    @allow_fips_mode_for_edge_gateways.setter
    def allow_fips_mode_for_edge_gateways(self, allow_fips_mode_for_edge_gateways):
        self._allow_fips_mode_for_edge_gateways = allow_fips_mode_for_edge_gateways


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GeneralSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
