"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..entity_type import EntityType


class DatastoreType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vim_object_ref': 'VimObjectRefType',
        'enabled': 'bool',
        'busy': 'bool',
        'vaai_for_fp_enabled': 'bool',
        'threshold_yellow_gb': 'int',
        'threshold_red_gb': 'int',
        'system_messages': 'str',
        'datastore_fs_type': 'str',
        'vc_display_name': 'str',
        'mount_host': 'str',
        'mount_directory': 'str',
        'total_capacity_mb': 'int',
        'total_capacity_gb': 'int',
        'used_capacity_mb': 'int',
        'used_capacity_gb': 'int',
        'used_capacity_percent': 'int',
        'provisioned_space_mb': 'int',
        'provisioned_space_gb': 'int',
        'requested_storage_mb': 'int',
        'requested_storage_gb': 'int',
        'vim_property_page_url': 'str',
        'members': 'VimObjectRefsType'
    }

    attribute_map = {
        'vim_object_ref': 'vimObjectRef',
        'enabled': 'enabled',
        'busy': 'busy',
        'vaai_for_fp_enabled': 'vaaiForFpEnabled',
        'threshold_yellow_gb': 'thresholdYellowGb',
        'threshold_red_gb': 'thresholdRedGb',
        'system_messages': 'systemMessages',
        'datastore_fs_type': 'datastoreFsType',
        'vc_display_name': 'vcDisplayName',
        'mount_host': 'mountHost',
        'mount_directory': 'mountDirectory',
        'total_capacity_mb': 'totalCapacityMb',
        'total_capacity_gb': 'totalCapacityGb',
        'used_capacity_mb': 'usedCapacityMb',
        'used_capacity_gb': 'usedCapacityGb',
        'used_capacity_percent': 'usedCapacityPercent',
        'provisioned_space_mb': 'provisionedSpaceMb',
        'provisioned_space_gb': 'provisionedSpaceGb',
        'requested_storage_mb': 'requestedStorageMb',
        'requested_storage_gb': 'requestedStorageGb',
        'vim_property_page_url': 'vimPropertyPageUrl',
        'members': 'members'
    }

    def __init__(self, vim_object_ref=None,enabled=None,busy=None,vaai_for_fp_enabled=None,threshold_yellow_gb=None,threshold_red_gb=None,system_messages=None,datastore_fs_type=None,vc_display_name=None,mount_host=None,mount_directory=None,total_capacity_mb=None,total_capacity_gb=None,used_capacity_mb=None,used_capacity_gb=None,used_capacity_percent=None,provisioned_space_mb=None,provisioned_space_gb=None,requested_storage_mb=None,requested_storage_gb=None,vim_property_page_url=None,members=None):
        self._vim_object_ref = None
        self._enabled = None
        self._busy = None
        self._vaai_for_fp_enabled = None
        self._threshold_yellow_gb = None
        self._threshold_red_gb = None
        self._system_messages = None
        self._datastore_fs_type = None
        self._vc_display_name = None
        self._mount_host = None
        self._mount_directory = None
        self._total_capacity_mb = None
        self._total_capacity_gb = None
        self._used_capacity_mb = None
        self._used_capacity_gb = None
        self._used_capacity_percent = None
        self._provisioned_space_mb = None
        self._provisioned_space_gb = None
        self._requested_storage_mb = None
        self._requested_storage_gb = None
        self._vim_property_page_url = None
        self._members = None

        if vim_object_ref is not None:
            self.vim_object_ref = vim_object_ref
        if enabled is not None:
            self.enabled = enabled
        if busy is not None:
            self.busy = busy
        if vaai_for_fp_enabled is not None:
            self.vaai_for_fp_enabled = vaai_for_fp_enabled
        if threshold_yellow_gb is not None:
            self.threshold_yellow_gb = threshold_yellow_gb
        if threshold_red_gb is not None:
            self.threshold_red_gb = threshold_red_gb
        if system_messages is not None:
            self.system_messages = system_messages
        if datastore_fs_type is not None:
            self.datastore_fs_type = datastore_fs_type
        if vc_display_name is not None:
            self.vc_display_name = vc_display_name
        if mount_host is not None:
            self.mount_host = mount_host
        if mount_directory is not None:
            self.mount_directory = mount_directory
        if total_capacity_mb is not None:
            self.total_capacity_mb = total_capacity_mb
        if total_capacity_gb is not None:
            self.total_capacity_gb = total_capacity_gb
        if used_capacity_mb is not None:
            self.used_capacity_mb = used_capacity_mb
        if used_capacity_gb is not None:
            self.used_capacity_gb = used_capacity_gb
        if used_capacity_percent is not None:
            self.used_capacity_percent = used_capacity_percent
        if provisioned_space_mb is not None:
            self.provisioned_space_mb = provisioned_space_mb
        if provisioned_space_gb is not None:
            self.provisioned_space_gb = provisioned_space_gb
        if requested_storage_mb is not None:
            self.requested_storage_mb = requested_storage_mb
        if requested_storage_gb is not None:
            self.requested_storage_gb = requested_storage_gb
        if vim_property_page_url is not None:
            self.vim_property_page_url = vim_property_page_url
        if members is not None:
            self.members = members

    @property
    def vim_object_ref(self):
        return self._vim_object_ref
    
    @vim_object_ref.setter
    def vim_object_ref(self, vim_object_ref):
        self._vim_object_ref = vim_object_ref

    @property
    def enabled(self):
        return self._enabled
    
    @enabled.setter
    def enabled(self, enabled):
        self._enabled = enabled

    @property
    def busy(self):
        return self._busy
    
    @busy.setter
    def busy(self, busy):
        self._busy = busy

    @property
    def vaai_for_fp_enabled(self):
        return self._vaai_for_fp_enabled
    
    @vaai_for_fp_enabled.setter
    def vaai_for_fp_enabled(self, vaai_for_fp_enabled):
        self._vaai_for_fp_enabled = vaai_for_fp_enabled

    @property
    def threshold_yellow_gb(self):
        return self._threshold_yellow_gb
    
    @threshold_yellow_gb.setter
    def threshold_yellow_gb(self, threshold_yellow_gb):
        self._threshold_yellow_gb = threshold_yellow_gb

    @property
    def threshold_red_gb(self):
        return self._threshold_red_gb
    
    @threshold_red_gb.setter
    def threshold_red_gb(self, threshold_red_gb):
        self._threshold_red_gb = threshold_red_gb

    @property
    def system_messages(self):
        return self._system_messages
    
    @system_messages.setter
    def system_messages(self, system_messages):
        self._system_messages = system_messages

    @property
    def datastore_fs_type(self):
        return self._datastore_fs_type
    
    @datastore_fs_type.setter
    def datastore_fs_type(self, datastore_fs_type):
        self._datastore_fs_type = datastore_fs_type

    @property
    def vc_display_name(self):
        return self._vc_display_name
    
    @vc_display_name.setter
    def vc_display_name(self, vc_display_name):
        self._vc_display_name = vc_display_name

    @property
    def mount_host(self):
        return self._mount_host
    
    @mount_host.setter
    def mount_host(self, mount_host):
        self._mount_host = mount_host

    @property
    def mount_directory(self):
        return self._mount_directory
    
    @mount_directory.setter
    def mount_directory(self, mount_directory):
        self._mount_directory = mount_directory

    @property
    def total_capacity_mb(self):
        return self._total_capacity_mb
    
    @total_capacity_mb.setter
    def total_capacity_mb(self, total_capacity_mb):
        self._total_capacity_mb = total_capacity_mb

    @property
    def total_capacity_gb(self):
        return self._total_capacity_gb
    
    @total_capacity_gb.setter
    def total_capacity_gb(self, total_capacity_gb):
        self._total_capacity_gb = total_capacity_gb

    @property
    def used_capacity_mb(self):
        return self._used_capacity_mb
    
    @used_capacity_mb.setter
    def used_capacity_mb(self, used_capacity_mb):
        self._used_capacity_mb = used_capacity_mb

    @property
    def used_capacity_gb(self):
        return self._used_capacity_gb
    
    @used_capacity_gb.setter
    def used_capacity_gb(self, used_capacity_gb):
        self._used_capacity_gb = used_capacity_gb

    @property
    def used_capacity_percent(self):
        return self._used_capacity_percent
    
    @used_capacity_percent.setter
    def used_capacity_percent(self, used_capacity_percent):
        self._used_capacity_percent = used_capacity_percent

    @property
    def provisioned_space_mb(self):
        return self._provisioned_space_mb
    
    @provisioned_space_mb.setter
    def provisioned_space_mb(self, provisioned_space_mb):
        self._provisioned_space_mb = provisioned_space_mb

    @property
    def provisioned_space_gb(self):
        return self._provisioned_space_gb
    
    @provisioned_space_gb.setter
    def provisioned_space_gb(self, provisioned_space_gb):
        self._provisioned_space_gb = provisioned_space_gb

    @property
    def requested_storage_mb(self):
        return self._requested_storage_mb
    
    @requested_storage_mb.setter
    def requested_storage_mb(self, requested_storage_mb):
        self._requested_storage_mb = requested_storage_mb

    @property
    def requested_storage_gb(self):
        return self._requested_storage_gb
    
    @requested_storage_gb.setter
    def requested_storage_gb(self, requested_storage_gb):
        self._requested_storage_gb = requested_storage_gb

    @property
    def vim_property_page_url(self):
        return self._vim_property_page_url
    
    @vim_property_page_url.setter
    def vim_property_page_url(self, vim_property_page_url):
        self._vim_property_page_url = vim_property_page_url

    @property
    def members(self):
        return self._members
    
    @members.setter
    def members(self, members):
        self._members = members


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DatastoreType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
