"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class ComponentManagerSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cm_url': 'str',
        'sso_admin_username': 'str',
        'sso_admin_password': 'str'
    }

    attribute_map = {
        'cm_url': 'cmUrl',
        'sso_admin_username': 'ssoAdminUsername',
        'sso_admin_password': 'ssoAdminPassword'
    }

    def __init__(self, cm_url=None,sso_admin_username=None,sso_admin_password=None):
        self._cm_url = None
        self._sso_admin_username = None
        self._sso_admin_password = None

        if cm_url is not None:
            self.cm_url = cm_url
        if sso_admin_username is not None:
            self.sso_admin_username = sso_admin_username
        if sso_admin_password is not None:
            self.sso_admin_password = sso_admin_password

    @property
    def cm_url(self):
        return self._cm_url
    
    @cm_url.setter
    def cm_url(self, cm_url):
        self._cm_url = cm_url

    @property
    def sso_admin_username(self):
        return self._sso_admin_username
    
    @sso_admin_username.setter
    def sso_admin_username(self, sso_admin_username):
        self._sso_admin_username = sso_admin_username

    @property
    def sso_admin_password(self):
        return self._sso_admin_password
    
    @sso_admin_password.setter
    def sso_admin_password(self, sso_admin_password):
        self._sso_admin_password = sso_admin_password


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ComponentManagerSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
