"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..resource_type import ResourceType


class AmqpSettingsType(ResourceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'amqp_host': 'str',
        'amqp_port': 'int',
        'amqp_username': 'str',
        'amqp_password': 'str',
        'amqp_exchange': 'str',
        'amqp_v_host': 'str',
        'amqp_use_ssl': 'bool',
        'amqp_ssl_accept_all': 'bool',
        'amqp_prefix': 'str'
    }

    attribute_map = {
        'amqp_host': 'amqpHost',
        'amqp_port': 'amqpPort',
        'amqp_username': 'amqpUsername',
        'amqp_password': 'amqpPassword',
        'amqp_exchange': 'amqpExchange',
        'amqp_v_host': 'amqpVHost',
        'amqp_use_ssl': 'amqpUseSSL',
        'amqp_ssl_accept_all': 'amqpSslAcceptAll',
        'amqp_prefix': 'amqpPrefix'
    }

    def __init__(self, amqp_host=None,amqp_port=None,amqp_username=None,amqp_password=None,amqp_exchange=None,amqp_v_host=None,amqp_use_ssl=None,amqp_ssl_accept_all=None,amqp_prefix=None):
        self._amqp_host = None
        self._amqp_port = None
        self._amqp_username = None
        self._amqp_password = None
        self._amqp_exchange = None
        self._amqp_v_host = None
        self._amqp_use_ssl = None
        self._amqp_ssl_accept_all = None
        self._amqp_prefix = None

        if amqp_host is not None:
            self.amqp_host = amqp_host
        if amqp_port is not None:
            self.amqp_port = amqp_port
        if amqp_username is not None:
            self.amqp_username = amqp_username
        if amqp_password is not None:
            self.amqp_password = amqp_password
        if amqp_exchange is not None:
            self.amqp_exchange = amqp_exchange
        if amqp_v_host is not None:
            self.amqp_v_host = amqp_v_host
        if amqp_use_ssl is not None:
            self.amqp_use_ssl = amqp_use_ssl
        if amqp_ssl_accept_all is not None:
            self.amqp_ssl_accept_all = amqp_ssl_accept_all
        if amqp_prefix is not None:
            self.amqp_prefix = amqp_prefix

    @property
    def amqp_host(self):
        return self._amqp_host
    
    @amqp_host.setter
    def amqp_host(self, amqp_host):
        self._amqp_host = amqp_host

    @property
    def amqp_port(self):
        return self._amqp_port
    
    @amqp_port.setter
    def amqp_port(self, amqp_port):
        self._amqp_port = amqp_port

    @property
    def amqp_username(self):
        return self._amqp_username
    
    @amqp_username.setter
    def amqp_username(self, amqp_username):
        self._amqp_username = amqp_username

    @property
    def amqp_password(self):
        return self._amqp_password
    
    @amqp_password.setter
    def amqp_password(self, amqp_password):
        self._amqp_password = amqp_password

    @property
    def amqp_exchange(self):
        return self._amqp_exchange
    
    @amqp_exchange.setter
    def amqp_exchange(self, amqp_exchange):
        self._amqp_exchange = amqp_exchange

    @property
    def amqp_v_host(self):
        return self._amqp_v_host
    
    @amqp_v_host.setter
    def amqp_v_host(self, amqp_v_host):
        self._amqp_v_host = amqp_v_host

    @property
    def amqp_use_ssl(self):
        return self._amqp_use_ssl
    
    @amqp_use_ssl.setter
    def amqp_use_ssl(self, amqp_use_ssl):
        self._amqp_use_ssl = amqp_use_ssl

    @property
    def amqp_ssl_accept_all(self):
        return self._amqp_ssl_accept_all
    
    @amqp_ssl_accept_all.setter
    def amqp_ssl_accept_all(self, amqp_ssl_accept_all):
        self._amqp_ssl_accept_all = amqp_ssl_accept_all

    @property
    def amqp_prefix(self):
        return self._amqp_prefix
    
    @amqp_prefix.setter
    def amqp_prefix(self, amqp_prefix):
        self._amqp_prefix = amqp_prefix


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AmqpSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
