"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from ..entity_type import EntityType


class AclRuleType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'service_resource_access': 'AclAccessType',
        'organization_access': 'AclAccessType',
        'principal_access': 'AclAccessType'
    }

    attribute_map = {
        'service_resource_access': 'serviceResourceAccess',
        'organization_access': 'organizationAccess',
        'principal_access': 'principalAccess'
    }

    def __init__(self, service_resource_access=None,organization_access=None,principal_access=None):
        self._service_resource_access = None
        self._organization_access = None
        self._principal_access = None

        if service_resource_access is not None:
            self.service_resource_access = service_resource_access
        if organization_access is not None:
            self.organization_access = organization_access
        if principal_access is not None:
            self.principal_access = principal_access

    @property
    def service_resource_access(self):
        return self._service_resource_access
    
    @service_resource_access.setter
    def service_resource_access(self, service_resource_access):
        self._service_resource_access = service_resource_access

    @property
    def organization_access(self):
        return self._organization_access
    
    @organization_access.setter
    def organization_access(self, organization_access):
        self._organization_access = organization_access

    @property
    def principal_access(self):
        return self._principal_access
    
    @principal_access.setter
    def principal_access(self, principal_access):
        self._principal_access = principal_access


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AclRuleType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
