"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class EventType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'owner': 'ReferenceType',
        'user': 'ReferenceType',
        'event_properties': 'EventPropertiesType',
        'service_namespace': 'str',
        'success': 'bool',
        'type': 'str',
        'type_full': 'str'
    }

    attribute_map = {
        'owner': 'owner',
        'user': 'user',
        'event_properties': 'eventProperties',
        'service_namespace': 'serviceNamespace',
        'success': 'success',
        'type': 'type',
        'type_full': 'typeFull'
    }

    def __init__(self, owner=None,user=None,event_properties=None,service_namespace=None,success=None,type=None,type_full=None):
        self._owner = None
        self._user = None
        self._event_properties = None
        self._service_namespace = None
        self._success = None
        self._type = None
        self._type_full = None

        if owner is not None:
            self.owner = owner
        if user is not None:
            self.user = user
        if event_properties is not None:
            self.event_properties = event_properties
        if service_namespace is not None:
            self.service_namespace = service_namespace
        if success is not None:
            self.success = success
        if type is not None:
            self.type = type
        if type_full is not None:
            self.type_full = type_full

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def user(self):
        return self._user
    
    @user.setter
    def user(self, user):
        self._user = user

    @property
    def event_properties(self):
        return self._event_properties
    
    @event_properties.setter
    def event_properties(self, event_properties):
        self._event_properties = event_properties

    @property
    def service_namespace(self):
        return self._service_namespace
    
    @service_namespace.setter
    def service_namespace(self, service_namespace):
        self._service_namespace = service_namespace

    @property
    def success(self):
        return self._success
    
    @success.setter
    def success(self, success):
        self._success = success

    @property
    def type(self):
        return self._type
    
    @type.setter
    def type(self, type):
        self._type = type

    @property
    def type_full(self):
        return self._type_full
    
    @type_full.setter
    def type_full(self, type_full):
        self._type_full = type_full


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EventType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
