"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .resource_entity_type import ResourceEntityType


class DiskType(ResourceEntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'storage_profile': 'ReferenceType',
        'owner': 'OwnerType',
        'bus_sub_type': 'str',
        'bus_type': 'str',
        'iops': 'int',
        'size': 'int',
        'size_mb': 'int'
    }

    attribute_map = {
        'storage_profile': 'storageProfile',
        'owner': 'owner',
        'bus_sub_type': 'busSubType',
        'bus_type': 'busType',
        'iops': 'iops',
        'size': 'size',
        'size_mb': 'sizeMb'
    }

    def __init__(self, storage_profile=None,owner=None,bus_sub_type=None,bus_type=None,iops=None,size=None,size_mb=None):
        self._storage_profile = None
        self._owner = None
        self._bus_sub_type = None
        self._bus_type = None
        self._iops = None
        self._size = None
        self._size_mb = None

        if storage_profile is not None:
            self.storage_profile = storage_profile
        if owner is not None:
            self.owner = owner
        if bus_sub_type is not None:
            self.bus_sub_type = bus_sub_type
        if bus_type is not None:
            self.bus_type = bus_type
        if iops is not None:
            self.iops = iops
        if size is not None:
            self.size = size
        if size_mb is not None:
            self.size_mb = size_mb

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def bus_sub_type(self):
        return self._bus_sub_type
    
    @bus_sub_type.setter
    def bus_sub_type(self, bus_sub_type):
        self._bus_sub_type = bus_sub_type

    @property
    def bus_type(self):
        return self._bus_type
    
    @bus_type.setter
    def bus_type(self, bus_type):
        self._bus_type = bus_type

    @property
    def iops(self):
        return self._iops
    
    @iops.setter
    def iops(self, iops):
        self._iops = iops

    @property
    def size(self):
        return self._size
    
    @size.setter
    def size(self, size):
        self._size = size

    @property
    def size_mb(self):
        return self._size_mb
    
    @size_mb.setter
    def size_mb(self, size_mb):
        self._size_mb = size_mb


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DiskType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
