"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class DiskSettingsType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'disk_id': 'str',
        'size_mb': 'int',
        'unit_number': 'int',
        'bus_number': 'int',
        'adapter_type': 'str',
        'thin_provisioned': 'bool',
        'disk': 'ReferenceType',
        'storage_profile': 'ReferenceType',
        'override_vm_default': 'bool',
        'iops': 'int',
        'virtual_quantity_unit': 'str',
        'virtual_quantity': 'int'
    }

    attribute_map = {
        'disk_id': 'diskId',
        'size_mb': 'sizeMb',
        'unit_number': 'unitNumber',
        'bus_number': 'busNumber',
        'adapter_type': 'adapterType',
        'thin_provisioned': 'thinProvisioned',
        'disk': 'disk',
        'storage_profile': 'storageProfile',
        'override_vm_default': 'overrideVmDefault',
        'iops': 'iops',
        'virtual_quantity_unit': 'virtualQuantityUnit',
        'virtual_quantity': 'virtualQuantity'
    }

    def __init__(self, disk_id=None,size_mb=None,unit_number=None,bus_number=None,adapter_type=None,thin_provisioned=None,disk=None,storage_profile=None,override_vm_default=None,iops=None,virtual_quantity_unit=None,virtual_quantity=None):
        self._disk_id = None
        self._size_mb = None
        self._unit_number = None
        self._bus_number = None
        self._adapter_type = None
        self._thin_provisioned = None
        self._disk = None
        self._storage_profile = None
        self._override_vm_default = None
        self._iops = None
        self._virtual_quantity_unit = None
        self._virtual_quantity = None

        if disk_id is not None:
            self.disk_id = disk_id
        if size_mb is not None:
            self.size_mb = size_mb
        if unit_number is not None:
            self.unit_number = unit_number
        if bus_number is not None:
            self.bus_number = bus_number
        if adapter_type is not None:
            self.adapter_type = adapter_type
        if thin_provisioned is not None:
            self.thin_provisioned = thin_provisioned
        if disk is not None:
            self.disk = disk
        if storage_profile is not None:
            self.storage_profile = storage_profile
        if override_vm_default is not None:
            self.override_vm_default = override_vm_default
        if iops is not None:
            self.iops = iops
        if virtual_quantity_unit is not None:
            self.virtual_quantity_unit = virtual_quantity_unit
        if virtual_quantity is not None:
            self.virtual_quantity = virtual_quantity

    @property
    def disk_id(self):
        return self._disk_id
    
    @disk_id.setter
    def disk_id(self, disk_id):
        self._disk_id = disk_id

    @property
    def size_mb(self):
        return self._size_mb
    
    @size_mb.setter
    def size_mb(self, size_mb):
        self._size_mb = size_mb

    @property
    def unit_number(self):
        return self._unit_number
    
    @unit_number.setter
    def unit_number(self, unit_number):
        self._unit_number = unit_number

    @property
    def bus_number(self):
        return self._bus_number
    
    @bus_number.setter
    def bus_number(self, bus_number):
        self._bus_number = bus_number

    @property
    def adapter_type(self):
        return self._adapter_type
    
    @adapter_type.setter
    def adapter_type(self, adapter_type):
        self._adapter_type = adapter_type

    @property
    def thin_provisioned(self):
        return self._thin_provisioned
    
    @thin_provisioned.setter
    def thin_provisioned(self, thin_provisioned):
        self._thin_provisioned = thin_provisioned

    @property
    def disk(self):
        return self._disk
    
    @disk.setter
    def disk(self, disk):
        self._disk = disk

    @property
    def storage_profile(self):
        return self._storage_profile
    
    @storage_profile.setter
    def storage_profile(self, storage_profile):
        self._storage_profile = storage_profile

    @property
    def override_vm_default(self):
        return self._override_vm_default
    
    @override_vm_default.setter
    def override_vm_default(self, override_vm_default):
        self._override_vm_default = override_vm_default

    @property
    def iops(self):
        return self._iops
    
    @iops.setter
    def iops(self, iops):
        self._iops = iops

    @property
    def virtual_quantity_unit(self):
        return self._virtual_quantity_unit
    
    @virtual_quantity_unit.setter
    def virtual_quantity_unit(self, virtual_quantity_unit):
        self._virtual_quantity_unit = virtual_quantity_unit

    @property
    def virtual_quantity(self):
        return self._virtual_quantity
    
    @virtual_quantity.setter
    def virtual_quantity(self, virtual_quantity):
        self._virtual_quantity = virtual_quantity


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DiskSettingsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
