"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .network_service_type import NetworkServiceType


class DhcpServiceType(NetworkServiceType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'default_lease_time': 'int',
        'max_lease_time': 'int',
        'ip_range': 'IpRangeType',
        'router_ip': 'str',
        'sub_mask': 'str',
        'primary_name_server': 'str',
        'secondary_name_server': 'str',
        'domain_name': 'str'
    }

    attribute_map = {
        'default_lease_time': 'defaultLeaseTime',
        'max_lease_time': 'maxLeaseTime',
        'ip_range': 'ipRange',
        'router_ip': 'routerIp',
        'sub_mask': 'subMask',
        'primary_name_server': 'primaryNameServer',
        'secondary_name_server': 'secondaryNameServer',
        'domain_name': 'domainName'
    }

    def __init__(self, default_lease_time=None,max_lease_time=None,ip_range=None,router_ip=None,sub_mask=None,primary_name_server=None,secondary_name_server=None,domain_name=None):
        self._default_lease_time = None
        self._max_lease_time = None
        self._ip_range = None
        self._router_ip = None
        self._sub_mask = None
        self._primary_name_server = None
        self._secondary_name_server = None
        self._domain_name = None

        if default_lease_time is not None:
            self.default_lease_time = default_lease_time
        if max_lease_time is not None:
            self.max_lease_time = max_lease_time
        if ip_range is not None:
            self.ip_range = ip_range
        if router_ip is not None:
            self.router_ip = router_ip
        if sub_mask is not None:
            self.sub_mask = sub_mask
        if primary_name_server is not None:
            self.primary_name_server = primary_name_server
        if secondary_name_server is not None:
            self.secondary_name_server = secondary_name_server
        if domain_name is not None:
            self.domain_name = domain_name

    @property
    def default_lease_time(self):
        return self._default_lease_time
    
    @default_lease_time.setter
    def default_lease_time(self, default_lease_time):
        self._default_lease_time = default_lease_time

    @property
    def max_lease_time(self):
        return self._max_lease_time
    
    @max_lease_time.setter
    def max_lease_time(self, max_lease_time):
        self._max_lease_time = max_lease_time

    @property
    def ip_range(self):
        return self._ip_range
    
    @ip_range.setter
    def ip_range(self, ip_range):
        self._ip_range = ip_range

    @property
    def router_ip(self):
        return self._router_ip
    
    @router_ip.setter
    def router_ip(self, router_ip):
        self._router_ip = router_ip

    @property
    def sub_mask(self):
        return self._sub_mask
    
    @sub_mask.setter
    def sub_mask(self, sub_mask):
        self._sub_mask = sub_mask

    @property
    def primary_name_server(self):
        return self._primary_name_server
    
    @primary_name_server.setter
    def primary_name_server(self, primary_name_server):
        self._primary_name_server = primary_name_server

    @property
    def secondary_name_server(self):
        return self._secondary_name_server
    
    @secondary_name_server.setter
    def secondary_name_server(self, secondary_name_server):
        self._secondary_name_server = secondary_name_server

    @property
    def domain_name(self):
        return self._domain_name
    
    @domain_name.setter
    def domain_name(self, domain_name):
        self._domain_name = domain_name


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DhcpServiceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
