"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_cloud_extensible_type import VCloudExtensibleType


class ComputeResourceType(VCloudExtensibleType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'configured': 'int',
        'reservation': 'int',
        'limit': 'int',
        'shares_level': 'ResourceSharesLevelType',
        'shares': 'int'
    }

    attribute_map = {
        'configured': 'configured',
        'reservation': 'reservation',
        'limit': 'limit',
        'shares_level': 'sharesLevel',
        'shares': 'shares'
    }

    def __init__(self, configured=None,reservation=None,limit=None,shares_level=None,shares=None):
        self._configured = None
        self._reservation = None
        self._limit = None
        self._shares_level = None
        self._shares = None

        if configured is not None:
            self.configured = configured
        if reservation is not None:
            self.reservation = reservation
        if limit is not None:
            self.limit = limit
        if shares_level is not None:
            self.shares_level = shares_level
        if shares is not None:
            self.shares = shares

    @property
    def configured(self):
        return self._configured
    
    @configured.setter
    def configured(self, configured):
        self._configured = configured

    @property
    def reservation(self):
        return self._reservation
    
    @reservation.setter
    def reservation(self, reservation):
        self._reservation = reservation

    @property
    def limit(self):
        return self._limit
    
    @limit.setter
    def limit(self, limit):
        self._limit = limit

    @property
    def shares_level(self):
        return self._shares_level
    
    @shares_level.setter
    def shares_level(self, shares_level):
        self._shares_level = shares_level

    @property
    def shares(self):
        return self._shares
    
    @shares.setter
    def shares(self, shares):
        self._shares = shares


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ComputeResourceType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
