"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .v_app_creation_params_type import VAppCreationParamsType


class ComposeVAppParamsType(VAppCreationParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sourced_item': 'list[SourcedCompositionItemParamType]',
        'create_item': 'list[VmType]',
        'all_eul_as_accepted': 'bool',
        'linked_clone': 'bool'
    }

    attribute_map = {
        'sourced_item': 'sourcedItem',
        'create_item': 'createItem',
        'all_eul_as_accepted': 'allEULAsAccepted',
        'linked_clone': 'linkedClone'
    }

    def __init__(self, sourced_item=None,create_item=None,all_eul_as_accepted=None,linked_clone=None):
        self._sourced_item = None
        self._create_item = None
        self._all_eul_as_accepted = None
        self._linked_clone = None

        if sourced_item is not None:
            self.sourced_item = sourced_item
        if create_item is not None:
            self.create_item = create_item
        if all_eul_as_accepted is not None:
            self.all_eul_as_accepted = all_eul_as_accepted
        if linked_clone is not None:
            self.linked_clone = linked_clone

    @property
    def sourced_item(self):
        return self._sourced_item
    
    @sourced_item.setter
    def sourced_item(self, sourced_item):
        self._sourced_item = sourced_item

    @property
    def create_item(self):
        return self._create_item
    
    @create_item.setter
    def create_item(self, create_item):
        self._create_item = create_item

    @property
    def all_eul_as_accepted(self):
        return self._all_eul_as_accepted
    
    @all_eul_as_accepted.setter
    def all_eul_as_accepted(self, all_eul_as_accepted):
        self._all_eul_as_accepted = all_eul_as_accepted

    @property
    def linked_clone(self):
        return self._linked_clone
    
    @linked_clone.setter
    def linked_clone(self, linked_clone):
        self._linked_clone = linked_clone


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ComposeVAppParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
