"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class CloneMediaParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source': 'ReferenceType',
        'is_source_delete': 'bool',
        'vdc_storage_profile': 'ReferenceType'
    }

    attribute_map = {
        'source': 'source',
        'is_source_delete': 'isSourceDelete',
        'vdc_storage_profile': 'vdcStorageProfile'
    }

    def __init__(self, source=None,is_source_delete=None,vdc_storage_profile=None):
        self._source = None
        self._is_source_delete = None
        self._vdc_storage_profile = None

        if source is not None:
            self.source = source
        if is_source_delete is not None:
            self.is_source_delete = is_source_delete
        if vdc_storage_profile is not None:
            self.vdc_storage_profile = vdc_storage_profile

    @property
    def source(self):
        return self._source
    
    @source.setter
    def source(self, source):
        self._source = source

    @property
    def is_source_delete(self):
        return self._is_source_delete
    
    @is_source_delete.setter
    def is_source_delete(self, is_source_delete):
        self._is_source_delete = is_source_delete

    @property
    def vdc_storage_profile(self):
        return self._vdc_storage_profile
    
    @vdc_storage_profile.setter
    def vdc_storage_profile(self, vdc_storage_profile):
        self._vdc_storage_profile = vdc_storage_profile


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CloneMediaParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
