"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .params_type import ParamsType


class CaptureVAppParamsType(ParamsType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'source': 'ReferenceType',
        'capture_vm_params': 'list[CaptureVmParamsType]',
        'section': 'list[SectionType]',
        'vdc_storage_profile': 'ReferenceType',
        'target_catalog_item': 'ReferenceType'
    }

    attribute_map = {
        'source': 'source',
        'capture_vm_params': 'captureVmParams',
        'section': 'section',
        'vdc_storage_profile': 'vdcStorageProfile',
        'target_catalog_item': 'targetCatalogItem'
    }

    def __init__(self, source=None,capture_vm_params=None,section=None,vdc_storage_profile=None,target_catalog_item=None):
        self._source = None
        self._capture_vm_params = None
        self._section = None
        self._vdc_storage_profile = None
        self._target_catalog_item = None

        if source is not None:
            self.source = source
        if capture_vm_params is not None:
            self.capture_vm_params = capture_vm_params
        if section is not None:
            self.section = section
        if vdc_storage_profile is not None:
            self.vdc_storage_profile = vdc_storage_profile
        if target_catalog_item is not None:
            self.target_catalog_item = target_catalog_item

    @property
    def source(self):
        return self._source
    
    @source.setter
    def source(self, source):
        self._source = source

    @property
    def capture_vm_params(self):
        return self._capture_vm_params
    
    @capture_vm_params.setter
    def capture_vm_params(self, capture_vm_params):
        self._capture_vm_params = capture_vm_params

    @property
    def section(self):
        return self._section
    
    @section.setter
    def section(self, section):
        self._section = section

    @property
    def vdc_storage_profile(self):
        return self._vdc_storage_profile
    
    @vdc_storage_profile.setter
    def vdc_storage_profile(self, vdc_storage_profile):
        self._vdc_storage_profile = vdc_storage_profile

    @property
    def target_catalog_item(self):
        return self._target_catalog_item
    
    @target_catalog_item.setter
    def target_catalog_item(self, target_catalog_item):
        self._target_catalog_item = target_catalog_item


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CaptureVAppParamsType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
