"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .entity_type import EntityType


class AuditEventType(EntityType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org': 'ReferenceType',
        'owner': 'ReferenceType',
        'user': 'ReferenceType',
        'details': 'str',
        'event_type': 'str',
        'service_namespace': 'str',
        'success': 'bool',
        'time_stamp': 'str'
    }

    attribute_map = {
        'org': 'org',
        'owner': 'owner',
        'user': 'user',
        'details': 'details',
        'event_type': 'eventType',
        'service_namespace': 'serviceNamespace',
        'success': 'success',
        'time_stamp': 'timeStamp'
    }

    def __init__(self, org=None,owner=None,user=None,details=None,event_type=None,service_namespace=None,success=None,time_stamp=None):
        self._org = None
        self._owner = None
        self._user = None
        self._details = None
        self._event_type = None
        self._service_namespace = None
        self._success = None
        self._time_stamp = None

        if org is not None:
            self.org = org
        if owner is not None:
            self.owner = owner
        if user is not None:
            self.user = user
        if details is not None:
            self.details = details
        if event_type is not None:
            self.event_type = event_type
        if service_namespace is not None:
            self.service_namespace = service_namespace
        if success is not None:
            self.success = success
        if time_stamp is not None:
            self.time_stamp = time_stamp

    @property
    def org(self):
        return self._org
    
    @org.setter
    def org(self, org):
        self._org = org

    @property
    def owner(self):
        return self._owner
    
    @owner.setter
    def owner(self, owner):
        self._owner = owner

    @property
    def user(self):
        return self._user
    
    @user.setter
    def user(self, user):
        self._user = user

    @property
    def details(self):
        return self._details
    
    @details.setter
    def details(self, details):
        self._details = details

    @property
    def event_type(self):
        return self._event_type
    
    @event_type.setter
    def event_type(self, event_type):
        self._event_type = event_type

    @property
    def service_namespace(self):
        return self._service_namespace
    
    @service_namespace.setter
    def service_namespace(self, service_namespace):
        self._service_namespace = service_namespace

    @property
    def success(self):
        return self._success
    
    @success.setter
    def success(self, success):
        self._success = success

    @property
    def time_stamp(self):
        return self._time_stamp
    
    @time_stamp.setter
    def time_stamp(self, time_stamp):
        self._time_stamp = time_stamp


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuditEventType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
