"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .org_type import OrgType


class AdminOrgType(OrgType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'settings': 'OrgSettingsType',
        'users': 'UsersListType',
        'groups': 'GroupsListType',
        'catalogs': 'CatalogsListType',
        'vdcs': 'VdcsType',
        'vdc_templates': 'VdcTemplatesType',
        'networks': 'NetworksType',
        'org_associations': 'OrgAssociationsType',
        'right_references': 'OrganizationRightsType',
        'role_references': 'OrganizationRolesType',
        'role_template_references': 'RoleReferencesType'
    }

    attribute_map = {
        'settings': 'settings',
        'users': 'users',
        'groups': 'groups',
        'catalogs': 'catalogs',
        'vdcs': 'vdcs',
        'vdc_templates': 'vdcTemplates',
        'networks': 'networks',
        'org_associations': 'orgAssociations',
        'right_references': 'rightReferences',
        'role_references': 'roleReferences',
        'role_template_references': 'roleTemplateReferences'
    }

    def __init__(self, settings=None,users=None,groups=None,catalogs=None,vdcs=None,vdc_templates=None,networks=None,org_associations=None,right_references=None,role_references=None,role_template_references=None):
        self._settings = None
        self._users = None
        self._groups = None
        self._catalogs = None
        self._vdcs = None
        self._vdc_templates = None
        self._networks = None
        self._org_associations = None
        self._right_references = None
        self._role_references = None
        self._role_template_references = None

        if settings is not None:
            self.settings = settings
        if users is not None:
            self.users = users
        if groups is not None:
            self.groups = groups
        if catalogs is not None:
            self.catalogs = catalogs
        if vdcs is not None:
            self.vdcs = vdcs
        if vdc_templates is not None:
            self.vdc_templates = vdc_templates
        if networks is not None:
            self.networks = networks
        if org_associations is not None:
            self.org_associations = org_associations
        if right_references is not None:
            self.right_references = right_references
        if role_references is not None:
            self.role_references = role_references
        if role_template_references is not None:
            self.role_template_references = role_template_references

    @property
    def settings(self):
        return self._settings
    
    @settings.setter
    def settings(self, settings):
        self._settings = settings

    @property
    def users(self):
        return self._users
    
    @users.setter
    def users(self, users):
        self._users = users

    @property
    def groups(self):
        return self._groups
    
    @groups.setter
    def groups(self, groups):
        self._groups = groups

    @property
    def catalogs(self):
        return self._catalogs
    
    @catalogs.setter
    def catalogs(self, catalogs):
        self._catalogs = catalogs

    @property
    def vdcs(self):
        return self._vdcs
    
    @vdcs.setter
    def vdcs(self, vdcs):
        self._vdcs = vdcs

    @property
    def vdc_templates(self):
        return self._vdc_templates
    
    @vdc_templates.setter
    def vdc_templates(self, vdc_templates):
        self._vdc_templates = vdc_templates

    @property
    def networks(self):
        return self._networks
    
    @networks.setter
    def networks(self, networks):
        self._networks = networks

    @property
    def org_associations(self):
        return self._org_associations
    
    @org_associations.setter
    def org_associations(self, org_associations):
        self._org_associations = org_associations

    @property
    def right_references(self):
        return self._right_references
    
    @right_references.setter
    def right_references(self, right_references):
        self._right_references = right_references

    @property
    def role_references(self):
        return self._role_references
    
    @role_references.setter
    def role_references(self, role_references):
        self._role_references = role_references

    @property
    def role_template_references(self):
        return self._role_template_references
    
    @role_template_references.setter
    def role_template_references(self, role_template_references):
        self._role_template_references = role_template_references


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdminOrgType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
