"""
 Copyright (c) 2020 VMware, Inc. All rights reserved.
"""
from pprint import pformat
from six import iteritems
import re
from .section_type import SectionType


class VirtualHardwareSectionType(SectionType):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'system': 'VSSDType',
        'item': 'list[RASDType]',
        'any': 'list[object]',
        'id': 'str',
        'transport': 'str'
    }

    attribute_map = {
        'system': 'system',
        'item': 'item',
        'any': 'any',
        'id': 'id',
        'transport': 'transport'
    }

    def __init__(self, system=None,item=None,any=None,id=None,transport=None):
        self._system = None
        self._item = None
        self._any = None
        self._id = None
        self._transport = None

        if system is not None:
            self.system = system
        if item is not None:
            self.item = item
        if any is not None:
            self.any = any
        if id is not None:
            self.id = id
        if transport is not None:
            self.transport = transport

    @property
    def system(self):
        return self._system
    
    @system.setter
    def system(self, system):
        self._system = system

    @property
    def item(self):
        return self._item
    
    @item.setter
    def item(self, item):
        self._item = item

    @property
    def any(self):
        return self._any
    
    @any.setter
    def any(self, any):
        self._any = any

    @property
    def id(self):
        return self._id
    
    @id.setter
    def id(self, id):
        self._id = id

    @property
    def transport(self):
        return self._transport
    
    @transport.setter
    def transport(self, transport):
        self._transport = transport


    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VirtualHardwareSectionType):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
