# Generated by Django 3.2.9 on 2021-11-04 20:48

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0062_clear_secrets_changelog"),
        ("netbox_dns", "0002_zone_default_ttl"),
    ]

    operations = [
        migrations.AddField(
            model_name="record",
            name="managed",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="zone",
            name="soa_expire",
            field=models.PositiveIntegerField(
                default=2592000,
                validators=[django.core.validators.MinValueValidator(1)],
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="zone",
            name="soa_minimum",
            field=models.PositiveIntegerField(
                default=3600, validators=[django.core.validators.MinValueValidator(1)]
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="zone",
            name="soa_mname",
            field=models.ForeignKey(
                default=1,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="zones_soa",
                to="netbox_dns.nameserver",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="zone",
            name="soa_refresh",
            field=models.PositiveIntegerField(
                default=172800, validators=[django.core.validators.MinValueValidator(1)]
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="zone",
            name="soa_retry",
            field=models.PositiveIntegerField(
                default=7200, validators=[django.core.validators.MinValueValidator(1)]
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="zone",
            name="soa_rname",
            field=models.CharField(default="hostmaster.example.com", max_length=255),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="zone",
            name="soa_serial",
            field=models.PositiveIntegerField(
                default=1,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(2147483647),
                ],
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="zone",
            name="soa_ttl",
            field=models.PositiveIntegerField(
                default=86400, validators=[django.core.validators.MinValueValidator(1)]
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="nameserver",
            name="tags",
            field=taggit.managers.TaggableManager(
                blank=True, through="extras.TaggedItem", to="extras.Tag"
            ),
        ),
        migrations.AlterField(
            model_name="record",
            name="tags",
            field=taggit.managers.TaggableManager(
                blank=True, through="extras.TaggedItem", to="extras.Tag"
            ),
        ),
        migrations.AlterField(
            model_name="zone",
            name="default_ttl",
            field=models.PositiveIntegerField(
                blank=True, validators=[django.core.validators.MinValueValidator(1)]
            ),
        ),
    ]
