# -*- coding: utf-8 -*-
# flake8:noqa
# pylint:skip-file
# isort:skip_file
# fmt:off
# id:01.20140505
# original at https://gist.github.com/798546
unicode_to_tex = {
    u'\u0020': b'\\space ',
    u'\u0023': b'\\#',
    u'\u0024': b'\\textdollar ',
    u'\u0025': b'\\%',
    u'\u0026': b'\\&amp;',
    u'\u0027': b'\\textquotesingle ',
    u'\u002A': b'\\ast ',
    u'\u005C': b'\\textbackslash ',
    u'\u005E': b'\\^{}',
    u'\u005F': b'\\_',
    u'\u0060': b'\\textasciigrave ',
    u'\u007B': b'\\lbrace ',
    u'\u007C': b'\\vert ',
    u'\u007D': b'\\rbrace ',
    u'\u007E': b'\\textasciitilde ',
    u'\u00A1': b'\\textexclamdown ',
    u'\u00A2': b'\\textcent ',
    u'\u00A3': b'\\textsterling ',
    u'\u00A4': b'\\textcurrency ',
    u'\u00A5': b'\\textyen ',
    u'\u00A6': b'\\textbrokenbar ',
    u'\u00A7': b'\\textsection ',
    u'\u00A8': b'\\textasciidieresis ',
    u'\u00A9': b'\\textcopyright ',
    u'\u00AA': b'\\textordfeminine ',
    u'\u00AB': b'\\guillemotleft ',
    u'\u00AC': b'\\lnot ',
    u'\u00AD': b'\\-',
    u'\u00AE': b'\\textregistered ',
    u'\u00AF': b'\\textasciimacron ',
    u'\u00B0': b'\\textdegree ',
    u'\u00B1': b'\\pm ',
    u'\u00B2': b'{^2}',
    u'\u00B3': b'{^3}',
    u'\u00B4': b'\\textasciiacute ',
    u'\u00B5': b'\\mathrm{\\mu}',
    u'\u00B6': b'\\textparagraph ',
    u'\u00B7': b'\\cdot ',
    u'\u00B8': b'\\c{}',
    u'\u00B9': b'{^1}',
    u'\u00BA': b'\\textordmasculine ',
    u'\u00BB': b'\\guillemotright ',
    u'\u00BC': b'\\textonequarter ',
    u'\u00BD': b'\\textonehalf ',
    u'\u00BE': b'\\textthreequarters ',
    u'\u00BF': b'\\textquestiondown ',
    u'\u00C0': b'\\`{A}',
    u'\u00C1': b"\\'{A}",
    u'\u00C2': b'\\^{A}',
    u'\u00C3': b'\\~{A}',
    u'\u00C4': b'\\"{A}',
    u'\u00C5': b'\\AA ',
    u'\u00C6': b'\\AE ',
    u'\u00C7': b'\\c{C}',
    u'\u00C8': b'\\`{E}',
    u'\u00C9': b"\\'{E}",
    u'\u00CA': b'\\^{E}',
    u'\u00CB': b'\\"{E}',
    u'\u00CC': b'\\`{I}',
    u'\u00CD': b"\\'{I}",
    u'\u00CE': b'\\^{I}',
    u'\u00CF': b'\\"{I}',
    u'\u00D0': b'\\DH ',
    u'\u00D1': b'\\~{N}',
    u'\u00D2': b'\\`{O}',
    u'\u00D3': b"\\'{O}",
    u'\u00D4': b'\\^{O}',
    u'\u00D5': b'\\~{O}',
    u'\u00D6': b'\\"{O}',
    u'\u00D7': b'\\texttimes ',
    u'\u00D8': b'\\O ',
    u'\u00D9': b'\\`{U}',
    u'\u00DA': b"\\'{U}",
    u'\u00DB': b'\\^{U}',
    u'\u00DC': b'\\"{U}',
    u'\u00DD': b"\\'{Y}",
    u'\u00DE': b'\\TH ',
    u'\u00DF': b'\\ss ',
    u'\u00E0': b'\\`{a}',
    u'\u00E1': b"\\'{a}",
    u'\u00E2': b'\\^{a}',
    u'\u00E3': b'\\~{a}',
    u'\u00E4': b'\\"{a}',
    u'\u00E5': b'\\aa ',
    u'\u00E6': b'\\ae ',
    u'\u00E7': b'\\c{c}',
    u'\u00E8': b'\\`{e}',
    u'\u00E9': b"\\'{e}",
    u'\u00EA': b'\\^{e}',
    u'\u00EB': b'\\"{e}',
    u'\u00EC': b'\\`{\\i}',
    u'\u00ED': b"\\'{\\i}",
    u'\u00EE': b'\\^{\\i}',
    u'\u00EF': b'\\"{\\i}',
    u'\u00F0': b'\\dh ',
    u'\u00F1': b'\\~{n}',
    u'\u00F2': b'\\`{o}',
    u'\u00F3': b"\\'{o}",
    u'\u00F4': b'\\^{o}',
    u'\u00F5': b'\\~{o}',
    u'\u00F6': b'\\"{o}',
    u'\u00F7': b'\\div ',
    u'\u00F8': b'\\o ',
    u'\u00F9': b'\\`{u}',
    u'\u00FA': b"\\'{u}",
    u'\u00FB': b'\\^{u}',
    u'\u00FC': b'\\"{u}',
    u'\u00FD': b"\\'{y}",
    u'\u00FE': b'\\th ',
    u'\u00FF': b'\\"{y}',
    u'\u0100': b'\\={A}',
    u'\u0101': b'\\={a}',
    u'\u0102': b'\\u{A}',
    u'\u0103': b'\\u{a}',
    u'\u0104': b'\\k{A}',
    u'\u0105': b'\\k{a}',
    u'\u0106': b"\\'{C}",
    u'\u0107': b"\\'{c}",
    u'\u0108': b'\\^{C}',
    u'\u0109': b'\\^{c}',
    u'\u010A': b'\\.{C}',
    u'\u010B': b'\\.{c}',
    u'\u010C': b'\\v{C}',
    u'\u010D': b'\\v{c}',
    u'\u010E': b'\\v{D}',
    u'\u010F': b'\\v{d}',
    u'\u0110': b'\\DJ ',
    u'\u0111': b'\\dj ',
    u'\u0112': b'\\={E}',
    u'\u0113': b'\\={e}',
    u'\u0114': b'\\u{E}',
    u'\u0115': b'\\u{e}',
    u'\u0116': b'\\.{E}',
    u'\u0117': b'\\.{e}',
    u'\u0118': b'\\k{E}',
    u'\u0119': b'\\k{e}',
    u'\u011A': b'\\v{E}',
    u'\u011B': b'\\v{e}',
    u'\u011C': b'\\^{G}',
    u'\u011D': b'\\^{g}',
    u'\u011E': b'\\u{G}',
    u'\u011F': b'\\u{g}',
    u'\u0120': b'\\.{G}',
    u'\u0121': b'\\.{g}',
    u'\u0122': b'\\c{G}',
    u'\u0123': b'\\c{g}',
    u'\u0124': b'\\^{H}',
    u'\u0125': b'\\^{h}',
    u'\u0126': b'{\\fontencoding{LELA}\\selectfont\\char40}',
    u'\u0127': b'\\Elzxh ',
    u'\u0128': b'\\~{I}',
    u'\u0129': b'\\~{\\i}',
    u'\u012A': b'\\={I}',
    u'\u012B': b'\\={\\i}',
    u'\u012C': b'\\u{I}',
    u'\u012D': b'\\u{\\i}',
    u'\u012E': b'\\k{I}',
    u'\u012F': b'\\k{i}',
    u'\u0130': b'\\.{I}',
    u'\u0131': b'\\i ',
    u'\u0132': b'IJ',
    u'\u0133': b'ij',
    u'\u0134': b'\\^{J}',
    u'\u0135': b'\\^{\\j}',
    u'\u0136': b'\\c{K}',
    u'\u0137': b'\\c{k}',
    u'\u0138': b'{\\fontencoding{LELA}\\selectfont\\char91}',
    u'\u0139': b"\\'{L}",
    u'\u013A': b"\\'{l}",
    u'\u013B': b'\\c{L}',
    u'\u013C': b'\\c{l}',
    u'\u013D': b'\\v{L}',
    u'\u013E': b'\\v{l}',
    u'\u013F': b'{\\fontencoding{LELA}\\selectfont\\char201}',
    u'\u0140': b'{\\fontencoding{LELA}\\selectfont\\char202}',
    u'\u0141': b'\\L ',
    u'\u0142': b'\\l ',
    u'\u0143': b"\\'{N}",
    u'\u0144': b"\\'{n}",
    u'\u0145': b'\\c{N}',
    u'\u0146': b'\\c{n}',
    u'\u0147': b'\\v{N}',
    u'\u0148': b'\\v{n}',
    u'\u0149': b"'n",
    u'\u014A': b'\\NG ',
    u'\u014B': b'\\ng ',
    u'\u014C': b'\\={O}',
    u'\u014D': b'\\={o}',
    u'\u014E': b'\\u{O}',
    u'\u014F': b'\\u{o}',
    u'\u0150': b'\\H{O}',
    u'\u0151': b'\\H{o}',
    u'\u0152': b'\\OE ',
    u'\u0153': b'\\oe ',
    u'\u0154': b"\\'{R}",
    u'\u0155': b"\\'{r}",
    u'\u0156': b'\\c{R}',
    u'\u0157': b'\\c{r}',
    u'\u0158': b'\\v{R}',
    u'\u0159': b'\\v{r}',
    u'\u015A': b"\\'{S}",
    u'\u015B': b"\\'{s}",
    u'\u015C': b'\\^{S}',
    u'\u015D': b'\\^{s}',
    u'\u015E': b'\\c{S}',
    u'\u015F': b'\\c{s}',
    u'\u0160': b'\\v{S}',
    u'\u0161': b'\\v{s}',
    u'\u0162': b'\\c{T}',
    u'\u0163': b'\\c{t}',
    u'\u0164': b'\\v{T}',
    u'\u0165': b'\\v{t}',
    u'\u0166': b'{\\fontencoding{LELA}\\selectfont\\char47}',
    u'\u0167': b'{\\fontencoding{LELA}\\selectfont\\char63}',
    u'\u0168': b'\\~{U}',
    u'\u0169': b'\\~{u}',
    u'\u016A': b'\\={U}',
    u'\u016B': b'\\={u}',
    u'\u016C': b'\\u{U}',
    u'\u016D': b'\\u{u}',
    u'\u016E': b'\\r{U}',
    u'\u016F': b'\\r{u}',
    u'\u0170': b'\\H{U}',
    u'\u0171': b'\\H{u}',
    u'\u0172': b'\\k{U}',
    u'\u0173': b'\\k{u}',
    u'\u0174': b'\\^{W}',
    u'\u0175': b'\\^{w}',
    u'\u0176': b'\\^{Y}',
    u'\u0177': b'\\^{y}',
    u'\u0178': b'\\"{Y}',
    u'\u0179': b"\\'{Z}",
    u'\u017A': b"\\'{z}",
    u'\u017B': b'\\.{Z}',
    u'\u017C': b'\\.{z}',
    u'\u017D': b'\\v{Z}',
    u'\u017E': b'\\v{z}',
    u'\u0195': b'\\texthvlig ',
    u'\u019E': b'\\textnrleg ',
    u'\u01AA': b'\\eth ',
    u'\u01BA': b'{\\fontencoding{LELA}\\selectfont\\char195}',
    u'\u01C2': b'\\textdoublepipe ',
    u'\u01F5': b"\\'{g}",
    u'\u0250': b'\\Elztrna ',
    u'\u0252': b'\\Elztrnsa ',
    u'\u0254': b'\\Elzopeno ',
    u'\u0256': b'\\Elzrtld ',
    u'\u0258': b'{\\fontencoding{LEIP}\\selectfont\\char61}',
    u'\u0259': b'\\Elzschwa ',
    u'\u025B': b'\\varepsilon ',
    u'\u0263': b'\\Elzpgamma ',
    u'\u0264': b'\\Elzpbgam ',
    u'\u0265': b'\\Elztrnh ',
    u'\u026C': b'\\Elzbtdl ',
    u'\u026D': b'\\Elzrtll ',
    u'\u026F': b'\\Elztrnm ',
    u'\u0270': b'\\Elztrnmlr ',
    u'\u0271': b'\\Elzltlmr ',
    u'\u0272': b'\\Elzltln ',
    u'\u0273': b'\\Elzrtln ',
    u'\u0277': b'\\Elzclomeg ',
    u'\u0278': b'\\textphi ',
    u'\u0279': b'\\Elztrnr ',
    u'\u027A': b'\\Elztrnrl ',
    u'\u027B': b'\\Elzrttrnr ',
    u'\u027C': b'\\Elzrl ',
    u'\u027D': b'\\Elzrtlr ',
    u'\u027E': b'\\Elzfhr ',
    u'\u027F': b'{\\fontencoding{LEIP}\\selectfont\\char202}',
    u'\u0282': b'\\Elzrtls ',
    u'\u0283': b'\\Elzesh ',
    u'\u0287': b'\\Elztrnt ',
    u'\u0288': b'\\Elzrtlt ',
    u'\u028A': b'\\Elzpupsil ',
    u'\u028B': b'\\Elzpscrv ',
    u'\u028C': b'\\Elzinvv ',
    u'\u028D': b'\\Elzinvw ',
    u'\u028E': b'\\Elztrny ',
    u'\u0290': b'\\Elzrtlz ',
    u'\u0292': b'\\Elzyogh ',
    u'\u0294': b'\\Elzglst ',
    u'\u0295': b'\\Elzreglst ',
    u'\u0296': b'\\Elzinglst ',
    u'\u029E': b'\\textturnk ',
    u'\u02A4': b'\\Elzdyogh ',
    u'\u02A7': b'\\Elztesh ',
    u'\u02C7': b'\\textasciicaron ',
    u'\u02C8': b'\\Elzverts ',
    u'\u02CC': b'\\Elzverti ',
    u'\u02D0': b'\\Elzlmrk ',
    u'\u02D1': b'\\Elzhlmrk ',
    u'\u02D2': b'\\Elzsbrhr ',
    u'\u02D3': b'\\Elzsblhr ',
    u'\u02D4': b'\\Elzrais ',
    u'\u02D5': b'\\Elzlow ',
    u'\u02D8': b'\\textasciibreve ',
    u'\u02D9': b'\\textperiodcentered ',
    u'\u02DA': b'\\r{}',
    u'\u02DB': b'\\k{}',
    u'\u02DC': b'\\texttildelow ',
    u'\u02DD': b'\\H{}',
    u'\u02E5': b'\\tone{55}',
    u'\u02E6': b'\\tone{44}',
    u'\u02E7': b'\\tone{33}',
    u'\u02E8': b'\\tone{22}',
    u'\u02E9': b'\\tone{11}',
    u'\u0300': b'\\`',
    u'\u0301': b"\\'",
    u'\u0302': b'\\^',
    u'\u0303': b'\\~',
    u'\u0304': b'\\=',
    u'\u0306': b'\\u',
    u'\u0307': b'\\.',
    u'\u0308': b'\\"',
    u'\u030A': b'\\r',
    u'\u030B': b'\\H',
    u'\u030C': b'\\v',
    u'\u030F': b'\\cyrchar\\C',
    u'\u0311': b'{\\fontencoding{LECO}\\selectfont\\char177}',
    u'\u0318': b'{\\fontencoding{LECO}\\selectfont\\char184}',
    u'\u0319': b'{\\fontencoding{LECO}\\selectfont\\char185}',
    u'\u0321': b'\\Elzpalh ',
    u'\u0322': b'\\Elzrh ',
    u'\u0327': b'\\c',
    u'\u0328': b'\\k',
    u'\u032A': b'\\Elzsbbrg ',
    u'\u032B': b'{\\fontencoding{LECO}\\selectfont\\char203}',
    u'\u032F': b'{\\fontencoding{LECO}\\selectfont\\char207}',
    u'\u0335': b'\\Elzxl ',
    u'\u0336': b'\\Elzbar ',
    u'\u0337': b'{\\fontencoding{LECO}\\selectfont\\char215}',
    u'\u0338': b'{\\fontencoding{LECO}\\selectfont\\char216}',
    u'\u033A': b'{\\fontencoding{LECO}\\selectfont\\char218}',
    u'\u033B': b'{\\fontencoding{LECO}\\selectfont\\char219}',
    u'\u033C': b'{\\fontencoding{LECO}\\selectfont\\char220}',
    u'\u033D': b'{\\fontencoding{LECO}\\selectfont\\char221}',
    u'\u0361': b'{\\fontencoding{LECO}\\selectfont\\char225}',
    u'\u0386': b"\\'{A}",
    u'\u0388': b"\\'{E}",
    u'\u0389': b"\\'{H}",
    u'\u038A': b"\\'{}{I}",
    u'\u038C': b"\\'{}O",
    u'\u038E': b"\\mathrm{'Y}",
    u'\u038F': b"\\mathrm{'\\Omega}",
    u'\u0390': b'\\acute{\\ddot{\\iota}}',
    u'\u0391': b'\\Alpha ',
    u'\u0392': b'\\Beta ',
    u'\u0393': b'\\Gamma ',
    u'\u0394': b'\\Delta ',
    u'\u0395': b'\\Epsilon ',
    u'\u0396': b'\\Zeta ',
    u'\u0397': b'\\Eta ',
    u'\u0398': b'\\Theta ',
    u'\u0399': b'\\Iota ',
    u'\u039A': b'\\Kappa ',
    u'\u039B': b'\\Lambda ',
    u'\u039E': b'\\Xi ',
    u'\u03A0': b'\\Pi ',
    u'\u03A1': b'\\Rho ',
    u'\u03A3': b'\\Sigma ',
    u'\u03A4': b'\\Tau ',
    u'\u03A5': b'\\Upsilon ',
    u'\u03A6': b'\\Phi ',
    u'\u03A7': b'\\Chi ',
    u'\u03A8': b'\\Psi ',
    u'\u03A9': b'\\Omega ',
    u'\u03AA': b'\\mathrm{\\ddot{I}}',
    u'\u03AB': b'\\mathrm{\\ddot{Y}}',
    u'\u03AC': b"\\'{$\\alpha$}",
    u'\u03AD': b'\\acute{\\epsilon}',
    u'\u03AE': b'\\acute{\\eta}',
    u'\u03AF': b'\\acute{\\iota}',
    u'\u03B0': b'\\acute{\\ddot{\\upsilon}}',
    u'\u03B1': b'\\alpha ',
    u'\u03B2': b'\\beta ',
    u'\u03B3': b'\\gamma ',
    u'\u03B4': b'\\delta ',
    u'\u03B5': b'\\epsilon ',
    u'\u03B6': b'\\zeta ',
    u'\u03B7': b'\\eta ',
    u'\u03B8': b'\\texttheta ',
    u'\u03B9': b'\\iota ',
    u'\u03BA': b'\\kappa ',
    u'\u03BB': b'\\lambda ',
    u'\u03BC': b'\\mu ',
    u'\u03BD': b'\\nu ',
    u'\u03BE': b'\\xi ',
    u'\u03C0': b'\\pi ',
    u'\u03C1': b'\\rho ',
    u'\u03C2': b'\\varsigma ',
    u'\u03C3': b'\\sigma ',
    u'\u03C4': b'\\tau ',
    u'\u03C5': b'\\upsilon ',
    u'\u03C6': b'\\varphi ',
    u'\u03C7': b'\\chi ',
    u'\u03C8': b'\\psi ',
    u'\u03C9': b'\\omega ',
    u'\u03CA': b'\\ddot{\\iota}',
    u'\u03CB': b'\\ddot{\\upsilon}',
    u'\u03CC': b"\\'{o}",
    u'\u03CD': b'\\acute{\\upsilon}',
    u'\u03CE': b'\\acute{\\omega}',
    u'\u03D0': b'\\Pisymbol{ppi022}{87}',
    u'\u03D1': b'\\textvartheta ',
    u'\u03D2': b'\\Upsilon ',
    u'\u03D5': b'\\phi ',
    u'\u03D6': b'\\varpi ',
    u'\u03DA': b'\\Stigma ',
    u'\u03DC': b'\\Digamma ',
    u'\u03DD': b'\\digamma ',
    u'\u03DE': b'\\Koppa ',
    u'\u03E0': b'\\Sampi ',
    u'\u03F0': b'\\varkappa ',
    u'\u03F1': b'\\varrho ',
    u'\u03F4': b'\\textTheta ',
    u'\u03F6': b'\\backepsilon ',
    u'\u0401': b'\\cyrchar\\CYRYO ',
    u'\u0402': b'\\cyrchar\\CYRDJE ',
    u'\u0403': b"\\cyrchar{\\'\\CYRG}",
    u'\u0404': b'\\cyrchar\\CYRIE ',
    u'\u0405': b'\\cyrchar\\CYRDZE ',
    u'\u0406': b'\\cyrchar\\CYRII ',
    u'\u0407': b'\\cyrchar\\CYRYI ',
    u'\u0408': b'\\cyrchar\\CYRJE ',
    u'\u0409': b'\\cyrchar\\CYRLJE ',
    u'\u040A': b'\\cyrchar\\CYRNJE ',
    u'\u040B': b'\\cyrchar\\CYRTSHE ',
    u'\u040C': b"\\cyrchar{\\'\\CYRK}",
    u'\u040E': b'\\cyrchar\\CYRUSHRT ',
    u'\u040F': b'\\cyrchar\\CYRDZHE ',
    u'\u0410': b'\\cyrchar\\CYRA ',
    u'\u0411': b'\\cyrchar\\CYRB ',
    u'\u0412': b'\\cyrchar\\CYRV ',
    u'\u0413': b'\\cyrchar\\CYRG ',
    u'\u0414': b'\\cyrchar\\CYRD ',
    u'\u0415': b'\\cyrchar\\CYRE ',
    u'\u0416': b'\\cyrchar\\CYRZH ',
    u'\u0417': b'\\cyrchar\\CYRZ ',
    u'\u0418': b'\\cyrchar\\CYRI ',
    u'\u0419': b'\\cyrchar\\CYRISHRT ',
    u'\u041A': b'\\cyrchar\\CYRK ',
    u'\u041B': b'\\cyrchar\\CYRL ',
    u'\u041C': b'\\cyrchar\\CYRM ',
    u'\u041D': b'\\cyrchar\\CYRN ',
    u'\u041E': b'\\cyrchar\\CYRO ',
    u'\u041F': b'\\cyrchar\\CYRP ',
    u'\u0420': b'\\cyrchar\\CYRR ',
    u'\u0421': b'\\cyrchar\\CYRS ',
    u'\u0422': b'\\cyrchar\\CYRT ',
    u'\u0423': b'\\cyrchar\\CYRU ',
    u'\u0424': b'\\cyrchar\\CYRF ',
    u'\u0425': b'\\cyrchar\\CYRH ',
    u'\u0426': b'\\cyrchar\\CYRC ',
    u'\u0427': b'\\cyrchar\\CYRCH ',
    u'\u0428': b'\\cyrchar\\CYRSH ',
    u'\u0429': b'\\cyrchar\\CYRSHCH ',
    u'\u042A': b'\\cyrchar\\CYRHRDSN ',
    u'\u042B': b'\\cyrchar\\CYRERY ',
    u'\u042C': b'\\cyrchar\\CYRSFTSN ',
    u'\u042D': b'\\cyrchar\\CYREREV ',
    u'\u042E': b'\\cyrchar\\CYRYU ',
    u'\u042F': b'\\cyrchar\\CYRYA ',
    u'\u0430': b'\\cyrchar\\cyra ',
    u'\u0431': b'\\cyrchar\\cyrb ',
    u'\u0432': b'\\cyrchar\\cyrv ',
    u'\u0433': b'\\cyrchar\\cyrg ',
    u'\u0434': b'\\cyrchar\\cyrd ',
    u'\u0435': b'\\cyrchar\\cyre ',
    u'\u0436': b'\\cyrchar\\cyrzh ',
    u'\u0437': b'\\cyrchar\\cyrz ',
    u'\u0438': b'\\cyrchar\\cyri ',
    u'\u0439': b'\\cyrchar\\cyrishrt ',
    u'\u043A': b'\\cyrchar\\cyrk ',
    u'\u043B': b'\\cyrchar\\cyrl ',
    u'\u043C': b'\\cyrchar\\cyrm ',
    u'\u043D': b'\\cyrchar\\cyrn ',
    u'\u043E': b'\\cyrchar\\cyro ',
    u'\u043F': b'\\cyrchar\\cyrp ',
    u'\u0440': b'\\cyrchar\\cyrr ',
    u'\u0441': b'\\cyrchar\\cyrs ',
    u'\u0442': b'\\cyrchar\\cyrt ',
    u'\u0443': b'\\cyrchar\\cyru ',
    u'\u0444': b'\\cyrchar\\cyrf ',
    u'\u0445': b'\\cyrchar\\cyrh ',
    u'\u0446': b'\\cyrchar\\cyrc ',
    u'\u0447': b'\\cyrchar\\cyrch ',
    u'\u0448': b'\\cyrchar\\cyrsh ',
    u'\u0449': b'\\cyrchar\\cyrshch ',
    u'\u044A': b'\\cyrchar\\cyrhrdsn ',
    u'\u044B': b'\\cyrchar\\cyrery ',
    u'\u044C': b'\\cyrchar\\cyrsftsn ',
    u'\u044D': b'\\cyrchar\\cyrerev ',
    u'\u044E': b'\\cyrchar\\cyryu ',
    u'\u044F': b'\\cyrchar\\cyrya ',
    u'\u0451': b'\\cyrchar\\cyryo ',
    u'\u0452': b'\\cyrchar\\cyrdje ',
    u'\u0453': b"\\cyrchar{\\'\\cyrg}",
    u'\u0454': b'\\cyrchar\\cyrie ',
    u'\u0455': b'\\cyrchar\\cyrdze ',
    u'\u0456': b'\\cyrchar\\cyrii ',
    u'\u0457': b'\\cyrchar\\cyryi ',
    u'\u0458': b'\\cyrchar\\cyrje ',
    u'\u0459': b'\\cyrchar\\cyrlje ',
    u'\u045A': b'\\cyrchar\\cyrnje ',
    u'\u045B': b'\\cyrchar\\cyrtshe ',
    u'\u045C': b"\\cyrchar{\\'\\cyrk}",
    u'\u045E': b'\\cyrchar\\cyrushrt ',
    u'\u045F': b'\\cyrchar\\cyrdzhe ',
    u'\u0460': b'\\cyrchar\\CYROMEGA ',
    u'\u0461': b'\\cyrchar\\cyromega ',
    u'\u0462': b'\\cyrchar\\CYRYAT ',
    u'\u0464': b'\\cyrchar\\CYRIOTE ',
    u'\u0465': b'\\cyrchar\\cyriote ',
    u'\u0466': b'\\cyrchar\\CYRLYUS ',
    u'\u0467': b'\\cyrchar\\cyrlyus ',
    u'\u0468': b'\\cyrchar\\CYRIOTLYUS ',
    u'\u0469': b'\\cyrchar\\cyriotlyus ',
    u'\u046A': b'\\cyrchar\\CYRBYUS ',
    u'\u046C': b'\\cyrchar\\CYRIOTBYUS ',
    u'\u046D': b'\\cyrchar\\cyriotbyus ',
    u'\u046E': b'\\cyrchar\\CYRKSI ',
    u'\u046F': b'\\cyrchar\\cyrksi ',
    u'\u0470': b'\\cyrchar\\CYRPSI ',
    u'\u0471': b'\\cyrchar\\cyrpsi ',
    u'\u0472': b'\\cyrchar\\CYRFITA ',
    u'\u0474': b'\\cyrchar\\CYRIZH ',
    u'\u0478': b'\\cyrchar\\CYRUK ',
    u'\u0479': b'\\cyrchar\\cyruk ',
    u'\u047A': b'\\cyrchar\\CYROMEGARND ',
    u'\u047B': b'\\cyrchar\\cyromegarnd ',
    u'\u047C': b'\\cyrchar\\CYROMEGATITLO ',
    u'\u047D': b'\\cyrchar\\cyromegatitlo ',
    u'\u047E': b'\\cyrchar\\CYROT ',
    u'\u047F': b'\\cyrchar\\cyrot ',
    u'\u0480': b'\\cyrchar\\CYRKOPPA ',
    u'\u0481': b'\\cyrchar\\cyrkoppa ',
    u'\u0482': b'\\cyrchar\\cyrthousands ',
    u'\u0488': b'\\cyrchar\\cyrhundredthousands ',
    u'\u0489': b'\\cyrchar\\cyrmillions ',
    u'\u048C': b'\\cyrchar\\CYRSEMISFTSN ',
    u'\u048D': b'\\cyrchar\\cyrsemisftsn ',
    u'\u048E': b'\\cyrchar\\CYRRTICK ',
    u'\u048F': b'\\cyrchar\\cyrrtick ',
    u'\u0490': b'\\cyrchar\\CYRGUP ',
    u'\u0491': b'\\cyrchar\\cyrgup ',
    u'\u0492': b'\\cyrchar\\CYRGHCRS ',
    u'\u0493': b'\\cyrchar\\cyrghcrs ',
    u'\u0494': b'\\cyrchar\\CYRGHK ',
    u'\u0495': b'\\cyrchar\\cyrghk ',
    u'\u0496': b'\\cyrchar\\CYRZHDSC ',
    u'\u0497': b'\\cyrchar\\cyrzhdsc ',
    u'\u0498': b'\\cyrchar\\CYRZDSC ',
    u'\u0499': b'\\cyrchar\\cyrzdsc ',
    u'\u049A': b'\\cyrchar\\CYRKDSC ',
    u'\u049B': b'\\cyrchar\\cyrkdsc ',
    u'\u049C': b'\\cyrchar\\CYRKVCRS ',
    u'\u049D': b'\\cyrchar\\cyrkvcrs ',
    u'\u049E': b'\\cyrchar\\CYRKHCRS ',
    u'\u049F': b'\\cyrchar\\cyrkhcrs ',
    u'\u04A0': b'\\cyrchar\\CYRKBEAK ',
    u'\u04A1': b'\\cyrchar\\cyrkbeak ',
    u'\u04A2': b'\\cyrchar\\CYRNDSC ',
    u'\u04A3': b'\\cyrchar\\cyrndsc ',
    u'\u04A4': b'\\cyrchar\\CYRNG ',
    u'\u04A5': b'\\cyrchar\\cyrng ',
    u'\u04A6': b'\\cyrchar\\CYRPHK ',
    u'\u04A7': b'\\cyrchar\\cyrphk ',
    u'\u04A8': b'\\cyrchar\\CYRABHHA ',
    u'\u04A9': b'\\cyrchar\\cyrabhha ',
    u'\u04AA': b'\\cyrchar\\CYRSDSC ',
    u'\u04AB': b'\\cyrchar\\cyrsdsc ',
    u'\u04AC': b'\\cyrchar\\CYRTDSC ',
    u'\u04AD': b'\\cyrchar\\cyrtdsc ',
    u'\u04AE': b'\\cyrchar\\CYRY ',
    u'\u04AF': b'\\cyrchar\\cyry ',
    u'\u04B0': b'\\cyrchar\\CYRYHCRS ',
    u'\u04B1': b'\\cyrchar\\cyryhcrs ',
    u'\u04B2': b'\\cyrchar\\CYRHDSC ',
    u'\u04B3': b'\\cyrchar\\cyrhdsc ',
    u'\u04B4': b'\\cyrchar\\CYRTETSE ',
    u'\u04B5': b'\\cyrchar\\cyrtetse ',
    u'\u04B6': b'\\cyrchar\\CYRCHRDSC ',
    u'\u04B7': b'\\cyrchar\\cyrchrdsc ',
    u'\u04B8': b'\\cyrchar\\CYRCHVCRS ',
    u'\u04B9': b'\\cyrchar\\cyrchvcrs ',
    u'\u04BA': b'\\cyrchar\\CYRSHHA ',
    u'\u04BB': b'\\cyrchar\\cyrshha ',
    u'\u04BC': b'\\cyrchar\\CYRABHCH ',
    u'\u04BD': b'\\cyrchar\\cyrabhch ',
    u'\u04BE': b'\\cyrchar\\CYRABHCHDSC ',
    u'\u04BF': b'\\cyrchar\\cyrabhchdsc ',
    u'\u04C0': b'\\cyrchar\\CYRpalochka ',
    u'\u04C3': b'\\cyrchar\\CYRKHK ',
    u'\u04C4': b'\\cyrchar\\cyrkhk ',
    u'\u04C7': b'\\cyrchar\\CYRNHK ',
    u'\u04C8': b'\\cyrchar\\cyrnhk ',
    u'\u04CB': b'\\cyrchar\\CYRCHLDSC ',
    u'\u04CC': b'\\cyrchar\\cyrchldsc ',
    u'\u04D4': b'\\cyrchar\\CYRAE ',
    u'\u04D5': b'\\cyrchar\\cyrae ',
    u'\u04D8': b'\\cyrchar\\CYRSCHWA ',
    u'\u04D9': b'\\cyrchar\\cyrschwa ',
    u'\u04E0': b'\\cyrchar\\CYRABHDZE ',
    u'\u04E1': b'\\cyrchar\\cyrabhdze ',
    u'\u04E8': b'\\cyrchar\\CYROTLD ',
    u'\u04E9': b'\\cyrchar\\cyrotld ',
    u'\u2002': b'\\hspace{0.6em}',
    u'\u2003': b'\\hspace{1em}',
    u'\u2004': b'\\hspace{0.33em}',
    u'\u2005': b'\\hspace{0.25em}',
    u'\u2006': b'\\hspace{0.166em}',
    u'\u2007': b'\\hphantom{0}',
    u'\u2008': b'\\hphantom{,}',
    u'\u2009': b'\\hspace{0.167em}',
    u'\u2009-0200A-0200A': b'\\;',
    u'\u200A': b'\\mkern1mu ',
    u'\u2013': b'\\textendash ',
    u'\u2014': b'\\textemdash ',
    u'\u2015': b'\\rule{1em}{1pt}',
    u'\u2016': b'\\Vert ',
    u'\u201B': b'\\Elzreapos ',
    u'\u201C': b'\\textquotedblleft ',
    u'\u201D': b'\\textquotedblright ',
    u'\u201E': b',,',
    u'\u2020': b'\\textdagger ',
    u'\u2021': b'\\textdaggerdbl ',
    u'\u2022': b'\\textbullet ',
    u'\u2025': b'..',
    u'\u2026': b'\\ldots ',
    u'\u2030': b'\\textperthousand ',
    u'\u2031': b'\\textpertenthousand ',
    u'\u2032': b"{'}",
    u'\u2033': b"{''}",
    u'\u2034': b"{'''}",
    u'\u2035': b'\\backprime ',
    u'\u2039': b'\\guilsinglleft ',
    u'\u203A': b'\\guilsinglright ',
    u'\u2057': b"''''",
    u'\u205F': b'\\mkern4mu ',
    u'\u2060': b'\\nolinebreak ',
    u'\u20A7': b'\\ensuremath{\\Elzpes}',
    u'\u20AC': b'\\mbox{\\texteuro} ',
    u'\u20DB': b'\\dddot ',
    u'\u20DC': b'\\ddddot ',
    u'\u2102': b'\\mathbb{C}',
    u'\u210A': b'\\mathscr{g}',
    u'\u210B': b'\\mathscr{H}',
    u'\u210C': b'\\mathfrak{H}',
    u'\u210D': b'\\mathbb{H}',
    u'\u210F': b'\\hslash ',
    u'\u2110': b'\\mathscr{I}',
    u'\u2111': b'\\mathfrak{I}',
    u'\u2112': b'\\mathscr{L}',
    u'\u2113': b'\\mathscr{l}',
    u'\u2115': b'\\mathbb{N}',
    u'\u2116': b'\\cyrchar\\textnumero ',
    u'\u2118': b'\\wp ',
    u'\u2119': b'\\mathbb{P}',
    u'\u211A': b'\\mathbb{Q}',
    u'\u211B': b'\\mathscr{R}',
    u'\u211C': b'\\mathfrak{R}',
    u'\u211D': b'\\mathbb{R}',
    u'\u211E': b'\\Elzxrat ',
    u'\u2122': b'\\texttrademark ',
    u'\u2124': b'\\mathbb{Z}',
    u'\u2126': b'\\Omega ',
    u'\u2127': b'\\mho ',
    u'\u2128': b'\\mathfrak{Z}',
    u'\u2129': b'\\ElsevierGlyph{2129}',
    u'\u212B': b'\\AA ',
    u'\u212C': b'\\mathscr{B}',
    u'\u212D': b'\\mathfrak{C}',
    u'\u212F': b'\\mathscr{e}',
    u'\u2130': b'\\mathscr{E}',
    u'\u2131': b'\\mathscr{F}',
    u'\u2133': b'\\mathscr{M}',
    u'\u2134': b'\\mathscr{o}',
    u'\u2135': b'\\aleph ',
    u'\u2136': b'\\beth ',
    u'\u2137': b'\\gimel ',
    u'\u2138': b'\\daleth ',
    u'\u2153': b'\\textfrac{1}{3}',
    u'\u2154': b'\\textfrac{2}{3}',
    u'\u2155': b'\\textfrac{1}{5}',
    u'\u2156': b'\\textfrac{2}{5}',
    u'\u2157': b'\\textfrac{3}{5}',
    u'\u2158': b'\\textfrac{4}{5}',
    u'\u2159': b'\\textfrac{1}{6}',
    u'\u215A': b'\\textfrac{5}{6}',
    u'\u215B': b'\\textfrac{1}{8}',
    u'\u215C': b'\\textfrac{3}{8}',
    u'\u215D': b'\\textfrac{5}{8}',
    u'\u215E': b'\\textfrac{7}{8}',
    u'\u2190': b'\\leftarrow ',
    u'\u2191': b'\\uparrow ',
    u'\u2192': b'\\rightarrow ',
    u'\u2193': b'\\downarrow ',
    u'\u2194': b'\\leftrightarrow ',
    u'\u2195': b'\\updownarrow ',
    u'\u2196': b'\\nwarrow ',
    u'\u2197': b'\\nearrow ',
    u'\u2198': b'\\searrow ',
    u'\u2199': b'\\swarrow ',
    u'\u219A': b'\\nleftarrow ',
    u'\u219B': b'\\nrightarrow ',
    u'\u219C': b'\\arrowwaveright ',
    u'\u219D': b'\\arrowwaveright ',
    u'\u219E': b'\\twoheadleftarrow ',
    u'\u21A0': b'\\twoheadrightarrow ',
    u'\u21A2': b'\\leftarrowtail ',
    u'\u21A3': b'\\rightarrowtail ',
    u'\u21A6': b'\\mapsto ',
    u'\u21A9': b'\\hookleftarrow ',
    u'\u21AA': b'\\hookrightarrow ',
    u'\u21AB': b'\\looparrowleft ',
    u'\u21AC': b'\\looparrowright ',
    u'\u21AD': b'\\leftrightsquigarrow ',
    u'\u21AE': b'\\nleftrightarrow ',
    u'\u21B0': b'\\Lsh ',
    u'\u21B1': b'\\Rsh ',
    u'\u21B3': b'\\ElsevierGlyph{21B3}',
    u'\u21B6': b'\\curvearrowleft ',
    u'\u21B7': b'\\curvearrowright ',
    u'\u21BA': b'\\circlearrowleft ',
    u'\u21BB': b'\\circlearrowright ',
    u'\u21BC': b'\\leftharpoonup ',
    u'\u21BD': b'\\leftharpoondown ',
    u'\u21BE': b'\\upharpoonright ',
    u'\u21BF': b'\\upharpoonleft ',
    u'\u21C0': b'\\rightharpoonup ',
    u'\u21C1': b'\\rightharpoondown ',
    u'\u21C2': b'\\downharpoonright ',
    u'\u21C3': b'\\downharpoonleft ',
    u'\u21C4': b'\\rightleftarrows ',
    u'\u21C5': b'\\dblarrowupdown ',
    u'\u21C6': b'\\leftrightarrows ',
    u'\u21C7': b'\\leftleftarrows ',
    u'\u21C8': b'\\upuparrows ',
    u'\u21C9': b'\\rightrightarrows ',
    u'\u21CA': b'\\downdownarrows ',
    u'\u21CB': b'\\leftrightharpoons ',
    u'\u21CC': b'\\rightleftharpoons ',
    u'\u21CD': b'\\nLeftarrow ',
    u'\u21CE': b'\\nLeftrightarrow ',
    u'\u21CF': b'\\nRightarrow ',
    u'\u21D0': b'\\Leftarrow ',
    u'\u21D1': b'\\Uparrow ',
    u'\u21D2': b'\\Rightarrow ',
    u'\u21D3': b'\\Downarrow ',
    u'\u21D4': b'\\Leftrightarrow ',
    u'\u21D5': b'\\Updownarrow ',
    u'\u21DA': b'\\Lleftarrow ',
    u'\u21DB': b'\\Rrightarrow ',
    u'\u21DD': b'\\rightsquigarrow ',
    u'\u21F5': b'\\DownArrowUpArrow ',
    u'\u2200': b'\\forall ',
    u'\u2201': b'\\complement ',
    u'\u2202': b'\\partial ',
    u'\u2203': b'\\exists ',
    u'\u2204': b'\\nexists ',
    u'\u2205': b'\\varnothing ',
    u'\u2207': b'\\nabla ',
    u'\u2208': b'\\in ',
    u'\u2209': b'\\not\\in ',
    u'\u220B': b'\\ni ',
    u'\u220C': b'\\not\\ni ',
    u'\u220F': b'\\prod ',
    u'\u2210': b'\\coprod ',
    u'\u2211': b'\\sum ',
    u'\u2213': b'\\mp ',
    u'\u2214': b'\\dotplus ',
    u'\u2216': b'\\setminus ',
    u'\u2217': b'{_\\ast}',
    u'\u2218': b'\\circ ',
    u'\u2219': b'\\bullet ',
    u'\u221A': b'\\surd ',
    u'\u221D': b'\\propto ',
    u'\u221E': b'\\infty ',
    u'\u221F': b'\\rightangle ',
    u'\u2220': b'\\angle ',
    u'\u2221': b'\\measuredangle ',
    u'\u2222': b'\\sphericalangle ',
    u'\u2223': b'\\mid ',
    u'\u2224': b'\\nmid ',
    u'\u2225': b'\\parallel ',
    u'\u2226': b'\\nparallel ',
    u'\u2227': b'\\wedge ',
    u'\u2228': b'\\vee ',
    u'\u2229': b'\\cap ',
    u'\u222A': b'\\cup ',
    u'\u222B': b'\\int ',
    u'\u222C': b'\\int\\!\\int ',
    u'\u222D': b'\\int\\!\\int\\!\\int ',
    u'\u222E': b'\\oint ',
    u'\u222F': b'\\surfintegral ',
    u'\u2230': b'\\volintegral ',
    u'\u2231': b'\\clwintegral ',
    u'\u2232': b'\\ElsevierGlyph{2232}',
    u'\u2233': b'\\ElsevierGlyph{2233}',
    u'\u2234': b'\\therefore ',
    u'\u2235': b'\\because ',
    u'\u2237': b'\\Colon ',
    u'\u2238': b'\\ElsevierGlyph{2238}',
    u'\u223A': b'\\mathbin{{:}\\!\\!{-}\\!\\!{:}}',
    u'\u223B': b'\\homothetic ',
    u'\u223C': b'\\sim ',
    u'\u223D': b'\\backsim ',
    u'\u223E': b'\\lazysinv ',
    u'\u2240': b'\\wr ',
    u'\u2241': b'\\not\\sim ',
    u'\u2242': b'\\ElsevierGlyph{2242}',
    u'\u2242-00338': b'\\NotEqualTilde ',
    u'\u2243': b'\\simeq ',
    u'\u2244': b'\\not\\simeq ',
    u'\u2245': b'\\cong ',
    u'\u2246': b'\\approxnotequal ',
    u'\u2247': b'\\not\\cong ',
    u'\u2248': b'\\approx ',
    u'\u2249': b'\\not\\approx ',
    u'\u224A': b'\\approxeq ',
    u'\u224B': b'\\tildetrpl ',
    u'\u224B-00338': b'\\not\\apid ',
    u'\u224C': b'\\allequal ',
    u'\u224D': b'\\asymp ',
    u'\u224E': b'\\Bumpeq ',
    u'\u224E-00338': b'\\NotHumpDownHump ',
    u'\u224F': b'\\bumpeq ',
    u'\u224F-00338': b'\\NotHumpEqual ',
    u'\u2250': b'\\doteq ',
    u'\u2250-00338': b'\\not\\doteq',
    u'\u2251': b'\\doteqdot ',
    u'\u2252': b'\\fallingdotseq ',
    u'\u2253': b'\\risingdotseq ',
    u'\u2254': b':=',
    u'\u2255': b'=:',
    u'\u2256': b'\\eqcirc ',
    u'\u2257': b'\\circeq ',
    u'\u2259': b'\\estimates ',
    u'\u225A': b'\\ElsevierGlyph{225A}',
    u'\u225B': b'\\starequal ',
    u'\u225C': b'\\triangleq ',
    u'\u225F': b'\\ElsevierGlyph{225F}',
    u'\u2260': b'\\not =',
    u'\u2261': b'\\equiv ',
    u'\u2262': b'\\not\\equiv ',
    u'\u2264': b'\\leq ',
    u'\u2265': b'\\geq ',
    u'\u2266': b'\\leqq ',
    u'\u2267': b'\\geqq ',
    u'\u2268': b'\\lneqq ',
    u'\u2268-0FE00': b'\\lvertneqq ',
    u'\u2269': b'\\gneqq ',
    u'\u2269-0FE00': b'\\gvertneqq ',
    u'\u226A': b'\\ll ',
    u'\u226A-00338': b'\\NotLessLess ',
    u'\u226B': b'\\gg ',
    u'\u226B-00338': b'\\NotGreaterGreater ',
    u'\u226C': b'\\between ',
    u'\u226D': b'\\not\\kern-0.3em\\times ',
    u'\u226E': b'\\not&lt;',
    u'\u226F': b'\\not&gt;',
    u'\u2270': b'\\not\\leq ',
    u'\u2271': b'\\not\\geq ',
    u'\u2272': b'\\lessequivlnt ',
    u'\u2273': b'\\greaterequivlnt ',
    u'\u2274': b'\\ElsevierGlyph{2274}',
    u'\u2275': b'\\ElsevierGlyph{2275}',
    u'\u2276': b'\\lessgtr ',
    u'\u2277': b'\\gtrless ',
    u'\u2278': b'\\notlessgreater ',
    u'\u2279': b'\\notgreaterless ',
    u'\u227A': b'\\prec ',
    u'\u227B': b'\\succ ',
    u'\u227C': b'\\preccurlyeq ',
    u'\u227D': b'\\succcurlyeq ',
    u'\u227E': b'\\precapprox ',
    u'\u227E-00338': b'\\NotPrecedesTilde ',
    u'\u227F': b'\\succapprox ',
    u'\u227F-00338': b'\\NotSucceedsTilde ',
    u'\u2280': b'\\not\\prec ',
    u'\u2281': b'\\not\\succ ',
    u'\u2282': b'\\subset ',
    u'\u2283': b'\\supset ',
    u'\u2284': b'\\not\\subset ',
    u'\u2285': b'\\not\\supset ',
    u'\u2286': b'\\subseteq ',
    u'\u2287': b'\\supseteq ',
    u'\u2288': b'\\not\\subseteq ',
    u'\u2289': b'\\not\\supseteq ',
    u'\u228A': b'\\subsetneq ',
    u'\u228A-0FE00': b'\\varsubsetneqq ',
    u'\u228B': b'\\supsetneq ',
    u'\u228B-0FE00': b'\\varsupsetneq ',
    u'\u228E': b'\\uplus ',
    u'\u228F': b'\\sqsubset ',
    u'\u228F-00338': b'\\NotSquareSubset ',
    u'\u2290': b'\\sqsupset ',
    u'\u2290-00338': b'\\NotSquareSuperset ',
    u'\u2291': b'\\sqsubseteq ',
    u'\u2292': b'\\sqsupseteq ',
    u'\u2293': b'\\sqcap ',
    u'\u2294': b'\\sqcup ',
    u'\u2295': b'\\oplus ',
    u'\u2296': b'\\ominus ',
    u'\u2297': b'\\otimes ',
    u'\u2298': b'\\oslash ',
    u'\u2299': b'\\odot ',
    u'\u229A': b'\\circledcirc ',
    u'\u229B': b'\\circledast ',
    u'\u229D': b'\\circleddash ',
    u'\u229E': b'\\boxplus ',
    u'\u229F': b'\\boxminus ',
    u'\u22A0': b'\\boxtimes ',
    u'\u22A1': b'\\boxdot ',
    u'\u22A2': b'\\vdash ',
    u'\u22A3': b'\\dashv ',
    u'\u22A4': b'\\top ',
    u'\u22A5': b'\\perp ',
    u'\u22A7': b'\\truestate ',
    u'\u22A8': b'\\forcesextra ',
    u'\u22A9': b'\\Vdash ',
    u'\u22AA': b'\\Vvdash ',
    u'\u22AB': b'\\VDash ',
    u'\u22AC': b'\\nvdash ',
    u'\u22AD': b'\\nvDash ',
    u'\u22AE': b'\\nVdash ',
    u'\u22AF': b'\\nVDash ',
    u'\u22B2': b'\\vartriangleleft ',
    u'\u22B3': b'\\vartriangleright ',
    u'\u22B4': b'\\trianglelefteq ',
    u'\u22B5': b'\\trianglerighteq ',
    u'\u22B6': b'\\original ',
    u'\u22B7': b'\\image ',
    u'\u22B8': b'\\multimap ',
    u'\u22B9': b'\\hermitconjmatrix ',
    u'\u22BA': b'\\intercal ',
    u'\u22BB': b'\\veebar ',
    u'\u22BE': b'\\rightanglearc ',
    u'\u22C0': b'\\ElsevierGlyph{22C0}',
    u'\u22C1': b'\\ElsevierGlyph{22C1}',
    u'\u22C2': b'\\bigcap ',
    u'\u22C3': b'\\bigcup ',
    u'\u22C4': b'\\diamond ',
    u'\u22C5': b'\\cdot ',
    u'\u22C6': b'\\star ',
    u'\u22C7': b'\\divideontimes ',
    u'\u22C8': b'\\bowtie ',
    u'\u22C9': b'\\ltimes ',
    u'\u22CA': b'\\rtimes ',
    u'\u22CB': b'\\leftthreetimes ',
    u'\u22CC': b'\\rightthreetimes ',
    u'\u22CD': b'\\backsimeq ',
    u'\u22CE': b'\\curlyvee ',
    u'\u22CF': b'\\curlywedge ',
    u'\u22D0': b'\\Subset ',
    u'\u22D1': b'\\Supset ',
    u'\u22D2': b'\\Cap ',
    u'\u22D3': b'\\Cup ',
    u'\u22D4': b'\\pitchfork ',
    u'\u22D6': b'\\lessdot ',
    u'\u22D7': b'\\gtrdot ',
    u'\u22D8': b'\\verymuchless ',
    u'\u22D9': b'\\verymuchgreater ',
    u'\u22DA': b'\\lesseqgtr ',
    u'\u22DB': b'\\gtreqless ',
    u'\u22DE': b'\\curlyeqprec ',
    u'\u22DF': b'\\curlyeqsucc ',
    u'\u22E2': b'\\not\\sqsubseteq ',
    u'\u22E3': b'\\not\\sqsupseteq ',
    u'\u22E5': b'\\Elzsqspne ',
    u'\u22E6': b'\\lnsim ',
    u'\u22E7': b'\\gnsim ',
    u'\u22E8': b'\\precedesnotsimilar ',
    u'\u22E9': b'\\succnsim ',
    u'\u22EA': b'\\ntriangleleft ',
    u'\u22EB': b'\\ntriangleright ',
    u'\u22EC': b'\\ntrianglelefteq ',
    u'\u22ED': b'\\ntrianglerighteq ',
    u'\u22EE': b'\\vdots ',
    u'\u22EF': b'\\cdots ',
    u'\u22F0': b'\\upslopeellipsis ',
    u'\u22F1': b'\\downslopeellipsis ',
    u'\u2305': b'\\barwedge ',
    u'\u2306': b'\\perspcorrespond ',
    u'\u2308': b'\\lceil ',
    u'\u2309': b'\\rceil ',
    u'\u230A': b'\\lfloor ',
    u'\u230B': b'\\rfloor ',
    u'\u2315': b'\\recorder ',
    u'\u2316': b'\\mathchar"2208',
    u'\u231C': b'\\ulcorner ',
    u'\u231D': b'\\urcorner ',
    u'\u231E': b'\\llcorner ',
    u'\u231F': b'\\lrcorner ',
    u'\u2322': b'\\frown ',
    u'\u2323': b'\\smile ',
    u'\u2329': b'\\langle ',
    u'\u232A': b'\\rangle ',
    u'\u233D': b'\\ElsevierGlyph{E838}',
    u'\u23A3': b'\\Elzdlcorn ',
    u'\u23B0': b'\\lmoustache ',
    u'\u23B1': b'\\rmoustache ',
    u'\u2423': b'\\textvisiblespace ',
    u'\u2460': b'\\ding{172}',
    u'\u2461': b'\\ding{173}',
    u'\u2462': b'\\ding{174}',
    u'\u2463': b'\\ding{175}',
    u'\u2464': b'\\ding{176}',
    u'\u2465': b'\\ding{177}',
    u'\u2466': b'\\ding{178}',
    u'\u2467': b'\\ding{179}',
    u'\u2468': b'\\ding{180}',
    u'\u2469': b'\\ding{181}',
    u'\u24C8': b'\\circledS ',
    u'\u2506': b'\\Elzdshfnc ',
    u'\u2519': b'\\Elzsqfnw ',
    u'\u2571': b'\\diagup ',
    u'\u25A0': b'\\ding{110}',
    u'\u25A1': b'\\square ',
    u'\u25AA': b'\\blacksquare ',
    u'\u25AD': b'\\fbox{~~}',
    u'\u25AF': b'\\Elzvrecto ',
    u'\u25B1': b'\\ElsevierGlyph{E381}',
    u'\u25B2': b'\\ding{115}',
    u'\u25B3': b'\\bigtriangleup ',
    u'\u25B4': b'\\blacktriangle ',
    u'\u25B5': b'\\vartriangle ',
    u'\u25B8': b'\\blacktriangleright ',
    u'\u25B9': b'\\triangleright ',
    u'\u25BC': b'\\ding{116}',
    u'\u25BD': b'\\bigtriangledown ',
    u'\u25BE': b'\\blacktriangledown ',
    u'\u25BF': b'\\triangledown ',
    u'\u25C2': b'\\blacktriangleleft ',
    u'\u25C3': b'\\triangleleft ',
    u'\u25C6': b'\\ding{117}',
    u'\u25CA': b'\\lozenge ',
    u'\u25CB': b'\\bigcirc ',
    u'\u25CF': b'\\ding{108}',
    u'\u25D0': b'\\Elzcirfl ',
    u'\u25D1': b'\\Elzcirfr ',
    u'\u25D2': b'\\Elzcirfb ',
    u'\u25D7': b'\\ding{119}',
    u'\u25D8': b'\\Elzrvbull ',
    u'\u25E7': b'\\Elzsqfl ',
    u'\u25E8': b'\\Elzsqfr ',
    u'\u25EA': b'\\Elzsqfse ',
    u'\u25EF': b'\\bigcirc ',
    u'\u2605': b'\\ding{72}',
    u'\u2606': b'\\ding{73}',
    u'\u260E': b'\\ding{37}',
    u'\u261B': b'\\ding{42}',
    u'\u261E': b'\\ding{43}',
    u'\u263E': b'\\rightmoon ',
    u'\u263F': b'\\mercury ',
    u'\u2640': b'\\venus ',
    u'\u2642': b'\\male ',
    u'\u2643': b'\\jupiter ',
    u'\u2644': b'\\saturn ',
    u'\u2645': b'\\uranus ',
    u'\u2646': b'\\neptune ',
    u'\u2647': b'\\pluto ',
    u'\u2648': b'\\aries ',
    u'\u2649': b'\\taurus ',
    u'\u264A': b'\\gemini ',
    u'\u264B': b'\\cancer ',
    u'\u264C': b'\\leo ',
    u'\u264D': b'\\virgo ',
    u'\u264E': b'\\libra ',
    u'\u264F': b'\\scorpio ',
    u'\u2650': b'\\sagittarius ',
    u'\u2651': b'\\capricornus ',
    u'\u2652': b'\\aquarius ',
    u'\u2653': b'\\pisces ',
    u'\u2660': b'\\ding{171}',
    u'\u2662': b'\\diamond ',
    u'\u2663': b'\\ding{168}',
    u'\u2665': b'\\ding{170}',
    u'\u2666': b'\\ding{169}',
    u'\u2669': b'\\quarternote ',
    u'\u266A': b'\\eighthnote ',
    u'\u266D': b'\\flat ',
    u'\u266E': b'\\natural ',
    u'\u266F': b'\\sharp ',
    u'\u2701': b'\\ding{33}',
    u'\u2702': b'\\ding{34}',
    u'\u2703': b'\\ding{35}',
    u'\u2704': b'\\ding{36}',
    u'\u2706': b'\\ding{38}',
    u'\u2707': b'\\ding{39}',
    u'\u2708': b'\\ding{40}',
    u'\u2709': b'\\ding{41}',
    u'\u270C': b'\\ding{44}',
    u'\u270D': b'\\ding{45}',
    u'\u270E': b'\\ding{46}',
    u'\u270F': b'\\ding{47}',
    u'\u2710': b'\\ding{48}',
    u'\u2711': b'\\ding{49}',
    u'\u2712': b'\\ding{50}',
    u'\u2713': b'\\ding{51}',
    u'\u2714': b'\\ding{52}',
    u'\u2715': b'\\ding{53}',
    u'\u2716': b'\\ding{54}',
    u'\u2717': b'\\ding{55}',
    u'\u2718': b'\\ding{56}',
    u'\u2719': b'\\ding{57}',
    u'\u271A': b'\\ding{58}',
    u'\u271B': b'\\ding{59}',
    u'\u271C': b'\\ding{60}',
    u'\u271D': b'\\ding{61}',
    u'\u271E': b'\\ding{62}',
    u'\u271F': b'\\ding{63}',
    u'\u2720': b'\\ding{64}',
    u'\u2721': b'\\ding{65}',
    u'\u2722': b'\\ding{66}',
    u'\u2723': b'\\ding{67}',
    u'\u2724': b'\\ding{68}',
    u'\u2725': b'\\ding{69}',
    u'\u2726': b'\\ding{70}',
    u'\u2727': b'\\ding{71}',
    u'\u2729': b'\\ding{73}',
    u'\u272A': b'\\ding{74}',
    u'\u272B': b'\\ding{75}',
    u'\u272C': b'\\ding{76}',
    u'\u272D': b'\\ding{77}',
    u'\u272E': b'\\ding{78}',
    u'\u272F': b'\\ding{79}',
    u'\u2730': b'\\ding{80}',
    u'\u2731': b'\\ding{81}',
    u'\u2732': b'\\ding{82}',
    u'\u2733': b'\\ding{83}',
    u'\u2734': b'\\ding{84}',
    u'\u2735': b'\\ding{85}',
    u'\u2736': b'\\ding{86}',
    u'\u2737': b'\\ding{87}',
    u'\u2738': b'\\ding{88}',
    u'\u2739': b'\\ding{89}',
    u'\u273A': b'\\ding{90}',
    u'\u273B': b'\\ding{91}',
    u'\u273C': b'\\ding{92}',
    u'\u273D': b'\\ding{93}',
    u'\u273E': b'\\ding{94}',
    u'\u273F': b'\\ding{95}',
    u'\u2740': b'\\ding{96}',
    u'\u2741': b'\\ding{97}',
    u'\u2742': b'\\ding{98}',
    u'\u2743': b'\\ding{99}',
    u'\u2744': b'\\ding{100}',
    u'\u2745': b'\\ding{101}',
    u'\u2746': b'\\ding{102}',
    u'\u2747': b'\\ding{103}',
    u'\u2748': b'\\ding{104}',
    u'\u2749': b'\\ding{105}',
    u'\u274A': b'\\ding{106}',
    u'\u274B': b'\\ding{107}',
    u'\u274D': b'\\ding{109}',
    u'\u274F': b'\\ding{111}',
    u'\u2750': b'\\ding{112}',
    u'\u2751': b'\\ding{113}',
    u'\u2752': b'\\ding{114}',
    u'\u2756': b'\\ding{118}',
    u'\u2758': b'\\ding{120}',
    u'\u2759': b'\\ding{121}',
    u'\u275A': b'\\ding{122}',
    u'\u275B': b'\\ding{123}',
    u'\u275C': b'\\ding{124}',
    u'\u275D': b'\\ding{125}',
    u'\u275E': b'\\ding{126}',
    u'\u2761': b'\\ding{161}',
    u'\u2762': b'\\ding{162}',
    u'\u2763': b'\\ding{163}',
    u'\u2764': b'\\ding{164}',
    u'\u2765': b'\\ding{165}',
    u'\u2766': b'\\ding{166}',
    u'\u2767': b'\\ding{167}',
    u'\u2776': b'\\ding{182}',
    u'\u2777': b'\\ding{183}',
    u'\u2778': b'\\ding{184}',
    u'\u2779': b'\\ding{185}',
    u'\u277A': b'\\ding{186}',
    u'\u277B': b'\\ding{187}',
    u'\u277C': b'\\ding{188}',
    u'\u277D': b'\\ding{189}',
    u'\u277E': b'\\ding{190}',
    u'\u277F': b'\\ding{191}',
    u'\u2780': b'\\ding{192}',
    u'\u2781': b'\\ding{193}',
    u'\u2782': b'\\ding{194}',
    u'\u2783': b'\\ding{195}',
    u'\u2784': b'\\ding{196}',
    u'\u2785': b'\\ding{197}',
    u'\u2786': b'\\ding{198}',
    u'\u2787': b'\\ding{199}',
    u'\u2788': b'\\ding{200}',
    u'\u2789': b'\\ding{201}',
    u'\u278A': b'\\ding{202}',
    u'\u278B': b'\\ding{203}',
    u'\u278C': b'\\ding{204}',
    u'\u278D': b'\\ding{205}',
    u'\u278E': b'\\ding{206}',
    u'\u278F': b'\\ding{207}',
    u'\u2790': b'\\ding{208}',
    u'\u2791': b'\\ding{209}',
    u'\u2792': b'\\ding{210}',
    u'\u2793': b'\\ding{211}',
    u'\u2794': b'\\ding{212}',
    u'\u2798': b'\\ding{216}',
    u'\u2799': b'\\ding{217}',
    u'\u279A': b'\\ding{218}',
    u'\u279B': b'\\ding{219}',
    u'\u279C': b'\\ding{220}',
    u'\u279D': b'\\ding{221}',
    u'\u279E': b'\\ding{222}',
    u'\u279F': b'\\ding{223}',
    u'\u27A0': b'\\ding{224}',
    u'\u27A1': b'\\ding{225}',
    u'\u27A2': b'\\ding{226}',
    u'\u27A3': b'\\ding{227}',
    u'\u27A4': b'\\ding{228}',
    u'\u27A5': b'\\ding{229}',
    u'\u27A6': b'\\ding{230}',
    u'\u27A7': b'\\ding{231}',
    u'\u27A8': b'\\ding{232}',
    u'\u27A9': b'\\ding{233}',
    u'\u27AA': b'\\ding{234}',
    u'\u27AB': b'\\ding{235}',
    u'\u27AC': b'\\ding{236}',
    u'\u27AD': b'\\ding{237}',
    u'\u27AE': b'\\ding{238}',
    u'\u27AF': b'\\ding{239}',
    u'\u27B1': b'\\ding{241}',
    u'\u27B2': b'\\ding{242}',
    u'\u27B3': b'\\ding{243}',
    u'\u27B4': b'\\ding{244}',
    u'\u27B5': b'\\ding{245}',
    u'\u27B6': b'\\ding{246}',
    u'\u27B7': b'\\ding{247}',
    u'\u27B8': b'\\ding{248}',
    u'\u27B9': b'\\ding{249}',
    u'\u27BA': b'\\ding{250}',
    u'\u27BB': b'\\ding{251}',
    u'\u27BC': b'\\ding{252}',
    u'\u27BD': b'\\ding{253}',
    u'\u27BE': b'\\ding{254}',
    u'\u27F5': b'\\longleftarrow ',
    u'\u27F6': b'\\longrightarrow ',
    u'\u27F7': b'\\longleftrightarrow ',
    u'\u27F8': b'\\Longleftarrow ',
    u'\u27F9': b'\\Longrightarrow ',
    u'\u27FA': b'\\Longleftrightarrow ',
    u'\u27FC': b'\\longmapsto ',
    u'\u27FF': b'\\sim\\joinrel\\leadsto',
    u'\u2905': b'\\ElsevierGlyph{E212}',
    u'\u2912': b'\\UpArrowBar ',
    u'\u2913': b'\\DownArrowBar ',
    u'\u2923': b'\\ElsevierGlyph{E20C}',
    u'\u2924': b'\\ElsevierGlyph{E20D}',
    u'\u2925': b'\\ElsevierGlyph{E20B}',
    u'\u2926': b'\\ElsevierGlyph{E20A}',
    u'\u2927': b'\\ElsevierGlyph{E211}',
    u'\u2928': b'\\ElsevierGlyph{E20E}',
    u'\u2929': b'\\ElsevierGlyph{E20F}',
    u'\u292A': b'\\ElsevierGlyph{E210}',
    u'\u2933': b'\\ElsevierGlyph{E21C}',
    u'\u2933-00338': b'\\ElsevierGlyph{E21D}',
    u'\u2936': b'\\ElsevierGlyph{E21A}',
    u'\u2937': b'\\ElsevierGlyph{E219}',
    u'\u2940': b'\\Elolarr ',
    u'\u2941': b'\\Elorarr ',
    u'\u2942': b'\\ElzRlarr ',
    u'\u2944': b'\\ElzrLarr ',
    u'\u2947': b'\\Elzrarrx ',
    u'\u294E': b'\\LeftRightVector ',
    u'\u294F': b'\\RightUpDownVector ',
    u'\u2950': b'\\DownLeftRightVector ',
    u'\u2951': b'\\LeftUpDownVector ',
    u'\u2952': b'\\LeftVectorBar ',
    u'\u2953': b'\\RightVectorBar ',
    u'\u2954': b'\\RightUpVectorBar ',
    u'\u2955': b'\\RightDownVectorBar ',
    u'\u2956': b'\\DownLeftVectorBar ',
    u'\u2957': b'\\DownRightVectorBar ',
    u'\u2958': b'\\LeftUpVectorBar ',
    u'\u2959': b'\\LeftDownVectorBar ',
    u'\u295A': b'\\LeftTeeVector ',
    u'\u295B': b'\\RightTeeVector ',
    u'\u295C': b'\\RightUpTeeVector ',
    u'\u295D': b'\\RightDownTeeVector ',
    u'\u295E': b'\\DownLeftTeeVector ',
    u'\u295F': b'\\DownRightTeeVector ',
    u'\u2960': b'\\LeftUpTeeVector ',
    u'\u2961': b'\\LeftDownTeeVector ',
    u'\u296E': b'\\UpEquilibrium ',
    u'\u296F': b'\\ReverseUpEquilibrium ',
    u'\u2970': b'\\RoundImplies ',
    u'\u297C': b'\\ElsevierGlyph{E214}',
    u'\u297D': b'\\ElsevierGlyph{E215}',
    u'\u2980': b'\\Elztfnc ',
    u'\u2985': b'\\ElsevierGlyph{3018}',
    u'\u2986': b'\\Elroang ',
    u'\u2993': b'&lt;\\kern-0.58em(',
    u'\u2994': b'\\ElsevierGlyph{E291}',
    u'\u2999': b'\\Elzddfnc ',
    u'\u299C': b'\\Angle ',
    u'\u29A0': b'\\Elzlpargt ',
    u'\u29B5': b'\\ElsevierGlyph{E260}',
    u'\u29B6': b'\\ElsevierGlyph{E61B}',
    u'\u29CA': b'\\ElzLap ',
    u'\u29CB': b'\\Elzdefas ',
    u'\u29CF': b'\\LeftTriangleBar ',
    u'\u29CF-00338': b'\\NotLeftTriangleBar ',
    u'\u29D0': b'\\RightTriangleBar ',
    u'\u29D0-00338': b'\\NotRightTriangleBar ',
    u'\u29DC': b'\\ElsevierGlyph{E372}',
    u'\u29EB': b'\\blacklozenge ',
    u'\u29F4': b'\\RuleDelayed ',
    u'\u2A04': b'\\Elxuplus ',
    u'\u2A05': b'\\ElzThr ',
    u'\u2A06': b'\\Elxsqcup ',
    u'\u2A07': b'\\ElzInf ',
    u'\u2A08': b'\\ElzSup ',
    u'\u2A0D': b'\\ElzCint ',
    u'\u2A0F': b'\\clockoint ',
    u'\u2A10': b'\\ElsevierGlyph{E395}',
    u'\u2A16': b'\\sqrint ',
    u'\u2A25': b'\\ElsevierGlyph{E25A}',
    u'\u2A2A': b'\\ElsevierGlyph{E25B}',
    u'\u2A2D': b'\\ElsevierGlyph{E25C}',
    u'\u2A2E': b'\\ElsevierGlyph{E25D}',
    u'\u2A2F': b'\\ElzTimes ',
    u'\u2A34': b'\\ElsevierGlyph{E25E}',
    u'\u2A35': b'\\ElsevierGlyph{E25E}',
    u'\u2A3C': b'\\ElsevierGlyph{E259}',
    u'\u2A3F': b'\\amalg ',
    u'\u2A53': b'\\ElzAnd ',
    u'\u2A54': b'\\ElzOr ',
    u'\u2A55': b'\\ElsevierGlyph{E36E}',
    u'\u2A56': b'\\ElOr ',
    u'\u2A5E': b'\\perspcorrespond ',
    u'\u2A5F': b'\\Elzminhat ',
    u'\u2A63': b'\\ElsevierGlyph{225A}',
    u'\u2A6E': b'\\stackrel{*}{=}',
    u'\u2A75': b'\\Equal ',
    u'\u2A7D': b'\\leqslant ',
    u'\u2A7D-00338': b'\\nleqslant ',
    u'\u2A7E': b'\\geqslant ',
    u'\u2A7E-00338': b'\\ngeqslant ',
    u'\u2A85': b'\\lessapprox ',
    u'\u2A86': b'\\gtrapprox ',
    u'\u2A87': b'\\lneq ',
    u'\u2A88': b'\\gneq ',
    u'\u2A89': b'\\lnapprox ',
    u'\u2A8A': b'\\gnapprox ',
    u'\u2A8B': b'\\lesseqqgtr ',
    u'\u2A8C': b'\\gtreqqless ',
    u'\u2A95': b'\\eqslantless ',
    u'\u2A96': b'\\eqslantgtr ',
    u'\u2A9D': b'\\Pisymbol{ppi020}{117}',
    u'\u2A9E': b'\\Pisymbol{ppi020}{105}',
    u'\u2AA1': b'\\NestedLessLess ',
    u'\u2AA1-00338': b'\\NotNestedLessLess ',
    u'\u2AA2': b'\\NestedGreaterGreater ',
    u'\u2AA2-00338': b'\\NotNestedGreaterGreater ',
    u'\u2AAF': b'\\preceq ',
    u'\u2AAF-00338': b'\\not\\preceq ',
    u'\u2AB0': b'\\succeq ',
    u'\u2AB0-00338': b'\\not\\succeq ',
    u'\u2AB5': b'\\precneqq ',
    u'\u2AB6': b'\\succneqq ',
    u'\u2AB7': b'\\precapprox ',
    u'\u2AB8': b'\\succapprox ',
    u'\u2AB9': b'\\precnapprox ',
    u'\u2ABA': b'\\succnapprox ',
    u'\u2AC5': b'\\subseteqq ',
    u'\u2AC5-00338': b'\\nsubseteqq ',
    u'\u2AC6': b'\\supseteqq ',
    u'\u2AC6-00338': b'\\nsupseteqq',
    u'\u2ACB': b'\\subsetneqq ',
    u'\u2ACC': b'\\supsetneqq ',
    u'\u2AEB': b'\\ElsevierGlyph{E30D}',
    u'\u2AF6': b'\\Elztdcol ',
    u'\u2AFD': b'{{/}\\!\\!{/}}',
    u'\u2AFD-020E5': b'{\\rlap{\\textbackslash}{{/}\\!\\!{/}}}',
    u'\u300A': b'\\ElsevierGlyph{300A}',
    u'\u300B': b'\\ElsevierGlyph{300B}',
    u'\u3018': b'\\ElsevierGlyph{3018}',
    u'\u3019': b'\\ElsevierGlyph{3019}',
    u'\u301A': b'\\openbracketleft ',
    u'\u301B': b'\\openbracketright ',
    u'\uFB00': b'ff',
    u'\uFB01': b'fi',
    u'\uFB02': b'fl',
    u'\uFB03': b'ffi',
    u'\uFB04': b'ffl',
    u'\uD400': b'\\mathbf{A}',
    u'\uD401': b'\\mathbf{B}',
    u'\uD402': b'\\mathbf{C}',
    u'\uD403': b'\\mathbf{D}',
    u'\uD404': b'\\mathbf{E}',
    u'\uD405': b'\\mathbf{F}',
    u'\uD406': b'\\mathbf{G}',
    u'\uD407': b'\\mathbf{H}',
    u'\uD408': b'\\mathbf{I}',
    u'\uD409': b'\\mathbf{J}',
    u'\uD40A': b'\\mathbf{K}',
    u'\uD40B': b'\\mathbf{L}',
    u'\uD40C': b'\\mathbf{M}',
    u'\uD40D': b'\\mathbf{N}',
    u'\uD40E': b'\\mathbf{O}',
    u'\uD40F': b'\\mathbf{P}',
    u'\uD410': b'\\mathbf{Q}',
    u'\uD411': b'\\mathbf{R}',
    u'\uD412': b'\\mathbf{S}',
    u'\uD413': b'\\mathbf{T}',
    u'\uD414': b'\\mathbf{U}',
    u'\uD415': b'\\mathbf{V}',
    u'\uD416': b'\\mathbf{W}',
    u'\uD417': b'\\mathbf{X}',
    u'\uD418': b'\\mathbf{Y}',
    u'\uD419': b'\\mathbf{Z}',
    u'\uD41A': b'\\mathbf{a}',
    u'\uD41B': b'\\mathbf{b}',
    u'\uD41C': b'\\mathbf{c}',
    u'\uD41D': b'\\mathbf{d}',
    u'\uD41E': b'\\mathbf{e}',
    u'\uD41F': b'\\mathbf{f}',
    u'\uD420': b'\\mathbf{g}',
    u'\uD421': b'\\mathbf{h}',
    u'\uD422': b'\\mathbf{i}',
    u'\uD423': b'\\mathbf{j}',
    u'\uD424': b'\\mathbf{k}',
    u'\uD425': b'\\mathbf{l}',
    u'\uD426': b'\\mathbf{m}',
    u'\uD427': b'\\mathbf{n}',
    u'\uD428': b'\\mathbf{o}',
    u'\uD429': b'\\mathbf{p}',
    u'\uD42A': b'\\mathbf{q}',
    u'\uD42B': b'\\mathbf{r}',
    u'\uD42C': b'\\mathbf{s}',
    u'\uD42D': b'\\mathbf{t}',
    u'\uD42E': b'\\mathbf{u}',
    u'\uD42F': b'\\mathbf{v}',
    u'\uD430': b'\\mathbf{w}',
    u'\uD431': b'\\mathbf{x}',
    u'\uD432': b'\\mathbf{y}',
    u'\uD433': b'\\mathbf{z}',
    u'\uD434': b'\\mathsl{A}',
    u'\uD435': b'\\mathsl{B}',
    u'\uD436': b'\\mathsl{C}',
    u'\uD437': b'\\mathsl{D}',
    u'\uD438': b'\\mathsl{E}',
    u'\uD439': b'\\mathsl{F}',
    u'\uD43A': b'\\mathsl{G}',
    u'\uD43B': b'\\mathsl{H}',
    u'\uD43C': b'\\mathsl{I}',
    u'\uD43D': b'\\mathsl{J}',
    u'\uD43E': b'\\mathsl{K}',
    u'\uD43F': b'\\mathsl{L}',
    u'\uD440': b'\\mathsl{M}',
    u'\uD441': b'\\mathsl{N}',
    u'\uD442': b'\\mathsl{O}',
    u'\uD443': b'\\mathsl{P}',
    u'\uD444': b'\\mathsl{Q}',
    u'\uD445': b'\\mathsl{R}',
    u'\uD446': b'\\mathsl{S}',
    u'\uD447': b'\\mathsl{T}',
    u'\uD448': b'\\mathsl{U}',
    u'\uD449': b'\\mathsl{V}',
    u'\uD44A': b'\\mathsl{W}',
    u'\uD44B': b'\\mathsl{X}',
    u'\uD44C': b'\\mathsl{Y}',
    u'\uD44D': b'\\mathsl{Z}',
    u'\uD44E': b'\\mathsl{a}',
    u'\uD44F': b'\\mathsl{b}',
    u'\uD450': b'\\mathsl{c}',
    u'\uD451': b'\\mathsl{d}',
    u'\uD452': b'\\mathsl{e}',
    u'\uD453': b'\\mathsl{f}',
    u'\uD454': b'\\mathsl{g}',
    u'\uD456': b'\\mathsl{i}',
    u'\uD457': b'\\mathsl{j}',
    u'\uD458': b'\\mathsl{k}',
    u'\uD459': b'\\mathsl{l}',
    u'\uD45A': b'\\mathsl{m}',
    u'\uD45B': b'\\mathsl{n}',
    u'\uD45C': b'\\mathsl{o}',
    u'\uD45D': b'\\mathsl{p}',
    u'\uD45E': b'\\mathsl{q}',
    u'\uD45F': b'\\mathsl{r}',
    u'\uD460': b'\\mathsl{s}',
    u'\uD461': b'\\mathsl{t}',
    u'\uD462': b'\\mathsl{u}',
    u'\uD463': b'\\mathsl{v}',
    u'\uD464': b'\\mathsl{w}',
    u'\uD465': b'\\mathsl{x}',
    u'\uD466': b'\\mathsl{y}',
    u'\uD467': b'\\mathsl{z}',
    u'\uD468': b'\\mathbit{A}',
    u'\uD469': b'\\mathbit{B}',
    u'\uD46A': b'\\mathbit{C}',
    u'\uD46B': b'\\mathbit{D}',
    u'\uD46C': b'\\mathbit{E}',
    u'\uD46D': b'\\mathbit{F}',
    u'\uD46E': b'\\mathbit{G}',
    u'\uD46F': b'\\mathbit{H}',
    u'\uD470': b'\\mathbit{I}',
    u'\uD471': b'\\mathbit{J}',
    u'\uD472': b'\\mathbit{K}',
    u'\uD473': b'\\mathbit{L}',
    u'\uD474': b'\\mathbit{M}',
    u'\uD475': b'\\mathbit{N}',
    u'\uD476': b'\\mathbit{O}',
    u'\uD477': b'\\mathbit{P}',
    u'\uD478': b'\\mathbit{Q}',
    u'\uD479': b'\\mathbit{R}',
    u'\uD47A': b'\\mathbit{S}',
    u'\uD47B': b'\\mathbit{T}',
    u'\uD47C': b'\\mathbit{U}',
    u'\uD47D': b'\\mathbit{V}',
    u'\uD47E': b'\\mathbit{W}',
    u'\uD47F': b'\\mathbit{X}',
    u'\uD480': b'\\mathbit{Y}',
    u'\uD481': b'\\mathbit{Z}',
    u'\uD482': b'\\mathbit{a}',
    u'\uD483': b'\\mathbit{b}',
    u'\uD484': b'\\mathbit{c}',
    u'\uD485': b'\\mathbit{d}',
    u'\uD486': b'\\mathbit{e}',
    u'\uD487': b'\\mathbit{f}',
    u'\uD488': b'\\mathbit{g}',
    u'\uD489': b'\\mathbit{h}',
    u'\uD48A': b'\\mathbit{i}',
    u'\uD48B': b'\\mathbit{j}',
    u'\uD48C': b'\\mathbit{k}',
    u'\uD48D': b'\\mathbit{l}',
    u'\uD48E': b'\\mathbit{m}',
    u'\uD48F': b'\\mathbit{n}',
    u'\uD490': b'\\mathbit{o}',
    u'\uD491': b'\\mathbit{p}',
    u'\uD492': b'\\mathbit{q}',
    u'\uD493': b'\\mathbit{r}',
    u'\uD494': b'\\mathbit{s}',
    u'\uD495': b'\\mathbit{t}',
    u'\uD496': b'\\mathbit{u}',
    u'\uD497': b'\\mathbit{v}',
    u'\uD498': b'\\mathbit{w}',
    u'\uD499': b'\\mathbit{x}',
    u'\uD49A': b'\\mathbit{y}',
    u'\uD49B': b'\\mathbit{z}',
    u'\uD49C': b'\\mathscr{A}',
    u'\uD49E': b'\\mathscr{C}',
    u'\uD49F': b'\\mathscr{D}',
    u'\uD4A2': b'\\mathscr{G}',
    u'\uD4A5': b'\\mathscr{J}',
    u'\uD4A6': b'\\mathscr{K}',
    u'\uD4A9': b'\\mathscr{N}',
    u'\uD4AA': b'\\mathscr{O}',
    u'\uD4AB': b'\\mathscr{P}',
    u'\uD4AC': b'\\mathscr{Q}',
    u'\uD4AE': b'\\mathscr{S}',
    u'\uD4AF': b'\\mathscr{T}',
    u'\uD4B0': b'\\mathscr{U}',
    u'\uD4B1': b'\\mathscr{V}',
    u'\uD4B2': b'\\mathscr{W}',
    u'\uD4B3': b'\\mathscr{X}',
    u'\uD4B4': b'\\mathscr{Y}',
    u'\uD4B5': b'\\mathscr{Z}',
    u'\uD4B6': b'\\mathscr{a}',
    u'\uD4B7': b'\\mathscr{b}',
    u'\uD4B8': b'\\mathscr{c}',
    u'\uD4B9': b'\\mathscr{d}',
    u'\uD4BB': b'\\mathscr{f}',
    u'\uD4BD': b'\\mathscr{h}',
    u'\uD4BE': b'\\mathscr{i}',
    u'\uD4BF': b'\\mathscr{j}',
    u'\uD4C0': b'\\mathscr{k}',
    u'\uD4C1': b'\\mathscr{l}',
    u'\uD4C2': b'\\mathscr{m}',
    u'\uD4C3': b'\\mathscr{n}',
    u'\uD4C5': b'\\mathscr{p}',
    u'\uD4C6': b'\\mathscr{q}',
    u'\uD4C7': b'\\mathscr{r}',
    u'\uD4C8': b'\\mathscr{s}',
    u'\uD4C9': b'\\mathscr{t}',
    u'\uD4CA': b'\\mathscr{u}',
    u'\uD4CB': b'\\mathscr{v}',
    u'\uD4CC': b'\\mathscr{w}',
    u'\uD4CD': b'\\mathscr{x}',
    u'\uD4CE': b'\\mathscr{y}',
    u'\uD4CF': b'\\mathscr{z}',
    u'\uD4D0': b'\\mathmit{A}',
    u'\uD4D1': b'\\mathmit{B}',
    u'\uD4D2': b'\\mathmit{C}',
    u'\uD4D3': b'\\mathmit{D}',
    u'\uD4D4': b'\\mathmit{E}',
    u'\uD4D5': b'\\mathmit{F}',
    u'\uD4D6': b'\\mathmit{G}',
    u'\uD4D7': b'\\mathmit{H}',
    u'\uD4D8': b'\\mathmit{I}',
    u'\uD4D9': b'\\mathmit{J}',
    u'\uD4DA': b'\\mathmit{K}',
    u'\uD4DB': b'\\mathmit{L}',
    u'\uD4DC': b'\\mathmit{M}',
    u'\uD4DD': b'\\mathmit{N}',
    u'\uD4DE': b'\\mathmit{O}',
    u'\uD4DF': b'\\mathmit{P}',
    u'\uD4E0': b'\\mathmit{Q}',
    u'\uD4E1': b'\\mathmit{R}',
    u'\uD4E2': b'\\mathmit{S}',
    u'\uD4E3': b'\\mathmit{T}',
    u'\uD4E4': b'\\mathmit{U}',
    u'\uD4E5': b'\\mathmit{V}',
    u'\uD4E6': b'\\mathmit{W}',
    u'\uD4E7': b'\\mathmit{X}',
    u'\uD4E8': b'\\mathmit{Y}',
    u'\uD4E9': b'\\mathmit{Z}',
    u'\uD4EA': b'\\mathmit{a}',
    u'\uD4EB': b'\\mathmit{b}',
    u'\uD4EC': b'\\mathmit{c}',
    u'\uD4ED': b'\\mathmit{d}',
    u'\uD4EE': b'\\mathmit{e}',
    u'\uD4EF': b'\\mathmit{f}',
    u'\uD4F0': b'\\mathmit{g}',
    u'\uD4F1': b'\\mathmit{h}',
    u'\uD4F2': b'\\mathmit{i}',
    u'\uD4F3': b'\\mathmit{j}',
    u'\uD4F4': b'\\mathmit{k}',
    u'\uD4F5': b'\\mathmit{l}',
    u'\uD4F6': b'\\mathmit{m}',
    u'\uD4F7': b'\\mathmit{n}',
    u'\uD4F8': b'\\mathmit{o}',
    u'\uD4F9': b'\\mathmit{p}',
    u'\uD4FA': b'\\mathmit{q}',
    u'\uD4FB': b'\\mathmit{r}',
    u'\uD4FC': b'\\mathmit{s}',
    u'\uD4FD': b'\\mathmit{t}',
    u'\uD4FE': b'\\mathmit{u}',
    u'\uD4FF': b'\\mathmit{v}',
    u'\uD500': b'\\mathmit{w}',
    u'\uD501': b'\\mathmit{x}',
    u'\uD502': b'\\mathmit{y}',
    u'\uD503': b'\\mathmit{z}',
    u'\uD504': b'\\mathfrak{A}',
    u'\uD505': b'\\mathfrak{B}',
    u'\uD507': b'\\mathfrak{D}',
    u'\uD508': b'\\mathfrak{E}',
    u'\uD509': b'\\mathfrak{F}',
    u'\uD50A': b'\\mathfrak{G}',
    u'\uD50D': b'\\mathfrak{J}',
    u'\uD50E': b'\\mathfrak{K}',
    u'\uD50F': b'\\mathfrak{L}',
    u'\uD510': b'\\mathfrak{M}',
    u'\uD511': b'\\mathfrak{N}',
    u'\uD512': b'\\mathfrak{O}',
    u'\uD513': b'\\mathfrak{P}',
    u'\uD514': b'\\mathfrak{Q}',
    u'\uD516': b'\\mathfrak{S}',
    u'\uD517': b'\\mathfrak{T}',
    u'\uD518': b'\\mathfrak{U}',
    u'\uD519': b'\\mathfrak{V}',
    u'\uD51A': b'\\mathfrak{W}',
    u'\uD51B': b'\\mathfrak{X}',
    u'\uD51C': b'\\mathfrak{Y}',
    u'\uD51E': b'\\mathfrak{a}',
    u'\uD51F': b'\\mathfrak{b}',
    u'\uD520': b'\\mathfrak{c}',
    u'\uD521': b'\\mathfrak{d}',
    u'\uD522': b'\\mathfrak{e}',
    u'\uD523': b'\\mathfrak{f}',
    u'\uD524': b'\\mathfrak{g}',
    u'\uD525': b'\\mathfrak{h}',
    u'\uD526': b'\\mathfrak{i}',
    u'\uD527': b'\\mathfrak{j}',
    u'\uD528': b'\\mathfrak{k}',
    u'\uD529': b'\\mathfrak{l}',
    u'\uD52A': b'\\mathfrak{m}',
    u'\uD52B': b'\\mathfrak{n}',
    u'\uD52C': b'\\mathfrak{o}',
    u'\uD52D': b'\\mathfrak{p}',
    u'\uD52E': b'\\mathfrak{q}',
    u'\uD52F': b'\\mathfrak{r}',
    u'\uD530': b'\\mathfrak{s}',
    u'\uD531': b'\\mathfrak{t}',
    u'\uD532': b'\\mathfrak{u}',
    u'\uD533': b'\\mathfrak{v}',
    u'\uD534': b'\\mathfrak{w}',
    u'\uD535': b'\\mathfrak{x}',
    u'\uD536': b'\\mathfrak{y}',
    u'\uD537': b'\\mathfrak{z}',
    u'\uD538': b'\\mathbb{A}',
    u'\uD539': b'\\mathbb{B}',
    u'\uD53B': b'\\mathbb{D}',
    u'\uD53C': b'\\mathbb{E}',
    u'\uD53D': b'\\mathbb{F}',
    u'\uD53E': b'\\mathbb{G}',
    u'\uD540': b'\\mathbb{I}',
    u'\uD541': b'\\mathbb{J}',
    u'\uD542': b'\\mathbb{K}',
    u'\uD543': b'\\mathbb{L}',
    u'\uD544': b'\\mathbb{M}',
    u'\uD546': b'\\mathbb{O}',
    u'\uD54A': b'\\mathbb{S}',
    u'\uD54B': b'\\mathbb{T}',
    u'\uD54C': b'\\mathbb{U}',
    u'\uD54D': b'\\mathbb{V}',
    u'\uD54E': b'\\mathbb{W}',
    u'\uD54F': b'\\mathbb{X}',
    u'\uD550': b'\\mathbb{Y}',
    u'\uD552': b'\\mathbb{a}',
    u'\uD553': b'\\mathbb{b}',
    u'\uD554': b'\\mathbb{c}',
    u'\uD555': b'\\mathbb{d}',
    u'\uD556': b'\\mathbb{e}',
    u'\uD557': b'\\mathbb{f}',
    u'\uD558': b'\\mathbb{g}',
    u'\uD559': b'\\mathbb{h}',
    u'\uD55A': b'\\mathbb{i}',
    u'\uD55B': b'\\mathbb{j}',
    u'\uD55C': b'\\mathbb{k}',
    u'\uD55D': b'\\mathbb{l}',
    u'\uD55E': b'\\mathbb{m}',
    u'\uD55F': b'\\mathbb{n}',
    u'\uD560': b'\\mathbb{o}',
    u'\uD561': b'\\mathbb{p}',
    u'\uD562': b'\\mathbb{q}',
    u'\uD563': b'\\mathbb{r}',
    u'\uD564': b'\\mathbb{s}',
    u'\uD565': b'\\mathbb{t}',
    u'\uD566': b'\\mathbb{u}',
    u'\uD567': b'\\mathbb{v}',
    u'\uD568': b'\\mathbb{w}',
    u'\uD569': b'\\mathbb{x}',
    u'\uD56A': b'\\mathbb{y}',
    u'\uD56B': b'\\mathbb{z}',
    u'\uD56C': b'\\mathslbb{A}',
    u'\uD56D': b'\\mathslbb{B}',
    u'\uD56E': b'\\mathslbb{C}',
    u'\uD56F': b'\\mathslbb{D}',
    u'\uD570': b'\\mathslbb{E}',
    u'\uD571': b'\\mathslbb{F}',
    u'\uD572': b'\\mathslbb{G}',
    u'\uD573': b'\\mathslbb{H}',
    u'\uD574': b'\\mathslbb{I}',
    u'\uD575': b'\\mathslbb{J}',
    u'\uD576': b'\\mathslbb{K}',
    u'\uD577': b'\\mathslbb{L}',
    u'\uD578': b'\\mathslbb{M}',
    u'\uD579': b'\\mathslbb{N}',
    u'\uD57A': b'\\mathslbb{O}',
    u'\uD57B': b'\\mathslbb{P}',
    u'\uD57C': b'\\mathslbb{Q}',
    u'\uD57D': b'\\mathslbb{R}',
    u'\uD57E': b'\\mathslbb{S}',
    u'\uD57F': b'\\mathslbb{T}',
    u'\uD580': b'\\mathslbb{U}',
    u'\uD581': b'\\mathslbb{V}',
    u'\uD582': b'\\mathslbb{W}',
    u'\uD583': b'\\mathslbb{X}',
    u'\uD584': b'\\mathslbb{Y}',
    u'\uD585': b'\\mathslbb{Z}',
    u'\uD586': b'\\mathslbb{a}',
    u'\uD587': b'\\mathslbb{b}',
    u'\uD588': b'\\mathslbb{c}',
    u'\uD589': b'\\mathslbb{d}',
    u'\uD58A': b'\\mathslbb{e}',
    u'\uD58B': b'\\mathslbb{f}',
    u'\uD58C': b'\\mathslbb{g}',
    u'\uD58D': b'\\mathslbb{h}',
    u'\uD58E': b'\\mathslbb{i}',
    u'\uD58F': b'\\mathslbb{j}',
    u'\uD590': b'\\mathslbb{k}',
    u'\uD591': b'\\mathslbb{l}',
    u'\uD592': b'\\mathslbb{m}',
    u'\uD593': b'\\mathslbb{n}',
    u'\uD594': b'\\mathslbb{o}',
    u'\uD595': b'\\mathslbb{p}',
    u'\uD596': b'\\mathslbb{q}',
    u'\uD597': b'\\mathslbb{r}',
    u'\uD598': b'\\mathslbb{s}',
    u'\uD599': b'\\mathslbb{t}',
    u'\uD59A': b'\\mathslbb{u}',
    u'\uD59B': b'\\mathslbb{v}',
    u'\uD59C': b'\\mathslbb{w}',
    u'\uD59D': b'\\mathslbb{x}',
    u'\uD59E': b'\\mathslbb{y}',
    u'\uD59F': b'\\mathslbb{z}',
    u'\uD5A0': b'\\mathsf{A}',
    u'\uD5A1': b'\\mathsf{B}',
    u'\uD5A2': b'\\mathsf{C}',
    u'\uD5A3': b'\\mathsf{D}',
    u'\uD5A4': b'\\mathsf{E}',
    u'\uD5A5': b'\\mathsf{F}',
    u'\uD5A6': b'\\mathsf{G}',
    u'\uD5A7': b'\\mathsf{H}',
    u'\uD5A8': b'\\mathsf{I}',
    u'\uD5A9': b'\\mathsf{J}',
    u'\uD5AA': b'\\mathsf{K}',
    u'\uD5AB': b'\\mathsf{L}',
    u'\uD5AC': b'\\mathsf{M}',
    u'\uD5AD': b'\\mathsf{N}',
    u'\uD5AE': b'\\mathsf{O}',
    u'\uD5AF': b'\\mathsf{P}',
    u'\uD5B0': b'\\mathsf{Q}',
    u'\uD5B1': b'\\mathsf{R}',
    u'\uD5B2': b'\\mathsf{S}',
    u'\uD5B3': b'\\mathsf{T}',
    u'\uD5B4': b'\\mathsf{U}',
    u'\uD5B5': b'\\mathsf{V}',
    u'\uD5B6': b'\\mathsf{W}',
    u'\uD5B7': b'\\mathsf{X}',
    u'\uD5B8': b'\\mathsf{Y}',
    u'\uD5B9': b'\\mathsf{Z}',
    u'\uD5BA': b'\\mathsf{a}',
    u'\uD5BB': b'\\mathsf{b}',
    u'\uD5BC': b'\\mathsf{c}',
    u'\uD5BD': b'\\mathsf{d}',
    u'\uD5BE': b'\\mathsf{e}',
    u'\uD5BF': b'\\mathsf{f}',
    u'\uD5C0': b'\\mathsf{g}',
    u'\uD5C1': b'\\mathsf{h}',
    u'\uD5C2': b'\\mathsf{i}',
    u'\uD5C3': b'\\mathsf{j}',
    u'\uD5C4': b'\\mathsf{k}',
    u'\uD5C5': b'\\mathsf{l}',
    u'\uD5C6': b'\\mathsf{m}',
    u'\uD5C7': b'\\mathsf{n}',
    u'\uD5C8': b'\\mathsf{o}',
    u'\uD5C9': b'\\mathsf{p}',
    u'\uD5CA': b'\\mathsf{q}',
    u'\uD5CB': b'\\mathsf{r}',
    u'\uD5CC': b'\\mathsf{s}',
    u'\uD5CD': b'\\mathsf{t}',
    u'\uD5CE': b'\\mathsf{u}',
    u'\uD5CF': b'\\mathsf{v}',
    u'\uD5D0': b'\\mathsf{w}',
    u'\uD5D1': b'\\mathsf{x}',
    u'\uD5D2': b'\\mathsf{y}',
    u'\uD5D3': b'\\mathsf{z}',
    u'\uD5D4': b'\\mathsfbf{A}',
    u'\uD5D5': b'\\mathsfbf{B}',
    u'\uD5D6': b'\\mathsfbf{C}',
    u'\uD5D7': b'\\mathsfbf{D}',
    u'\uD5D8': b'\\mathsfbf{E}',
    u'\uD5D9': b'\\mathsfbf{F}',
    u'\uD5DA': b'\\mathsfbf{G}',
    u'\uD5DB': b'\\mathsfbf{H}',
    u'\uD5DC': b'\\mathsfbf{I}',
    u'\uD5DD': b'\\mathsfbf{J}',
    u'\uD5DE': b'\\mathsfbf{K}',
    u'\uD5DF': b'\\mathsfbf{L}',
    u'\uD5E0': b'\\mathsfbf{M}',
    u'\uD5E1': b'\\mathsfbf{N}',
    u'\uD5E2': b'\\mathsfbf{O}',
    u'\uD5E3': b'\\mathsfbf{P}',
    u'\uD5E4': b'\\mathsfbf{Q}',
    u'\uD5E5': b'\\mathsfbf{R}',
    u'\uD5E6': b'\\mathsfbf{S}',
    u'\uD5E7': b'\\mathsfbf{T}',
    u'\uD5E8': b'\\mathsfbf{U}',
    u'\uD5E9': b'\\mathsfbf{V}',
    u'\uD5EA': b'\\mathsfbf{W}',
    u'\uD5EB': b'\\mathsfbf{X}',
    u'\uD5EC': b'\\mathsfbf{Y}',
    u'\uD5ED': b'\\mathsfbf{Z}',
    u'\uD5EE': b'\\mathsfbf{a}',
    u'\uD5EF': b'\\mathsfbf{b}',
    u'\uD5F0': b'\\mathsfbf{c}',
    u'\uD5F1': b'\\mathsfbf{d}',
    u'\uD5F2': b'\\mathsfbf{e}',
    u'\uD5F3': b'\\mathsfbf{f}',
    u'\uD5F4': b'\\mathsfbf{g}',
    u'\uD5F5': b'\\mathsfbf{h}',
    u'\uD5F6': b'\\mathsfbf{i}',
    u'\uD5F7': b'\\mathsfbf{j}',
    u'\uD5F8': b'\\mathsfbf{k}',
    u'\uD5F9': b'\\mathsfbf{l}',
    u'\uD5FA': b'\\mathsfbf{m}',
    u'\uD5FB': b'\\mathsfbf{n}',
    u'\uD5FC': b'\\mathsfbf{o}',
    u'\uD5FD': b'\\mathsfbf{p}',
    u'\uD5FE': b'\\mathsfbf{q}',
    u'\uD5FF': b'\\mathsfbf{r}',
    u'\uD600': b'\\mathsfbf{s}',
    u'\uD601': b'\\mathsfbf{t}',
    u'\uD602': b'\\mathsfbf{u}',
    u'\uD603': b'\\mathsfbf{v}',
    u'\uD604': b'\\mathsfbf{w}',
    u'\uD605': b'\\mathsfbf{x}',
    u'\uD606': b'\\mathsfbf{y}',
    u'\uD607': b'\\mathsfbf{z}',
    u'\uD608': b'\\mathsfsl{A}',
    u'\uD609': b'\\mathsfsl{B}',
    u'\uD60A': b'\\mathsfsl{C}',
    u'\uD60B': b'\\mathsfsl{D}',
    u'\uD60C': b'\\mathsfsl{E}',
    u'\uD60D': b'\\mathsfsl{F}',
    u'\uD60E': b'\\mathsfsl{G}',
    u'\uD60F': b'\\mathsfsl{H}',
    u'\uD610': b'\\mathsfsl{I}',
    u'\uD611': b'\\mathsfsl{J}',
    u'\uD612': b'\\mathsfsl{K}',
    u'\uD613': b'\\mathsfsl{L}',
    u'\uD614': b'\\mathsfsl{M}',
    u'\uD615': b'\\mathsfsl{N}',
    u'\uD616': b'\\mathsfsl{O}',
    u'\uD617': b'\\mathsfsl{P}',
    u'\uD618': b'\\mathsfsl{Q}',
    u'\uD619': b'\\mathsfsl{R}',
    u'\uD61A': b'\\mathsfsl{S}',
    u'\uD61B': b'\\mathsfsl{T}',
    u'\uD61C': b'\\mathsfsl{U}',
    u'\uD61D': b'\\mathsfsl{V}',
    u'\uD61E': b'\\mathsfsl{W}',
    u'\uD61F': b'\\mathsfsl{X}',
    u'\uD620': b'\\mathsfsl{Y}',
    u'\uD621': b'\\mathsfsl{Z}',
    u'\uD622': b'\\mathsfsl{a}',
    u'\uD623': b'\\mathsfsl{b}',
    u'\uD624': b'\\mathsfsl{c}',
    u'\uD625': b'\\mathsfsl{d}',
    u'\uD626': b'\\mathsfsl{e}',
    u'\uD627': b'\\mathsfsl{f}',
    u'\uD628': b'\\mathsfsl{g}',
    u'\uD629': b'\\mathsfsl{h}',
    u'\uD62A': b'\\mathsfsl{i}',
    u'\uD62B': b'\\mathsfsl{j}',
    u'\uD62C': b'\\mathsfsl{k}',
    u'\uD62D': b'\\mathsfsl{l}',
    u'\uD62E': b'\\mathsfsl{m}',
    u'\uD62F': b'\\mathsfsl{n}',
    u'\uD630': b'\\mathsfsl{o}',
    u'\uD631': b'\\mathsfsl{p}',
    u'\uD632': b'\\mathsfsl{q}',
    u'\uD633': b'\\mathsfsl{r}',
    u'\uD634': b'\\mathsfsl{s}',
    u'\uD635': b'\\mathsfsl{t}',
    u'\uD636': b'\\mathsfsl{u}',
    u'\uD637': b'\\mathsfsl{v}',
    u'\uD638': b'\\mathsfsl{w}',
    u'\uD639': b'\\mathsfsl{x}',
    u'\uD63A': b'\\mathsfsl{y}',
    u'\uD63B': b'\\mathsfsl{z}',
    u'\uD63C': b'\\mathsfbfsl{A}',
    u'\uD63D': b'\\mathsfbfsl{B}',
    u'\uD63E': b'\\mathsfbfsl{C}',
    u'\uD63F': b'\\mathsfbfsl{D}',
    u'\uD640': b'\\mathsfbfsl{E}',
    u'\uD641': b'\\mathsfbfsl{F}',
    u'\uD642': b'\\mathsfbfsl{G}',
    u'\uD643': b'\\mathsfbfsl{H}',
    u'\uD644': b'\\mathsfbfsl{I}',
    u'\uD645': b'\\mathsfbfsl{J}',
    u'\uD646': b'\\mathsfbfsl{K}',
    u'\uD647': b'\\mathsfbfsl{L}',
    u'\uD648': b'\\mathsfbfsl{M}',
    u'\uD649': b'\\mathsfbfsl{N}',
    u'\uD64A': b'\\mathsfbfsl{O}',
    u'\uD64B': b'\\mathsfbfsl{P}',
    u'\uD64C': b'\\mathsfbfsl{Q}',
    u'\uD64D': b'\\mathsfbfsl{R}',
    u'\uD64E': b'\\mathsfbfsl{S}',
    u'\uD64F': b'\\mathsfbfsl{T}',
    u'\uD650': b'\\mathsfbfsl{U}',
    u'\uD651': b'\\mathsfbfsl{V}',
    u'\uD652': b'\\mathsfbfsl{W}',
    u'\uD653': b'\\mathsfbfsl{X}',
    u'\uD654': b'\\mathsfbfsl{Y}',
    u'\uD655': b'\\mathsfbfsl{Z}',
    u'\uD656': b'\\mathsfbfsl{a}',
    u'\uD657': b'\\mathsfbfsl{b}',
    u'\uD658': b'\\mathsfbfsl{c}',
    u'\uD659': b'\\mathsfbfsl{d}',
    u'\uD65A': b'\\mathsfbfsl{e}',
    u'\uD65B': b'\\mathsfbfsl{f}',
    u'\uD65C': b'\\mathsfbfsl{g}',
    u'\uD65D': b'\\mathsfbfsl{h}',
    u'\uD65E': b'\\mathsfbfsl{i}',
    u'\uD65F': b'\\mathsfbfsl{j}',
    u'\uD660': b'\\mathsfbfsl{k}',
    u'\uD661': b'\\mathsfbfsl{l}',
    u'\uD662': b'\\mathsfbfsl{m}',
    u'\uD663': b'\\mathsfbfsl{n}',
    u'\uD664': b'\\mathsfbfsl{o}',
    u'\uD665': b'\\mathsfbfsl{p}',
    u'\uD666': b'\\mathsfbfsl{q}',
    u'\uD667': b'\\mathsfbfsl{r}',
    u'\uD668': b'\\mathsfbfsl{s}',
    u'\uD669': b'\\mathsfbfsl{t}',
    u'\uD66A': b'\\mathsfbfsl{u}',
    u'\uD66B': b'\\mathsfbfsl{v}',
    u'\uD66C': b'\\mathsfbfsl{w}',
    u'\uD66D': b'\\mathsfbfsl{x}',
    u'\uD66E': b'\\mathsfbfsl{y}',
    u'\uD66F': b'\\mathsfbfsl{z}',
    u'\uD670': b'\\mathtt{A}',
    u'\uD671': b'\\mathtt{B}',
    u'\uD672': b'\\mathtt{C}',
    u'\uD673': b'\\mathtt{D}',
    u'\uD674': b'\\mathtt{E}',
    u'\uD675': b'\\mathtt{F}',
    u'\uD676': b'\\mathtt{G}',
    u'\uD677': b'\\mathtt{H}',
    u'\uD678': b'\\mathtt{I}',
    u'\uD679': b'\\mathtt{J}',
    u'\uD67A': b'\\mathtt{K}',
    u'\uD67B': b'\\mathtt{L}',
    u'\uD67C': b'\\mathtt{M}',
    u'\uD67D': b'\\mathtt{N}',
    u'\uD67E': b'\\mathtt{O}',
    u'\uD67F': b'\\mathtt{P}',
    u'\uD680': b'\\mathtt{Q}',
    u'\uD681': b'\\mathtt{R}',
    u'\uD682': b'\\mathtt{S}',
    u'\uD683': b'\\mathtt{T}',
    u'\uD684': b'\\mathtt{U}',
    u'\uD685': b'\\mathtt{V}',
    u'\uD686': b'\\mathtt{W}',
    u'\uD687': b'\\mathtt{X}',
    u'\uD688': b'\\mathtt{Y}',
    u'\uD689': b'\\mathtt{Z}',
    u'\uD68A': b'\\mathtt{a}',
    u'\uD68B': b'\\mathtt{b}',
    u'\uD68C': b'\\mathtt{c}',
    u'\uD68D': b'\\mathtt{d}',
    u'\uD68E': b'\\mathtt{e}',
    u'\uD68F': b'\\mathtt{f}',
    u'\uD690': b'\\mathtt{g}',
    u'\uD691': b'\\mathtt{h}',
    u'\uD692': b'\\mathtt{i}',
    u'\uD693': b'\\mathtt{j}',
    u'\uD694': b'\\mathtt{k}',
    u'\uD695': b'\\mathtt{l}',
    u'\uD696': b'\\mathtt{m}',
    u'\uD697': b'\\mathtt{n}',
    u'\uD698': b'\\mathtt{o}',
    u'\uD699': b'\\mathtt{p}',
    u'\uD69A': b'\\mathtt{q}',
    u'\uD69B': b'\\mathtt{r}',
    u'\uD69C': b'\\mathtt{s}',
    u'\uD69D': b'\\mathtt{t}',
    u'\uD69E': b'\\mathtt{u}',
    u'\uD69F': b'\\mathtt{v}',
    u'\uD6A0': b'\\mathtt{w}',
    u'\uD6A1': b'\\mathtt{x}',
    u'\uD6A2': b'\\mathtt{y}',
    u'\uD6A3': b'\\mathtt{z}',
    u'\uD6A8': b'\\mathbf{\\Alpha}',
    u'\uD6A9': b'\\mathbf{\\Beta}',
    u'\uD6AA': b'\\mathbf{\\Gamma}',
    u'\uD6AB': b'\\mathbf{\\Delta}',
    u'\uD6AC': b'\\mathbf{\\Epsilon}',
    u'\uD6AD': b'\\mathbf{\\Zeta}',
    u'\uD6AE': b'\\mathbf{\\Eta}',
    u'\uD6AF': b'\\mathbf{\\Theta}',
    u'\uD6B0': b'\\mathbf{\\Iota}',
    u'\uD6B1': b'\\mathbf{\\Kappa}',
    u'\uD6B2': b'\\mathbf{\\Lambda}',
    u'\uD6B5': b'\\mathbf{\\Xi}',
    u'\uD6B7': b'\\mathbf{\\Pi}',
    u'\uD6B8': b'\\mathbf{\\Rho}',
    u'\uD6B9': b'\\mathbf{\\vartheta}',
    u'\uD6BA': b'\\mathbf{\\Sigma}',
    u'\uD6BB': b'\\mathbf{\\Tau}',
    u'\uD6BC': b'\\mathbf{\\Upsilon}',
    u'\uD6BD': b'\\mathbf{\\Phi}',
    u'\uD6BE': b'\\mathbf{\\Chi}',
    u'\uD6BF': b'\\mathbf{\\Psi}',
    u'\uD6C0': b'\\mathbf{\\Omega}',
    u'\uD6C1': b'\\mathbf{\\nabla}',
    u'\uD6C2': b'\\mathbf{\\Alpha}',
    u'\uD6C3': b'\\mathbf{\\Beta}',
    u'\uD6C4': b'\\mathbf{\\Gamma}',
    u'\uD6C5': b'\\mathbf{\\Delta}',
    u'\uD6C6': b'\\mathbf{\\Epsilon}',
    u'\uD6C7': b'\\mathbf{\\Zeta}',
    u'\uD6C8': b'\\mathbf{\\Eta}',
    u'\uD6C9': b'\\mathbf{\\theta}',
    u'\uD6CA': b'\\mathbf{\\Iota}',
    u'\uD6CB': b'\\mathbf{\\Kappa}',
    u'\uD6CC': b'\\mathbf{\\Lambda}',
    u'\uD6CF': b'\\mathbf{\\Xi}',
    u'\uD6D1': b'\\mathbf{\\Pi}',
    u'\uD6D2': b'\\mathbf{\\Rho}',
    u'\uD6D3': b'\\mathbf{\\varsigma}',
    u'\uD6D4': b'\\mathbf{\\Sigma}',
    u'\uD6D5': b'\\mathbf{\\Tau}',
    u'\uD6D6': b'\\mathbf{\\Upsilon}',
    u'\uD6D7': b'\\mathbf{\\Phi}',
    u'\uD6D8': b'\\mathbf{\\Chi}',
    u'\uD6D9': b'\\mathbf{\\Psi}',
    u'\uD6DA': b'\\mathbf{\\Omega}',
    u'\uD6DB': b'\\partial ',
    u'\uD6DC': b'\\in',
    u'\uD6DD': b'\\mathbf{\\vartheta}',
    u'\uD6DE': b'\\mathbf{\\varkappa}',
    u'\uD6DF': b'\\mathbf{\\phi}',
    u'\uD6E0': b'\\mathbf{\\varrho}',
    u'\uD6E1': b'\\mathbf{\\varpi}',
    u'\uD6E2': b'\\mathsl{\\Alpha}',
    u'\uD6E3': b'\\mathsl{\\Beta}',
    u'\uD6E4': b'\\mathsl{\\Gamma}',
    u'\uD6E5': b'\\mathsl{\\Delta}',
    u'\uD6E6': b'\\mathsl{\\Epsilon}',
    u'\uD6E7': b'\\mathsl{\\Zeta}',
    u'\uD6E8': b'\\mathsl{\\Eta}',
    u'\uD6E9': b'\\mathsl{\\Theta}',
    u'\uD6EA': b'\\mathsl{\\Iota}',
    u'\uD6EB': b'\\mathsl{\\Kappa}',
    u'\uD6EC': b'\\mathsl{\\Lambda}',
    u'\uD6EF': b'\\mathsl{\\Xi}',
    u'\uD6F1': b'\\mathsl{\\Pi}',
    u'\uD6F2': b'\\mathsl{\\Rho}',
    u'\uD6F3': b'\\mathsl{\\vartheta}',
    u'\uD6F4': b'\\mathsl{\\Sigma}',
    u'\uD6F5': b'\\mathsl{\\Tau}',
    u'\uD6F6': b'\\mathsl{\\Upsilon}',
    u'\uD6F7': b'\\mathsl{\\Phi}',
    u'\uD6F8': b'\\mathsl{\\Chi}',
    u'\uD6F9': b'\\mathsl{\\Psi}',
    u'\uD6FA': b'\\mathsl{\\Omega}',
    u'\uD6FB': b'\\mathsl{\\nabla}',
    u'\uD6FC': b'\\mathsl{\\Alpha}',
    u'\uD6FD': b'\\mathsl{\\Beta}',
    u'\uD6FE': b'\\mathsl{\\Gamma}',
    u'\uD6FF': b'\\mathsl{\\Delta}',
    u'\uD700': b'\\mathsl{\\Epsilon}',
    u'\uD701': b'\\mathsl{\\Zeta}',
    u'\uD702': b'\\mathsl{\\Eta}',
    u'\uD703': b'\\mathsl{\\Theta}',
    u'\uD704': b'\\mathsl{\\Iota}',
    u'\uD705': b'\\mathsl{\\Kappa}',
    u'\uD706': b'\\mathsl{\\Lambda}',
    u'\uD709': b'\\mathsl{\\Xi}',
    u'\uD70B': b'\\mathsl{\\Pi}',
    u'\uD70C': b'\\mathsl{\\Rho}',
    u'\uD70D': b'\\mathsl{\\varsigma}',
    u'\uD70E': b'\\mathsl{\\Sigma}',
    u'\uD70F': b'\\mathsl{\\Tau}',
    u'\uD710': b'\\mathsl{\\Upsilon}',
    u'\uD711': b'\\mathsl{\\Phi}',
    u'\uD712': b'\\mathsl{\\Chi}',
    u'\uD713': b'\\mathsl{\\Psi}',
    u'\uD714': b'\\mathsl{\\Omega}',
    u'\uD715': b'\\partial ',
    u'\uD716': b'\\in',
    u'\uD717': b'\\mathsl{\\vartheta}',
    u'\uD718': b'\\mathsl{\\varkappa}',
    u'\uD719': b'\\mathsl{\\phi}',
    u'\uD71A': b'\\mathsl{\\varrho}',
    u'\uD71B': b'\\mathsl{\\varpi}',
    u'\uD71C': b'\\mathbit{\\Alpha}',
    u'\uD71D': b'\\mathbit{\\Beta}',
    u'\uD71E': b'\\mathbit{\\Gamma}',
    u'\uD71F': b'\\mathbit{\\Delta}',
    u'\uD720': b'\\mathbit{\\Epsilon}',
    u'\uD721': b'\\mathbit{\\Zeta}',
    u'\uD722': b'\\mathbit{\\Eta}',
    u'\uD723': b'\\mathbit{\\Theta}',
    u'\uD724': b'\\mathbit{\\Iota}',
    u'\uD725': b'\\mathbit{\\Kappa}',
    u'\uD726': b'\\mathbit{\\Lambda}',
    u'\uD729': b'\\mathbit{\\Xi}',
    u'\uD72B': b'\\mathbit{\\Pi}',
    u'\uD72C': b'\\mathbit{\\Rho}',
    u'\uD72D': b'\\mathbit{O}',
    u'\uD72E': b'\\mathbit{\\Sigma}',
    u'\uD72F': b'\\mathbit{\\Tau}',
    u'\uD730': b'\\mathbit{\\Upsilon}',
    u'\uD731': b'\\mathbit{\\Phi}',
    u'\uD732': b'\\mathbit{\\Chi}',
    u'\uD733': b'\\mathbit{\\Psi}',
    u'\uD734': b'\\mathbit{\\Omega}',
    u'\uD735': b'\\mathbit{\\nabla}',
    u'\uD736': b'\\mathbit{\\Alpha}',
    u'\uD737': b'\\mathbit{\\Beta}',
    u'\uD738': b'\\mathbit{\\Gamma}',
    u'\uD739': b'\\mathbit{\\Delta}',
    u'\uD73A': b'\\mathbit{\\Epsilon}',
    u'\uD73B': b'\\mathbit{\\Zeta}',
    u'\uD73C': b'\\mathbit{\\Eta}',
    u'\uD73D': b'\\mathbit{\\Theta}',
    u'\uD73E': b'\\mathbit{\\Iota}',
    u'\uD73F': b'\\mathbit{\\Kappa}',
    u'\uD740': b'\\mathbit{\\Lambda}',
    u'\uD743': b'\\mathbit{\\Xi}',
    u'\uD745': b'\\mathbit{\\Pi}',
    u'\uD746': b'\\mathbit{\\Rho}',
    u'\uD747': b'\\mathbit{\\varsigma}',
    u'\uD748': b'\\mathbit{\\Sigma}',
    u'\uD749': b'\\mathbit{\\Tau}',
    u'\uD74A': b'\\mathbit{\\Upsilon}',
    u'\uD74B': b'\\mathbit{\\Phi}',
    u'\uD74C': b'\\mathbit{\\Chi}',
    u'\uD74D': b'\\mathbit{\\Psi}',
    u'\uD74E': b'\\mathbit{\\Omega}',
    u'\uD74F': b'\\partial ',
    u'\uD750': b'\\in',
    u'\uD751': b'\\mathbit{\\vartheta}',
    u'\uD752': b'\\mathbit{\\varkappa}',
    u'\uD753': b'\\mathbit{\\phi}',
    u'\uD754': b'\\mathbit{\\varrho}',
    u'\uD755': b'\\mathbit{\\varpi}',
    u'\uD756': b'\\mathsfbf{\\Alpha}',
    u'\uD757': b'\\mathsfbf{\\Beta}',
    u'\uD758': b'\\mathsfbf{\\Gamma}',
    u'\uD759': b'\\mathsfbf{\\Delta}',
    u'\uD75A': b'\\mathsfbf{\\Epsilon}',
    u'\uD75B': b'\\mathsfbf{\\Zeta}',
    u'\uD75C': b'\\mathsfbf{\\Eta}',
    u'\uD75D': b'\\mathsfbf{\\Theta}',
    u'\uD75E': b'\\mathsfbf{\\Iota}',
    u'\uD75F': b'\\mathsfbf{\\Kappa}',
    u'\uD760': b'\\mathsfbf{\\Lambda}',
    u'\uD763': b'\\mathsfbf{\\Xi}',
    u'\uD765': b'\\mathsfbf{\\Pi}',
    u'\uD766': b'\\mathsfbf{\\Rho}',
    u'\uD767': b'\\mathsfbf{\\vartheta}',
    u'\uD768': b'\\mathsfbf{\\Sigma}',
    u'\uD769': b'\\mathsfbf{\\Tau}',
    u'\uD76A': b'\\mathsfbf{\\Upsilon}',
    u'\uD76B': b'\\mathsfbf{\\Phi}',
    u'\uD76C': b'\\mathsfbf{\\Chi}',
    u'\uD76D': b'\\mathsfbf{\\Psi}',
    u'\uD76E': b'\\mathsfbf{\\Omega}',
    u'\uD76F': b'\\mathsfbf{\\nabla}',
    u'\uD770': b'\\mathsfbf{\\Alpha}',
    u'\uD771': b'\\mathsfbf{\\Beta}',
    u'\uD772': b'\\mathsfbf{\\Gamma}',
    u'\uD773': b'\\mathsfbf{\\Delta}',
    u'\uD774': b'\\mathsfbf{\\Epsilon}',
    u'\uD775': b'\\mathsfbf{\\Zeta}',
    u'\uD776': b'\\mathsfbf{\\Eta}',
    u'\uD777': b'\\mathsfbf{\\Theta}',
    u'\uD778': b'\\mathsfbf{\\Iota}',
    u'\uD779': b'\\mathsfbf{\\Kappa}',
    u'\uD77A': b'\\mathsfbf{\\Lambda}',
    u'\uD77D': b'\\mathsfbf{\\Xi}',
    u'\uD77F': b'\\mathsfbf{\\Pi}',
    u'\uD780': b'\\mathsfbf{\\Rho}',
    u'\uD781': b'\\mathsfbf{\\varsigma}',
    u'\uD782': b'\\mathsfbf{\\Sigma}',
    u'\uD783': b'\\mathsfbf{\\Tau}',
    u'\uD784': b'\\mathsfbf{\\Upsilon}',
    u'\uD785': b'\\mathsfbf{\\Phi}',
    u'\uD786': b'\\mathsfbf{\\Chi}',
    u'\uD787': b'\\mathsfbf{\\Psi}',
    u'\uD788': b'\\mathsfbf{\\Omega}',
    u'\uD789': b'\\partial ',
    u'\uD78A': b'\\in',
    u'\uD78B': b'\\mathsfbf{\\vartheta}',
    u'\uD78C': b'\\mathsfbf{\\varkappa}',
    u'\uD78D': b'\\mathsfbf{\\phi}',
    u'\uD78E': b'\\mathsfbf{\\varrho}',
    u'\uD78F': b'\\mathsfbf{\\varpi}',
    u'\uD790': b'\\mathsfbfsl{\\Alpha}',
    u'\uD791': b'\\mathsfbfsl{\\Beta}',
    u'\uD792': b'\\mathsfbfsl{\\Gamma}',
    u'\uD793': b'\\mathsfbfsl{\\Delta}',
    u'\uD794': b'\\mathsfbfsl{\\Epsilon}',
    u'\uD795': b'\\mathsfbfsl{\\Zeta}',
    u'\uD796': b'\\mathsfbfsl{\\Eta}',
    u'\uD797': b'\\mathsfbfsl{\\vartheta}',
    u'\uD798': b'\\mathsfbfsl{\\Iota}',
    u'\uD799': b'\\mathsfbfsl{\\Kappa}',
    u'\uD79A': b'\\mathsfbfsl{\\Lambda}',
    u'\uD79D': b'\\mathsfbfsl{\\Xi}',
    u'\uD79F': b'\\mathsfbfsl{\\Pi}',
    u'\uD7A0': b'\\mathsfbfsl{\\Rho}',
    u'\uD7A1': b'\\mathsfbfsl{\\vartheta}',
    u'\uD7A2': b'\\mathsfbfsl{\\Sigma}',
    u'\uD7A3': b'\\mathsfbfsl{\\Tau}',
    u'\uD7A4': b'\\mathsfbfsl{\\Upsilon}',
    u'\uD7A5': b'\\mathsfbfsl{\\Phi}',
    u'\uD7A6': b'\\mathsfbfsl{\\Chi}',
    u'\uD7A7': b'\\mathsfbfsl{\\Psi}',
    u'\uD7A8': b'\\mathsfbfsl{\\Omega}',
    u'\uD7A9': b'\\mathsfbfsl{\\nabla}',
    u'\uD7AA': b'\\mathsfbfsl{\\Alpha}',
    u'\uD7AB': b'\\mathsfbfsl{\\Beta}',
    u'\uD7AC': b'\\mathsfbfsl{\\Gamma}',
    u'\uD7AD': b'\\mathsfbfsl{\\Delta}',
    u'\uD7AE': b'\\mathsfbfsl{\\Epsilon}',
    u'\uD7AF': b'\\mathsfbfsl{\\Zeta}',
    u'\uD7B0': b'\\mathsfbfsl{\\Eta}',
    u'\uD7B1': b'\\mathsfbfsl{\\vartheta}',
    u'\uD7B2': b'\\mathsfbfsl{\\Iota}',
    u'\uD7B3': b'\\mathsfbfsl{\\Kappa}',
    u'\uD7B4': b'\\mathsfbfsl{\\Lambda}',
    u'\uD7B7': b'\\mathsfbfsl{\\Xi}',
    u'\uD7B9': b'\\mathsfbfsl{\\Pi}',
    u'\uD7BA': b'\\mathsfbfsl{\\Rho}',
    u'\uD7BB': b'\\mathsfbfsl{\\varsigma}',
    u'\uD7BC': b'\\mathsfbfsl{\\Sigma}',
    u'\uD7BD': b'\\mathsfbfsl{\\Tau}',
    u'\uD7BE': b'\\mathsfbfsl{\\Upsilon}',
    u'\uD7BF': b'\\mathsfbfsl{\\Phi}',
    u'\uD7C0': b'\\mathsfbfsl{\\Chi}',
    u'\uD7C1': b'\\mathsfbfsl{\\Psi}',
    u'\uD7C2': b'\\mathsfbfsl{\\Omega}',
    u'\uD7C3': b'\\partial ',
    u'\uD7C4': b'\\in',
    u'\uD7C5': b'\\mathsfbfsl{\\vartheta}',
    u'\uD7C6': b'\\mathsfbfsl{\\varkappa}',
    u'\uD7C7': b'\\mathsfbfsl{\\phi}',
    u'\uD7C8': b'\\mathsfbfsl{\\varrho}',
    u'\uD7C9': b'\\mathsfbfsl{\\varpi}',
    u'\uD7CE': b'\\mathbf{0}',
    u'\uD7CF': b'\\mathbf{1}',
    u'\uD7D0': b'\\mathbf{2}',
    u'\uD7D1': b'\\mathbf{3}',
    u'\uD7D2': b'\\mathbf{4}',
    u'\uD7D3': b'\\mathbf{5}',
    u'\uD7D4': b'\\mathbf{6}',
    u'\uD7D5': b'\\mathbf{7}',
    u'\uD7D6': b'\\mathbf{8}',
    u'\uD7D7': b'\\mathbf{9}',
    u'\uD7D8': b'\\mathbb{0}',
    u'\uD7D9': b'\\mathbb{1}',
    u'\uD7DA': b'\\mathbb{2}',
    u'\uD7DB': b'\\mathbb{3}',
    u'\uD7DC': b'\\mathbb{4}',
    u'\uD7DD': b'\\mathbb{5}',
    u'\uD7DE': b'\\mathbb{6}',
    u'\uD7DF': b'\\mathbb{7}',
    u'\uD7E0': b'\\mathbb{8}',
    u'\uD7E1': b'\\mathbb{9}',
    u'\uD7E2': b'\\mathsf{0}',
    u'\uD7E3': b'\\mathsf{1}',
    u'\uD7E4': b'\\mathsf{2}',
    u'\uD7E5': b'\\mathsf{3}',
    u'\uD7E6': b'\\mathsf{4}',
    u'\uD7E7': b'\\mathsf{5}',
    u'\uD7E8': b'\\mathsf{6}',
    u'\uD7E9': b'\\mathsf{7}',
    u'\uD7EA': b'\\mathsf{8}',
    u'\uD7EB': b'\\mathsf{9}',
    u'\uD7EC': b'\\mathsfbf{0}',
    u'\uD7ED': b'\\mathsfbf{1}',
    u'\uD7EE': b'\\mathsfbf{2}',
    u'\uD7EF': b'\\mathsfbf{3}',
    u'\uD7F0': b'\\mathsfbf{4}',
    u'\uD7F1': b'\\mathsfbf{5}',
    u'\uD7F2': b'\\mathsfbf{6}',
    u'\uD7F3': b'\\mathsfbf{7}',
    u'\uD7F4': b'\\mathsfbf{8}',
    u'\uD7F5': b'\\mathsfbf{9}',
    u'\uD7F6': b'\\mathtt{0}',
    u'\uD7F7': b'\\mathtt{1}',
    u'\uD7F8': b'\\mathtt{2}',
    u'\uD7F9': b'\\mathtt{3}',
    u'\uD7FA': b'\\mathtt{4}',
    u'\uD7FB': b'\\mathtt{5}',
    u'\uD7FC': b'\\mathtt{6}',
    u'\uD7FD': b'\\mathtt{7}',
    u'\uD7FE': b'\\mathtt{8}',
    u'\uD7FF': b'\\mathtt{9}',
}
