* [Skip to main content](#document-main)
* [Select language](#language)
* [Skip to search](#q)

[mozilla](//www.mozilla.org/) [Mozilla Developer Network](https://developer.mozilla.org/en-US/)

* [Sign in](https://developer.mozilla.org/users/github/login/?next=%2Fen-US%2Fdocs%2FWeb%2FHTML%2FElement)

* [Web Technologies](https://developer.mozilla.org/en-US/docs/Web) Technologies
  - [HTML](https://developer.mozilla.org/en-US/docs/Web/HTML)
  - [CSS](https://developer.mozilla.org/en-US/docs/Web/CSS)
  - [JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript)
  - [Graphics](https://developer.mozilla.org/en-US/docs/Web/Guide/Graphics)
  - [HTTP](https://developer.mozilla.org/en-US/docs/Web/HTTP)
  - [APIs / DOM](https://developer.mozilla.org/en-US/docs/Web/API)
  - [WebExtensions](https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons/WebExtensions)
  - [MathML](https://developer.mozilla.org/en-US/docs/Web/MathML) References & Guides
  - [Learning web development](https://developer.mozilla.org/en-US/docs/Learn)
  - [Tutorials](https://developer.mozilla.org/en-US/docs/Web/Tutorials)
  - [References](https://developer.mozilla.org/en-US/docs/Web/Reference)
  - [Developer Guides](https://developer.mozilla.org/en-US/docs/Web/Guide)
  - [Accessibility](https://developer.mozilla.org/en-US/docs/Web/Accessibility)
  - [Game development](https://developer.mozilla.org/en-US/docs/Games)
  - [...more docs](https://developer.mozilla.org/en-US/docs/Web)
* [Mozilla Docs](https://developer.mozilla.org/en-US/docs/Zones)
  - [Add-ons](https://developer.mozilla.org/en-US/docs/Mozilla/Add-ons)
  - [Firefox](https://developer.mozilla.org/en-US/docs/Mozilla/Firefox)
* [Developer Tools](https://developer.mozilla.org/en-US/docs/Tools)
* [Feedback](https://developer.mozilla.org/en-US/docs/MDN/Feedback)
  - [Get Firefox help](https://support.mozilla.org/)
  - [Get web development help](http://stackoverflow.com/)
  - [Join the MDN community](https://developer.mozilla.org/en-US/docs/MDN/Community)
  - [Report a content problem](https://bugzilla.mozilla.org/form.doc?bug_file_loc=https%3A//developer.mozilla.org/en-US/docs/Web/HTML/Element)
  - [Report a bug](https://bugzilla.mozilla.org/form.mdn)

*
  - <bdi>[عربي (ar)](https://developer.mozilla.org/ar/docs/Web/HTML/Element "Arabic")</bdi>
  - <bdi>[বাংলা (বাংলাদেশ) (bn-BD)](https://developer.mozilla.org/bn-BD/docs/Web/HTML/Element "Bengali (Bangladesh)")</bdi>
  - <bdi>[Català (ca)](https://developer.mozilla.org/ca/docs/Web/HTML/Element "Catalan")</bdi>
  - <bdi>[Čeština (cs)](https://developer.mozilla.org/cs/docs/Web/HTML/Element "Czech")</bdi>
  - <bdi>[Deutsch (de)](https://developer.mozilla.org/de/docs/Web/HTML/Element "German")</bdi>
  - <bdi>[Español (es)](https://developer.mozilla.org/es/docs/Web/HTML/Elemento "Spanish")</bdi>
  - <bdi>[فارسی (fa)](https://developer.mozilla.org/fa/docs/Web/HTML/Element "Persian")</bdi>
  - <bdi>[Français (fr)](https://developer.mozilla.org/fr/docs/Web/HTML/Element "French")</bdi>
  - <bdi>[עברית (he)](https://developer.mozilla.org/he/docs/Web/HTML/Element "Hebrew")</bdi>
  - <bdi>[magyar (hu)](https://developer.mozilla.org/hu/docs/Web/HTML/Element "Hungarian")</bdi>
  - <bdi>[Bahasa Indonesia (id)](https://developer.mozilla.org/id/docs/Web/HTML/Element "Indonesian")</bdi>
  - <bdi>[Italiano (it)](https://developer.mozilla.org/it/docs/Web/HTML/Element "Italian")</bdi>
  - <bdi>[日本語 (ja)](https://developer.mozilla.org/ja/docs/Web/HTML/Element "Japanese")</bdi>
  - <bdi>[한국어 (ko)](https://developer.mozilla.org/ko/docs/Web/HTML/Element "Korean")</bdi>
  - <bdi>[Melayu (ms)](https://developer.mozilla.org/ms/docs/HTML/Elemen "Malay")</bdi>
  - <bdi>[Nederlands (nl)](https://developer.mozilla.org/nl/docs/Web/HTML/HTML_Tags "Dutch")</bdi>
  - <bdi>[Polski (pl)](https://developer.mozilla.org/pl/docs/Web/HTML/Element "Polish")</bdi>
  - <bdi>[Português (do Brasil) (pt-BR)](https://developer.mozilla.org/pt-BR/docs/Web/HTML/Element "Portuguese (Brazilian)")</bdi>
  - <bdi>[Português (Europeu) (pt-PT)](https://developer.mozilla.org/pt-PT/docs/Web/HTML/Elemento "Portuguese (Portugal)")</bdi>
  - <bdi>[Română (ro)](https://developer.mozilla.org/ro/docs/Web/HTML/Element "Romanian")</bdi>
  - <bdi>[Русский (ru)](https://developer.mozilla.org/ru/docs/Web/HTML/Element "Russian")</bdi>
  - <bdi>[Türkçe (tr)](https://developer.mozilla.org/tr/docs/Web/HTML/Element "Turkish")</bdi>
  - <bdi>[Українська (uk)](https://developer.mozilla.org/uk/docs/Web/HTML/%D0%95%D0%BB%D0%B5%D0%BC%D0%B5%D0%BD%D1%82 "Ukrainian")</bdi>
  - <bdi>[Tiếng Việt (vi)](https://developer.mozilla.org/vi/docs/Web/HTML/Element "Vietnamese")</bdi>
  - <bdi>[中文 (简体) (zh-CN)](https://developer.mozilla.org/zh-CN/docs/Web/HTML/Element "Chinese (Simplified)")</bdi>
  - <bdi>[正體中文 (繁體) (zh-TW)](https://developer.mozilla.org/zh-TW/docs/Web/HTML/Element "Chinese (Traditional)")</bdi>
  - [Add a translation](https://developer.mozilla.org/en-US/docs/Web/HTML/Element$locales)
* [Edit](https://developer.mozilla.org/en-US/docs/Web/HTML/Element$edit)
* Advanced
  - [History](https://developer.mozilla.org/en-US/docs/Web/HTML/Element$history)
  - [Print this article](#)

1. [MDN](https://developer.mozilla.org/en-US)
2. [Web technology for developers](https://developer.mozilla.org/en-US/docs/Web)
3. [HTML](https://developer.mozilla.org/en-US/docs/Web/HTML)
4. HTML element reference

Your Search Results

* [Jeremie](https://developer.mozilla.org/en-US/profiles/Jeremie "View profile: Jeremie")
* [Fizco](https://developer.mozilla.org/en-US/profiles/Fizco "View profile: Fizco")
* [pcat](https://developer.mozilla.org/en-US/profiles/pcat "View profile: pcat")
* [chrisdavidmills](https://developer.mozilla.org/en-US/profiles/chrisdavidmills "View profile: chrisdavidmills")
* [kenobll](https://developer.mozilla.org/en-US/profiles/kenobll "View profile: kenobll")
* [fcard](https://developer.mozilla.org/en-US/profiles/fcard "View profile: fcard")
* [slimsag](https://developer.mozilla.org/en-US/profiles/slimsag "View profile: slimsag")
* [arsmrn](https://developer.mozilla.org/en-US/profiles/arsmrn "View profile: arsmrn")
* [Sebastianz](https://developer.mozilla.org/en-US/profiles/Sebastianz "View profile: Sebastianz")
* [cezaraugusto](https://developer.mozilla.org/en-US/profiles/cezaraugusto "View profile: cezaraugusto")
* [Ende93](https://developer.mozilla.org/en-US/profiles/Ende93 "View profile: Ende93")
* [kmcgillivray](https://developer.mozilla.org/en-US/profiles/kmcgillivray "View profile: kmcgillivray")
* [jsx](https://developer.mozilla.org/en-US/profiles/jsx "View profile: jsx")
* [tkkhhaarree](https://developer.mozilla.org/en-US/profiles/tkkhhaarree "View profile: tkkhhaarree")
* [jswisher](https://developer.mozilla.org/en-US/profiles/jswisher "View profile: jswisher")
* [vickylance](https://developer.mozilla.org/en-US/profiles/vickylance "View profile: vickylance")
* [MusikAnimal](https://developer.mozilla.org/en-US/profiles/MusikAnimal "View profile: MusikAnimal")
* [rosytrevino4](https://developer.mozilla.org/en-US/profiles/rosytrevino4 "View profile: rosytrevino4")
* [MarkBeleski](https://developer.mozilla.org/en-US/profiles/MarkBeleski "View profile: MarkBeleski")
* [Sheppy](https://developer.mozilla.org/en-US/profiles/Sheppy "View profile: Sheppy")
* [ambischof](https://developer.mozilla.org/en-US/profiles/ambischof "View profile: ambischof")
* [Yuzmeister](https://developer.mozilla.org/en-US/profiles/Yuzmeister "View profile: Yuzmeister")
* [SphinxKnight](https://developer.mozilla.org/en-US/profiles/SphinxKnight "View profile: SphinxKnight")
* [whitman](https://developer.mozilla.org/en-US/profiles/whitman "View profile: whitman")
* [teoli](https://developer.mozilla.org/en-US/profiles/teoli "View profile: teoli")
* [Dexter_Deter](https://developer.mozilla.org/en-US/profiles/Dexter_Deter "View profile: Dexter_Deter")
* [neelance](https://developer.mozilla.org/en-US/profiles/neelance "View profile: neelance")
* [xfq](https://developer.mozilla.org/en-US/profiles/xfq "View profile: xfq")
* [Brettz9](https://developer.mozilla.org/en-US/profiles/Brettz9 "View profile: Brettz9")
* [FabioBohnenberger](https://developer.mozilla.org/en-US/profiles/FabioBohnenberger "View profile: FabioBohnenberger")
* [kscarfone](https://developer.mozilla.org/en-US/profiles/kscarfone "View profile: kscarfone")
* [dekajp](https://developer.mozilla.org/en-US/profiles/dekajp "View profile: dekajp")
* [kohei.yoshino](https://developer.mozilla.org/en-US/profiles/kohei.yoshino "View profile: kohei.yoshino")
* [Ruakh](https://developer.mozilla.org/en-US/profiles/Ruakh "View profile: Ruakh")
* [slhuang](https://developer.mozilla.org/en-US/profiles/slhuang "View profile: slhuang")
* [Nickolay](https://developer.mozilla.org/en-US/profiles/Nickolay "View profile: Nickolay")
* [SteveFaulkner](https://developer.mozilla.org/en-US/profiles/SteveFaulkner "View profile: SteveFaulkner")
* [claudepache](https://developer.mozilla.org/en-US/profiles/claudepache "View profile: claudepache")
* [haboqueferus](https://developer.mozilla.org/en-US/profiles/haboqueferus "View profile: haboqueferus")
* [allergic](https://developer.mozilla.org/en-US/profiles/allergic "View profile: allergic")
* [simonsarris](https://developer.mozilla.org/en-US/profiles/simonsarris "View profile: simonsarris")
* [BillyONeal](https://developer.mozilla.org/en-US/profiles/BillyONeal "View profile: BillyONeal")
* [zziccardi](https://developer.mozilla.org/en-US/profiles/zziccardi "View profile: zziccardi")
* [betoscopio](https://developer.mozilla.org/en-US/profiles/betoscopio "View profile: betoscopio")
* [ethertank](https://developer.mozilla.org/en-US/profiles/ethertank "View profile: ethertank")
* [BobChao](https://developer.mozilla.org/en-US/profiles/BobChao "View profile: BobChao")
* [tregagnon](https://developer.mozilla.org/en-US/profiles/tregagnon "View profile: tregagnon")
* [Faldo](https://developer.mozilla.org/en-US/profiles/Faldo "View profile: Faldo")
* [syssgx](https://developer.mozilla.org/en-US/profiles/syssgx "View profile: syssgx")
* [trevorh](https://developer.mozilla.org/en-US/profiles/trevorh "View profile: trevorh")
* [timemachine3030](https://developer.mozilla.org/en-US/profiles/timemachine3030 "View profile: timemachine3030")
* [fscholz](https://developer.mozilla.org/en-US/profiles/fscholz "View profile: fscholz")
* [cers](https://developer.mozilla.org/en-US/profiles/cers "View profile: cers")
* [hobophobe](https://developer.mozilla.org/en-US/profiles/hobophobe "View profile: hobophobe")
* [Ms2ger](https://developer.mozilla.org/en-US/profiles/Ms2ger "View profile: Ms2ger")
* [Jürgen Jeka](https://developer.mozilla.org/en-US/profiles/J%C3%BCrgen%20Jeka "View profile: Jürgen Jeka")
* [Gilchris](https://developer.mozilla.org/en-US/profiles/Gilchris "View profile: Gilchris")
* [Mgjbot](https://developer.mozilla.org/en-US/profiles/Mgjbot "View profile: Mgjbot")
* [Jscher2000](https://developer.mozilla.org/en-US/profiles/Jscher2000 "View profile: Jscher2000")
* [PablO](https://developer.mozilla.org/en-US/profiles/PablO "View profile: PablO")
* [Rappo](https://developer.mozilla.org/en-US/profiles/Rappo "View profile: Rappo")
* [Ptak82](https://developer.mozilla.org/en-US/profiles/Ptak82 "View profile: Ptak82")
* [NickolayBot](https://developer.mozilla.org/en-US/profiles/NickolayBot "View profile: NickolayBot")
* [Dria](https://developer.mozilla.org/en-US/profiles/Dria "View profile: Dria")
* [Charles](https://developer.mozilla.org/en-US/profiles/Charles "View profile: Charles")

# HTML element reference

[In This Article](#toc)

1. [Basic elements](#basic-elements)
2. [Basic syntax](#basic-syntax)
3. [Main root](#main-root)
4. [Document metadata](#document-metadata)
5. [Content sectioning](#content-sectioning)
6. [Text content](#text-content)
7. [Inline text semantics](#inline-text-semantics)
8. [Image and multimedia](#image-and-multimedia)
9. [Embedded content](#embedded-content)
10. [Scripting](#scripting)
11. [Demarcating edits](#demarcating-edits)
12. [Table content](#table-content)
13. [Forms](#forms)
14. [Interactive elements](#interactive-elements)
15. [Web Components](#web-components)
16. [Obsolete and deprecated elements](#obsolete-and-deprecated-elements)

This page lists all the [HTML](https://developer.mozilla.org/en-US/docs/Glossary/HTML "HTML: HTML (HyperText Markup Language) is a descriptive language that specifies webpage structure.") [elements](https://developer.mozilla.org/en-US/docs/Glossary/Element "elements: An element is a part of a webpage. In XML and HTML, an element may contain a data item or a chunk of text or an image, or perhaps nothing. A typical element includes an opening tag with some attributes, enclosed text content, and a closing tag:"). They are grouped by function to help you find what you have in mind easily. Although this guide is written for those who are newer to coding, we intend it to be useful for anyone.

## Basic elements

Basic elements are the backbone of any HTML document. You'll see these elements in the source code for all web pages, following the doctype declaration, which is on the first line of the page. The doctype specifies which version of (X)HTML that page is using. Elements comprising the contents of a Web page are placed between the opening [`<html>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html "The HTML <html> element (or HTML root element) represents the root of an HTML document. All other elements must be descendants of this element.") tag and the closing `</html>` tag. The [`<html>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html "The HTML <html> element (or HTML root element) represents the root of an HTML document. All other elements must be descendants of this element.") element is also known as the root element. (Note however that complex documents may also have special "child" roots called [shadow-roots](https://developer.mozilla.org/en-US/docs/Web/API/ShadowRoot).)

### Attributes

Most elements need, or can have, additional information specified in order to function properly, or as intended. These details are given via special _name_="_value"_ pairs called attributes, and are included in the opening tag of the element. Each element or element-type has its own set of [allowed attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes), (See desired element for its specific list), but there are also general or ["global" attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes) that can be applied to ANY element (though some may have no effect.) Note that attribute values should be in quotes (and MUST be to properly function if value contains any whitespace -- for example, a [class-list)](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/class) but there is usually no error message generated if quotes are missing. Note also that there is usually no error generated by misspelled or undefined attributes (though they do violate the formal spec), and thus some complex HTML documents may make use of their own private attribute-names in handling their data and elements.

## Basic syntax

<pre><strong>&lt;</strong><em>tagname</em> <em>attribute1</em> <strong>=</strong> <strong>&quot;</strong><em>value</em><strong>&quot;</strong> ... <em>attributeN</em> <strong>=</strong> <strong>&quot;</strong><em>value</em><strong>&quot;&gt;</strong> <em>element</em> <em>contents</em> <strong>&lt;/</strong><code><em>tagname</em><strong>&gt;</strong></code>
</pre>

## Main root

| Element | Description |
| --- | --- |
| [`<html>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html "The HTML <html> element (or HTML root element) represents the root of an HTML document. All other elements must be descendants of this element.") | The **HTML `<html>` element** (or _HTML root element_) represents the root of an HTML document. All other elements must be descendants of this element. |

## Document metadata

Metadata contains information about the page. This includes information about styles, scripts and data to help software ([search engines](https://developer.mozilla.org/en-US/docs/Glossary/search_engine "search engines: A search engine is a software system that collects information from the World Wide Web and presents it to users who are looking for specific information."), [browsers](https://developer.mozilla.org/en-US/docs/Glossary/Browser "browsers: A Web browser is a program that retrieves and displays pages from the Web, and lets users access further pages through hyperlinks."), etc.) use and render the page. Metadata for styles and scripts may be defined in the page or link to another file that has the information.

| Element | Description |
| --- | --- |
| [`<base>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/base "The HTML <base> element specifies the base URL to use for all relative URLs contained within a document. There can be only one <base> element in a document.") | The **HTML `<base>` element** specifies the base URL to use for all relative URLs contained within a document. There can be only one `<base>` element in a document. |
| [`<head>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/head "The HTML <head> element provides general information (metadata) about the document, including its title and links to its scripts and style sheets.") | The **HTML `<head>` element** provides general information (metadata) about the document, including its title and links to its scripts and style sheets. |
| [`<link>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link "The HTML <link> element specifies relationships between the current document and an external resource. Possible uses for this element include defining a relational framework for navigation. This Element is most used to link to style sheets.") | The **HTML `<link>` element** specifies relationships between the current document and an external resource. Possible uses for this element include defining a relational framework for navigation. This Element is most used to link to style sheets. |
| [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents any metadata information that cannot be represented by one of the other HTML meta-related elements (<base>, <link>, <script>, <style> or <title>).") | The **HTML `<meta>` element** represents any metadata information that cannot be represented by one of the other HTML meta-related elements ([`<base>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/base "The HTML <base> element specifies the base URL to use for all relative URLs contained within a document. There can be only one <base> element in a document."),[`<link>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link "The HTML <link> element specifies relationships between the current document and an external resource. Possible uses for this element include defining a relational framework for navigation. This Element is most used to link to style sheets."),[`<script>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/script "The HTML Script Element (<script>) is used to embed or reference an executable script within an HTML or XHTML document."),[`<style>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/style "The HTML <style> element contains style information for a document, or part of a document. By default, the style instructions written inside that element are expected to be CSS.") or [`<title>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title "The HTML <title> element defines the title of the document, shown in a browser's title bar or on the page's tab. It can only contain text, and any contained tags are ignored.")). |
| [`<style>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/style "The HTML <style> element contains style information for a document, or part of a document. By default, the style instructions written inside that element are expected to be CSS.") | The **HTML `<style>` element** contains style information for a document, or part of a document. By default, the style instructions written inside that element are expected to be [CSS](https://developer.mozilla.org/en-US/docs/Web/CSS). |
| [`<title>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title "The HTML <title> element defines the title of the document, shown in a browser's title bar or on the page's tab. It can only contain text, and any contained tags are ignored.") | The **HTML `<title>` element** defines the title of the document, shown in a browser's title bar or on the page's tab. It can only contain text, and any contained tags are ignored. |

## Content sectioning

Content sectioning elements allow you to organize the document content into logical pieces. Use the sectioning elements to create a broad outline for your page content, including header and footer navigation, and heading elements to identify sections of content.

| Element | Description |
| --- | --- |
| [`<address>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/address "The HTML <address> element supplies contact information for its nearest <article> or <body> ancestor; in the latter case, it applies to the whole document.") | The **HTML `<address>` element** supplies contact information for its nearest [`<article>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/article "The HTML <article> element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each <article> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <article> element.") or [`<body>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body "The HTML <body> Element represents the content of an HTML document. There can be only one <body> element in a document.") ancestor; in the latter case, it applies to the whole document. |
| [`<article>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/article "The HTML <article> element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each <article> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <article> element.") | The **HTML `<article>` element** represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each `<article>` should be identified, typically by including a heading ([`<h1>`-`<h6>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/Heading_Elements) element) as a child of the `<article>` element. |
| [`<aside>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/aside "The HTML <aside> element represents a section of the page with content connected tangentially to the rest, which could be considered separate from that content. These sections are often represented as sidebars or inserts. They often contain the definitions on the sidebars, such as definitions from the glossary; there may also be other types of information, such as related advertisements; the biography of the author; web applications; profile information or related links on the blog.") | The **HTML `<aside>` element** represents a section of the page with content connected tangentially to the rest, which could be considered separate from that content. These sections are often represented as sidebars or inserts. They often contain the definitions on the sidebars, such as definitions from the glossary; there may also be other types of information, such as related advertisements; the biography of the author; web applications; profile information or related links on the blog. |
| [`<footer>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/footer "The HTML <footer> element represents a footer for its nearest sectioning content or sectioning root element. A footer typically contains information about the author of the section, copyright data or links to related documents.") | The **HTML `<footer>` element** represents a footer for its nearest [sectioning content](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Sections_and_Outlines_of_an_HTML5_document#Defining_Sections_in_HTML5) or [sectioning root](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Sections_and_Outlines_of_an_HTML5_document#Sectioning_root "Sections and Outlines of an HTML5 document#Sectioning root") element. A footer typically contains information about the author of the section, copyright data or links to related documents. |
| [`<header>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/header "The HTML <header> element represents a group of introductory or navigational aids. It may contain some heading elements but also other elements like a logo, wrapped section's header, a search form, and so on.") | The **HTML `<header>` element** represents a group of introductory or navigational aids. It may contain some heading elements but also other elements like a logo, wrapped section's header, a search form, and so on. |
| [`<h1>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h1 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h2>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h2 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h3>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h3 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h4>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h4 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h5>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h5 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically."),[`<h6>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h6 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically.") | **Heading** elements implement six levels of document headings, `<h1>` is the most important and `<h6>` is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically. |
| [`<hgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/hgroup "The HTML <hgroup> Element (HTML Heading Group Element) represents the heading of a section. It defines a single title that participates in the outline of the document as the heading of the implicit or explicit section that it belongs to.") | The **HTML `<hgroup>` Element** (_HTML Heading Group Element_) represents the heading of a section. It defines a single title that participates in [the outline of the document](https://developer.mozilla.org/en-US/docs/Sections_and_Outlines_of_an_HTML5_document "Sections and Outlines of an HTML5 document") as the heading of the implicit or explicit section that it belongs to. |
| [`<nav>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nav "The HTML <nav> element (HTML Navigation Element) represents a section of a page that links to other pages or to parts within the page: a section with navigation links.") | The **HTML `<nav>` element** (_HTML Navigation Element_) represents a section of a page that links to other pages or to parts within the page: a section with navigation links. |
| [`<section>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/section "The HTML <section> element represents a generic section of a document, i.e., a thematic grouping of content, typically with a heading. Each <section> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <section> element.") | The **HTML `<section>` element** represents a generic section of a document, i.e., a thematic grouping of content, typically with a heading. Each `<section>` should be identified, typically by including a heading ([`<h1>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h1 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically.")-[`<h6>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/h6 "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically.") element) as a child of the `<section>` element. |

## Text content

Use HTML text content elements to organize blocks or sections of content placed between the opening [`<body>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body "The HTML <body> Element represents the content of an HTML document. There can be only one <body> element in a document.") and closing `</body>` tags. Important for [accessibility](https://developer.mozilla.org/en-US/docs/Glossary/accessibility "accessibility: Web Accessibility (A11Y) refers to best practices for keeping a website usable despite physical and technical restrictions. Web accessibility is formally defined and discussed at the W3C through the Web Accessibility Initiative (WAI).") and [SEO](https://developer.mozilla.org/en-US/docs/Glossary/SEO "SEO: SEO (Search Engine Optimization) is the process of making a website more visible in search results, also termed improving search rankings."), these elements identify the purpose or structure of that content.

| Element | Description |
| --- | --- |
| [`<dd>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dd "The HTML <dd> element (or HTML Description Element) indicates the description of a term in a description list (<dl>).") | The **HTML `<dd>` element** (or _HTML Description Element_) indicates the description of a term in a description list ([`<dl>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dl "The HTML <dl> element (or HTML Description List Element) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs).")). |
| [`<div>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/div "The HTML <div> element (or HTML Document Division Element) is the generic container for flow content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the class or id attributes), or because they share attribute values, such as lang. It should be used only when no other semantic element (such as <article> or <nav>) is appropriate.") | The **HTML `<div>` element** (or _HTML Document Division Element_) is the generic container for flow content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the **class** or **id** attributes), or because they share attribute values, such as **lang**. It should be used only when no other semantic element (such as [`<article>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/article "The HTML <article> element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each <article> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <article> element.") or [`<nav>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nav "The HTML <nav> element (HTML Navigation Element) represents a section of a page that links to other pages or to parts within the page: a section with navigation links.")) is appropriate. |
| [`<dl>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dl "The HTML <dl> element (or HTML Description List Element) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs).") | The **HTML `<dl>` element** (or _HTML_ _Description List Element_) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs). |
| [`<dt>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dt "The HTML <dt> element (or HTML Description Term Element) identifies a term in a description list. This element can occur only as a child element of a <dl>. It is usually followed by a <dd> element; however, multiple <dt> elements in a row indicate several terms that are all defined by the immediate next <dd> element.") | The **HTML `<dt>` element** (or _HTML Description Term Element_) identifies a term in a description list. This element can occur only as a child element of a [`<dl>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dl "The HTML <dl> element (or HTML Description List Element) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs)."). It is usually followed by a [`<dd>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dd "The HTML <dd> element (HTML Description Element) indicates the description of a term in a description list (<dl>) element. This element can occur only as a child element of a description list and it must follow a <dt> element.") element; however, multiple `<dt>` elements in a row indicate several terms that are all defined by the immediate next [`<dd>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dd "The HTML <dd> element (HTML Description Element) indicates the description of a term in a description list (<dl>) element. This element can occur only as a child element of a description list and it must follow a <dt> element.") element. |
| [`<figcaption>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figcaption "The HTML <figcaption> element represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the <figure> element which is its immediate ancestor which means <figcaption> can be the first or last element inside a <figure> block. Also, the HTML Figcaption Element is optional; if not provided, then the parent figure element will have no caption.") | The **HTML `<figcaption>` element** represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the [`<figure>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figure "The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow.") element which is its immediate ancestor which means `<figcaption>` can be the first or last element inside a [`<figure>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figure "The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow.") block. Also, the _HTML Figcaption Element_ is optional; if not provided, then the parent figure element will have no caption. |
| [`<figure>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figure "The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow.") | The **HTML `<figure>` element** represents self-contained content, frequently with a caption ([`<figcaption>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figcaption "The HTML <figcaption> element represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the <figure> element which is its immediate ancestor which means <figcaption> can be the first or last element inside a <figure> block. Also, the HTML Figcaption Element is optional; if not provided, then the parent figure element will have no caption.")) _`,`_ and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow. |
| [`<hr>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/hr "The HTML <hr> element represents a thematic break between paragraph-level elements (for example, a change of scene in a story, or a shift of topic with a section). In previous versions of HTML, it represented a horizontal rule. It may still be displayed as a horizontal rule in visual browsers, but is now defined in semantic terms, rather than presentational terms.") | The **HTML `<hr>` element** represents a thematic break between paragraph-level elements (for example, a change of scene in a story, or a shift of topic with a section). In previous versions of HTML, it represented a horizontal rule. It may still be displayed as a horizontal rule in visual browsers, but is now defined in semantic terms, rather than presentational terms. |
| [`<li>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li "The HTML <li> element (or HTML List Item Element) is used to represent an item in a list. It must be contained in a parent element: an ordered list (<ol>), an unordered list (<ul>), or a menu (<menu>). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter.") | The **HTML `<li>` element** (or _HTML List Item Element_) is used to represent an item in a list. It must be contained in a parent element: an ordered list ([`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> Element (or HTML Ordered List Element) represents an ordered list of items. Typically, ordered-list items are displayed with a preceding numbering, which can be of any form, like numerals, letters or Romans numerals or even simple bullets. This numbered style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.")), an unordered list ([`<ul>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element (or HTML Unordered List Element) represents an unordered list of items, namely a collection of items that do not have a numerical ordering, and their order in the list is meaningless. Typically, unordered-list items are displayed with a bullet, which can be of several forms, like a dot, a circle or a squared. The bullet style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.")), or a menu ([`<menu>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/menu "The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked.")). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter. |
| [`<main>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/main "The HTML <main> element represents the main content of  the <body> of a document or application. The main content area consists of content that is directly related to, or expands upon the central topic of a document or the central functionality of an application. This content should be unique to the document, excluding any content that is repeated across a set of documents such as sidebars, navigation links, copyright information, site logos, and search forms (unless the document's main function is as a search form).") | The **HTML `<main>` element** represents the main content of  the [`<body>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body "The HTML <body> Element represents the content of an HTML document. There can be only one <body> element in a document.") of a document or application. The main content area consists of content that is directly related to, or expands upon the central topic of a document or the central functionality of an application. This content should be unique to the document, excluding any content that is repeated across a set of documents such as sidebars, navigation links, copyright information, site logos, and search forms (unless the document's main function is as a search form). |
| [`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> Element (or HTML Ordered List Element) represents an ordered list of items. Typically, ordered-list items are displayed with a preceding numbering, which can be of any form, like numerals, letters or Romans numerals or even simple bullets. This numbered style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.") | The **HTML `<ol>` Element** (or _HTML Ordered List Element_) represents an ordered list of items. Typically, ordered-list items are displayed with a preceding numbering, which can be of any form, like numerals, letters or Romans numerals or even simple bullets. This numbered style is not defined in the HTML description of the page, but in its associated CSS, using the [`list-style-type`](https://developer.mozilla.org/en-US/docs/Web/CSS/list-style-type "The list-style-type property specifies the appearance of a list item element. Because it is the only property that defaults to display:list-item, this is usually a <li> element, but can be any element with this display value.") property. |
| [`<p>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/p "The HTML <p> element (or HTML Paragraph Element) represents a paragraph of text.") | The **HTML `<p>` element** (or _HTML Paragraph Element_) represents a paragraph of text. |
| [`<pre>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/pre "The HTML <pre> element (or HTML Preformatted Text) represents preformatted text. Text within this element is typically displayed in a non-proportional ("monospace") font exactly as it is laid out in the file. Whitespace inside this element is displayed as typed.") | The **HTML `<pre>` element** (or _HTML Preformatted Text_) represents preformatted text. Text within this element is typically displayed in a non-proportional ("[monospace](https://developer.mozilla.org/en-US/docs/XUL/Style/monospace) ") font exactly as it is laid out in the file. Whitespace inside this element is displayed as typed. |
| [`<ul>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element (or HTML Unordered List Element) represents an unordered list of items, namely a collection of items that do not have a numerical ordering, and their order in the list is meaningless. Typically, unordered-list items are displayed with a bullet, which can be of several forms, like a dot, a circle or a squared. The bullet style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.") | The **HTML `<ul>` element** (or _HTML U_ _nordered List Element_ `)` represents an unordered list of items, namely a collection of items that do not have a numerical ordering, and their order in the list is meaningless. Typically, unordered-list items are displayed with a bullet, which can be of several forms, like a dot, a circle or a squared. The bullet style is not defined in the HTML description of the page, but in its associated CSS, using the [`list-style-type`](https://developer.mozilla.org/en-US/docs/Web/CSS/list-style-type "The list-style-type property specifies the appearance of a list item element. Because it is the only property that defaults to display:list-item, this is usually a <li> element, but can be any element with this display value.") property. |

## Inline text semantics

Use the HTML inline text semantic to define the meaning, structure, or style of a word, line, or any arbitrary piece of text.

| Element | Description |
| --- | --- |
| [`<a>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a "The HTML Anchor Element (<a>) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL.") | The _HTML `Anchor` Element_ (**`<a>`**) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL. |
| [`<abbr>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/abbr "The HTML <abbr> element (or HTML Abbreviation Element) represents an abbreviation and optionally provides a full description for it. If present, the title attribute must contain this full description and nothing else.") | The **HTML `<abbr>` element** (or _HTML Abbreviation Element_) represents an abbreviation and optionally provides a full description for it. If present, the `title` attribute must contain this full description and nothing else. |
| [`<b>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/b "The HTML <b> Element represents a span of text stylistically different from normal text, without conveying any special importance or relevance. It is typically used for keywords in a summary, product names in a review, or other spans of text whose typical presentation would be boldfaced. Another example of its use is to mark the lead sentence of each paragraph of an article.") | The **HTML `<b>` Element** represents a span of text stylistically different from normal text, without conveying any special importance or relevance. It is typically used for keywords in a summary, product names in a review, or other spans of text whose typical presentation would be boldfaced. Another example of its use is to mark the lead sentence of each paragraph of an article. |
| [`<bdi>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/bdi "The HTML <bdi> Element (or Bi-Directional Isolation Element) isolates a span of text that might be formatted in a different direction from other text outside it.") | The _HTML `<bdi>` Element_ (or Bi-Directional Isolation Element) isolates a span of text that might be formatted in a different direction from other text outside it. |
| [`<bdo>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/bdo "The HTML <bdo> Element (or HTML bidirectional override element) is used to override the current directionality of text. It causes the directionality of the characters to be ignored in favor of the specified directionality.") | The **HTML `<bdo>` Element** (or _HTML bidirectional override element_) is used to override the current directionality of text. It causes the directionality of the characters to be ignored in favor of the specified directionality. |
| [`<br>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/br "The HTML element line break <br> produces a line break in text (carriage-return). It is useful for writing a poem or an address, where the division of lines is significant.") | The HTML element _l_ _ine break_ `<br>` produces a line break in text (carriage-return). It is useful for writing a poem or an address, where the division of lines is significant. |
| [`<cite>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/cite "The HTML Citation Element (<cite>) represents a reference to a creative work. It must include the title of a work or a URL reference, which may be in an abbreviated form according to the conventions used for the addition of citation metadata.") | The _HTML Citation Element_ (**<cite>**) represents a reference to a creative work. It must include the title of a work or a URL reference, which may be in an abbreviated form according to the conventions used for the addition of citation metadata. |
| [`<code>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/code "The HTML Code Element (<code>) represents a fragment of computer code. By default, it is displayed in the browser's default monospace font.") | The _HTML Code Element_ (**<code>**) represents a fragment of computer code. By default, it is displayed in the browser's default monospace font. |
| [`<data>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/data "The HTML <data> Element links a given content with a machine-readable translation. If the content is time- or date-related, the <time> must be used.") | The **HTML `<data>` Element** links a given content with a machine-readable translation. If the content is time- or date-related, the [`<time>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/time "The HTML <time> element represents either a time on a 24-hour clock or a precise date in the Gregorian calendar (with optional time and timezone information).") must be used. |
| [`<dfn>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dfn "The HTML Definition Element (<dfn>) represents the defining instance of a term.") | The _HTML Definition Element_ (**<dfn>**) represents the defining instance of a term. |
| [`<em>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/em "The HTML element emphasis  <em> marks text that has stress emphasis. The <em> element can be nested, with each level of nesting indicating a greater degree of emphasis.") | The HTML element _emphasis_ **<em>** marks text that has stress emphasis. The `<em>` element can be nested, with each level of nesting indicating a greater degree of emphasis. |
| [`<i>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/i "The HTML <i> Element represents a range of text that is set off from the normal text for some reason, for example, technical terms, foreign language phrases, or fictional character thoughts. It is typically displayed in italic type.") | The **HTML `<i>` Element** represents a range of text that is set off from the normal text for some reason, for example, technical terms, foreign language phrases, or fictional character thoughts. It is typically displayed in italic type. |
| [`<kbd>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/kbd "The HTML Keyboard Input Element (<kbd>) represents user input and produces an inline element displayed in the browser's default monospace font.") | The _HTML Keyboard Input Element_ (**<kbd>**) represents user input and produces an inline element displayed in the browser's default monospace font. |
| [`<mark>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/mark "The HTML Mark Element (<mark>) represents highlighted text, i.e., a run of text marked for reference purpose, due to its relevance in a particular context. For example it can be used in a page showing search results to highlight every instance of the searched-for word.") | The _HTML Mark Element_ (<mark>) represents highlighted text, i.e., a run of text marked for reference purpose, due to its _relevance_ in a particular context. For example it can be used in a page showing search results to highlight every instance of the searched-for word. |
| [`<q>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/q "The HTML Quote Element (<q>) indicates that the enclosed text is a short inline quotation. This element is intended for short quotations that don't require paragraph breaks; for long quotations use the <blockquote> element.") | The _HTML Quote Element_ (**<q>**) indicates that the enclosed text is a short inline quotation. This element is intended for short quotations that don't require paragraph breaks; for long quotations use the [`<blockquote>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/blockquote "The HTML <blockquote> Element (or HTML Block Quotation Element) indicates that the enclosed text is an extended quotation. Usually, this is rendered visually by indentation (see Notes for how to change it). A URL for the source of the quotation may be given using the cite attribute, while a text representation of the source can be given using the <cite> element.") element. |
| [`<rp>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rp "The HTML <rp> element is used to provide fall-back parenthesis for browsers non-supporting ruby annotations. Ruby annotations are for showing pronunciation of East Asian characters, like using Japanese furigana or Taiwainese bopomofo characters. The <rp> element is used in the case of lack of <ruby> element support its content has what should be displayed in order to indicate the presence of a ruby annotation, usually parentheses.") | The **HTML `<rp>` element** is used to provide fall-back parenthesis for browsers non-supporting ruby annotations. Ruby annotations are for showing pronunciation of East Asian characters, like using Japanese furigana or Taiwainese bopomofo characters. The `<rp>` element is used in the case of lack of [`<ruby>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.") element support its content has what should be displayed in order to indicate the presence of a ruby annotation, usually parentheses. |
| [`<rt>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rt "The HTML <rt> Element embraces pronunciation of characters presented in a ruby annotations, which are used to describe the pronunciation of East Asian characters. This element is always used inside a <ruby> element.") | The **HTML `<rt>` Element** embraces pronunciation of characters presented in a ruby annotations, which are used to describe the pronunciation of East Asian characters. This element is always used inside a [`<ruby>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.") element. |
| [`<rtc>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rtc "The HTML <rtc> Element embraces semantic annotations of characters presented in a ruby of <rb> elements used inside of <ruby> element. <rb> elements can have both pronunciation (<rt>) and semantic (<rtc>) annotations.") | The **HTML `<rtc>` Element** embraces semantic annotations of characters presented in a ruby of [`<rb>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rb "The documentation about this has not yet been written; please consider contributing!") elements used inside of [`<ruby>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.") element. [`<rb>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rb "The documentation about this has not yet been written; please consider contributing!") elements can have both pronunciation ([`<rt>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rt "The HTML <rt> Element embraces pronunciation of characters presented in a ruby annotations, which are used to describe the pronunciation of East Asian characters. This element is always used inside a <ruby> element.")) and semantic ([`<rtc>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rtc "The HTML <rtc> Element embraces semantic annotations of characters presented in a ruby of <rb> elements used inside of <ruby> element. <rb> elements can have both pronunciation (<rt>) and semantic (<rtc>) annotations.")) annotations. |
| [`<ruby>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.") | The **HTML `<ruby>` Element** represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters. |
| [`<s>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/s "The HTML Strikethrough Element (<s>) renders text with a strikethrough, or a line through it. Use the <s> element to represent things that are no longer relevant or no longer accurate. However, <s> is not appropriate when indicating document edits; for that, use the <del> and <ins> elements, as appropriate.") | The _HTML Strikethrough Element_ (`<s>`) renders text with a strikethrough, or a line through it. Use the `<s>` element to represent things that are no longer relevant or no longer accurate. However, `<s>` is not appropriate when indicating document edits; for that, use the [`<del>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/del "The HTML Deleted Text Element (<del>) represents a range of text that has been deleted from a document. This element is often (but need not be) rendered with strike-through text.") and [`<ins>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ins "The HTML <ins> Element (or HTML Inserted Text) HTML represents a range of text that has been added to a document.") elements, as appropriate. |
| [`<samp>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/samp "The HTML <samp> element is an element intended to identify sample output from a computer program. It is usually displayed in the browser's default monotype font (such as Lucida Console).") | The HTML <samp> element is an element intended to identify sample output from a computer program. It is usually displayed in the browser's default monotype font (such as Lucida Console). |
| [`<small>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/small "The HTML Small Element (<small>) makes the text font size one size smaller (for example, from large to medium, or from small to x-small) down to the browser's minimum font size.  In HTML5, this element is repurposed to represent side-comments and small print, including copyright and legal text, independent of its styled presentation.") | The HTML Small Element (<small>) makes the text _font size_ one size smaller (for example, from large to medium, or from small to x-small) down to the browser's minimum font size.  In HTML5, this element is repurposed to represent side-comments and small print, including copyright and legal text, independent of its styled presentation. |
| [`<span>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/span "The HTML <span> element is a generic inline container for phrasing content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the class or id attributes), or because they share attribute values, such as lang.") | The **HTML _`<span>`_ element** is a generic inline container for phrasing content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the `class` or `id` attributes), or because they share attribute values, such as `lang`. |
| [`<strong>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/strong "The HTML <strong> element (or HTML Strong Element) gives text strong importance, and is typically displayed in bold.") | The **HTML** `<strong><strong></strong>` **element** `(or` _HTML Strong Element_) gives text strong importance, and is typically displayed in bold. |
| [`<sub>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/sub "The HTML Subscript Element (<sub>) defines a span of text that should be displayed, for typographic reasons, lower, and often smaller, than the main span of text.") | The _HTML Subscript Element_ (`<sub>`) defines a span of text that should be displayed, for typographic reasons, lower, and often smaller, than the main span of text. |
| [`<sup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/sup "The HTML Superscript Element (<sup>) defines a span of text that should be displayed, for typographic reasons, higher, and often smaller, than the main span of text.") | The _HTML Superscript Element_ (`<sup>`) defines a span of text that should be displayed, for typographic reasons, higher, and often smaller, than the main span of text. |
| [`<time>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/time "The HTML <time> element represents either a time on a 24-hour clock or a precise date in the Gregorian calendar (with optional time and timezone information).") | The **HTML `<time>` element** represents either a time on a 24-hour clock or a precise date in the [Gregorian calendar](http://en.wikipedia.org/wiki/Gregorian_calendar "http://en.wikipedia.org/wiki/Gregorian_calendar") (with optional time and timezone information). |
| [`<u>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/u "The HTML Underline Element (<u>) renders text with an underline, a line under the baseline of its content.") | The _HTML Underline Element_ (`<u>`) renders text with an underline, a line under the baseline of its content. |
| [`<var>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/var "The HTML Variable Element (<var>) represents a variable in a mathematical expression or a programming context.") | The HTML Variable Element (`<var>`) represents a variable in a mathematical expression or a programming context. |
| [`<wbr>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/wbr "The HTML element word break opportunity <wbr> represents a position within text where the browser may optionally break a line, though its line-breaking rules would not otherwise create a break at that location.") | The HTML element _word break opportunity_ `<wbr>` represents a position within text where the browser may optionally break a line, though its line-breaking rules would not otherwise create a break at that location. |

## Image and multimedia

HTML supports various multimedia resources such as images, audio, and video.

| Element | Description |
| --- | --- |
| [`<area>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/area "The HTML <area> element defines a hot-spot region on an image, and optionally associates it with a hypertext link. This element is used only within a <map> element.") | The _HTML `<area>` element_ defines a hot-spot region on an image, and optionally associates it with a [hypertext link](https://developer.mozilla.org/en-US/docs/Glossary/Hyperlink "hypertext link: Hyperlinks connect webpages or data items to one another. In HTML, <a> elements define hyperlinks from a spot on a webpage (like a text string or image) to another spot on some webpage (even the same page)."). This element is used only within a [`<map>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/map "The HTML <map> element is used with <area> elements to define an image map (a clickable link area).") element. |
| [`<audio>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio "The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element; the browser will choose the most suitable one.") | The **HTML `<audio>` element** is used to embed sound content in documents. It may contain one or more audio sources, represented using the `src` attribute or the [`<source>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source "The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers.") element; the browser will choose the most suitable one. |
| [`<img>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/img "The HTML <img> element represents an image in the document.") | The **HTML `<img>` element** represents an image in the document. |
| [`<map>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/map "The HTML <map> element is used with <area> elements to define an image map (a clickable link area).") | The **HTML `<map>` element** is used with [`<area>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/area "The HTML <area> element defines a hot-spot region on an image, and optionally associates it with a hypertext link. This element is used only within a <map> element.") elements to define an image map (a clickable link area). |
| [`<track>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/track "The HTML <track> element is used as a child of the media elements—<audio> and <video>. It lets you specify timed text tracks (or time-based data), for example to automatically handle subtitles. The tracks are formatted in WebVTT format (.vtt files) — Web Video Text Tracks.") | The **HTML `<track>` element** is used as a child of the media elements—[`<audio>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio "The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element; the browser will choose the most suitable one.") and [`<video>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video "Use the  HTML <video> element to embed video content in a document. The video element contains one or more video sources. To specify a video source, use either the src attribute or the <source> element; the browser will choose the most suitable one."). It lets you specify timed text tracks (or time-based data), for example to automatically handle subtitles. The tracks are formatted in [WebVTT format](https://developer.mozilla.org/en-US/docs/Web/API/Web_Video_Text_Tracks_Format) (`.vtt` files) — Web Video Text Tracks. |
| [`<video>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video "Use the  HTML <video> element to embed video content in a document. The video element contains one or more video sources. To specify a video source, use either the src attribute or the <source> element; the browser will choose the most suitable one.") | Use the **HTML `<video>` element** to embed video content in a document. The video element contains one or more video sources. To specify a video source, use either the `src` attribute or the [`<source>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source "The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers.") element; the browser will choose the most suitable one. |

## Embedded content

In addition to regular multimedia content, HTML can include a variety of other content, even if it's not always easy to interact with.

| Element | Description |
| --- | --- |
| [`<embed>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/embed "The HTML <embed> Element represents an integration point for an external application or interactive content (in other words, a plug-in).") | The **HTML `<embed>` Element** represents an integration point for an external application or interactive content (in other words, a plug-in). |
| [`<object>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/object "The HTML Embedded Object Element (<object>) represents an external resource, which can be treated as an image, a nested browsing context, or a resource to be handled by a plugin.") | The _HTML Embedded Object Element_ (**<object>**) represents an external resource, which can be treated as an image, a nested browsing context, or a resource to be handled by a plugin. |
| [`<param>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/param "The HTML <param> Element (or HTML Parameter Element) defines parameters for <object>.") | The **HTML `<param>` Element** (or _HTML Parameter Element)_ defines parameters for [`<object>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/object "The HTML Embedded Object Element (<object>) represents an external resource, which can be treated as an image, a nested browsing context, or a resource to be handled by a plugin."). |
| [`<source>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source "The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers.") | The **HTML `<source>` element** specifies multiple media resources for either the [`<picture>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/picture "The HTML <picture> element is a container used to specify multiple <source> elements for a specific <img> contained in it. The browser will choose the most suitable source according to the current layout of the page (the constraints of the box the image will appear in) and the device it will be displayed on (e.g. a normal or hiDPI device.)"), the [`<audio>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio "The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element; the browser will choose the most suitable one.") or the [`<video>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video "Use the  HTML <video> element to embed video content in a document. The video element contains one or more video sources. To specify a video source, use either the src attribute or the <source> element; the browser will choose the most suitable one.") element. It is an empty element. It is commonly used to serve the same media content in [multiple formats supported by different browsers](https://developer.mozilla.org/en-US/docs/Media_formats_supported_by_the_audio_and_video_elements). |

## Scripting

In order to create dynamic content and Web applications, HTML supports the use of scripting languages, most prominently JavaScript. Certain elements support this capability.

| Element | Description |
| --- | --- |
| [`<canvas>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "The HTML <canvas> Element can be used to draw graphics via scripting (usually JavaScript). For example, it can be used to draw graphs, make photo compositions or even perform animations. You may (and should) provide alternate content inside the <canvas> block. That content will be rendered both on older browsers that don't support canvas and in browsers with JavaScript disabled.") | The **HTML `<canvas>` Element** can be used to draw graphics via scripting (usually [JavaScript](https://developer.mozilla.org/en-US/docs/Web/JavaScript)). For example, it can be used to draw graphs, make photo compositions or even perform animations. You may (and should) provide alternate content inside the `<canvas>` block. That content will be rendered both on older browsers that don't support canvas **and** in browsers with JavaScript disabled. |
| [`<noscript>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/noscript "The HTML <noscript> Element defines a section of html to be inserted if a script type on the page is unsupported or if scripting is currently turned off in the browser.") | The **HTML `<noscript>` Element** defines a section of html to be inserted if a script type on the page is unsupported or if scripting is currently turned off in the browser. |
| [`<script>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/script "The <script> element (or HTML Script Element ) is used to embed or reference an executable script within an HTML or XHTML document.") | The `<strong><script></strong>` element (or _HTML Script Element_) is used to embed or reference an executable script within an <abbr title="Hypertext Markup Language">HTML</abbr> or <abbr title="Extensible Hypertext Markup Language">XHTML</abbr> document. |

## Demarcating edits

These elements let you provide indications that specific parts of the text have been altered.

| Element | Description |
| --- | --- |
| [`<del>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/del "The HTML Deleted Text Element (<del>) represents a range of text that has been deleted from a document. This element is often (but need not be) rendered with strike-through text.") | The _HTML Deleted Text Element_ (**<del>**) represents a range of text that has been deleted from a document. This element is often (but need not be) rendered with strike-through text. |
| [`<ins>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ins "The HTML <ins> Element (or HTML Inserted Text) HTML represents a range of text that has been added to a document.") | The **HTML `<ins>` Element** (or _HTML Inserted Text_) HTML represents a range of text that has been added to a document. |

## Table content

The elements here are used to create and handle tabular data.

| Element | Description |
| --- | --- |
| [`<caption>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/caption "The HTML <caption> Element (or HTML Table Caption Element) represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table.") | The **HTML `<caption>` Element** (or _HTML Table Caption Element_) represents the title of a table. Though it is always the first descendant of a [`<table>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents data in two dimensions or more."), its styling, using CSS, may place it elsewhere, relative to the table. |
| [`<col>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col "The HTML Table Column Element (<col>) defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a <colgroup> element.") | The _HTML Table Column Element_ (**<col>**) defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a [`<colgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup "The HTML Table Column Group Element (<colgroup>) defines a group of columns within a table.") element. |
| [`<colgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup "The HTML Table Column Group Element (<colgroup>) defines a group of columns within a table.") | The _HTML Table Column Group Element_ (**<colgroup>**) defines a group of columns within a table. |
| [`<table>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents tabular data - i.e., information expressed via a two dimensional data table.") | The **HTML Table Element** (`<table>`) represents tabular data - i.e., information expressed via a two dimensional data table. |
| [`<tbody>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody "The HTML Table Body Element (<tbody>) defines one or more <tr> element data-rows to be the body of its parent <table> element (as long as no <tr> elements are immediate children of that table element.)  In conjunction with a preceding <thead> and/or <tfoot> element, <tbody> provides additional semantic information for devices such as printers and displays. Of the parent table's child elements, <tbody> represents the content which, when longer than a page, will most likely differ for each page printed; while the content of <thead> and <tfoot> will be the same or similar for each page printed. For displays, <tbody> will enable separate scrolling of the <thead>, <tfoot>, and <caption> elements of the same parent <table> element.  Note that unlike the <thead>, <tfoot>, and <caption> elements however, multiple <tbody> elements are permitted (if consecutive), allowing the data-rows in long tables to be divided into different sections, each separately formatted as needed.") | The HTML **Table Body Element (<tbody>)** defines one or more [`<tr>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tr "The HTML element table row <tr> defines a row of cells in a table. Those can be a mix of <td> and <th> elements.") element data-rows to be the body of its parent [`<table>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents data in two dimensions or more.") element (as long as no <tr> elements are immediate children of that table element.)  In conjunction with a preceding [`<thead>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table.") and/or [`<tfoot>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table.") element, <tbody> provides additional semantic information for devices such as printers and displays. Of the parent table's child elements, <tbody> represents the content which, when longer than a page, will most likely differ for each page printed; while the content of [`<thead>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table.") and [`<tfoot>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table.") will be the same or similar for each page printed. For displays, <tbody> will enable separate scrolling of the [`<thead>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table."),[`<tfoot>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table."), and [`<caption>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/caption "The HTML <caption> Element (or HTML Table Caption Element) represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table.") elements of the same parent [`<table>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents data in two dimensions or more.") element. Note that unlike the <thead>, <tfoot>, and <caption> elements however, multiple <tbody> elements are permitted (if consecutive), allowing the data-rows in long tables to be divided into different sections, each separately formatted as needed. |
| [`<td>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td "The Table cell HTML element (<td>) defines a cell of a table that contains data. It participates in the table model.") | The _Table cell_ [HTML](https://developer.mozilla.org/en-US/docs/Web/HTML) element (**`<td>`**) defines a cell of a table that contains data. It participates in the _table model_. |
| [`<tfoot>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table.") | The _HTML Table Foot Element_ (`<tfoot>`) defines a set of rows summarizing the columns of the table. |
| [`<th>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th "The HTML element table header cell <th> defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes.") | The HTML element _table header cell_ `<th>` defines a cell as header of a group of table cells. The exact nature of this group is defined by the `<a href="/en-US/docs/Web/HTML/Element/th#attr-scope">scope</a>` and `<a href="/en-US/docs/Web/HTML/Element/th#attr-headers">headers</a>` attributes. |
| [`<thead>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table.") | The _HTML Table Head Element_ (`<thead>`) defines a set of rows defining the head of the columns of the table. |
| [`<tr>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tr "The HTML element table row <tr> defines a row of cells in a table. Those can be a mix of <td> and <th> elements.") | The HTML element _table row_ `<tr>` defines a row of cells in a table. Those can be a mix of [`<td>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td "The Table cell HTML element (<td>) defines a cell of a table that contains data. It participates in the table model.") and [`<th>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th "The HTML element table header cell <th> defines a cell that is a header for a group of cells of a table. The group of cells that the header refers to is defined by the scope and headers attribute.") elements. |

## Forms

HTML provides a number of elements which can be used together to create forms which the user can fill out and submit to the Web site or application. There's a great deal of further information about this available in the [HTML forms guide](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Forms).

| Element | Description |
| --- | --- |
| [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> Element represents a clickable button.") | The **HTML _`<button>`_ Element** represents a clickable button. |
| [`<datalist>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/datalist "The HTML Datalist Element (<datalist>) contains a set of <option> elements that represent the values available for other controls.") | The _HTML Datalist Element_ (**<datalist>**) contains a set of [`<option>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/option "In a Web form, the HTML <option> element is used to create a control representing an item within a <select>, an <optgroup> or a <datalist> HTML5 element.") elements that represent the values available for other controls. |
| [`<fieldset>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/fieldset "The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form.") | The **HTML `<fieldset>` element** is used to group several controls as well as labels ([`<label>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label "The HTML Label Element (<label>) represents a caption for an item in a user interface. It can be associated with a control either by placing the control element inside the <label> element, or by using the for attribute. Such a control is called the labeled control of the label element. One input can be associated with multiple labels.")) within a web form. |
| [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls to submit information to a web server.") | The **HTML `<form>` element** represents a document section that contains interactive controls to submit information to a web server. |
| [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML element <input> is used to create interactive controls for web-based forms in order to accept data from the user. How an <input> works varies considerably depending on the value of its type attribute.") | The HTML element `<input>` is used to create interactive controls for web-based forms in order to accept data from the user. How an `<input>` works varies considerably depending on the value of its `type` attribute. |
| [`<label>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label "The HTML Label Element (<label>) represents a caption for an item in a user interface. It can be associated with a control either by placing the control element inside the <label> element, or by using the for attribute. Such a control is called the labeled control of the label element. One input can be associated with multiple labels.") | The _HTML Label Element_ (`<strong><label></strong>`) represents a caption for an item in a user interface. It can be associated with a control either by placing the control element inside the `<label>` element, or by using the `<a href="/en-US/docs/Web/HTML/Global_attributes#attr-for">for</a>` attribute. Such a control is called the _labeled control_ of the label element. One input can be associated with multiple labels. |
| [`<legend>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/legend "The HTML <legend> Element (or HTML Legend Field Element) represents a caption for the content of its parent <fieldset>.") | The **HTML `<legend>` Element** (or _HTML Legend Field Element_) represents a caption for the content of its parent [`<fieldset>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/fieldset "The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form."). |
| [`<meter>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meter "The HTML <meter> Element represents either a scalar value within a known range or a fractional value.") | The **HTML `<meter>` Element** represents either a scalar value within a known range or a fractional value. |
| [`<optgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/optgroup "In a Web form, the HTML <optgroup> element  creates a grouping of options within a <select> element.") | In a Web form, the **HTML `<optgroup>` element** creates a grouping of options within a [`<select>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select "The HTML select (<select>) element represents a control that presents a menu of options. The options within the menu are represented by <option> elements, which can be grouped by <optgroup> elements. Options can be pre-selected for the user.") element. |
| [`<option>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/option "In a Web form, the HTML <option> element is used to create a control representing an item within a <select>, an <optgroup> or a <datalist> HTML5 element.") | In a Web form, the **HTML `<option>` element** is used to create a control representing an item within a [`<select>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select "The HTML select (<select>) element represents a control that presents a menu of options. The options within the menu are represented by <option> elements, which can be grouped by <optgroup> elements. Options can be pre-selected for the user."), an [`<optgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/optgroup "In a Web form, the HTML <optgroup> element  creates a grouping of options within a <select> element.") or a [`<datalist>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/datalist "The HTML Datalist Element (<datalist>) contains a set of <option> elements that represent the values available for other controls.") HTML5 element. |
| [`<output>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/output "The HTML <output> element represents the result of a calculation or user action.") | The **HTML `<output>` element** represents the result of a calculation or user action. |
| [`<progress>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/progress "The HTML <progress> Element is used to view the completion progress of a task. While the specifics of how it's displayed is left up to the browser developer, it's typically displayed as a progress bar. Javascript can be used to manipulate the value of progress bar.") | The **HTML `<progress>` Element** is used to view the completion progress of a task. While the specifics of how it's displayed is left up to the browser developer, it's typically displayed as a progress bar. Javascript can be used to manipulate the value of progress bar. |
| [`<select>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select "The HTML select (<select>) element represents a control that presents a menu of options. The options within the menu are represented by <option> elements, which can be grouped by <optgroup> elements. Options can be pre-selected for the user.") | The HTML _select_ (`<select>`) element represents a control that presents a menu of options. The options within the menu are represented by `<a href="/en-US/docs/Web/HTML/Element/option" title="In a Web form, the HTML <option> element is used to create a control representing an item within a <select>, an <optgroup> or a <datalist> HTML5 element."><code><option></code></a>` elements, which can be grouped by `<a href="/en-US/docs/Web/HTML/Element/optgroup" title="In a Web form, the HTML <optgroup> element&#xA0; creates a grouping of options within a <select> element."><code><optgroup></code></a>` elements. Options can be pre-selected for the user. |
| [`<textarea>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/textarea "The HTML <textarea> element represents a multi-line plain-text editing control.") | The **HTML `<textarea> ` element** represents a multi-line plain-text editing control. |

## Interactive elements

HTML offers a selection of elements which help to create interactive user interface objects.

| Element | Description |
| --- | --- |
| [`<details>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/details "The HTML <details> element is used as a disclosure widget from which the user can retrieve additional information.") | The HTML `<strong><details></strong>` element is used as a disclosure widget from which the user can retrieve additional information. |
| [`<dialog>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dialog "The HTML <dialog> element represents a dialog box or other interactive component, such as an inspector or window. <form> elements can be integrated within a dialog by specifying them with the attribute method="dialog". When such a form is submitted, the dialog is closed with a returnValue attribute set to the value of the submit button used.") | The **HTML `<dialog>` element** represents a dialog box or other interactive component, such as an inspector or window. `<form>` elements can be integrated within a dialog by specifying them with the attribute `method="dialog"`. When such a form is submitted, the dialog is closed with a `returnValue` attribute set to the `value` of the submit button used. |
| [`<menu>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/menu "The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked.") | The **HTML `<menu>` element** represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked. |
| [`<menuitem>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/menuitem "The HTML <menuitem> element represents a command that a user is able to invoke through a popup menu. This includes context menus, as well as menus that might be attached to a menu button.") | The **HTML `<menuitem>` element** represents a command that a user is able to invoke through a popup menu. This includes context menus, as well as menus that might be attached to a menu button. |
| [`<summary>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/summary "The HTML <summary> element is used as a summary, caption, or legend for the content of a <details> element.") | The HTML `<strong><summary></strong>` element is used as a summary, caption, or legend for the content of a [`<details>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/details "The HTML Details Element (<details>) is used as a disclosure widget from which the user can retrieve additional information.") element. |

## Web Components

Web Components is an HTML-related technology which makes it possible to, essentially, create and use custom elements as if it were regular HTML. In addition, you can create custom versions of standard HTML elements.
**Note:** The elements for Web Components are defined in the [World Wide Web Consortium](https://developer.mozilla.org/en-US/docs/Glossary/W3C "World Wide Web Consortium: The World Wide Web Consortium (W3C) is an international body that maintains Web-related rules and frameworks.") (W3C) [Web Components collection of specifications](https://www.w3.org/TR/components-intro/) rather than the HTML specification. In addition, the Web Components specification has not been finalized and is subject to change.

| Element | Description |
| --- | --- |
| [`<content>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/content "The HTML <content> element is used inside of Shadow DOM as an insertion point. It is not intended to be used in ordinary HTML. It is used with Web Components. It has now been replaced by the <slot> element.") | The **[HTML](https://developer.mozilla.org/en-US/docs/Web/HTML) `<content>`** element is used inside of [Shadow DOM](https://developer.mozilla.org/en-US/docs/Web/Web_Components/Shadow_DOM) as an [insertion point](https://developer.mozilla.org/en-US/docs/Glossary/insertion_point "The definition of that term (insertion point) has not been written yet; please consider contributing it!"). It is not intended to be used in ordinary HTML. It is used with [Web Components](https://developer.mozilla.org/en-US/docs/Web/Web_Components). It has now been replaced by the **<slot>** element. |
| [`<element>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/element "The HTML <element> element is used to define new custom DOM elements.") | The **[HTML](https://developer.mozilla.org/en-US/docs/Web/HTML) `<element>` element** is used to define new custom DOM elements. |
| [`<shadow>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/shadow "The HTML <shadow> element is used as a shadow DOM insertion point. You might use it if you have created multiple shadow roots under a shadow host. It is not useful in ordinary HTML. It is used with Web Components.") | The **[HTML](https://developer.mozilla.org/en-US/docs/Web/HTML) `<shadow>`** element is used as a shadow DOM [insertion point](https://developer.mozilla.org/en-US/docs/Glossary/insertion_point "The definition of that term (insertion point) has not been written yet; please consider contributing it!"). You might use it if you have created multiple shadow roots under a shadow host. It is not useful in ordinary HTML. It is used with [Web Components](https://developer.mozilla.org/en-US/docs/Web/Web_Components). |
| [`<template>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/template "The HTML template element <template> is a mechanism for holding client-side content that is not to be rendered when a page is loaded but may subsequently be instantiated during runtime using JavaScript.") | The **[HTML](https://developer.mozilla.org/en-US/docs/Web/HTML) template element `<template>`** is a mechanism for holding client-side content that is not to be rendered when a page is loaded but may subsequently be instantiated during runtime using JavaScript. |

## Obsolete and deprecated elements

**Warning:** These are old HTML elements which are deprecated and should not be used. **You should never use them in new projects, and should replace them in old projects as soon as you can.** They are listed here for informational purposes only.

| Element | Description |
| --- | --- |
| [`<acronym>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/acronym "The HTML Acronym Element (<acronym>) allows authors to clearly indicate a sequence of characters that compose an acronym or abbreviation for a word. This element has been removed in HTML5. Use <abbr> element.") | The HTML Acronym Element (`<acronym>)` allows authors to clearly indicate a sequence of characters that compose an acronym or abbreviation for a word. This element has been removed in HTML5. Use [`<abbr>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/abbr "The HTML <abbr> element (or HTML Abbreviation Element) represents an abbreviation and optionally provides a full description for it. If present, the title attribute must contain this full description and nothing else.") element. |
| [`<applet>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/applet "The HTML Applet Element (<applet>) identifies the inclusion of a Java applet.") | The HTML Applet Element (`<applet>`) identifies the inclusion of a Java applet. |
| [`<basefont>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/basefont "The HTML basefont element (<basefont>) establishes a default font size for a document. Font size then can be varied relative to the base font size using the <font> element.") | The HTML basefont element (`<basefont>`) establishes a default font size for a document. Font size then can be varied relative to the base font size using the [`<font>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/font "The HTML Font Element (<font>) defines the font size, color and face for its content.") element. |
| [`<big>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/big "The HTML Big Element (<big>) makes the text font size one size bigger (for example, from small to medium, or from large to x-large) up to the browser's maximum font size.") | The HTML Big Element (`<big>`) makes the text _font size_ one size bigger (for example, from small to medium, or from large to x-large) up to the browser's maximum font size. |
| [`<blink>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/blink "The HTML Blink Element (<blink>) is a non-standard element causing the enclosed text to flash slowly.") | The HTML Blink Element (`<blink>`) is a non-standard element causing the enclosed text to flash slowly. |
| [`<center>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/center "The HTML Center Element (<center>) is a block-level element that can contain paragraphs and other block-level and inline elements. The entire content of this element is centered horizontally within its containing element (typically, the <body>).") | The HTML Center Element (`<center>`) is a [block-level element](https://developer.mozilla.org/en-US/docs/HTML/Block-level_elements "HTML/Block-level_elements") that can contain paragraphs and other block-level and inline elements. The entire content of this element is centered horizontally within its containing element (typically, the [`<body>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body "The HTML <body> Element represents the content of an HTML document. There can be only one <body> element in a document.")). |
| [`<command>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/command "The command element represents a command which the user can invoke.") | The `command` element represents a command which the user can invoke. |
| [`<content>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/content "The HTML <content> element is used inside of Shadow DOM as an insertion point. It is not intended to be used in ordinary HTML. It is used with Web Components. It has now been replaced by the <slot> element.") | The **[HTML](https://developer.mozilla.org/en-US/docs/Web/HTML) `<content>`** element is used inside of [Shadow DOM](https://developer.mozilla.org/en-US/docs/Web/Web_Components/Shadow_DOM) as an [insertion point](https://developer.mozilla.org/en-US/docs/Glossary/insertion_point "The definition of that term (insertion point) has not been written yet; please consider contributing it!"). It is not intended to be used in ordinary HTML. It is used with [Web Components](https://developer.mozilla.org/en-US/docs/Web/Web_Components). It has now been replaced by the **<slot>** element. |
| [`<dir>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dir "The HTML directory element (<dir>) represents a directory, namely a collection of filenames.") | The _HTML directory element_ (`<dir>`) represents a directory, namely a collection of filenames. |
| [`<font>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/font "The HTML Font Element (<font>) defines the font size, color and face for its content.") | The _HTML Font Element_ (<font>) defines the font size, color and face for its content. |
| [`<frame>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/frame "<frame> is an HTML element which defines a particular area in which another HTML document can be displayed. A frame should be used within a <frameset>.") | `<frame>` is an HTML element which defines a particular area in which another HTML document can be displayed. A frame should be used within a [`<frameset>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/frameset "<frameset> is an HTML element which is used to contain <frame> elements."). |
| [`<frameset>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/frameset "<frameset> is an HTML element which is used to contain <frame> elements.") | `<frameset>` is an HTML element which is used to contain [`<frame>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/frame "<frame> is an HTML element which defines a particular area in which another HTML document can be displayed. A frame should be used within a <frameset>.") elements. |
| [`<isindex>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/isindex "<isindex> is an obsolete HTML element that puts a text field in a page for querying the document.") | **`<isindex>`** is an obsolete HTML element that puts a text field in a page for querying the document. |
| [`<keygen>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/keygen "The HTML <keygen> element exists to facilitate generation of key material, and submission of the public key as part of an HTML form. This mechanism is designed for use with Web-based certificate management systems. It is expected that the <keygen> element will be used in an HTML form along with other information needed to construct a certificate request, and that the result of the process will be a signed certificate.") | The HTML `<keygen>` element exists to facilitate generation of key material, and submission of the public key as part of an [HTML form](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Forms). This mechanism is designed for use with Web-based certificate management systems. It is expected that the `<keygen>` element will be used in an HTML form along with other information needed to construct a certificate request, and that the result of the process will be a signed certificate. |
| [`<listing>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/listing "The HTML Listing Element (<listing>) renders text between the start and end tags without interpreting the HTML in between and using a monospaced font. The HTML 2 standard recommended that lines shouldn't be broken when not greater than 132 characters.") | The _HTML Listing Element_ (`<listing>`) renders text between the start and end tags without interpreting the HTML in between and using a monospaced font. The HTML 2 standard recommended that lines shouldn't be broken when not greater than 132 characters. |
| [`<marquee>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/marquee "The HTML <marquee> element is used to insert a scrolling area of text.") | The HTML `<marquee>` element is used to insert a scrolling area of text. |
| [`<multicol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/multicol "The HTML <multicol> element was an experimental element designed to allow multi-column layouts. It never got any significant traction and is not implemented in any major browsers.") | The HTML `<multicol>` element was an experimental element designed to allow multi-column layouts. It never got any significant traction and is not implemented in any major browsers. |
| [`<nextid>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nextid "Technical review completed.") | Technical review completed. |
| [`<noembed>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/noembed "The <noembed> element is a deprecated and non-standard way to provide alternative, or "fallback", content for browsers that do not support the <embed> element or do not support embedded content an author wishes to use.") | The `<strong><noembed></strong>` element is a deprecated and non-standard way to provide alternative, or "fallback", content for browsers that do not support the [`<embed>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/embed "The HTML <embed> Element represents an integration point for an external application or interactive content (in other words, a plug-in).") element or do not support [embedded content](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Content_categories#Embedded_content) an author wishes to use. |
| [`<plaintext>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/plaintext "The HTML Plaintext Element (<plaintext>) renders everything following the start tag as raw text, without interpreting any HTML. There is no closing tag, since everything after it is considered raw text.") | The _HTML Plaintext Element_ (`<plaintext>`) renders everything following the start tag as raw text, without interpreting any HTML. There is no closing tag, since everything after it is considered raw text. |
| [`<spacer>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/spacer "<spacer> is an HTML element which is used for inserting white spaces to web pages. It was created by NetScape for achieving same effect as a single-pixel layout GIF image, which was something web designers used to use to add white spaces to web pages, without actually using a GIF. However <spacer> is not supported by any major browser and same effects can be created with various CSS rules. In Mozilla applications, support for this element was removed in Gecko 2.0. Therefore usage of <spacer> is unnecessary.") | `<spacer>` is an HTML element which is used for inserting white spaces to web pages. It was created by NetScape for achieving same effect as a single-pixel layout GIF image, which was something web designers used to use to add white spaces to web pages, without actually using a GIF. However `<spacer> ` is not supported by any major browser and same effects can be created with various CSS rules. In Mozilla applications, support for this element was removed in Gecko 2.0. Therefore usage of `<spacer>` is unnecessary. |
| [`<strike>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/strike "The HTML <strike> element (or HTML Strikethrough Element) places a strikethrough (horizontal line) over text.") | The **HTML `<strike>` element** (or _HTML Strikethrough Element_) places a strikethrough (horizontal line) over text. |
| [`<tt>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tt "The HTML Teletype Text Element (<tt>) produces an inline element displayed in the browser's default monotype font. This element was intended to style text as it would display on a fixed width display, such as a teletype. It probably is more common to display fixed width type using the <code> element.") | The HTML Teletype Text Element (`<tt>`) produces an inline element displayed in the browser's default monotype font. This element was intended to style text as it would display on a fixed width display, such as a teletype. It probably is more common to display fixed width type using the [`<code>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/code "The HTML <code> Element represents a fragment of computer code. By default, it is displayed in the browser's default monospace font.") element. |
| [`<xmp>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/xmp "The HTML Example Element (<xmp>) renders text between the start and end tags without interpreting the HTML in between and using a monospaced font. The HTML2 specification recommended that it should be rendered wide enough to allow 80 characters per line.") | The _HTML Example Element_ (`<xmp>`) renders text between the start and end tags without interpreting the HTML in between and using a monospaced font. The HTML2 specification recommended that it should be rendered wide enough to allow 80 characters per line. |

## Document Tags and Contributors

**Tags:**

* [Basic](https://developer.mozilla.org/en-US/docs/tag/Basic)
* [Element](https://developer.mozilla.org/en-US/docs/tag/Element)
* [HTML](https://developer.mozilla.org/en-US/docs/tag/HTML)
* [l10n:priority](https://developer.mozilla.org/en-US/docs/tag/l10n:priority)
* [Reference](https://developer.mozilla.org/en-US/docs/tag/Reference)
* [Web](https://developer.mozilla.org/en-US/docs/tag/Web)

**Contributors to this page:** [Jeremie](https://developer.mozilla.org/en-US/profiles/Jeremie),
[Fizco](https://developer.mozilla.org/en-US/profiles/Fizco),
[pcat](https://developer.mozilla.org/en-US/profiles/pcat),
[chrisdavidmills](https://developer.mozilla.org/en-US/profiles/chrisdavidmills),
[kenobll](https://developer.mozilla.org/en-US/profiles/kenobll),
[fcard](https://developer.mozilla.org/en-US/profiles/fcard),
[slimsag](https://developer.mozilla.org/en-US/profiles/slimsag),
[arsmrn](https://developer.mozilla.org/en-US/profiles/arsmrn),
[Sebastianz](https://developer.mozilla.org/en-US/profiles/Sebastianz),
[cezaraugusto](https://developer.mozilla.org/en-US/profiles/cezaraugusto),
[Ende93](https://developer.mozilla.org/en-US/profiles/Ende93),
[kmcgillivray](https://developer.mozilla.org/en-US/profiles/kmcgillivray),
[jsx](https://developer.mozilla.org/en-US/profiles/jsx),
[tkkhhaarree](https://developer.mozilla.org/en-US/profiles/tkkhhaarree),
[jswisher](https://developer.mozilla.org/en-US/profiles/jswisher),
[vickylance](https://developer.mozilla.org/en-US/profiles/vickylance),
[MusikAnimal](https://developer.mozilla.org/en-US/profiles/MusikAnimal),
[rosytrevino4](https://developer.mozilla.org/en-US/profiles/rosytrevino4),
[MarkBeleski](https://developer.mozilla.org/en-US/profiles/MarkBeleski),
[Sheppy](https://developer.mozilla.org/en-US/profiles/Sheppy),
[ambischof](https://developer.mozilla.org/en-US/profiles/ambischof),
[Yuzmeister](https://developer.mozilla.org/en-US/profiles/Yuzmeister),
[SphinxKnight](https://developer.mozilla.org/en-US/profiles/SphinxKnight),
[whitman](https://developer.mozilla.org/en-US/profiles/whitman),
[teoli](https://developer.mozilla.org/en-US/profiles/teoli),
[Dexter_Deter](https://developer.mozilla.org/en-US/profiles/Dexter_Deter),
[neelance](https://developer.mozilla.org/en-US/profiles/neelance),
[xfq](https://developer.mozilla.org/en-US/profiles/xfq),
[Brettz9](https://developer.mozilla.org/en-US/profiles/Brettz9),
[FabioBohnenberger](https://developer.mozilla.org/en-US/profiles/FabioBohnenberger),
[kscarfone](https://developer.mozilla.org/en-US/profiles/kscarfone),
[dekajp](https://developer.mozilla.org/en-US/profiles/dekajp),
[kohei.yoshino](https://developer.mozilla.org/en-US/profiles/kohei.yoshino),
[Ruakh](https://developer.mozilla.org/en-US/profiles/Ruakh),
[slhuang](https://developer.mozilla.org/en-US/profiles/slhuang),
[Nickolay](https://developer.mozilla.org/en-US/profiles/Nickolay),
[SteveFaulkner](https://developer.mozilla.org/en-US/profiles/SteveFaulkner),
[claudepache](https://developer.mozilla.org/en-US/profiles/claudepache),
[haboqueferus](https://developer.mozilla.org/en-US/profiles/haboqueferus),
[allergic](https://developer.mozilla.org/en-US/profiles/allergic),
[simonsarris](https://developer.mozilla.org/en-US/profiles/simonsarris),
[BillyONeal](https://developer.mozilla.org/en-US/profiles/BillyONeal),
[zziccardi](https://developer.mozilla.org/en-US/profiles/zziccardi),
[betoscopio](https://developer.mozilla.org/en-US/profiles/betoscopio),
[ethertank](https://developer.mozilla.org/en-US/profiles/ethertank),
[BobChao](https://developer.mozilla.org/en-US/profiles/BobChao),
[tregagnon](https://developer.mozilla.org/en-US/profiles/tregagnon),
[Faldo](https://developer.mozilla.org/en-US/profiles/Faldo),
[syssgx](https://developer.mozilla.org/en-US/profiles/syssgx),
[trevorh](https://developer.mozilla.org/en-US/profiles/trevorh),
[timemachine3030](https://developer.mozilla.org/en-US/profiles/timemachine3030),
[fscholz](https://developer.mozilla.org/en-US/profiles/fscholz),
[cers](https://developer.mozilla.org/en-US/profiles/cers),
[hobophobe](https://developer.mozilla.org/en-US/profiles/hobophobe),
[Ms2ger](https://developer.mozilla.org/en-US/profiles/Ms2ger),
[Jürgen Jeka](https://developer.mozilla.org/en-US/profiles/J%C3%BCrgen%20Jeka),
[Gilchris](https://developer.mozilla.org/en-US/profiles/Gilchris),
[Mgjbot](https://developer.mozilla.org/en-US/profiles/Mgjbot),
[Jscher2000](https://developer.mozilla.org/en-US/profiles/Jscher2000),
[PablO](https://developer.mozilla.org/en-US/profiles/PablO),
[Rappo](https://developer.mozilla.org/en-US/profiles/Rappo),
[Ptak82](https://developer.mozilla.org/en-US/profiles/Ptak82),
[NickolayBot](https://developer.mozilla.org/en-US/profiles/NickolayBot),
[Dria](https://developer.mozilla.org/en-US/profiles/Dria),
[Charles](https://developer.mozilla.org/en-US/profiles/Charles) **Last updated by:** [Jeremie](https://developer.mozilla.org/en-US/profiles/Jeremie),
<time>Nov 21, 2016, 7:25:59 AM</time>

## Thanks! Please check your inbox to confirm your subscription.

If you haven't previously confirmed a subscription to a Mozilla-related newsletter you may have to do so. Please check your inbox or your spam filter for an email from us.
See also

1. [**_HTML_**](https://developer.mozilla.org/en-US/docs/Web/HTML)
2. **Tutorials:**
3. [Introductory](#)
  1. [HTML developer guide](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML)
4. [Intermediate](#)
  1. [Block-level elements](https://developer.mozilla.org/en-US/docs/Web/HTML/Block-level_elements)
5. [Advanced](#)
  1. [Optimizing your pages for speculative parsing](https://developer.mozilla.org/en-US/docs/Web/HTML/Optimizing_your_pages_for_speculative_parsing)
6. **[References:](https://developer.mozilla.org/en-US/docs/Web/HTML/Reference)**
7. [HTML elements](https://developer.mozilla.org/en-US/docs/Web/HTML/Element)
  1. [<a>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a "The HTML Anchor Element (<a>) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL.")
  2. [<abbr>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/abbr "The HTML <abbr> element (or HTML Abbreviation Element) represents an abbreviation and optionally provides a full description for it. If present, the title attribute must contain this full description and nothing else.")
  3. [<acronym>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/acronym "The HTML Acronym Element (<acronym>) allows authors to clearly indicate a sequence of characters that compose an acronym or abbreviation for a word. This element has been removed in HTML5. Use <abbr> element.")
  4. [<address>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/address "The HTML <address> element supplies contact information for its nearest <article> or <body> ancestor; in the latter case, it applies to the whole document.")
  5. [<applet>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/applet "The HTML Applet Element (<applet>) identifies the inclusion of a Java applet.")
  6. [<area>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/area "The HTML <area> element defines a hot-spot region on an image, and optionally associates it with a hypertext link. This element is used only within a <map> element.")
  7. [<article>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/article "The HTML <article> element represents a self-contained composition in a document, page, application, or site, which is intended to be independently distributable or reusable (e.g., in syndication). This could be a forum post, a magazine or newspaper article, a blog entry, an object, or any other independent item of content. Each <article> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <article> element.")
  8. [<aside>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/aside "The HTML <aside> element represents a section of the page with content connected tangentially to the rest, which could be considered separate from that content. These sections are often represented as sidebars or inserts. They often contain the definitions on the sidebars, such as definitions from the glossary; there may also be other types of information, such as related advertisements; the biography of the author; web applications; profile information or related links on the blog.")
  9. [<audio>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio "The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element; the browser will choose the most suitable one.")
  10. [<b>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/b "The HTML <b> Element represents a span of text stylistically different from normal text, without conveying any special importance or relevance. It is typically used for keywords in a summary, product names in a review, or other spans of text whose typical presentation would be boldfaced. Another example of its use is to mark the lead sentence of each paragraph of an article.")
  11. [<base>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/base "The HTML <base> element specifies the base URL to use for all relative URLs contained within a document. There can be only one <base> element in a document.")
  12. [<basefont>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/basefont "The HTML basefont element (<basefont>) establishes a default font size for a document. Font size then can be varied relative to the base font size using the <font> element.")
  13. [<bdi>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/bdi "The HTML <bdi> Element (or Bi-Directional Isolation Element) isolates a span of text that might be formatted in a different direction from other text outside it.")
  14. [<bdo>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/bdo "The HTML <bdo> Element (or HTML bidirectional override element) is used to override the current directionality of text. It causes the directionality of the characters to be ignored in favor of the specified directionality.")
  15. [<bgsound>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/bgsound "The HTML Background Sound Element () is an Internet Explorer element associating a background sound with a page.")
  16. [<big>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/big "The HTML Big Element (<big>) makes the text font size one size bigger (for example, from small to medium, or from large to x-large) up to the browser's maximum font size.")
  17. [<blink>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/blink "The HTML Blink Element (<blink>) is a non-standard element causing the enclosed text to flash slowly.")
  18. [<blockquote>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/blockquote "The HTML <blockquote> Element (or HTML Block Quotation Element) indicates that the enclosed text is an extended quotation. Usually, this is rendered visually by indentation (see Notes for how to change it). A URL for the source of the quotation may be given using the cite attribute, while a text representation of the source can be given using the <cite> element.")
  19. [<body>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/body "The HTML <body> Element represents the content of an HTML document. There can be only one <body> element in a document.")
  20. [<br>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/br "The HTML element line break <br> produces a line break in text (carriage-return). It is useful for writing a poem or an address, where the division of lines is significant.")
  21. [<button>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> Element represents a clickable button.")
  22. [<canvas>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "The HTML <canvas> Element can be used to draw graphics via scripting (usually JavaScript). For example, it can be used to draw graphs, make photo compositions or even perform animations. You may (and should) provide alternate content inside the <canvas> block. That content will be rendered both on older browsers that don't support canvas and in browsers with JavaScript disabled.")
  23. [<caption>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/caption "The HTML <caption> Element (or HTML Table Caption Element) represents the title of a table. Though it is always the first descendant of a <table>, its styling, using CSS, may place it elsewhere, relative to the table.")
  24. [<center>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/center "The HTML Center Element (<center>) is a block-level element that can contain paragraphs and other block-level and inline elements. The entire content of this element is centered horizontally within its containing element (typically, the <body>).")
  25. [<cite>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/cite "The HTML Citation Element (<cite>) represents a reference to a creative work. It must include the title of a work or a URL reference, which may be in an abbreviated form according to the conventions used for the addition of citation metadata.")
  26. [<code>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/code "The HTML Code Element (<code>) represents a fragment of computer code. By default, it is displayed in the browser's default monospace font.")
  27. [<col>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col "The HTML Table Column Element (<col>) defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a <colgroup> element.")
  28. [<colgroup>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup "The HTML Table Column Group Element (<colgroup>) defines a group of columns within a table.")
  29. [<command>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/command "The command element represents a command which the user can invoke.")
  30. [<content>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/content "The HTML <content> element is used inside of Shadow DOM as an insertion point. It is not intended to be used in ordinary HTML. It is used with Web Components. It has now been replaced by the <slot> element.")
  31. [<data>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/data "The HTML <data> Element links a given content with a machine-readable translation. If the content is time- or date-related, the <time> must be used.")
  32. [<datalist>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/datalist "The HTML Datalist Element (<datalist>) contains a set of <option> elements that represent the values available for other controls.")
  33. [<dd>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dd "The HTML <dd> element (or HTML Description Element) indicates the description of a term in a description list (<dl>).")
  34. [<del>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/del "The HTML Deleted Text Element (<del>) represents a range of text that has been deleted from a document. This element is often (but need not be) rendered with strike-through text.")
  35. [<details>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/details "The HTML <details> element is used as a disclosure widget from which the user can retrieve additional information.")
  36. [<dfn>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dfn "The HTML Definition Element (<dfn>) represents the defining instance of a term.")
  37. [<dialog>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dialog "The HTML <dialog> element represents a dialog box or other interactive component, such as an inspector or window. <form> elements can be integrated within a dialog by specifying them with the attribute method="dialog". When such a form is submitted, the dialog is closed with a returnValue attribute set to the value of the submit button used.")
  38. [<dir>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dir "The HTML directory element (<dir>) represents a directory, namely a collection of filenames.")
  39. [<div>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/div "The HTML <div> element (or HTML Document Division Element) is the generic container for flow content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the class or id attributes), or because they share attribute values, such as lang. It should be used only when no other semantic element (such as <article> or <nav>) is appropriate.")
  40. [<dl>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dl "The HTML <dl> element (or HTML Description List Element) encloses a list of groups of terms and descriptions. Common uses for this element are to implement a glossary or to display metadata (a list of key-value pairs).")
  41. [<dt>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dt "The HTML <dt> element (or HTML Description Term Element) identifies a term in a description list. This element can occur only as a child element of a <dl>. It is usually followed by a <dd> element; however, multiple <dt> elements in a row indicate several terms that are all defined by the immediate next <dd> element.")
  42. [<element>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/element "The HTML <element> element is used to define new custom DOM elements.")
  43. [<em>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/em "The HTML element emphasis  <em> marks text that has stress emphasis. The <em> element can be nested, with each level of nesting indicating a greater degree of emphasis.")
  44. [<embed>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/embed "The HTML <embed> Element represents an integration point for an external application or interactive content (in other words, a plug-in).")
  45. [<fieldset>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/fieldset "The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form.")
  46. [<figcaption>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figcaption "The HTML <figcaption> element represents a caption or a legend associated with a figure or an illustration described by the rest of the data of the <figure> element which is its immediate ancestor which means <figcaption> can be the first or last element inside a <figure> block. Also, the HTML Figcaption Element is optional; if not provided, then the parent figure element will have no caption.")
  47. [<figure>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/figure "The HTML <figure> element represents self-contained content, frequently with a caption (<figcaption>), and is typically referenced as a single unit. While it is related to the main flow, its position is independent of the main flow. Usually this is an image, an illustration, a diagram, a code snippet, or a schema that is referenced in the main text, but that can be moved to another page or to an appendix without affecting the main flow.")
  48. [<font>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/font "The HTML Font Element (<font>) defines the font size, color and face for its content.")
  49. [<footer>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/footer "The HTML <footer> element represents a footer for its nearest sectioning content or sectioning root element. A footer typically contains information about the author of the section, copyright data or links to related documents.")
  50. [<form>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls to submit information to a web server.")
  51. [<frame>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/frame "<frame> is an HTML element which defines a particular area in which another HTML document can be displayed. A frame should be used within a <frameset>.")
  52. [<frameset>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/frameset "<frameset> is an HTML element which is used to contain <frame> elements.")
  53. [<head>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/head "The HTML <head> element provides general information (metadata) about the document, including its title and links to its scripts and style sheets.")
  54. [<header>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/header "The HTML <header> element represents a group of introductory or navigational aids. It may contain some heading elements but also other elements like a logo, wrapped section's header, a search form, and so on.")
  55. [<hgroup>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/hgroup "The HTML <hgroup> Element (HTML Heading Group Element) represents the heading of a section. It defines a single title that participates in the outline of the document as the heading of the implicit or explicit section that it belongs to.")
  56. [<hr>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/hr "The HTML <hr> element represents a thematic break between paragraph-level elements (for example, a change of scene in a story, or a shift of topic with a section). In previous versions of HTML, it represented a horizontal rule. It may still be displayed as a horizontal rule in visual browsers, but is now defined in semantic terms, rather than presentational terms.")
  57. [<html>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html "The HTML <html> element (or HTML root element) represents the root of an HTML document. All other elements must be descendants of this element.")
  58. [<i>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/i "The HTML <i> Element represents a range of text that is set off from the normal text for some reason, for example, technical terms, foreign language phrases, or fictional character thoughts. It is typically displayed in italic type.")
  59. [<iframe>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe "The HTML Inline Frame Element (<iframe>) represents a nested browsing context, effectively embedding another HTML page into the current page. In HTML 4.01, a document may contain a head and a body or a head and a frameset, but not both a body and a frameset. However, an <iframe> can be used within a normal document body. Each browsing context has its own session history and active document. The browsing context that contains the embedded content is called the parent browsing context. The top-level browsing context (which has no parent) is typically the browser window.")
  60. [<image>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/image "The HTML <image> element was an experimental element designed to display pictures. It never was implemented and the standard <img> element must be used.")
  61. [<img>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/img "The HTML <img> element represents an image in the document.")
  62. [<input>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML element <input> is used to create interactive controls for web-based forms in order to accept data from the user. How an <input> works varies considerably depending on the value of its type attribute.")
  63. [<ins>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ins "The HTML <ins> Element (or HTML Inserted Text) HTML represents a range of text that has been added to a document.")
  64. [<isindex>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/isindex "<isindex> is an obsolete HTML element that puts a text field in a page for querying the document.")
  65. [<kbd>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/kbd "The HTML Keyboard Input Element (<kbd>) represents user input and produces an inline element displayed in the browser's default monospace font.")
  66. [<keygen>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/keygen "The HTML <keygen> element exists to facilitate generation of key material, and submission of the public key as part of an HTML form. This mechanism is designed for use with Web-based certificate management systems. It is expected that the <keygen> element will be used in an HTML form along with other information needed to construct a certificate request, and that the result of the process will be a signed certificate.")
  67. [<label>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label "The HTML Label Element (<label>) represents a caption for an item in a user interface. It can be associated with a control either by placing the control element inside the <label> element, or by using the for attribute. Such a control is called the labeled control of the label element. One input can be associated with multiple labels.")
  68. [<legend>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/legend "The HTML <legend> Element (or HTML Legend Field Element) represents a caption for the content of its parent <fieldset>.")
  69. [<li>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li "The HTML <li> element (or HTML List Item Element) is used to represent an item in a list. It must be contained in a parent element: an ordered list (<ol>), an unordered list (<ul>), or a menu (<menu>). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter.")
  70. [<link>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link "The HTML <link> element specifies relationships between the current document and an external resource. Possible uses for this element include defining a relational framework for navigation. This Element is most used to link to style sheets.")
  71. [<listing>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/listing "The HTML Listing Element (<listing>) renders text between the start and end tags without interpreting the HTML in between and using a monospaced font. The HTML 2 standard recommended that lines shouldn't be broken when not greater than 132 characters.")
  72. [<main>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/main "The HTML <main> element represents the main content of  the <body> of a document or application. The main content area consists of content that is directly related to, or expands upon the central topic of a document or the central functionality of an application. This content should be unique to the document, excluding any content that is repeated across a set of documents such as sidebars, navigation links, copyright information, site logos, and search forms (unless the document's main function is as a search form).")
  73. [<map>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/map "The HTML <map> element is used with <area> elements to define an image map (a clickable link area).")
  74. [<mark>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/mark "The HTML Mark Element (<mark>) represents highlighted text, i.e., a run of text marked for reference purpose, due to its relevance in a particular context. For example it can be used in a page showing search results to highlight every instance of the searched-for word.")
  75. [<marquee>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/marquee "The HTML <marquee> element is used to insert a scrolling area of text.")
  76. [<menu>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/menu "The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked.")
  77. [<menuitem>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/menuitem "The HTML <menuitem> element represents a command that a user is able to invoke through a popup menu. This includes context menus, as well as menus that might be attached to a menu button.")
  78. [<meta>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents any metadata information that cannot be represented by one of the other HTML meta-related elements (<base>, <link>, <script>, <style> or <title>).")
  79. [<meter>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meter "The HTML <meter> Element represents either a scalar value within a known range or a fractional value.")
  80. [<multicol>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/multicol "The HTML <multicol> element was an experimental element designed to allow multi-column layouts. It never got any significant traction and is not implemented in any major browsers.")
  81. [<nav>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nav "The HTML <nav> element (HTML Navigation Element) represents a section of a page that links to other pages or to parts within the page: a section with navigation links.")
  82. [<nobr>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nobr "The HTML <nobr> element prevents a text from breaking into a new line automatically, so it is displayed on one long line and scrolling might be necessary. This tag is not standard HTML and should not be used.")
  83. [<noembed>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/noembed "The <noembed> element is a deprecated and non-standard way to provide alternative, or "fallback", content for browsers that do not support the <embed> element or do not support embedded content an author wishes to use.")
  84. [<noframes>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/noframes "<noframes> is an HTML element which is used to supporting browsers which are not able to support <frame> elements or configured to do so.")
  85. [<noscript>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/noscript "The HTML <noscript> Element defines a section of html to be inserted if a script type on the page is unsupported or if scripting is currently turned off in the browser.")
  86. [<object>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/object "The HTML Embedded Object Element (<object>) represents an external resource, which can be treated as an image, a nested browsing context, or a resource to be handled by a plugin.")
  87. [<ol>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> Element (or HTML Ordered List Element) represents an ordered list of items. Typically, ordered-list items are displayed with a preceding numbering, which can be of any form, like numerals, letters or Romans numerals or even simple bullets. This numbered style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.")
  88. [<optgroup>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/optgroup "In a Web form, the HTML <optgroup> element  creates a grouping of options within a <select> element.")
  89. [<option>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/option "In a Web form, the HTML <option> element is used to create a control representing an item within a <select>, an <optgroup> or a <datalist> HTML5 element.")
  90. [<output>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/output "The HTML <output> element represents the result of a calculation or user action.")
  91. [<p>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/p "The HTML <p> element (or HTML Paragraph Element) represents a paragraph of text.")
  92. [<param>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/param "The HTML <param> Element (or HTML Parameter Element) defines parameters for <object>.")
  93. [<picture>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/picture "The HTML <picture> element is a container used to specify multiple <source> elements for a specific <img> contained in it. The browser will choose the most suitable source according to the current layout of the page (the constraints of the box the image will appear in) and the device it will be displayed on (e.g. a normal or hiDPI device.)")
  94. [<plaintext>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/plaintext "The HTML Plaintext Element (<plaintext>) renders everything following the start tag as raw text, without interpreting any HTML. There is no closing tag, since everything after it is considered raw text.")
  95. [<pre>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/pre "The HTML <pre> element (or HTML Preformatted Text) represents preformatted text. Text within this element is typically displayed in a non-proportional ("monospace") font exactly as it is laid out in the file. Whitespace inside this element is displayed as typed.")
  96. [<progress>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/progress "The HTML <progress> Element is used to view the completion progress of a task. While the specifics of how it's displayed is left up to the browser developer, it's typically displayed as a progress bar. Javascript can be used to manipulate the value of progress bar.")
  97. [<q>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/q "The HTML Quote Element (<q>) indicates that the enclosed text is a short inline quotation. This element is intended for short quotations that don't require paragraph breaks; for long quotations use the <blockquote> element.")
  98. [<rp>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rp "The HTML <rp> element is used to provide fall-back parenthesis for browsers non-supporting ruby annotations. Ruby annotations are for showing pronunciation of East Asian characters, like using Japanese furigana or Taiwainese bopomofo characters. The <rp> element is used in the case of lack of <ruby> element support its content has what should be displayed in order to indicate the presence of a ruby annotation, usually parentheses.")
  99. [<rt>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rt "The HTML <rt> Element embraces pronunciation of characters presented in a ruby annotations, which are used to describe the pronunciation of East Asian characters. This element is always used inside a <ruby> element.")
  100. [<rtc>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/rtc "The HTML <rtc> Element embraces semantic annotations of characters presented in a ruby of <rb> elements used inside of <ruby> element. <rb> elements can have both pronunciation (<rt>) and semantic (<rtc>) annotations.")
  101. [<ruby>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ruby "The HTML <ruby> Element represents a ruby annotation. Ruby annotations are for showing pronunciation of East Asian characters.")
  102. [<s>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/s "The HTML Strikethrough Element (<s>) renders text with a strikethrough, or a line through it. Use the <s> element to represent things that are no longer relevant or no longer accurate. However, <s> is not appropriate when indicating document edits; for that, use the <del> and <ins> elements, as appropriate.")
  103. [<samp>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/samp "The HTML <samp> element is an element intended to identify sample output from a computer program. It is usually displayed in the browser's default monotype font (such as Lucida Console).")
  104. [<script>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/script "The <script> element (or HTML Script Element ) is used to embed or reference an executable script within an HTML or XHTML document.")
  105. [<section>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/section "The HTML <section> element represents a generic section of a document, i.e., a thematic grouping of content, typically with a heading. Each <section> should be identified, typically by including a heading (<h1>-<h6> element) as a child of the <section> element.")
  106. [<select>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select "The HTML select (<select>) element represents a control that presents a menu of options. The options within the menu are represented by <option> elements, which can be grouped by <optgroup> elements. Options can be pre-selected for the user.")
  107. [<shadow>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/Shadow "The HTML <shadow> element is used as a shadow DOM insertion point. You might use it if you have created multiple shadow roots under a shadow host. It is not useful in ordinary HTML. It is used with Web Components.")
  108. [<small>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/small "The HTML Small Element (<small>) makes the text font size one size smaller (for example, from large to medium, or from small to x-small) down to the browser's minimum font size.  In HTML5, this element is repurposed to represent side-comments and small print, including copyright and legal text, independent of its styled presentation.")
  109. [<source>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source "The HTML <source> element specifies multiple media resources for either the <picture>, the <audio> or the <video> element. It is an empty element. It is commonly used to serve the same media content in multiple formats supported by different browsers.")
  110. [<spacer>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/spacer "<spacer> is an HTML element which is used for inserting white spaces to web pages. It was created by NetScape for achieving same effect as a single-pixel layout GIF image, which was something web designers used to use to add white spaces to web pages, without actually using a GIF. However <spacer> is not supported by any major browser and same effects can be created with various CSS rules. In Mozilla applications, support for this element was removed in Gecko 2.0. Therefore usage of <spacer> is unnecessary.")
  111. [<span>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/span "The HTML <span> element is a generic inline container for phrasing content, which does not inherently represent anything. It can be used to group elements for styling purposes (using the class or id attributes), or because they share attribute values, such as lang.")
  112. [<strike>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/strike "The HTML <strike> element (or HTML Strikethrough Element) places a strikethrough (horizontal line) over text.")
  113. [<strong>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/strong "The HTML <strong> element (or HTML Strong Element) gives text strong importance, and is typically displayed in bold.")
  114. [<style>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/style "The HTML <style> element contains style information for a document, or part of a document. By default, the style instructions written inside that element are expected to be CSS.")
  115. [<sub>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/sub "The HTML Subscript Element (<sub>) defines a span of text that should be displayed, for typographic reasons, lower, and often smaller, than the main span of text.")
  116. [<summary>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/summary "The HTML <summary> element is used as a summary, caption, or legend for the content of a <details> element.")
  117. [<sup>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/sup "The HTML Superscript Element (<sup>) defines a span of text that should be displayed, for typographic reasons, higher, and often smaller, than the main span of text.")
  118. [<table>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/table "The HTML Table Element (<table>) represents tabular data - i.e., information expressed via a two dimensional data table.")
  119. [<tbody>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody "The HTML Table Body Element (<tbody>) defines one or more <tr> element data-rows to be the body of its parent <table> element (as long as no <tr> elements are immediate children of that table element.)  In conjunction with a preceding <thead> and/or <tfoot> element, <tbody> provides additional semantic information for devices such as printers and displays. Of the parent table's child elements, <tbody> represents the content which, when longer than a page, will most likely differ for each page printed; while the content of <thead> and <tfoot> will be the same or similar for each page printed. For displays, <tbody> will enable separate scrolling of the <thead>, <tfoot>, and <caption> elements of the same parent <table> element.  Note that unlike the <thead>, <tfoot>, and <caption> elements however, multiple <tbody> elements are permitted (if consecutive), allowing the data-rows in long tables to be divided into different sections, each separately formatted as needed.")
  120. [<td>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td "The Table cell HTML element (<td>) defines a cell of a table that contains data. It participates in the table model.")
  121. [<template>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/template "The HTML template element <template> is a mechanism for holding client-side content that is not to be rendered when a page is loaded but may subsequently be instantiated during runtime using JavaScript.")
  122. [<textarea>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/textarea "The HTML <textarea> element represents a multi-line plain-text editing control.")
  123. [<tfoot>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tfoot "The HTML Table Foot Element (<tfoot>) defines a set of rows summarizing the columns of the table.")
  124. [<th>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th "The HTML element table header cell <th> defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes.")
  125. [<thead>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead "The HTML Table Head Element (<thead>) defines a set of rows defining the head of the columns of the table.")
  126. [<time>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/time "The HTML <time> element represents either a time on a 24-hour clock or a precise date in the Gregorian calendar (with optional time and timezone information).")
  127. [<title>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title "The HTML <title> element defines the title of the document, shown in a browser's title bar or on the page's tab. It can only contain text, and any contained tags are ignored.")
  128. [<tr>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tr "The HTML element table row <tr> defines a row of cells in a table. Those can be a mix of <td> and <th> elements.")
  129. [<track>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/track "The HTML <track> element is used as a child of the media elements—<audio> and <video>. It lets you specify timed text tracks (or time-based data), for example to automatically handle subtitles. The tracks are formatted in WebVTT format (.vtt files) — Web Video Text Tracks.")
  130. [<tt>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tt "The HTML Teletype Text Element (<tt>) produces an inline element displayed in the browser's default monotype font. This element was intended to style text as it would display on a fixed width display, such as a teletype. It probably is more common to display fixed width type using the <code> element.")
  131. [<u>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/u "The HTML Underline Element (<u>) renders text with an underline, a line under the baseline of its content.")
  132. [<ul>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element (or HTML Unordered List Element) represents an unordered list of items, namely a collection of items that do not have a numerical ordering, and their order in the list is meaningless. Typically, unordered-list items are displayed with a bullet, which can be of several forms, like a dot, a circle or a squared. The bullet style is not defined in the HTML description of the page, but in its associated CSS, using the list-style-type property.")
  133. [<var>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/var "The HTML Variable Element (<var>) represents a variable in a mathematical expression or a programming context.")
  134. [<video>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video "Use the  HTML <video> element to embed video content in a document. The video element contains one or more video sources. To specify a video source, use either the src attribute or the <source> element; the browser will choose the most suitable one.")
  135. [<wbr>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/wbr "The HTML element word break opportunity <wbr> represents a position within text where the browser may optionally break a line, though its line-breaking rules would not otherwise create a break at that location.")
  136. [<xmp>](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/xmp "The HTML Example Element (<xmp>) renders text between the start and end tags without interpreting the HTML in between and using a monospaced font. The HTML2 specification recommended that it should be rendered wide enough to allow 80 characters per line.")
  137. [Heading elements](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/Heading_Elements "Heading elements implement six levels of document headings, <h1> is the most important and <h6> is the least. A heading element briefly describes the topic of the section it introduces. Heading information may be used by user agents, for example, to construct a table of contents for a document automatically.")
  138. [nextid](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/nextid "Technical review completed.")
8. [Global attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes)
  1. [`accesskey`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/accesskey "The accesskey global attribute provides a hint for generating a keyboard shortcut for the current element. This attribute consists of a space-separated list of characters (one single Unicode code point). The browser uses the first one that exists on the computer keyboard layout.")
  2. [`class`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/class "The class global attribute is a space-separated list of the classes of the element. Classes allows CSS and Javascript to select and access specific elements via the class selectors or functions like the DOM method document.getElementsByClassName.")
  3. [`contenteditable`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/contenteditable "The contenteditable global attribute is an enumerated attribute indicating if the element should be editable by the user. If so, the browser modifies its widget to allow editing. The attribute must take one of the following values:")
  4. [`contextmenu`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/contextmenu "The contextmenu global attribute is the id of a <menu> to use as the contextual menu for this element.")
  5. [`data-*`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/data-* "The data-* global attributes form a class of attributes called custom data attributes, that allow proprietary information to be exchanged between the HTML and its DOM representation by scripts. All such custom data are available via the HTMLElement interface of the element the attribute is set on. The HTMLElement.dataset property gives access to them.
 The * may be replaced by any name following the production rule of xml names with the following restrictions:")
  6. [`dir`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/dir "The dir global attribute is an enumerated attribute indicates the directionality of the element's text. It can have the following values:")
  7. [`draggable`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/draggable "The draggable global attribute is an enumerated attribute that indicates whether the element can be dragged, using the HTML Drag and Drop API. It can have the following values:")
  8. [`dropzone`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/dropzone "The dropzone global attribute is an enumerated attribute indicating what types of content can be dropped on an element, using the Drag and Drop API. It can have the following values:")
  9. [`hidden`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/hidden "The hidden global attribute is a Boolean attribute indicating that the element is not yet, or is no longer, relevant. For example, it can be used to hide elements of the page that can't be used until the login process has been completed.")
  10. [`id`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/id "The id global attribute defines a unique identifier (ID) which must be unique in the whole document. Its purpose is to identify the element when linking (using a fragment identifier), scripting, or styling (with CSS).")
  11. [`itemid`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/itemid "The itemid global attribute is the unique, global identifier of an item. itemid attributes can only be specified on elements that have both itemscope and itemtype attributes. Also, the itemid can only be specified on elements with an itemscope attribute whose corresponding itemtype refers to or defines a vocabulary that supports global identifiers.")
  12. [`itemprop`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/itemprop "The itemprop global attribute is used to add properties to an item. Every HTML element can have an itemprop attribute specified, and an itemprop consists of a name-value pair. Each name-value pair is called a property, and a group of one or more properties forms an item. Property values are either a string or a URL and can be associated with a very wide range of elements including <audio>, <embed>, <iframe>, <img>, <link>, <object>, <source> , <track>, and <video>.")
  13. [`itemref`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/itemref "The global attribute itemref Properties that are not descendants of an element with the itemscope attribute can be associated with the item using an itemref. itemref provides a list of element id's (not itemids) with additional properties elsewhere in the document.")
  14. [`itemscope`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/itemscope "The global attribute itemscope (usually) works along with itemtype to specify that the HTML contained in a block is about a particular item. itemscope creates the Item and defines the scope of the itemtype associated with it. itemtype is a valid URL of a vocabulary (such as schema.org) that describes the item and its properties context. In the examples below the vocabulary used is from schema.org. Every HTML element may have an itemscope attribute specified. An itemscope element that doesn't have an associated itemtype has an itemref.")
  15. [`itemtype`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/itemtype "The global attribute itemtype specifies the URL of the vocabulary that will be used to define itemprop's (item properties) in the data structure. itemscope is used to set the scope of  where in the data structure the vocabulary set by itemtype will be active.")
  16. [`lang`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/lang "The lang global attribute participates in defining the language of the element, the language that is non-editable elements are written in or the language that the editable elements should be written in. The tag contains one single entry value in the format defined in the Tags for Identifying Languages (BCP47) IETF document. If the tag content is the empty string the language is set to unknown; if the tag content is not valid, regarding BCP47, it is set to invalid.")
  17. [`spellcheck`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/spellcheck "The spellcheck global attribute is an enumerated attribute defines whether the element may be checked for spelling errors. It may have the following values:")
  18. [`style`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/style "The style global attribute contains CSS styling declarations to be applied to the element. Note that it is recommended for styles to be defined in a separate file or files. This attribute and the <style> element have mainly the purpose of allowing for quick styling, for example for testing purposes.")
  19. [`tabindex`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/tabindex "The maximum value for tabIndex should not exceed 32767 per W3C section 17.11.1
 If not specified default value is -1")
  20. [`title`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/title "The title global attribute contains a text representing advisory information related to the element it belongs to. Such information can typically, but not necessarily, be presented to the user as a tooltip. Here are some typical uses of this attribute:")
  21. [`translate`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/translate "The translate global attribute is an enumerated attribute that is used to specify whether an element's attribute values and the values of its Text node children are to be translated when the page is localized, or whether to leave them unchanged. It can have the following values:")
9. **[Documentation:](https://developer.mozilla.org/en-US/docs/MDN)**
10. [Useful lists](#)
  1. [All pages index](https://developer.mozilla.org/en-US/docs/Web/HTML/Index)
  2. [Pages tagged "HTML"](https://developer.mozilla.org/en-US/docs/tag/HTML)
11. [Contribute](#)
  1. [HTML doc status](https://developer.mozilla.org/en-US/docs/MDN/Doc_status/HTML)
  2. [The MDN project](https://developer.mozilla.org/en-US/docs/MDN)

© 2005-2016 Mozilla Developer Network and individual contributors.

Content is available under [these licenses](https://developer.mozilla.org/en-US/docs/MDN/About#Copyrights_and_licenses).

* [About MDN](https://developer.mozilla.org/docs/MDN/About)
* [Terms](//www.mozilla.org/about/legal/terms/mozilla)
* [Privacy](//www.mozilla.org/privacy/websites/)
* [Cookies](//www.mozilla.org/privacy/websites/#cookies)
* [Contribute to the code](//github.com/mozilla/kuma)
