# Can I use... Support tables for HTML5, CSS3, etc

* [Home](#home)
* [News](#info-news)

[October 23, 2016 - New visualization: Date relative mode](/feed/157)

* [Compare browsers](#comparison)
* [Import stats](#stats-import)
* [Index](#index)
* [About](#info-about)

[Can I use](#tables)?

### Index

### [CSS](/#cats=CSS)

1. [::first-letter CSS pseudo-element selector](css-first-letter)
2. [::placeholder CSS pseudo-element](css-placeholder)
3. [::selection CSS pseudo-element](css-selection)
4. [:dir() CSS pseudo-class](css-dir-pseudo)
5. [:in-range and :out-of-range CSS pseudo-classes](css-in-out-of-range)
6. [:matches() CSS pseudo-class](css-matches-pseudo)
7. [:placeholder-shown CSS pseudo-class](css-placeholder-shown)
8. [@font-face Web fonts](fontface)
9. [Blending of HTML/SVG elements](css-mixblendmode)
10. [calc() as CSS unit value](calc)
11. [ch (character) unit](ch-unit)
12. [2.1 selectors](css-sel2)
13. [all property](css-all)
14. [Animation](css-animation)
15. [Appearance](css-appearance)
16. [background-attachment](background-attachment)
17. [background-blend-mode](css-backgroundblendmode)
18. [background-position edge offsets](css-background-offsets)
19. [box-decoration-break](css-boxdecorationbreak)
20. [clip-path property](css-clip-path)
21. [Counter Styles](css-at-counter-style)
22. [Counters](css-counters)
23. [currentColor value](currentcolor)
24. [Device Adaptation](css-deviceadaptation)
25. [element() function](css-element-function)
26. [Exclusions Level 1](css-exclusions)
27. [Feature Queries](css-featurequeries)
28. [Filter Effects](css-filters)
29. [filter() function](css-filter-function)
30. [first-line pseudo-element](css-first-line)
31. [font-feature-settings](font-feature)
32. [font-size-adjust](font-size-adjust)
33. [font-stretch](css-font-stretch)
34. [font-variant-alternates](font-variant-alternates)
35. [Generated content for pseudo-elements](css-gencontent)
36. [Gradients](css-gradients)
37. [Grid Layout](css-grid)
38. [Hyphenation](css-hyphens)
39. [initial value](css-initial-value)
40. [inline-block](inline-block)
41. [Masks](css-masks)
42. [min/max-width/height](minmaxwh)
43. [outline](outline)
44. [page-break properties](css-page-break)
45. [position:fixed](css-fixed)
46. [Regions](css-regions)
47. [Repeating Gradients](css-repeating-gradients)
48. [resize property](css-resize)
49. [revert value](css-revert-value)
50. [Scroll snap points](css-snappoints)
51. [Shapes Level 1](css-shapes)
52. [Table display](css-table)
53. [text-justify](css-text-justify)
54. [touch-action property](css-touch-action)
55. [unset value](css-unset-value)
56. [user-select: none](user-select-none)
57. [Variables (Custom Properties)](css-variables)
58. [widows & orphans](css-widows-orphans)
59. [will-change property](will-change)
60. [writing-mode property](css-writing-mode)
61. [2D Transforms](transforms2d)
62. [3D Transforms](transforms3d)
63. [attr() function](css3-attr)
64. [Background-image options](background-img-opts)
65. [Border images](border-image)
66. [Border-radius (rounded corners)](border-radius)
67. [Box-shadow](css-boxshadow)
68. [Box-sizing](css3-boxsizing)
69. [Colors](css3-colors)
70. [Cursors (original values)](css3-cursors)
71. [Cursors: zoom-in & zoom-out](css3-cursors-newer)
72. [font-kerning](font-kerning)
73. [image-orientation](css-image-orientation)
74. [Media Queries](css-mediaqueries)
75. [Multiple backgrounds](multibackgrounds)
76. [Multiple column layout](multicolumn)
77. [object-fit/object-position](object-fit)
78. [Opacity](css-opacity)
79. [Overflow-wrap](wordwrap)
80. [selectors](css-sel3)
81. [tab-size](css3-tabsize)
82. [text-align-last](css-text-align-last)
83. [Text-overflow](text-overflow)
84. [Text-shadow](css-textshadow)
85. [Transitions](css-transitions)
86. [word-break](word-break)
87. [OM Scroll-behavior](css-scroll-behavior)
88. [Flexible Box Layout Module](flexbox)
89. [Font unicode-range subsetting](font-unicode-range)
90. [Intrinsic & Extrinsic Sizing](intrinsic-width)
91. [letter-spacing CSS property](css-letter-spacing)
92. [Media Queries: interaction media features](css-media-interaction)
93. [Media Queries: resolution feature](css-media-resolution)
94. [rem (root em) units](rem)
95. [selector list argument of :not()](css-not-sel-list)
96. [text-decoration styling](text-decoration)
97. [text-emphasis styling](text-emphasis)
98. [TTF/OTF - TrueType and OpenType font support](ttf)
99. [Viewport units: vw, vh, vmin, vmax](viewport-units)
100. [:default CSS pseudo-class](css-default-pseudo)
101. [:focus-within CSS pseudo-class](css-focus-within)
102. [:has() CSS relational pseudo-class](css-has)
103. [:indeterminate CSS pseudo-class](css-indeterminate-pseudo)
104. [:optional CSS pseudo-class](css-optional-pseudo)
105. [background-position-x & background-position-y](background-position-x-y)
106. [Case-insensitive CSS attribute selectors](css-case-insensitive)
107. [Crisp edges/pixelated images](css-crisp-edges)
108. [Backdrop Filter](css-backdrop-filter)
109. [Canvas Drawings](css-canvas)
110. [Containment](css-containment)
111. [Cross-Fade Function](css-cross-fade)
112. [font-rendering controls](css-font-rendering-controls)
113. [font-smooth](font-smooth)
114. [image-set](css-image-set)
115. [line-clamp](css-line-clamp)
116. [Logical Properties](css-logical-props)
117. [Motion Path](css-motion-paths)
118. [pointer-events (for HTML)](pointer-events)
119. [position:sticky](css-sticky)
120. [Reflections](css-reflections)
121. [scrollbar styling](css-scrollbar)
122. [text-size-adjust](text-size-adjust)
123. [text-stroke and text-fill](text-stroke)
124. [zoom](css-zoom)
125. [Explicit descendant combinator >>](css-descendant-gtgt)
126. [Improved kerning pairs & ligatures](kerning-pairs-ligatures)
127. [selector list argument of :nth-child and :nth-last-child CSS pseudo-classes](css-nth-child-of)
128. [All CSS features](/#cats=CSS)

### [HTML5](/#cats=HTML5)

1. [accept attribute for file input](input-file-accept)
2. [Audio element](audio)
3. [Audio Tracks](audiotracks)
4. [Autofocus attribute](autofocus)
5. [Canvas (basic support)](canvas)
6. [Canvas blend modes](canvas-blending)
7. [classList (DOMTokenList)](classlist)
8. [Color input type](input-color)
9. [contenteditable attribute (basic support)](contenteditable)
10. [Custom Elements v0](custom-elements)
11. [Custom Elements v1](custom-elementsv1)
12. [Custom protocol handling](registerprotocolhandler)
13. [Datalist element](datalist)
14. [dataset & data-* attributes](dataset)
15. [Date and time input types](input-datetime)
16. [Details & Summary elements](details)
17. [Dialog element](dialog)
18. [disabled attribute of the fieldset element](fieldset-disabled)
19. [Download attribute](download)
20. [Drag and Drop](dragndrop)
21. [Email, telephone & URL input types](input-email-tel-url)
22. [Form attribute](form-attribute)
23. [Form validation](form-validation)
24. [getElementsByClassName](getelementsbyclassname)
25. [hidden attribute](hidden)
26. [HTML Imports](imports)
27. [HTML templates](template)
28. [HTML5 form features](forms)
29. [indeterminate checkbox](indeterminate-checkbox)
30. [input event](input-event)
31. [input placeholder attribute](input-placeholder)
32. [meter element](meter)
33. [Minimum length attribute for input fields](input-minlength)
34. [Multiple file selection](input-file-multiple)
35. [naturalWidth & naturalHeight image properties](img-naturalwidth-naturalheight)
36. [New semantic elements](html5semantic)
37. [Number input type](input-number)
38. [Pattern attribute for input fields](input-pattern)
39. [Picture element](picture)
40. [PNG favicons](link-icon-png)
41. [progress element](progress)
42. [Range input type](input-range)
43. [readonly attribute of input and textarea elements](readonly-attr)
44. [rel=noopener](rel-noopener)
45. [relList (DOMTokenList)](rellist)
46. [Reversed attribute of ordered lists](ol-reversed)
47. [Ruby annotation](ruby)
48. [sandbox attribute for iframes](iframe-sandbox)
49. [Search input type](input-search)
50. [Session history management](history)
51. [Spellcheck attribute](spellcheck-attribute)
52. [srcdoc attribute for iframes](iframe-srcdoc)
53. [Srcset attribute](srcset)
54. [Subresource Integrity](subresource-integrity)
55. [tabindex global attribute](tabindex-attr)
56. [Text API for Canvas](canvas-text)
57. [Toolbar/context menu](menu)
58. [Video element](video)
59. [Video Tracks](videotracks)
60. [wbr (word break opportunity) element](wbr-element)
61. [Web App Manifest](web-app-manifest)
62. [WebGL - 3D Canvas graphics](webgl)
63. [WebGL 2.0](webgl2)
64. [Offline web applications](offline-apps)
65. [Scoped CSS](style-scoped)
66. [seamless attribute for iframes](iframe-seamless)
67. [All HTML5 features](/#cats=HTML5)

### [Other](/#cats=Other)

1. ["once" event listener option](once-event-listener)
2. ['SameSite' cookie attribute](same-site-cookie-attribute)
3. [AAC audio file format](aac)
4. [asm.js](asmjs)
5. [async attribute for external scripts](script-async)
6. [autocomplete attribute: on & off values](input-autocomplete-onoff)
7. [Brotli Accept-Encoding/Content-Encoding](brotli)
8. [ChaCha20-Poly1305 cipher suites for TLS](chacha20-poly1305)
9. [ChildNode.remove()](childnode-remove)
10. [Client Hints: DPR, Width, Viewport-Width](client-hints-dpr-width-viewport)
11. [Content Security Policy 1.0](contentsecuritypolicy)
12. [Content Security Policy Level 2](contentsecuritypolicy2)
13. [CSS Paged Media (@page)](css-paged-media)
14. [Data URIs](datauri)
15. [defer attribute for external scripts](script-defer)
16. [document.elementFromPoint()](element-from-point)
17. [document.head](documenthead)
18. [DOM manipulation convenience methods](dom-manip-convenience)
19. [DOMContentLoaded](domcontentloaded)
20. [ECMAScript 5 Strict Mode](use-strict)
21. [Element.closest()](element-closest)
22. [Element.insertAdjacentElement() & Element.insertAdjacentText()](insert-adjacent)
23. [EventTarget.addEventListener()](addeventlistener)
24. [EventTarget.dispatchEvent](dispatchevent)
25. [focusin & focusout events](focusin-focusout-events)
26. [getComputedStyle](getcomputedstyle)
27. [HTTP/2 protocol](http2)
28. [inputmode attribute](input-inputmode)
29. [JPEG 2000 image format](jpeg2000)
30. [JPEG XR image format](jpegxr)
31. [KeyboardEvent.code](keyboardevent-code)
32. [KeyboardEvent.getModifierState()](keyboardevent-getmodifierstate)
33. [KeyboardEvent.key](keyboardevent-key)
34. [KeyboardEvent.location](keyboardevent-location)
35. [MathML](mathml)
36. [MP3 audio format](mp3)
37. [MPEG-4/H.264 video format](mpeg4)
38. [Mutation events](mutation-events)
39. [Node.compareDocumentPosition()](comparedocumentposition)
40. [Node.innerText](innertext)
41. [Node.textContent](textcontent)
42. [Ogg Vorbis audio format](ogg-vorbis)
43. [Ogg/Theora video format](ogv)
44. [Opus](opus)
45. [Passive event listeners](passive-event-listener)
46. [PNG alpha transparency](png-alpha)
47. [Public Key Pinning](publickeypinning)
48. [querySelector/querySelectorAll](queryselector)
49. [Referrer Policy](referrer-policy)
50. [Resource Hints: dns-prefetch](link-rel-dns-prefetch)
51. [Resource Hints: preconnect](link-rel-preconnect)
52. [Resource Hints: prefetch](link-rel-prefetch)
53. [Resource Hints: preload](link-rel-preload)
54. [Resource Hints: prerender](link-rel-prerender)
55. [SDCH Accept-Encoding/Content-Encoding](sdch)
56. [Server Name Indication](sni)
57. [Shadow DOM v0](shadowdom)
58. [Shadow DOM v1](shadowdomv1)
59. [Strict Transport Security](stricttransportsecurity)
60. [TLS 1.1](tls1-1)
61. [TLS 1.2](tls1-2)
62. [Upgrade Insecure Requests](upgradeinsecurerequests)
63. [WAI-ARIA Accessibility features](wai-aria)
64. [Wav audio format](wav)
65. [WebAssembly](wasm)
66. [WebM video format](webm)
67. [WebVTT - Web Video Text Tracks](webvtt)
68. [Window.devicePixelRatio](devicepixelratio)
69. [WOFF - Web Open Font Format](woff)
70. [WOFF 2.0 - Web Open Font Format](woff2)
71. [X-Frame-Options HTTP header](x-frame-options)
72. [XHTML served as application/xhtml+xml](xhtml)
73. [Animated PNG (APNG)](apng)
74. [EOT - Embedded OpenType fonts](eot)
75. [HTTP Live Streaming (HLS)](http-live-streaming)
76. [KeyboardEvent.charCode](keyboardevent-charcode)
77. [KeyboardEvent.which](keyboardevent-which)
78. [Resource Hints: Lazyload](lazyload)
79. [SPDY protocol](spdy)
80. [WebP image format](webp)
81. [XHTML+SMIL animation](xhtmlsmil)
82. [All Other features](/#cats=Other)

### [SVG](/#cats=SVG)

1. [Inline SVG in HTML5](svg-html5)
2. [SVG (basic support)](svg)
3. [SVG effects for HTML](svg-html)
4. [SVG favicons](link-icon-svg)
5. [SVG filters](svg-filters)
6. [SVG fragment identifiers](svg-fragment)
7. [SVG in CSS backgrounds](svg-css)
8. [SVG in HTML img element](svg-img)
9. [SVG SMIL animation](svg-smil)
10. [SVG fonts](svg-fonts)
11. [All SVG features](/#cats=SVG)

### [JS API](/#cats=JS_API)

1. [Ambient Light API](ambient-light)
2. [Arrow functions](arrow-functions)
3. [Base64 encoding and decoding](atob-btoa)
4. [Basic console logging functions](console-basic)
5. [Battery Status API](battery-status)
6. [Beacon API](beacon)
7. [Blob constructing](blobbuilder)
8. [Blob URLs](bloburls)
9. [BroadcastChannel](broadcastchannel)
10. [Channel messaging](channel-messaging)
11. [Clipboard API](clipboard)
12. [const](const)
13. [Credential Management API](credential-management)
14. [Cross-document messaging](x-doc-messaging)
15. [Cross-Origin Resource Sharing](cors)
16. [crypto.getRandomValues()](getrandomvalues)
17. [CSS Font Loading](font-loading)
18. [CSS.supports() API](css-supports-api)
19. [CustomEvent](customevent)
20. [DeviceOrientation & DeviceMotion events](deviceorientation)
21. [Document Object Model Range](dom-range)
22. [document.currentScript](document-currentscript)
23. [DOM Parsing and Serialization](xml-serializer)
24. [ECMAScript 5](es5)
25. [Element.getBoundingClientRect()](getboundingclientrect)
26. [Element.insertAdjacentHTML()](insertadjacenthtml)
27. [ES6 Number](es6-number)
28. [Fetch](fetch)
29. [FIDO U2F API](u2f)
30. [File API](fileapi)
31. [FileReader API](filereader)
32. [FileReaderSync](filereadersync)
33. [Full Screen API](fullscreen)
34. [Gamepad API](gamepad)
35. [Geolocation](geolocation)
36. [getUserMedia/Stream API](stream)
37. [Hashchange event](hashchange)
38. [High Resolution Time API](high-resolution-time)
39. [IndexedDB](indexeddb)
40. [Input Method Editor API](ime)
41. [Internationalization API](internationalization)
42. [JSON parsing](json)
43. [let](let)
44. [matches() DOM method](matchesselector)
45. [matchMedia](matchmedia)
46. [maxlength attribute for input and textarea elements](maxlength)
47. [Media Source Extensions](mediasource)
48. [MediaRecorder API](mediarecorder)
49. [Mutation Observer](mutationobserver)
50. [Navigation Timing API](nav-timing)
51. [Object RTC (ORTC) API for WebRTC](objectrtc)
52. [Online/offline status](online-status)
53. [Page Visibility](pagevisibility)
54. [PageTransitionEvent](page-transition-events)
55. [Payment Request API](payment-request)
56. [Pointer events](pointer)
57. [PointerLock API](pointerlock)
58. [Promises](promises)
59. [Proximity API](proximity)
60. [Proxy object](proxy)
61. [Push API](push-api)
62. [requestAnimationFrame](requestanimationframe)
63. [requestIdleCallback](requestidlecallback)
64. [Resource Timing](resource-timing)
65. [Rest parameters](rest-parameters)
66. [Screen Orientation](screen-orientation)
67. [scrollIntoView](scrollintoview)
68. [Selection API](selection-api)
69. [Server-sent events](eventsource)
70. [Service Workers](serviceworkers)
71. [Shared Web Workers](sharedworkers)
72. [TextEncoder & TextDecoder](textencoder)
73. [Touch events](touch)
74. [Typed Arrays](typedarrays)
75. [URLSearchParams](urlsearchparams)
76. [User Timing API](user-timing)
77. [Vibration API](vibration)
78. [Web Animations API](web-animation)
79. [Web Audio API](audio-api)
80. [Web Cryptography](cryptography)
81. [Web MIDI API](midi)
82. [Web Notifications](notifications)
83. [Web Sockets](websockets)
84. [Web Storage - name/value pairs](namevalue-storage)
85. [Web Workers](webworkers)
86. [WebRTC Peer-to-peer connections](rtcpeerconnection)
87. [XMLHttpRequest advanced features](xhr2)
88. [Document.execCommand()](document-execcommand)
89. [Efficient Script Yielding: setImmediate()](setimmediate)
90. [Element.scrollIntoViewIfNeeded()](scrollintoviewifneeded)
91. [Filesystem & FileWriter API](filesystem)
92. [Network Information API](netinfo)
93. [Object.observe data binding](object-observe)
94. [Permissions API](permissions-api)
95. [Speech Recognition API](speech-recognition)
96. [Speech Synthesis API](speech-synthesis)
97. [Web Bluetooth](web-bluetooth)
98. [Web SQL Database](sql-storage)
99. [All JS API features](/#cats=JS_API)

### Home

[Index of features](#index)

##### Latest features

##### Most searched features

1. [Flexbox](flexbox)
2. [CSS transforms](transforms2d)
3. [SVG](svg)
4. [CSS calc()](calc)
5. [CSS filter effects](css-filters)

##### Did you know?

* You can import usage data from your **Google Analytics** account and see exactly how well a feature is supported among your own site's visitors. Look under the **Settings panel** to get started!
* Usage data for all countries and continents can be imported via the **Settings panel**.
* By default, older browser versions are only shown if they have >= 0.5% usage share. You can increase or decrease this value from the **Settings panel**.
* If a feature you're looking for is not available on the site, you can [vote to have it included](https://github.com/fyrd/caniuse/issues). Better yet, if you've done the research you can even [submit it yourself](https://github.com/Fyrd/caniuse/blob/master/CONTRIBUTING.md#adding-a-feature)!
* Each feature support table includes a "Usage relative" button. This will resize each browser version cell to be relative to the amount of support it has for the selected usage source.

##### Browser scores

The caniuse browser scores are tallies of all features tracked on caniuse (excluding those marked as "unofficial"). The fully opaque part represents supported features, the semi-transparent part represents partial support.

Note that while caniuse tracks a wide variety of features, it only covers a subset of all web technologies so the scores are not 100% representative of any browser's capabilities.

##### Third party tools

1. [The CanIUse Embed — Add support tables to your site](https://caniuse.bitsofco.de/)
2. [Caniuse Component — Add support tables to your presentations](https://github.com/una/caniuse-component)
3. [Caniuse command line tool](https://github.com/sgentle/caniuse-cmd)
4. [Doiuse...? — Lint your CSS to check what features work](http://doiuse.com)
5. [I want to use — Select multiple features and see what % of users can use them](http://iwanttouse.com)

[See full list](https://github.com/Fyrd/caniuse/wiki/Third-party-tools)

### Tables

### About

"Can I use" provides up-to-date browser support tables for support of front-end web technologies on desktop and mobile web browsers.

The site was built and is maintained by [Alexis Deveria](http://a.deveria.com), with occasional updates provided by the [web development community](https://github.com/fyrd/caniuse). The design used as of 2014 was largely created by [Lennart Schoors](http://www.lensco.be/).

### FAQ

#### May I use your data in my presentation/article/site, etc?

Yes, the support data on this site is free to use under the [CC BY 4.0](http://creativecommons.org/licenses/by/4.0/) license.

#### Is there a way to see the support data in colors other than red/green?

Yes, you can enable accessible colors from [this link](/#accessible_colors=1) or from the option under Settings. This color scheme will be used again on revisit.

#### Do you have the data available in a raw format?

Yes, the raw support data is available on [GitHub](https://github.com/fyrd/caniuse) and is updated regularly.

#### Could you add _feature X_ to the site?

Adding features takes quite some time and there are many requests for additions. Because of this I use [GitHub issues](https://github.com/Fyrd/caniuse/issues) to manage requests. Feel free to add/vote for your feature there.

If you've done the research yourself already, you can also [submit a feature](https://github.com/Fyrd/caniuse/blob/master/CONTRIBUTING.md) on GitHub.

#### Could you cover email clients too so I can see what I can use in HTML emails?

That certainly sounds useful, but for now I only intend to take on web browser support.

#### Which features do you choose to add to this list?

I use the following criteria:

1. Useful to web designers/developers
2. Likely to be eventually implemented by the majority of browsers
3. _Not_ already fully supported in even old browsers. These features can be made searchable but will not include support tables.

Most features are added in priority order from [this list](http://caniuse.com/issue-list).

#### How do you test support?

I use a hand-crafted test suite to test features, which tests for basic support of each feature.

The test suite is publicly available at [tests.caniuse.com](http://tests.caniuse.com).

#### Where do you get your information for upcoming versions?

Most information comes directly from the latest developer/preview/nightly builds.

#### When is a feature considered "supported"?

When its primary purpose is largely fulfilled. It does not mean it's 100% supported, just that it's usable in most cases.

#### How often is this page updated?

I try to keep it as current as possible, with new information being usually being processed within a few days. Follow the [feed](feed.php) if you'd like keep up with all the changes made.

##### Can I use...

Browser support tables for modern web technologies

Created & maintained by [@Fyrd](http://twitter.com/Fyrd), design by [@Lensco](http://twitter.com/Lensco).

Support data contributions by the GitHub [community](https://github.com/Fyrd/caniuse/graphs/contributors).

Usage share statistics by [StatCounter GlobalStats](http://gs.statcounter.com/) for September, 2016

Location detection provided by [ipinfo.io](http://ipinfo.io).

##### Site links

* [Home](#home)
* [Feature index](#index)
* [Browser usage table](http://caniuse.com/usage-table)
* [Feature suggestion list](http://caniuse.com/issue-list)
* [Caniuse data on GitHub](https://github.com/fyrd/caniuse)

## Legend

* Green = Supported
* Red = Not supported
* Greenish yellow = Partial support
* Gray = Support unknown

[Enable accessible colors](/#accessible_colors=1)

[Use default colors](/#accessible_colors=0)
