# Code · Bootstrap

[Skip to main content](#content)

[Bootstrap](/)

* [Bootstrap](/)
* [Documentation](/getting-started/introduction/)
* [Examples](/examples/)
* [Themes](https://themes.getbootstrap.com)
* [Expo](https://expo.getbootstrap.com)
* [Blog](https://blog.getbootstrap.com)

# Content

Styles for displaying content with some of the most commonly used HTML elements, including normalization, typography, images, tables, and more.

[Getting started](/getting-started/introduction)

* [Introduction](/getting-started/introduction/)
* [Download](/getting-started/download/)
* [Contents](/getting-started/contents/)
* [Browsers & devices](/getting-started/browsers-devices/)
* [JavaScript](/getting-started/javascript/)
* [Options](/getting-started/options/)
* [Flexbox](/getting-started/flexbox/)
* [Build tools](/getting-started/build-tools/)
* [Best practices](/getting-started/best-practices/)
* [Accessibility](/getting-started/accessibility/)

[Layout](/layout/overview)

* [Overview](/layout/overview/)
* [Grid](/layout/grid/)
* [Flexbox grid](/layout/flexbox-grid/)
* [Media object](/layout/media-object/)
* [Responsive utilities](/layout/responsive-utilities/)

[Content](/content/reboot)

* [Reboot](/content/reboot/)
* [Typography](/content/typography/)
* [Code](/content/code/)
* [Images](/content/images/)
* [Tables](/content/tables/)
* [Figures](/content/figures/)

[Components](/components/alerts)

* [Alerts](/components/alerts/)
* [Breadcrumb](/components/breadcrumb/)
* [Buttons](/components/buttons/)
* [Button group](/components/button-group/)
* [Card](/components/card/)
* [Carousel](/components/carousel/)
* [Collapse](/components/collapse/)
* [Dropdowns](/components/dropdowns/)
* [Forms](/components/forms/)
* [Input group](/components/input-group/)
* [Jumbotron](/components/jumbotron/)
* [List group](/components/list-group/)
* [Modal](/components/modal/)
* [Navs](/components/navs/)
* [Navbar](/components/navbar/)
* [Pagination](/components/pagination/)
* [Popovers](/components/popovers/)
* [Progress](/components/progress/)
* [Scrollspy](/components/scrollspy/)
* [Tag](/components/tag/)
* [Tooltips](/components/tooltips/)

[Utilities](/utilities/borders)

* [Borders](/utilities/borders/)
* [Clearfix](/utilities/clearfix/)
* [Close icon](/utilities/close-icon/)
* [Colors](/utilities/colors/)
* [Display property](/utilities/display-property/)
* [Image replacement](/utilities/image-replacement/)
* [Invisible content](/utilities/invisible-content/)
* [Responsive helpers](/utilities/responsive-helpers/)
* [Screenreaders](/utilities/screenreaders/)
* [Sizing and positioning](/utilities/sizing-and-positioning/)
* [Spacing](/utilities/spacing/)
* [Typography](/utilities/typography/)
* [Vertical align](/utilities/vertical-align/)

[About](/about/history)

* [History](/about/history/)
* [Team](/about/team/)
* [Brand](/about/brand/)
* [License](/about/license/)
* [Translations](/about/translations/)

[Migration](/migration/)

# Code

Styles for inline code snippets and longer, multiline blocks of code.

## Contents

* [Contents](#contents)
* [Inline code](#inline-code)
* [Code blocks](#code-blocks)
* [Variables](#variables)
* [User input](#user-input)
* [Sample output](#sample-output)

## Inline code

Wrap inline snippets of code with `<code>`. Be sure to escape HTML angle brackets.
For example, `<section>` should be wrapped as inline.

```html
For example, <code>&lt;section&gt;</code> should be wrapped as inline.
```

## Code blocks

Use `<pre>`s for multiple lines of code. Once again, be sure to escape any angle brackets in the code for proper rendering. You may optionally add the `.pre-scrollable` class, which will set a max-height of 350px and provide a y-axis scrollbar.

```
<p>Sample text here...</p>
<p>And another line of sample text here...</p>
```

```html
<pre><code>&lt;p&gt;Sample text here...&lt;/p&gt;
&lt;p&gt;And another line of sample text here...&lt;/p&gt;
</code></pre>
```

## Variables

For indicating variables use the `<var>` tag.
<var>y</var> = <var>m</var><var>x</var> + <var>b</var>

```html
<var>y</var> = <var>m</var><var>x</var> + <var>b</var>
```

## User input

Use the `<kbd>` to indicate input that is typically entered via keyboard.
To switch directories, type <kbd>cd</kbd> followed by the name of the directory.<br>
To edit settings, press <kbd><kbd>ctrl</kbd> + <kbd>,</kbd></kbd>

```html
To switch directories, type <kbd>cd</kbd> followed by the name of the directory.<br>
To edit settings, press <kbd><kbd>ctrl</kbd> + <kbd>,</kbd></kbd>
```

## Sample output

For indicating sample output from a program use the `<samp>` tag.
<samp>This text is meant to be treated as sample output from a computer program.</samp>

```html
<samp>This text is meant to be treated as sample output from a computer program.</samp>
```

* [GitHub](https://github.com/twbs/bootstrap)
* [Twitter](https://twitter.com/getbootstrap)
* [Examples](/examples/)
* [About](/about/history/)

Designed and built with all the love in the world by [@mdo](https://twitter.com/mdo) and [@fat](https://twitter.com/fat). Maintained by the [core team](https://github.com/orgs/twbs/people) with the help of [our contributors](https://github.com/twbs/bootstrap/graphs/contributors).

Currently v4.0.0-alpha.5. Code licensed [MIT](https://github.com/twbs/bootstrap/blob/master/LICENSE), docs [CC BY 3.0](https://creativecommons.org/licenses/by/3.0/).
