﻿#  Библиотека Bybit_parser

## О библиотеке
Данная библиотека предназначена для более удобной работы с API Bybit
Она включает в себя следующие функции:

- getdata
- getdata_period
- getdata_d
- getdata_period_d
- instruments

## Сопутствующие библиотеки 

Для работы библиотеки необходимы и автоматически устанавливаются следующие библиотеки:

- requests  
- pandas
- numpy 
- tzlocal
## Опциональный параметр spot 
Функции для получения данных getdata, getdata_period, getdata_d, getdata_period_d имеют опциональный параметр spot 

Он предназначен для тикеров, которым соответствуют как спотовые активы так и фьючерсы

Параметр принимает значения True/False. **Default: False**

- True - возвращается информация о спотовом активе
- False - возвращается информация о linear фьючерсе 

**Параметр является опциональным, если тикеру соответствует только спотовый актив/фьючерс, изменять его значение не требуется**

## getdata

Функция возвращает информацию о n последних свечах в выбранном таймфрейме 
Поддерживает Spot, USDT perpetual, USDC contract, Inverse contract

Аргументы:

- ticker - тикер инструмента
- timeframe - таймфрейм возвращаемых значений
- periods - количество возвращаемых значений 
- spot - опциональный параметр для тикеров 

timeframe принимает значения: 1, 3, 5, 15, 30, 60, 120, 240, 360, 720 в минутах в формате int или "D", "W", "M"  в формате str

Функция возвращает объект pandas.DataFrame со столбцами:
1) Начало свечи в формате DD/MM/YYYY HH.MM 
2) Цена открытия 
3) Максимальная цена
4) Минимальная цена
5) Цена закрытия
6) Traiding volume - единица измерения зависит от типа актива

## getdata_period
Функция предназначена для получения данных за определённый период 
Поддерживает Spot, USDT perpetual, USDC contract, Inverse contract

Аргументы:
- ticker - тикер инструмента
- timeframe - таймфрейм возвращаемых значений
- periods - количество возвращаемых значений 
- spot - опциональный параметр для тикеров 
- start - начало периода
- end - конец периода 

timeframe принимает значения: 1, 3, 5, 15, 30, 60, 120, 240, 360, 720 в минутах в формате int или "D", "W", "M"  в формате str

 start и end  передаются в формате "DD.MM.YY HH.MM"
 
 Функция возвращает объект pandas.DataFrame со столбцами:
1) Начало свечи в формате DD/MM/YYYY HH.MM 
2) Цена открытия 
3) Максимальная цена
4) Минимальная цена
5) Цена закрытия
6) Traiding volume - единица измерения зависит от типа актива

## getadata_d

Аналог функции getdata для загрузки данных в формате csv
Дополнительные аргументы, помимо аргументов getdata:

- name - имя файла
- sep - разделитель для данных **не может принимать значение '.'**

Создает файл name.csv с разделителем sep и записывает туда полученные данные 
 

## getdata_period_d

Аналог функции getdata_period для загрузки данных в формате csv
Дополнительные аргументы, помимо аргументов getdata:

- name - имя файла
- sep - разделитель для данных **не может принимать значение '.'**

Создает файл name.csv с разделителем sep и записывает туда полученные данные 

## instruments

Возвращает список доступных инструментов 
Аргументы:

- category   - категория активов 

Category принимает три значения:
1) spot
2) linear
3) inverse

Возвращает объект pandas.DataFrame

Если category == linear/inverse 

Столбцы:
1) Символ
2) Bid price
3) Bid size 
4) Ask price
5) Ask size
6) Последняя цена
7) Индексная цен
8) Предыдущая цена 24 часа назад 
9) Процентное изменение цены за 24 часа
10) Максимальная цена за последние 24 часа
11) Минимальная цена за последние 24 часа
12) Open interest size
13) Open interest value 
14) Turnover 24h
15) Volume 24h 
16) Funding rate
17) Next funding time
18) Экспирация 

Если category == spot 

Столбцы:
1) Символ
2) Bid price
3) Bid size 
4) Ask price
5) Ask size
6) Последняя цена
7) Предыдущая цена 24 часа назад 
8) Процентное изменение цены за 24 часа
9) Максимальная цена за последние 24 часа
10) Минимальная цена за последние 24 часа
11) Turnover 24h
12) Volume 24h 











