# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyinvoicer']

package_data = \
{'': ['*'], 'pyinvoicer': ['templates/*']}

install_requires = \
['Jinja2>=2.11.2,<3.0.0', 'PyYAML>=5.4.1,<6.0.0', 'WeasyPrint>=52.2,<53.0']

entry_points = \
{'console_scripts': ['invoicer = pyinvoicer.pyinvoicer:main']}

setup_kwargs = {
    'name': 'pyinvoicer',
    'version': '0.0.2',
    'description': 'Commandline tool to generate HTML-based and PDF invoices.',
    'long_description': '[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://makeapullrequest.com)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\n\n# PyInvoicer\n\nCommandline tool to generate HTML-based and PDF invoices.\n\nPyInvoicer is a light-weight commandline tool written in Python to generate HTML-based and PDF invoices.\nThe usage is very straightforward and easy to use:\nprepare your invoice content in YAML as the input of PyInvoicer.\nThat\'s it!! No complicated setup like database is needed.\n\nQuick highlights:\n\n- run locally\n- content of input in YAML\n- output html and pdf\n- use as less third party dependency as possible\n\n\n![Invoice Screenshot Generated by PyInvoicer](./screenshot.png "Example Invoice").\n\n## Getting Started\n\n### Prerequisites\n* [Python](https://www.python.org/downloads/)\n\nThe release has been tested with Python 3.9.1.\n\n### Installation\nThe tool has been released to PyPI. You can install it directly from PyPI via pip.\n\n```\npip install pyinvoicer\n```\n\nIf you want to install from the source, you may need `poetry`, the package dependency management tool.\nThis project is managed by `poetry`. Fetch the source and `poetry install`. See [Contributing](contributing.md) for\nmore details.\n\n\n## Usage\n```buildoutcfg\ninvoicer <your content yaml>\n```\n\nYou will get `invoice.pdf` in the same folder. The [examples](examples/simple-invoice.yaml) folder of the source\nshows an example of the content yaml.\n\n\n### Output in Different Format\nFor example, if you want to output your invoice in html, invoke:\n```buildoutcfg\ninvoicer <your content yaml> --format html\n```\n\n\n### Output with Customized Name and Path\n```buildoutcfg\ninvoicer <your content yaml> /path/you/want/to/use/your-invoice.pdf\n```\n\n\n### More Usage Options\nPlease refer to `invoicer --help`.\n\n\n## Contributing\nSee [Contributing](contributing.md)\n\n\n## Authors\nTaihsiang Ho (tai271828) <tai271828@gmail.com>\n\n\nCreated from [Lee-W/cookiecutter-python-template](https://github.com/Lee-W/cookiecutter-python-template/tree/0.7.2) version 0.7.2\n',
    'author': 'Taihsiang Ho (tai271828)',
    'author_email': 'tai271828@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
