from __future__ import annotations

import datetime

from beancount.core.data import Account, Close, Commodity, Directive, Open
from collections import OrderedDict
from typing import Any, Callable, Iterable, Optional

class GetAccounts:
    def get_accounts_use_map(
        self: GetAccounts, entries: list[Directive]
    ) -> tuple[dict[Account, datetime.date], dict[Account, datetime.date]]: ...
    def get_entry_accounts(
        self: GetAccounts, entry: Directive
    ) -> set[Account]: ...
    def Transaction(_, entry: Directive) -> Iterable[Account]: ...
    def Pad(_, entry: Directive) -> tuple[Account, Account]: ...
    def _one(_, entry: Directive) -> tuple[Account]: ...
    def _zero(_, entry: Directive) -> tuple: ...
    Open: Callable[[GetAccounts, Directive], tuple[Account]]
    Close: Callable[[GetAccounts, Directive], tuple[Account]]
    Balance: Callable[[GetAccounts, Directive], tuple[Account]]
    Note: Callable[[GetAccounts, Directive], tuple[Account]]
    Document: Callable[[GetAccounts, Directive], tuple[Account]]
    Commodity: Callable[[GetAccounts, Directive], tuple]
    Event: Callable[[GetAccounts, Directive], tuple]
    Query: Callable[[GetAccounts, Directive], tuple]
    Price: Callable[[GetAccounts, Directive], tuple]
    Custom: Callable[[GetAccounts, Directive], tuple]

def get_accounts_use_map(
    entries: list[Directive],
) -> tuple[dict[Account, datetime.date], dict[Account, datetime.date]]: ...
def get_accounts(entries: list[Directive]) -> set[Account]: ...
def get_entry_accounts(entry: Directive) -> set[Account]: ...
def get_account_components(entries: list[Directive]) -> list[Account]: ...
def get_all_tags(entries: list[Directive]) -> set[str]: ...
def get_all_payees(entries: list[Directive]) -> set[str]: ...
def get_all_links(entries: list[Directive]) -> set[str]: ...
def get_leveln_parent_accounts(
    account_names: list[Account], level: int, nrepeats: int = ...
) -> list[str]: ...
def get_dict_accounts(
    account_names: Iterable[Account],
) -> OrderedDict[str, OrderedDict]: ...
def get_min_max_dates(
    entries: list[Directive], types: tuple[type] | None = ...
) -> tuple[datetime.date, datetime.date]: ...
def get_active_years(entries: list[Directive]) -> Iterable[datetime.date]: ...
def get_account_open_close(
    entries: list[Directive],
) -> dict[str, tuple[Optional[Open], Optional[Close]]]: ...
def get_commodity_directives(
    entries: list[Directive],
) -> dict[str, Commodity]: ...
def get_values_meta(
    name_to_entries_map: dict[str, Optional[Directive]],
    *meta_keys: list[str],
    default: Any | None = ...
) -> dict[str, Any]: ...
