# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MinifluxServiceArgs', 'MinifluxService']

@pulumi.input_type
class MinifluxServiceArgs:
    def __init__(__self__, *,
                 admin_password: pulumi.Input[str],
                 db_password: pulumi.Input[str],
                 admin_username: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MinifluxService resource.
        :param pulumi.Input[str] admin_password: The Miniflux administrator's password.
        :param pulumi.Input[str] db_password: The PostgreSQL user's password.
        :param pulumi.Input[str] admin_username: The username to use for the Miniflux service administrator account.
        :param pulumi.Input[str] db_name: The name of the PostgreSQL database to be used by Miniflux.
        :param pulumi.Input[str] db_username: The username of the PostgreSQL account to be used by the Miniflux service.
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "db_password", db_password)
        if admin_username is None:
            admin_username = 'admin'
        if admin_username is not None:
            pulumi.set(__self__, "admin_username", admin_username)
        if db_name is None:
            db_name = 'miniflux'
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_username is None:
            db_username = 'miniflux'
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> pulumi.Input[str]:
        """
        The Miniflux administrator's password.
        """
        return pulumi.get(self, "admin_password")

    @admin_password.setter
    def admin_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_password", value)

    @property
    @pulumi.getter(name="dbPassword")
    def db_password(self) -> pulumi.Input[str]:
        """
        The PostgreSQL user's password.
        """
        return pulumi.get(self, "db_password")

    @db_password.setter
    def db_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_password", value)

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> Optional[pulumi.Input[str]]:
        """
        The username to use for the Miniflux service administrator account.
        """
        return pulumi.get(self, "admin_username")

    @admin_username.setter
    def admin_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_username", value)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the PostgreSQL database to be used by Miniflux.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the PostgreSQL account to be used by the Miniflux service.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_username", value)


class MinifluxService(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_password: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a MinifluxService resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_password: The Miniflux administrator's password.
        :param pulumi.Input[str] admin_username: The username to use for the Miniflux service administrator account.
        :param pulumi.Input[str] db_name: The name of the PostgreSQL database to be used by Miniflux.
        :param pulumi.Input[str] db_password: The PostgreSQL user's password.
        :param pulumi.Input[str] db_username: The username of the PostgreSQL account to be used by the Miniflux service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MinifluxServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a MinifluxService resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param MinifluxServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MinifluxServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_password: Optional[pulumi.Input[str]] = None,
                 admin_username: Optional[pulumi.Input[str]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 db_password: Optional[pulumi.Input[str]] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MinifluxServiceArgs.__new__(MinifluxServiceArgs)

            if admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'admin_password'")
            __props__.__dict__["admin_password"] = admin_password
            if admin_username is None:
                admin_username = 'admin'
            __props__.__dict__["admin_username"] = admin_username
            if db_name is None:
                db_name = 'miniflux'
            __props__.__dict__["db_name"] = db_name
            if db_password is None and not opts.urn:
                raise TypeError("Missing required property 'db_password'")
            __props__.__dict__["db_password"] = db_password
            if db_username is None:
                db_username = 'miniflux'
            __props__.__dict__["db_username"] = db_username
            __props__.__dict__["endpoint"] = None
        super(MinifluxService, __self__).__init__(
            'aws-miniflux:index:MinifluxService',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The URL of the Miniflux service.
        """
        return pulumi.get(self, "endpoint")

