# coding: utf-8


"""
IGNORE:
    Nutanix Lcm Versioned APIs

    Manage Infrastructure, Software and Firmware Upgrades.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from ntnx_lcm_py_client.api_client import ApiClient


class NodePriorityConfigApi(object):
    """IGNORE:
    NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    IGNORE
    """ # noqa: E501

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_node_priorities(self, **kwargs):  # noqa: E501
        """Get the order in which nodes will be upgraded
        Get node priorities

        >>> response = api.get_node_priorities()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_node_priorities(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: lcm.v4.resources.GetNodePrioritiesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_priorities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_node_priorities_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_node_priorities_with_http_info(self, **kwargs):  # noqa: E501
        """Get the order in which nodes will be upgraded
        Get node priorities

        >>> response = api.get_node_priorities()

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_node_priorities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param bool async_req:
        :return: lcm.v4.resources.GetNodePrioritiesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_priorities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/lcm/v4.0.a1/resources/config/node-priorities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='lcm.v4.resources.GetNodePrioritiesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_node_priority(self, nodeUuid, **kwargs):  # noqa: E501
        """Get the node priority of a node by UUID
        Get node priority value of a node

        >>> response = api.get_node_priority(nodeUuid)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_node_priority(nodeUuid, async_req=True)
        >>> result = thread.get()

        :param str nodeUuid: UUID of a node in the cluster (required)
        :param bool async_req:
        :return: lcm.v4.resources.GetNodePriorityNodeApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_node_priority_with_http_info(nodeUuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_node_priority_with_http_info(nodeUuid, **kwargs)  # noqa: E501
            return data

    def get_node_priority_with_http_info(self, nodeUuid, **kwargs):  # noqa: E501
        """Get the node priority of a node by UUID
        Get node priority value of a node

        >>> response = api.get_node_priority(nodeUuid)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_node_priority_with_http_info(nodeUuid, async_req=True)
        >>> result = thread.get()

        :param str nodeUuid: UUID of a node in the cluster (required)
        :param bool async_req:
        :return: lcm.v4.resources.GetNodePriorityNodeApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['nodeUuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_node_priority" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'nodeUuid' is set
        if ('nodeUuid' not in params or
                params['nodeUuid'] is None):
            raise ValueError("Missing the required parameter `nodeUuid` when calling `get_node_priority`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'nodeUuid' in params:
            path_params['nodeUuid'] = params['nodeUuid']  # noqa: E501

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/lcm/v4.0.a1/resources/config/node_priority/{nodeUuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='lcm.v4.resources.GetNodePriorityNodeApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_node_priorities(self, **kwargs):  # noqa: E501
        """Set the order in which nodes will be upgraded
        Update node priority of the node

        >>> response = api.post_node_priorities((optional) body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_node_priorities(async_req=True)
        >>> result = thread.get()

        :param lcm.v4.resources.NodePriorityConfig body:
        :param bool async_req:
        :return: lcm.v4.resources.PostNodePrioritiesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """ # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_node_priorities_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_node_priorities_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_node_priorities_with_http_info(self, **kwargs):  # noqa: E501
        """Set the order in which nodes will be upgraded
        Update node priority of the node

        >>> response = api.post_node_priorities((optional) body)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.post_node_priorities_with_http_info(async_req=True)
        >>> result = thread.get()

        :param lcm.v4.resources.NodePriorityConfig body:
        :param bool async_req:
        :return: lcm.v4.resources.PostNodePrioritiesApiResponse

                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')
        all_params.append('if_match')
        all_params.append('if_none_match')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_node_priorities" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'if_match' in params and params['if_match'] is not None:
            header_params['If-Match'] = params['if_match']  # noqa: E501
        if 'if_none_match' in params and params['if_none_match'] is not None:
            header_params['If-None-Match'] = params['if_none_match']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuthScheme']  # noqa: E501

        return self.api_client.call_api(
            '/api/lcm/v4.0.a1/resources/config/node-priorities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='lcm.v4.resources.PostNodePrioritiesApiResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
