# coding: utf-8


"""
IGNORE:
    Nutanix Lcm Versioned APIs

    Manage Infrastructure, Software and Firmware Upgrades.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_lcm_py_client.Ntnx.lcm.v4.resources.EntityInfo import EntityInfo  # noqa: F401,E501
from ntnx_lcm_py_client.Ntnx.lcm.v4.resources.LcmOpType import LcmOpType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class OperationHistoryElement(object):
    """OperationHistoryElement - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'operation_id': 'str',
        'operation_type': 'lcm.v4.resources.LcmOpType',
        'lcm_version': 'str',
        'start_time': 'str',
        'end_time': 'str',
        'operation_done': 'bool',
        'op_exception_report': 'str',
        'entity_info': 'list[lcm.v4.resources.EntityInfo]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'operation_id': 'operationId',
        'operation_type': 'operationType',
        'lcm_version': 'lcmVersion',
        'start_time': 'startTime',
        'end_time': 'endTime',
        'operation_done': 'operationDone',
        'op_exception_report': 'opExceptionReport',
        'entity_info': 'entityInfo',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, operation_id=None, operation_type=None, lcm_version=None, start_time=None, end_time=None, operation_done=None, op_exception_report=None, entity_info=None, *args, **kwargs):  # noqa: E501
        """OperationHistoryElement - a model defined in Swagger
            \nDetails about an LCM operation that was run
        """
        self.__operation_id = None
        self.__operation_type = None
        self.__lcm_version = None
        self.__start_time = None
        self.__end_time = None
        self.__operation_done = None
        self.__op_exception_report = None
        self.__entity_info = None
        self.discriminator = None
        if operation_id is not None:
            self.__operation_id = operation_id
        if operation_type is not None:
            self.__operation_type = operation_type
        if lcm_version is not None:
            self.__lcm_version = lcm_version
        if start_time is not None:
            self.__start_time = start_time
        if end_time is not None:
            self.__end_time = end_time
        if operation_done is not None:
            self.__operation_done = operation_done
        if op_exception_report is not None:
            self.__op_exception_report = op_exception_report
        if entity_info is not None:
            self.__entity_info = entity_info
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'lcm.v4.resources.OperationHistoryElement'

    def _initialize_fq_object_type(self):
        return 'lcm.v4.r0.a1.resources.OperationHistoryElement'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def operation_id(self):
        """`{ str }`
            \nUUID of an LCM operation
        """ # noqa: E501
        return self.__operation_id

    @operation_id.setter
    def operation_id(self, operation_id):
        if operation_id is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', operation_id):  # noqa: E501
            raise ValueError(r"Invalid value for `operation_id`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__operation_id = operation_id

    @property
    def operation_type(self):
        """`{ lcm.v4.resources.LcmOpType }`
            
        """ # noqa: E501
        return self.__operation_type

    @operation_type.setter
    def operation_type(self, operation_type):

        self.__operation_type = operation_type

    @property
    def lcm_version(self):
        """`{ str }`
            \nLCM version installed on the cluster
        """ # noqa: E501
        return self.__lcm_version

    @lcm_version.setter
    def lcm_version(self, lcm_version):

        self.__lcm_version = lcm_version

    @property
    def start_time(self):
        """`{ str }`
            \nStart time for an LCM operation
        """ # noqa: E501
        return self.__start_time

    @start_time.setter
    def start_time(self, start_time):

        self.__start_time = start_time

    @property
    def end_time(self):
        """`{ str }`
            \nEnd time for an LCM operation
        """ # noqa: E501
        return self.__end_time

    @end_time.setter
    def end_time(self, end_time):

        self.__end_time = end_time

    @property
    def operation_done(self):
        """`{ bool }`
            \nBoolean that indicates whether the operation was done
        """ # noqa: E501
        return self.__operation_done

    @operation_done.setter
    def operation_done(self, operation_done):

        self.__operation_done = operation_done

    @property
    def op_exception_report(self):
        """`{ str }`
            \nDetails of the operation failure
        """ # noqa: E501
        return self.__op_exception_report

    @op_exception_report.setter
    def op_exception_report(self, op_exception_report):

        self.__op_exception_report = op_exception_report

    @property
    def entity_info(self):
        """`{ list[lcm.v4.resources.EntityInfo] }`
            
        """ # noqa: E501
        return self.__entity_info

    @entity_info.setter
    def entity_info(self, entity_info):

        self.__entity_info = entity_info

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OperationHistoryElement, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OperationHistoryElement):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

