# coding: utf-8


"""
IGNORE:
    Nutanix Lcm Versioned APIs

    Manage Infrastructure, Software and Firmware Upgrades.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_lcm_py_client.Ntnx.lcm.v4.resources.OperationType import OperationType  # noqa: F401,E501
from ntnx_lcm_py_client.Ntnx.lcm.v4.resources.StatusType import StatusType  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class LcmTask(object):
    """LcmTask - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'uuid': 'str',
        'logical_timestamp': 'int',
        'operation_type': 'lcm.v4.resources.OperationType',
        'percentage_complete': 'int',
        'status': 'lcm.v4.resources.StatusType',
        'cluster_uuid': 'str',
        'parent_task_uuid': 'str',
        'subtask_uuids': 'list[str]',
        'creation_time': 'str',
        'creation_time_usecs': 'int',
        'last_update_time': 'str',
        'start_time': 'str',
        'completion_time': 'str',
        'error_code': 'str',
        'error_detail': 'str',
        'message': 'str',
        'entity_uuids': 'list[str]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'uuid': 'uuid',
        'logical_timestamp': 'logicalTimestamp',
        'operation_type': 'operationType',
        'percentage_complete': 'percentageComplete',
        'status': 'status',
        'cluster_uuid': 'clusterUuid',
        'parent_task_uuid': 'parentTaskUuid',
        'subtask_uuids': 'subtaskUuids',
        'creation_time': 'creationTime',
        'creation_time_usecs': 'creationTimeUsecs',
        'last_update_time': 'lastUpdateTime',
        'start_time': 'startTime',
        'completion_time': 'completionTime',
        'error_code': 'errorCode',
        'error_detail': 'errorDetail',
        'message': 'message',
        'entity_uuids': 'entityUuids',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, uuid=None, logical_timestamp=None, operation_type=None, percentage_complete=None, status=None, cluster_uuid=None, parent_task_uuid=None, subtask_uuids=None, creation_time=None, creation_time_usecs=None, last_update_time=None, start_time=None, completion_time=None, error_code=None, error_detail=None, message=None, entity_uuids=None, *args, **kwargs):  # noqa: E501
        """LcmTask - a model defined in Swagger
            \nDetails about LCM Task
        """
        self.__uuid = None
        self.__logical_timestamp = None
        self.__operation_type = None
        self.__percentage_complete = None
        self.__status = None
        self.__cluster_uuid = None
        self.__parent_task_uuid = None
        self.__subtask_uuids = None
        self.__creation_time = None
        self.__creation_time_usecs = None
        self.__last_update_time = None
        self.__start_time = None
        self.__completion_time = None
        self.__error_code = None
        self.__error_detail = None
        self.__message = None
        self.__entity_uuids = None
        self.discriminator = None
        if uuid is not None:
            self.__uuid = uuid
        if logical_timestamp is not None:
            self.__logical_timestamp = logical_timestamp
        if operation_type is not None:
            self.__operation_type = operation_type
        if percentage_complete is not None:
            self.__percentage_complete = percentage_complete
        if status is not None:
            self.__status = status
        if cluster_uuid is not None:
            self.__cluster_uuid = cluster_uuid
        if parent_task_uuid is not None:
            self.__parent_task_uuid = parent_task_uuid
        if subtask_uuids is not None:
            self.__subtask_uuids = subtask_uuids
        if creation_time is not None:
            self.__creation_time = creation_time
        if creation_time_usecs is not None:
            self.__creation_time_usecs = creation_time_usecs
        if last_update_time is not None:
            self.__last_update_time = last_update_time
        if start_time is not None:
            self.__start_time = start_time
        if completion_time is not None:
            self.__completion_time = completion_time
        if error_code is not None:
            self.__error_code = error_code
        if error_detail is not None:
            self.__error_detail = error_detail
        if message is not None:
            self.__message = message
        if entity_uuids is not None:
            self.__entity_uuids = entity_uuids
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'lcm.v4.resources.LcmTask'

    def _initialize_fq_object_type(self):
        return 'lcm.v4.r0.a1.resources.LcmTask'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def uuid(self):
        """`{ str }`
            \nUUID of LCM task
        """ # noqa: E501
        return self.__uuid

    @uuid.setter
    def uuid(self, uuid):
        if uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__uuid = uuid

    @property
    def logical_timestamp(self):
        """`{ int }`
            \nNumber of times the task has been updated. The value increases sequentially with each update of the task and can be used to verify if there have been changes to the task.
        """ # noqa: E501
        return self.__logical_timestamp

    @logical_timestamp.setter
    def logical_timestamp(self, logical_timestamp):

        self.__logical_timestamp = logical_timestamp

    @property
    def operation_type(self):
        """`{ lcm.v4.resources.OperationType }`
            
        """ # noqa: E501
        return self.__operation_type

    @operation_type.setter
    def operation_type(self, operation_type):

        self.__operation_type = operation_type

    @property
    def percentage_complete(self):
        """`{ int }`
            \nCompletion percentage of a task
        """ # noqa: E501
        return self.__percentage_complete

    @percentage_complete.setter
    def percentage_complete(self, percentage_complete):

        self.__percentage_complete = percentage_complete

    @property
    def status(self):
        """`{ lcm.v4.resources.StatusType }`
            
        """ # noqa: E501
        return self.__status

    @status.setter
    def status(self, status):

        self.__status = status

    @property
    def cluster_uuid(self):
        """`{ str }`
            \nReference to the cluster the task is being executed on.
        """ # noqa: E501
        return self.__cluster_uuid

    @cluster_uuid.setter
    def cluster_uuid(self, cluster_uuid):
        if cluster_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', cluster_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `cluster_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__cluster_uuid = cluster_uuid

    @property
    def parent_task_uuid(self):
        """`{ str }`
            \nReference to the parent task
        """ # noqa: E501
        return self.__parent_task_uuid

    @parent_task_uuid.setter
    def parent_task_uuid(self, parent_task_uuid):
        if parent_task_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', parent_task_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `parent_task_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__parent_task_uuid = parent_task_uuid

    @property
    def subtask_uuids(self):
        """`{ list[str] }`
            \nList with the reference to the sub-task UUIDs
        """ # noqa: E501
        return self.__subtask_uuids

    @subtask_uuids.setter
    def subtask_uuids(self, subtask_uuids):

        self.__subtask_uuids = subtask_uuids

    @property
    def creation_time(self):
        """`{ str }`
            \nUTC date and time in RFC-3339 format when the task was created.
        """ # noqa: E501
        return self.__creation_time

    @creation_time.setter
    def creation_time(self, creation_time):

        self.__creation_time = creation_time

    @property
    def creation_time_usecs(self):
        """`{ int }`
            \nTime in microseconds from Epoch when task was created.
        """ # noqa: E501
        return self.__creation_time_usecs

    @creation_time_usecs.setter
    def creation_time_usecs(self, creation_time_usecs):

        self.__creation_time_usecs = creation_time_usecs

    @property
    def last_update_time(self):
        """`{ str }`
            \nUTC date and time in RFC-3339 format when the task was last updated.
        """ # noqa: E501
        return self.__last_update_time

    @last_update_time.setter
    def last_update_time(self, last_update_time):

        self.__last_update_time = last_update_time

    @property
    def start_time(self):
        """`{ str }`
            \nStart time for an LCM operation
        """ # noqa: E501
        return self.__start_time

    @start_time.setter
    def start_time(self, start_time):

        self.__start_time = start_time

    @property
    def completion_time(self):
        """`{ str }`
            \nEnd time for an LCM operation
        """ # noqa: E501
        return self.__completion_time

    @completion_time.setter
    def completion_time(self, completion_time):

        self.__completion_time = completion_time

    @property
    def error_code(self):
        """`{ str }`
            \nIn case of task failure this field will provide the error code.
        """ # noqa: E501
        return self.__error_code

    @error_code.setter
    def error_code(self, error_code):

        self.__error_code = error_code

    @property
    def error_detail(self):
        """`{ str }`
            \nIn case of task failure this field will provide the error description.
        """ # noqa: E501
        return self.__error_detail

    @error_detail.setter
    def error_detail(self, error_detail):

        self.__error_detail = error_detail

    @property
    def message(self):
        """`{ str }`
            \nAny custom message related to the task
        """ # noqa: E501
        return self.__message

    @message.setter
    def message(self, message):

        self.__message = message

    @property
    def entity_uuids(self):
        """`{ list[str] }`
            \nList of entity identifiers being upgraded, in UUID format
        """ # noqa: E501
        return self.__entity_uuids

    @entity_uuids.setter
    def entity_uuids(self, entity_uuids):

        self.__entity_uuids = entity_uuids

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LcmTask, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LcmTask):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

