# coding: utf-8


"""
IGNORE:
    Nutanix Lcm Versioned APIs

    Manage Infrastructure, Software and Firmware Upgrades.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_lcm_py_client.Ntnx.lcm.v4.common.LcmEntityType import LcmEntityType  # noqa: F401,E501
from ntnx_lcm_py_client.Ntnx.lcm.v4.resources.LcmAvailableVersion import LcmAvailableVersion  # noqa: F401,E501
from ntnx_lcm_py_client.Ntnx.lcm.v4.resources.SubEntity import SubEntity  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class LcmEntity(object):
    """LcmEntity - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'uuid': 'str',
        'entity_description': 'str',
        'entity_class': 'str',
        'entity_type': 'lcm.v4.common.LcmEntityType',
        'entity_model': 'str',
        'location_id': 'str',
        'version': 'str',
        'request_version': 'str',
        'last_updated_time': 'str',
        'id': 'str',
        'single_group_uuid': 'str',
        'entity_details': 'object',
        'child_entities': 'object',
        'available_versions': 'list[lcm.v4.resources.LcmAvailableVersion]',
        'sub_entities': 'list[lcm.v4.resources.SubEntity]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'uuid': 'uuid',
        'entity_description': 'entityDescription',
        'entity_class': 'entityClass',
        'entity_type': 'entityType',
        'entity_model': 'entityModel',
        'location_id': 'locationId',
        'version': 'version',
        'request_version': 'requestVersion',
        'last_updated_time': 'lastUpdatedTime',
        'id': 'id',
        'single_group_uuid': 'singleGroupUuid',
        'entity_details': 'entityDetails',
        'child_entities': 'childEntities',
        'available_versions': 'availableVersions',
        'sub_entities': 'subEntities',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, uuid=None, entity_description=None, entity_class=None, entity_type=None, entity_model=None, location_id=None, version=None, request_version=None, last_updated_time=None, id=None, single_group_uuid=None, entity_details=None, child_entities=None, available_versions=None, sub_entities=None, *args, **kwargs):  # noqa: E501
        """LcmEntity - a model defined in Swagger
            \nDetails of an LCM entity
        """
        self.__uuid = None
        self.__entity_description = None
        self.__entity_class = None
        self.__entity_type = None
        self.__entity_model = None
        self.__location_id = None
        self.__version = None
        self.__request_version = None
        self.__last_updated_time = None
        self.__id = None
        self.__single_group_uuid = None
        self.__entity_details = None
        self.__child_entities = None
        self.__available_versions = None
        self.__sub_entities = None
        self.discriminator = None
        if uuid is not None:
            self.__uuid = uuid
        if entity_description is not None:
            self.__entity_description = entity_description
        if entity_class is not None:
            self.__entity_class = entity_class
        if entity_type is not None:
            self.__entity_type = entity_type
        if entity_model is not None:
            self.__entity_model = entity_model
        if location_id is not None:
            self.__location_id = location_id
        if version is not None:
            self.__version = version
        if request_version is not None:
            self.__request_version = request_version
        if last_updated_time is not None:
            self.__last_updated_time = last_updated_time
        if id is not None:
            self.__id = id
        if single_group_uuid is not None:
            self.__single_group_uuid = single_group_uuid
        if entity_details is not None:
            self.__entity_details = entity_details
        if child_entities is not None:
            self.__child_entities = child_entities
        if available_versions is not None:
            self.__available_versions = available_versions
        if sub_entities is not None:
            self.__sub_entities = sub_entities
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'lcm.v4.resources.LcmEntity'

    def _initialize_fq_object_type(self):
        return 'lcm.v4.r0.a1.resources.LcmEntity'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def uuid(self):
        """`{ str }`
            \nUUID of the entity to be used
        """ # noqa: E501
        return self.__uuid

    @uuid.setter
    def uuid(self, uuid):
        if uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__uuid = uuid

    @property
    def entity_description(self):
        """`{ str }`
            \nDescription of an LCM entity
        """ # noqa: E501
        return self.__entity_description

    @entity_description.setter
    def entity_description(self, entity_description):

        self.__entity_description = entity_description

    @property
    def entity_class(self):
        """`{ str }`
            \nLCM entity class
        """ # noqa: E501
        return self.__entity_class

    @entity_class.setter
    def entity_class(self, entity_class):

        self.__entity_class = entity_class

    @property
    def entity_type(self):
        """`{ lcm.v4.common.LcmEntityType }`
            
        """ # noqa: E501
        return self.__entity_type

    @entity_type.setter
    def entity_type(self, entity_type):

        self.__entity_type = entity_type

    @property
    def entity_model(self):
        """`{ str }`
            \nLCM entity model
        """ # noqa: E501
        return self.__entity_model

    @entity_model.setter
    def entity_model(self, entity_model):

        self.__entity_model = entity_model

    @property
    def location_id(self):
        """`{ str }`
            \nThe location of the LCM entity, it can be at the cluster level or at the node level, in the format of \"cluster:uuid\" or \"node:uuid\"
        """ # noqa: E501
        return self.__location_id

    @location_id.setter
    def location_id(self, location_id):

        self.__location_id = location_id

    @property
    def version(self):
        """`{ str }`
            \nCurrent version of an LCM entity
        """ # noqa: E501
        return self.__version

    @version.setter
    def version(self, version):

        self.__version = version

    @property
    def request_version(self):
        """`{ str }`
            \nThe requested update version of an LCM entity.
        """ # noqa: E501
        return self.__request_version

    @request_version.setter
    def request_version(self, request_version):

        self.__request_version = request_version

    @property
    def last_updated_time(self):
        """`{ str }`
            \nUTC date and time in RFC-3339 format when the task was last updated.
        """ # noqa: E501
        return self.__last_updated_time

    @last_updated_time.setter
    def last_updated_time(self, last_updated_time):

        self.__last_updated_time = last_updated_time

    @property
    def id(self):
        """`{ str }`
            \nUnique identifier of an LCM entity e.g. \"HDD serial number\"
        """ # noqa: E501
        return self.__id

    @id.setter
    def id(self, id):

        self.__id = id

    @property
    def single_group_uuid(self):
        """`{ str }`
            \nUUID of the group that this LCM entity is part of
        """ # noqa: E501
        return self.__single_group_uuid

    @single_group_uuid.setter
    def single_group_uuid(self, single_group_uuid):
        if single_group_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', single_group_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `single_group_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__single_group_uuid = single_group_uuid

    @property
    def entity_details(self):
        """`{ object }`
            \nDetailed information for the LCM entity. For example, firmware entities contain additional information about NIC and so on
        """ # noqa: E501
        return self.__entity_details

    @entity_details.setter
    def entity_details(self, entity_details):

        self.__entity_details = entity_details

    @property
    def child_entities(self):
        """`{ object }`
            \nComponent information for the payload based entity
        """ # noqa: E501
        return self.__child_entities

    @child_entities.setter
    def child_entities(self, child_entities):

        self.__child_entities = child_entities

    @property
    def available_versions(self):
        """`{ list[lcm.v4.resources.LcmAvailableVersion] }`
            \nList of available versions for an LCM entity to update
        """ # noqa: E501
        return self.__available_versions

    @available_versions.setter
    def available_versions(self, available_versions):

        self.__available_versions = available_versions

    @property
    def sub_entities(self):
        """`{ list[lcm.v4.resources.SubEntity] }`
            \nA list of sub-entities applicable to the entity.
        """ # noqa: E501
        return self.__sub_entities

    @sub_entities.setter
    def sub_entities(self, sub_entities):

        self.__sub_entities = sub_entities

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LcmEntity, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LcmEntity):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

