# coding: utf-8


"""
IGNORE:
    Nutanix Lcm Versioned APIs

    Manage Infrastructure, Software and Firmware Upgrades.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_lcm_py_client.Ntnx.lcm.v4.resources.UserPreference import UserPreference  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class LcmConfig(object):
    """LcmConfig - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'url': 'str',
        'auto_inventory_enabled': 'bool',
        'auto_inventory_scheduled_time': 'str',
        'inventory_parallel_limit': 'int',
        'ui_version': 'str',
        'lcm_version': 'str',
        'semantic_version': 'str',
        'build_type': 'str',
        'skipped_precheck_names': 'list[str]',
        'product_meta_disabled': 'bool',
        'product_meta_url': 'str',
        'recovery_disabled': 'bool',
        'is_darksite': 'bool',
        'enable_https': 'bool',
        'api_enabled': 'bool',
        'prism_api_timeout': 'int',
        'distribute_inventory': 'bool',
        'user_preferences': 'list[lcm.v4.resources.UserPreference]',
        'metrics_enabled': 'bool',
        'supported_software_entities': 'list[str]',
        'deprecated_software_entities': 'list[str]',
        'uploaded_bundle': 'bool',
        'module_auto_upgrade_enabled': 'bool',
        'redfish_o_o_b_update_support': 'bool',
        'enable_auto_log_collection': 'bool',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'url': 'url',
        'auto_inventory_enabled': 'autoInventoryEnabled',
        'auto_inventory_scheduled_time': 'autoInventoryScheduledTime',
        'inventory_parallel_limit': 'inventoryParallelLimit',
        'ui_version': 'uiVersion',
        'lcm_version': 'lcmVersion',
        'semantic_version': 'semanticVersion',
        'build_type': 'buildType',
        'skipped_precheck_names': 'skippedPrecheckNames',
        'product_meta_disabled': 'productMetaDisabled',
        'product_meta_url': 'productMetaUrl',
        'recovery_disabled': 'recoveryDisabled',
        'is_darksite': 'isDarksite',
        'enable_https': 'enableHttps',
        'api_enabled': 'apiEnabled',
        'prism_api_timeout': 'prismApiTimeout',
        'distribute_inventory': 'distributeInventory',
        'user_preferences': 'userPreferences',
        'metrics_enabled': 'metricsEnabled',
        'supported_software_entities': 'supportedSoftwareEntities',
        'deprecated_software_entities': 'deprecatedSoftwareEntities',
        'uploaded_bundle': 'uploadedBundle',
        'module_auto_upgrade_enabled': 'moduleAutoUpgradeEnabled',
        'redfish_o_o_b_update_support': 'redfishOOBUpdateSupport',
        'enable_auto_log_collection': 'enableAutoLogCollection',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, url=None, auto_inventory_enabled=None, auto_inventory_scheduled_time=None, inventory_parallel_limit=None, ui_version=None, lcm_version=None, semantic_version=None, build_type=None, skipped_precheck_names=None, product_meta_disabled=None, product_meta_url=None, recovery_disabled=None, is_darksite=None, enable_https=None, api_enabled=None, prism_api_timeout=None, distribute_inventory=None, user_preferences=None, metrics_enabled=None, supported_software_entities=None, deprecated_software_entities=None, uploaded_bundle=None, module_auto_upgrade_enabled=None, redfish_o_o_b_update_support=None, enable_auto_log_collection=None, *args, **kwargs):  # noqa: E501
        """LcmConfig - a model defined in Swagger
            \nLCM configuration on the cluster
        """
        self.__url = None
        self.__auto_inventory_enabled = None
        self.__auto_inventory_scheduled_time = None
        self.__inventory_parallel_limit = None
        self.__ui_version = None
        self.__lcm_version = None
        self.__semantic_version = None
        self.__build_type = None
        self.__skipped_precheck_names = None
        self.__product_meta_disabled = None
        self.__product_meta_url = None
        self.__recovery_disabled = None
        self.__is_darksite = None
        self.__enable_https = None
        self.__api_enabled = None
        self.__prism_api_timeout = None
        self.__distribute_inventory = None
        self.__user_preferences = None
        self.__metrics_enabled = None
        self.__supported_software_entities = None
        self.__deprecated_software_entities = None
        self.__uploaded_bundle = None
        self.__module_auto_upgrade_enabled = None
        self.__redfish_o_o_b_update_support = None
        self.__enable_auto_log_collection = None
        self.discriminator = None
        if url is not None:
            self.__url = url
        if auto_inventory_enabled is not None:
            self.__auto_inventory_enabled = auto_inventory_enabled
        if auto_inventory_scheduled_time is not None:
            self.__auto_inventory_scheduled_time = auto_inventory_scheduled_time
        if inventory_parallel_limit is not None:
            self.__inventory_parallel_limit = inventory_parallel_limit
        if ui_version is not None:
            self.__ui_version = ui_version
        if lcm_version is not None:
            self.__lcm_version = lcm_version
        if semantic_version is not None:
            self.__semantic_version = semantic_version
        if build_type is not None:
            self.__build_type = build_type
        if skipped_precheck_names is not None:
            self.__skipped_precheck_names = skipped_precheck_names
        if product_meta_disabled is not None:
            self.__product_meta_disabled = product_meta_disabled
        if product_meta_url is not None:
            self.__product_meta_url = product_meta_url
        if recovery_disabled is not None:
            self.__recovery_disabled = recovery_disabled
        if is_darksite is not None:
            self.__is_darksite = is_darksite
        if enable_https is not None:
            self.__enable_https = enable_https
        if api_enabled is not None:
            self.__api_enabled = api_enabled
        if prism_api_timeout is not None:
            self.__prism_api_timeout = prism_api_timeout
        if distribute_inventory is not None:
            self.__distribute_inventory = distribute_inventory
        if user_preferences is not None:
            self.__user_preferences = user_preferences
        if metrics_enabled is not None:
            self.__metrics_enabled = metrics_enabled
        if supported_software_entities is not None:
            self.__supported_software_entities = supported_software_entities
        if deprecated_software_entities is not None:
            self.__deprecated_software_entities = deprecated_software_entities
        if uploaded_bundle is not None:
            self.__uploaded_bundle = uploaded_bundle
        if module_auto_upgrade_enabled is not None:
            self.__module_auto_upgrade_enabled = module_auto_upgrade_enabled
        if redfish_o_o_b_update_support is not None:
            self.__redfish_o_o_b_update_support = redfish_o_o_b_update_support
        if enable_auto_log_collection is not None:
            self.__enable_auto_log_collection = enable_auto_log_collection
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'lcm.v4.resources.LcmConfig'

    def _initialize_fq_object_type(self):
        return 'lcm.v4.r0.a1.resources.LcmConfig'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def url(self):
        """`{ str }`
            \nURL of the LCM repository.
        """ # noqa: E501
        return self.__url

    @url.setter
    def url(self, url):

        self.__url = url

    @property
    def auto_inventory_enabled(self):
        """`{ bool }`
            \nIndicates if the auto inventory operation is enabled. The default value is set to False
        """ # noqa: E501
        return self.__auto_inventory_enabled

    @auto_inventory_enabled.setter
    def auto_inventory_enabled(self, auto_inventory_enabled):

        self.__auto_inventory_enabled = auto_inventory_enabled

    @property
    def auto_inventory_scheduled_time(self):
        """`{ str }`
            \nThe scheduled time in \"%H:%M\" 24-hour format of the next inventory execution. Used when auto_inventory_enabled is set to True. The default schedule time is 03:00(AM)
        """ # noqa: E501
        return self.__auto_inventory_scheduled_time

    @auto_inventory_scheduled_time.setter
    def auto_inventory_scheduled_time(self, auto_inventory_scheduled_time):
        if auto_inventory_scheduled_time is not None and not re.search('^([01]\\d|2[0-3]):([0-5]\\d)$', auto_inventory_scheduled_time):  # noqa: E501
            raise ValueError(r"Invalid value for `auto_inventory_scheduled_time`, must be a follow pattern or equal to `/^([01]\\d|2[0-3]):([0-5]\\d)$/`")  # noqa: E501

        self.__auto_inventory_scheduled_time = auto_inventory_scheduled_time

    @property
    def inventory_parallel_limit(self):
        """`{ int }`
            \nNumber of parallel threads running inventory. The default value is set to 8
        """ # noqa: E501
        return self.__inventory_parallel_limit

    @inventory_parallel_limit.setter
    def inventory_parallel_limit(self, inventory_parallel_limit):
        if inventory_parallel_limit is not None and inventory_parallel_limit < 1:  # noqa: E501
            raise ValueError("Invalid value for `inventory_parallel_limit`, must be a value greater than or equal to `1`")  # noqa: E501

        self.__inventory_parallel_limit = inventory_parallel_limit

    @property
    def ui_version(self):
        """`{ str }`
            \nLCM UI version installed on the cluster
        """ # noqa: E501
        return self.__ui_version

    @ui_version.setter
    def ui_version(self, ui_version):

        self.__ui_version = ui_version

    @property
    def lcm_version(self):
        """`{ str }`
            \nLCM version installed on the cluster
        """ # noqa: E501
        return self.__lcm_version

    @lcm_version.setter
    def lcm_version(self, lcm_version):

        self.__lcm_version = lcm_version

    @property
    def semantic_version(self):
        """`{ str }`
            \nLCM semantic version installed on the cluster
        """ # noqa: E501
        return self.__semantic_version

    @semantic_version.setter
    def semantic_version(self, semantic_version):

        self.__semantic_version = semantic_version

    @property
    def build_type(self):
        """`{ str }`
            \nIndicates whether the LCM binaries in the URL are of type connected-site or dark-site
        """ # noqa: E501
        return self.__build_type

    @build_type.setter
    def build_type(self, build_type):

        self.__build_type = build_type

    @property
    def skipped_precheck_names(self):
        """`{ list[str] }`
            \nList of skipped prechecks.
        """ # noqa: E501
        return self.__skipped_precheck_names

    @skipped_precheck_names.setter
    def skipped_precheck_names(self, skipped_precheck_names):

        self.__skipped_precheck_names = skipped_precheck_names

    @property
    def product_meta_disabled(self):
        """`{ bool }`
            \nIndicates if Product Meta filtering is disabled. The default value is False.
        """ # noqa: E501
        return self.__product_meta_disabled

    @product_meta_disabled.setter
    def product_meta_disabled(self, product_meta_disabled):

        self.__product_meta_disabled = product_meta_disabled

    @property
    def product_meta_url(self):
        """`{ str }`
            \nURL for Product Meta artifact
        """ # noqa: E501
        return self.__product_meta_url

    @product_meta_url.setter
    def product_meta_url(self, product_meta_url):

        self.__product_meta_url = product_meta_url

    @property
    def recovery_disabled(self):
        """`{ bool }`
            \nLCM can automatically recover a benign failure in the early stages of an upgrade. This value indicates if that feature is enabled. The default value is False.
        """ # noqa: E501
        return self.__recovery_disabled

    @recovery_disabled.setter
    def recovery_disabled(self, recovery_disabled):

        self.__recovery_disabled = recovery_disabled

    @property
    def is_darksite(self):
        """`{ bool }`
            \nIndicates if LCM is pointing to a dark site. It is set to True if the LCM URL is not pointing to the default Nutanix portal URL.
        """ # noqa: E501
        return self.__is_darksite

    @is_darksite.setter
    def is_darksite(self, is_darksite):

        self.__is_darksite = is_darksite

    @property
    def enable_https(self):
        """`{ bool }`
            \nIndicates if the LCM URL has HTTPS enabled. The default value is True
        """ # noqa: E501
        return self.__enable_https

    @enable_https.setter
    def enable_https(self, enable_https):

        self.__enable_https = enable_https

    @property
    def api_enabled(self):
        """`{ bool }`
            \nIndicates if REST APIs for LCM is enabled. The default value is True
        """ # noqa: E501
        return self.__api_enabled

    @api_enabled.setter
    def api_enabled(self, api_enabled):

        self.__api_enabled = api_enabled

    @property
    def prism_api_timeout(self):
        """`{ int }`
            \nTimeout to send GET/POST requests to Prism
        """ # noqa: E501
        return self.__prism_api_timeout

    @prism_api_timeout.setter
    def prism_api_timeout(self, prism_api_timeout):

        self.__prism_api_timeout = prism_api_timeout

    @property
    def distribute_inventory(self):
        """`{ bool }`
            \nIndicates if LCM is enabled to distribute inventory across the cluster. The default value is True
        """ # noqa: E501
        return self.__distribute_inventory

    @distribute_inventory.setter
    def distribute_inventory(self, distribute_inventory):

        self.__distribute_inventory = distribute_inventory

    @property
    def user_preferences(self):
        """`{ list[lcm.v4.resources.UserPreference] }`
            \nIndicates the user preferences.
        """ # noqa: E501
        return self.__user_preferences

    @user_preferences.setter
    def user_preferences(self, user_preferences):

        self.__user_preferences = user_preferences

    @property
    def metrics_enabled(self):
        """`{ bool }`
            \nIndicates if metrics for LCM is enabled. The default value is True
        """ # noqa: E501
        return self.__metrics_enabled

    @metrics_enabled.setter
    def metrics_enabled(self, metrics_enabled):

        self.__metrics_enabled = metrics_enabled

    @property
    def supported_software_entities(self):
        """`{ list[str] }`
            \nList of entities for which One-Click upgrades are supported
        """ # noqa: E501
        return self.__supported_software_entities

    @supported_software_entities.setter
    def supported_software_entities(self, supported_software_entities):

        self.__supported_software_entities = supported_software_entities

    @property
    def deprecated_software_entities(self):
        """`{ list[str] }`
            \nList of entities for which One-Click upgrades are not available
        """ # noqa: E501
        return self.__deprecated_software_entities

    @deprecated_software_entities.setter
    def deprecated_software_entities(self, deprecated_software_entities):

        self.__deprecated_software_entities = deprecated_software_entities

    @property
    def uploaded_bundle(self):
        """`{ bool }`
            \nIndicates if the bundle is uploaded or not.
        """ # noqa: E501
        return self.__uploaded_bundle

    @uploaded_bundle.setter
    def uploaded_bundle(self, uploaded_bundle):

        self.__uploaded_bundle = uploaded_bundle

    @property
    def module_auto_upgrade_enabled(self):
        """`{ bool }`
            \nIndicates if LCM is enabled to auto-upgrade products. The default value is False.
        """ # noqa: E501
        return self.__module_auto_upgrade_enabled

    @module_auto_upgrade_enabled.setter
    def module_auto_upgrade_enabled(self, module_auto_upgrade_enabled):

        self.__module_auto_upgrade_enabled = module_auto_upgrade_enabled

    @property
    def redfish_o_o_b_update_support(self):
        """`{ bool }`
            \nIndicates if Redfish out of band update is enabled. The default value is False.
        """ # noqa: E501
        return self.__redfish_o_o_b_update_support

    @redfish_o_o_b_update_support.setter
    def redfish_o_o_b_update_support(self, redfish_o_o_b_update_support):

        self.__redfish_o_o_b_update_support = redfish_o_o_b_update_support

    @property
    def enable_auto_log_collection(self):
        """`{ bool }`
            \nIndicates if automatic log collection on failures is enabled or not. The default value is True
        """ # noqa: E501
        return self.__enable_auto_log_collection

    @enable_auto_log_collection.setter
    def enable_auto_log_collection(self, enable_auto_log_collection):

        self.__enable_auto_log_collection = enable_auto_log_collection

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LcmConfig, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LcmConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

