# coding: utf-8


"""
IGNORE:
    Nutanix Lcm Versioned APIs

    Manage Infrastructure, Software and Firmware Upgrades.  # noqa: E501

    OpenAPI spec version: 4.0.1-alpha-1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
IGNORE
"""
import pprint
import json
import ast
import re  # noqa: F401

import six
from ntnx_lcm_py_client.Ntnx.lcm.v4.common.LcmAvailableVersionStatus import LcmAvailableVersionStatus  # noqa: F401,E501
from ntnx_lcm_py_client.Ntnx.lcm.v4.resources.LcmDependency import LcmDependency  # noqa: F401,E501

"""
IGNORE:
NOTE: This class is auto generated by the swagger code generator program.

Do not edit the class manually.
IGNORE
"""


class LcmAvailableVersion(object):
    """LcmAvailableVersion - a model defined in Swagger"""
    """
    IGNORE:
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    IGNORE
    """ # noqa: E501
    swagger_types = {
        'version': 'str',
        'status': 'lcm.v4.common.LcmAvailableVersionStatus',
        'is_enabled': 'bool',
        'uuid': 'str',
        'order': 'int',
        'disable_reason': 'str',
        'release_notes': 'str',
        'release_date': 'str',
        'other_metadata': 'str',
        'child_entities': 'object',
        'single_group_uuid': 'str',
        'dependencies': 'list[lcm.v4.resources.LcmDependency]',
        '_reserved': 'dict(str, object)',
        '_object_type': 'str',
        '_unknown_fields': 'dict(str, object)',
    }

    attribute_map = {
        'version': 'version',
        'status': 'status',
        'is_enabled': 'isEnabled',
        'uuid': 'uuid',
        'order': 'order',
        'disable_reason': 'disableReason',
        'release_notes': 'releaseNotes',
        'release_date': 'releaseDate',
        'other_metadata': 'otherMetadata',
        'child_entities': 'childEntities',
        'single_group_uuid': 'singleGroupUuid',
        'dependencies': 'dependencies',
        '_reserved': '$reserved',
        '_object_type': '$objectType',
        '_unknown_fields': '$unknownFields',
    }



    def __init__(self, version=None, status=None, is_enabled=None, uuid=None, order=None, disable_reason=None, release_notes=None, release_date=None, other_metadata=None, child_entities=None, single_group_uuid=None, dependencies=None, *args, **kwargs):  # noqa: E501
        """LcmAvailableVersion - a model defined in Swagger
            \nAvailable version for an LCM entity to update
        """
        self.__version = None
        self.__status = None
        self.__is_enabled = None
        self.__uuid = None
        self.__order = None
        self.__disable_reason = None
        self.__release_notes = None
        self.__release_date = None
        self.__other_metadata = None
        self.__child_entities = None
        self.__single_group_uuid = None
        self.__dependencies = None
        self.discriminator = None
        if version is not None:
            self.__version = version
        if status is not None:
            self.__status = status
        if is_enabled is not None:
            self.__is_enabled = is_enabled
        if uuid is not None:
            self.__uuid = uuid
        if order is not None:
            self.__order = order
        if disable_reason is not None:
            self.__disable_reason = disable_reason
        if release_notes is not None:
            self.__release_notes = release_notes
        if release_date is not None:
            self.__release_date = release_date
        if other_metadata is not None:
            self.__other_metadata = other_metadata
        if child_entities is not None:
            self.__child_entities = child_entities
        if single_group_uuid is not None:
            self.__single_group_uuid = single_group_uuid
        if dependencies is not None:
            self.__dependencies = dependencies
        # populate hidden vars if not empty
        self._populate_hidden_vars(kwargs)

    def _initialize_object_type(self):
        return 'lcm.v4.resources.LcmAvailableVersion'

    def _initialize_fq_object_type(self):
        return 'lcm.v4.r0.a1.resources.LcmAvailableVersion'

    def _populate_hidden_vars(self, kwargs):
        if "_reserved" in kwargs and kwargs["_reserved"] is not None:
            self.__dollar_reserved = kwargs["_reserved"]
        elif "_reserved" in self.attribute_map and self.attribute_map["_reserved"] in kwargs and kwargs[self.attribute_map["_reserved"]] is not None:
            self.__dollar_reserved = kwargs[self.attribute_map["_reserved"]]
        else :
            self.__dollar_reserved = {"$fqObjectType": self._initialize_fq_object_type()}
        if "_unknown_fields" in kwargs and kwargs["_unknown_fields"] is not None:
            self.__dollar_unknown_fields = kwargs["_unknown_fields"]
        elif "_unknown_fields" in self.attribute_map and self.attribute_map["_unknown_fields"] in kwargs and kwargs[self.attribute_map["_unknown_fields"]] is not None:
            self.__dollar_unknown_fields = kwargs[self.attribute_map["_unknown_fields"]]
        else :
            self.__dollar_unknown_fields = {}
        if "_object_type" in kwargs and kwargs["_object_type"] is not None:
            self.__dollar_object_type = kwargs["_object_type"]
        elif "_object_type" in self.attribute_map and self.attribute_map["_object_type"] in kwargs and kwargs[self.attribute_map["_object_type"]] is not None:
            self.__dollar_object_type = kwargs[self.attribute_map["_object_type"]]
        else:
            self.__dollar_object_type = self._initialize_object_type()

    def get_object_type(self):
        return self.__dollar_object_type

    def get_reserved(self):
        return self.__dollar_reserved

    def get_unknown_fields(self):
        return self.__dollar_unknown_fields

    @property
    def version(self):
        """`{ str }`
            \nAvailable version for the LCM entity
        """ # noqa: E501
        return self.__version

    @version.setter
    def version(self, version):

        self.__version = version

    @property
    def status(self):
        """`{ lcm.v4.common.LcmAvailableVersionStatus }`
            
        """ # noqa: E501
        return self.__status

    @status.setter
    def status(self, status):

        self.__status = status

    @property
    def is_enabled(self):
        """`{ bool }`
            \nIndicates if the available update is enabled
        """ # noqa: E501
        return self.__is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):

        self.__is_enabled = is_enabled

    @property
    def uuid(self):
        """`{ str }`
            \nUUID of the entity to be used
        """ # noqa: E501
        return self.__uuid

    @uuid.setter
    def uuid(self, uuid):
        if uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__uuid = uuid

    @property
    def order(self):
        """`{ int }`
            \nOrder of this available version (1 being the lowest and 6 being the highest) when multiple versions are present with different status.
        """ # noqa: E501
        return self.__order

    @order.setter
    def order(self, order):

        self.__order = order

    @property
    def disable_reason(self):
        """`{ str }`
            \nReason for disabling the available version
        """ # noqa: E501
        return self.__disable_reason

    @disable_reason.setter
    def disable_reason(self, disable_reason):

        self.__disable_reason = disable_reason

    @property
    def release_notes(self):
        """`{ str }`
            \nRelease notes corresponding to the update
        """ # noqa: E501
        return self.__release_notes

    @release_notes.setter
    def release_notes(self, release_notes):

        self.__release_notes = release_notes

    @property
    def release_date(self):
        """`{ str }`
            \nRelease date for the entities that need this information
        """ # noqa: E501
        return self.__release_date

    @release_date.setter
    def release_date(self, release_date):

        self.__release_date = release_date

    @property
    def other_metadata(self):
        """`{ str }`
            \nUpdate metadata other than the release notes - like a custom message
        """ # noqa: E501
        return self.__other_metadata

    @other_metadata.setter
    def other_metadata(self, other_metadata):

        self.__other_metadata = other_metadata

    @property
    def child_entities(self):
        """`{ object }`
            \nComponent information for the payload based entity
        """ # noqa: E501
        return self.__child_entities

    @child_entities.setter
    def child_entities(self, child_entities):

        self.__child_entities = child_entities

    @property
    def single_group_uuid(self):
        """`{ str }`
            \nUUID of the group that this LCM entity is part of
        """ # noqa: E501
        return self.__single_group_uuid

    @single_group_uuid.setter
    def single_group_uuid(self, single_group_uuid):
        if single_group_uuid is not None and not re.search('^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$', single_group_uuid):  # noqa: E501
            raise ValueError(r"Invalid value for `single_group_uuid`, must be a follow pattern or equal to `/^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/`")  # noqa: E501

        self.__single_group_uuid = single_group_uuid

    @property
    def dependencies(self):
        """`{ list[lcm.v4.resources.LcmDependency] }`
            \nList of dependencies for the available version.
        """ # noqa: E501
        return self.__dependencies

    @dependencies.setter
    def dependencies(self, dependencies):

        self.__dependencies = dependencies

    @property
    def _reserved(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_reserved

    @property
    def _object_type(self):
        """`{ str }`
            
        """ # noqa: E501
        return self.__dollar_object_type

    @property
    def _unknown_fields(self):
        """`{ dict(str, object) }`
            
        """ # noqa: E501
        return self.__dollar_unknown_fields

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, attr_type in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LcmAvailableVersion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LcmAvailableVersion):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other

