# -*- coding: utf-8 -*-
from setuptools import setup

# read the contents of your README file
from pathlib import Path
this_directory = Path(__file__).parent
long_description = (this_directory / "README.md").read_text()

packages = ['impactrun']

package_data = {
    '': ['*'],
    'impactrun': [
        'templates/*',
        'templates/assets/images/*',
        'templates/assets/images/charts/*',
        'templates/assets/styles/*',
        'templates/html/*',
        'templates/data/*',
        'new_templates/*',
        'new_templates/assets/images/*',
        'new_templates/assets/scripts/*',
        'new_templates/styles/*',
        'new_templates/webfonts/*',
        'fuzzdb/*',
        'fuzzdb/attack/*',
        'fuzzdb/attack/all-attacks/*',
        'fuzzdb/attack/authentication/*',
        'fuzzdb/attack/business-logic/*',
        'fuzzdb/attack/control-chars/*',
        'fuzzdb/attack/disclosure-directory/*',
        'fuzzdb/attack/disclosure-localpaths/unix/*',
        'fuzzdb/attack/disclosure-source/*',
        'fuzzdb/attack/email/*',
        'fuzzdb/attack/file-upload/*',
        'fuzzdb/attack/file-upload/malicious-images/*',
        'fuzzdb/attack/format-strings/*',
        'fuzzdb/attack/html_js_fuzz/*',
        'fuzzdb/attack/http-protocol/*',
        'fuzzdb/attack/integer-overflow/*',
        'fuzzdb/attack/ip/*',
        'fuzzdb/attack/json/*',
        'fuzzdb/attack/ldap/*',
        'fuzzdb/attack/lfi/*',
        'fuzzdb/attack/mimetypes/*',
        'fuzzdb/attack/no-sql-injection/*',
        'fuzzdb/attack/os-cmd-execution/*',
        'fuzzdb/attack/os-dir-indexing/*',
        'fuzzdb/attack/path-traversal/*',
        'fuzzdb/attack/redirect/*',
        'fuzzdb/attack/rfi/*',
        'fuzzdb/attack/server-side-include/*',
        'fuzzdb/attack/sql-injection/detect/*',
        'fuzzdb/attack/sql-injection/exploit/*',
        'fuzzdb/attack/sql-injection/payloads-sql-blind/*',
        'fuzzdb/attack/string-expansion/*',
        'fuzzdb/attack/unicode/*',
        'fuzzdb/attack/xml/*',
        'fuzzdb/attack/xpath/*',
        'fuzzdb/attack/xss/*',
        'fuzzdb/discovery/URI_SCHEMES/*',
        'fuzzdb/discovery/UserAgent/*',
        'fuzzdb/discovery/WebSocket/*',
        'fuzzdb/discovery/common-methods/*',
        'fuzzdb/discovery/dns/*',
        'fuzzdb/discovery/predictable-filepaths/*',
        'fuzzdb/discovery/predictable-filepaths/backdoors/*',
        'fuzzdb/discovery/predictable-filepaths/cgi/*',
        'fuzzdb/discovery/predictable-filepaths/cms/*',
        'fuzzdb/discovery/predictable-filepaths/filename-dirname-bruteforce/*',
        'fuzzdb/discovery/predictable-filepaths/login-file-locations/*',
        'fuzzdb/discovery/predictable-filepaths/password-file-locations/*',
        'fuzzdb/discovery/predictable-filepaths/php/*',
        'fuzzdb/discovery/predictable-filepaths/webservers-appservers/*',
        'fuzzdb/docs/attack-docs/*',
        'fuzzdb/docs/attack-docs/remote-cmd-exfiltration/*',
        'fuzzdb/docs/attack-docs/sqli/*',
        'fuzzdb/docs/attack-docs/waf-bypass/*',
        'fuzzdb/docs/attack-docs/xss/docs.wasc-scriptmapping/*',
        'fuzzdb/docs/attack-docs/xss/docs.wasc-scriptmapping/images/*',
        'fuzzdb/docs/misc/*',
        'fuzzdb/regex/*',
        'fuzzdb/web-backdoors/*',
        'fuzzdb/web-backdoors/asp/*',
        'fuzzdb/web-backdoors/c/*',
        'fuzzdb/web-backdoors/cfm/*',
        'fuzzdb/web-backdoors/exe/*',
        'fuzzdb/web-backdoors/jsp/*',
        'fuzzdb/web-backdoors/jsp/laudanum/*',
        'fuzzdb/web-backdoors/jsp/laudanum/warfiles/*',
        'fuzzdb/web-backdoors/jsp/laudanum/warfiles/META-INF/*',
        'fuzzdb/web-backdoors/jsp/laudanum/warfiles/WEB-INF/*',
        'fuzzdb/web-backdoors/jsp/win32/*',
        'fuzzdb/web-backdoors/php/*',
        'fuzzdb/web-backdoors/pl-cgi/*',
        'fuzzdb/web-backdoors/servlet/*',
        'fuzzdb/web-backdoors/sh/*',
        'fuzzdb/web-backdoors/wordpress/*',
        'fuzzdb/web-backdoors/wordpress/templates/*',
        'fuzzdb/wordlists-misc/*',
        'fuzzdb/wordlists-user-passwd/*',
        'fuzzdb/wordlists-user-passwd/db2/*',
        'fuzzdb/wordlists-user-passwd/generic-listpairs/*',
        'fuzzdb/wordlists-user-passwd/names/*',
        'fuzzdb/wordlists-user-passwd/oracle/*',
        'fuzzdb/wordlists-user-passwd/passwds/*',
        'fuzzdb/wordlists-user-passwd/postgres/*',
        'fuzzdb/wordlists-user-passwd/tomcat/*',
        'fuzzdb/wordlists-user-passwd/unix-os/*',
    ]
}

install_requires = [
    'PyYAML==6.0',
    'autopep8==1.7.0',
    'curlify==2.2.1',
    'cvapianalyser==1.43.7',
    'dictor==0.1.10',
    'jinja2==3.1.2',
    'nested-lookup==0.2.25',
    'openapispecdiff==1.43.9',
    'pytest-cases==3.6.13',
    'pytest-html==3.1.1',
    'pytest-metadata==2.0.2',
    'pytest-json==0.4.0',
    'pytest-lazy-fixture==0.6.3',
    'pytest-rerunfailures==10.2',
    'pytest-testrail==2.9.0',
    'pytest-timeout==2.1.0',
    'pytest==7.1.3',
    'requests==2.28.1',
    'tqdm==4.64.1',
    'MarkupSafe==2.0.1',
    'validators==0.20.0'
]

entry_points = {'console_scripts': ['impactrun = impactrun.entry:main']}

setup_kwargs = {
    'name': 'impactrun',
    'version': '2.0.4',
    'description': 'To regenerate pytest fixtures and test methods dynamically from OpenAPI spec and Cloudvector APIShark events',
    'long_description': long_description,
    'long_description_content_type': 'text/markdown',
    'author': 'Priyank Chheda',
    'author_email': 'priyank.chheda@imperva.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
