# coding: utf-8

"""
    KFM - Application API

    KFM manages and stores key fragments. The core operations of each KFM instance are as follows: Creating secure random encryption keys which will be used as an encryption key fragment. Managing data storage for key fragments. Performing a key fragment derivation function, which generates a derived fragment from the original key fragment.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class RoleAuthMethodAssociation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'assoc_id': 'str',
        'auth_method_access_id': 'str',
        'auth_method_name': 'str',
        'auth_method_sub_claims': 'dict(str, list[str])'
    }

    attribute_map = {
        'assoc_id': 'assoc_id',
        'auth_method_access_id': 'auth_method_access_id',
        'auth_method_name': 'auth_method_name',
        'auth_method_sub_claims': 'auth_method_sub_claims'
    }

    def __init__(self, assoc_id=None, auth_method_access_id=None, auth_method_name=None, auth_method_sub_claims=None):  # noqa: E501
        """RoleAuthMethodAssociation - a model defined in Swagger"""  # noqa: E501

        self._assoc_id = None
        self._auth_method_access_id = None
        self._auth_method_name = None
        self._auth_method_sub_claims = None
        self.discriminator = None

        if assoc_id is not None:
            self.assoc_id = assoc_id
        if auth_method_access_id is not None:
            self.auth_method_access_id = auth_method_access_id
        if auth_method_name is not None:
            self.auth_method_name = auth_method_name
        if auth_method_sub_claims is not None:
            self.auth_method_sub_claims = auth_method_sub_claims

    @property
    def assoc_id(self):
        """Gets the assoc_id of this RoleAuthMethodAssociation.  # noqa: E501


        :return: The assoc_id of this RoleAuthMethodAssociation.  # noqa: E501
        :rtype: str
        """
        return self._assoc_id

    @assoc_id.setter
    def assoc_id(self, assoc_id):
        """Sets the assoc_id of this RoleAuthMethodAssociation.


        :param assoc_id: The assoc_id of this RoleAuthMethodAssociation.  # noqa: E501
        :type: str
        """

        self._assoc_id = assoc_id

    @property
    def auth_method_access_id(self):
        """Gets the auth_method_access_id of this RoleAuthMethodAssociation.  # noqa: E501


        :return: The auth_method_access_id of this RoleAuthMethodAssociation.  # noqa: E501
        :rtype: str
        """
        return self._auth_method_access_id

    @auth_method_access_id.setter
    def auth_method_access_id(self, auth_method_access_id):
        """Sets the auth_method_access_id of this RoleAuthMethodAssociation.


        :param auth_method_access_id: The auth_method_access_id of this RoleAuthMethodAssociation.  # noqa: E501
        :type: str
        """

        self._auth_method_access_id = auth_method_access_id

    @property
    def auth_method_name(self):
        """Gets the auth_method_name of this RoleAuthMethodAssociation.  # noqa: E501


        :return: The auth_method_name of this RoleAuthMethodAssociation.  # noqa: E501
        :rtype: str
        """
        return self._auth_method_name

    @auth_method_name.setter
    def auth_method_name(self, auth_method_name):
        """Sets the auth_method_name of this RoleAuthMethodAssociation.


        :param auth_method_name: The auth_method_name of this RoleAuthMethodAssociation.  # noqa: E501
        :type: str
        """

        self._auth_method_name = auth_method_name

    @property
    def auth_method_sub_claims(self):
        """Gets the auth_method_sub_claims of this RoleAuthMethodAssociation.  # noqa: E501


        :return: The auth_method_sub_claims of this RoleAuthMethodAssociation.  # noqa: E501
        :rtype: dict(str, list[str])
        """
        return self._auth_method_sub_claims

    @auth_method_sub_claims.setter
    def auth_method_sub_claims(self, auth_method_sub_claims):
        """Sets the auth_method_sub_claims of this RoleAuthMethodAssociation.


        :param auth_method_sub_claims: The auth_method_sub_claims of this RoleAuthMethodAssociation.  # noqa: E501
        :type: dict(str, list[str])
        """

        self._auth_method_sub_claims = auth_method_sub_claims

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(RoleAuthMethodAssociation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoleAuthMethodAssociation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
