# coding: utf-8

"""
    KFM - Application API

    KFM manages and stores key fragments. The core operations of each KFM instance are as follows: Creating secure random encryption keys which will be used as an encryption key fragment. Managing data storage for key fragments. Performing a key fragment derivation function, which generates a derived fragment from the original key fragment.  # noqa: E501

    OpenAPI spec version: 0.1.0
    Contact: refael@akeyless-security.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from akeyless_kfm_api.models.access_rules import AccessRules  # noqa: F401,E501
from akeyless_kfm_api.models.access_rules_type import AccessRulesType  # noqa: F401,E501
from akeyless_kfm_api.models.access_type import AccessType  # noqa: F401,E501


class GetAccessReplyObj(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_id': 'str',
        'access_rules_type': 'AccessRulesType',
        'access_type': 'AccessType',
        'account_id': 'str',
        'attaches': 'str',
        'comment': 'str',
        'expires': 'int',
        'rules': 'AccessRules'
    }

    attribute_map = {
        'access_id': 'access_id',
        'access_rules_type': 'access_rules_type',
        'access_type': 'access_type',
        'account_id': 'account_id',
        'attaches': 'attaches',
        'comment': 'comment',
        'expires': 'expires',
        'rules': 'rules'
    }

    def __init__(self, access_id=None, access_rules_type=None, access_type=None, account_id=None, attaches=None, comment=None, expires=None, rules=None):  # noqa: E501
        """GetAccessReplyObj - a model defined in Swagger"""  # noqa: E501

        self._access_id = None
        self._access_rules_type = None
        self._access_type = None
        self._account_id = None
        self._attaches = None
        self._comment = None
        self._expires = None
        self._rules = None
        self.discriminator = None

        if access_id is not None:
            self.access_id = access_id
        if access_rules_type is not None:
            self.access_rules_type = access_rules_type
        if access_type is not None:
            self.access_type = access_type
        if account_id is not None:
            self.account_id = account_id
        if attaches is not None:
            self.attaches = attaches
        if comment is not None:
            self.comment = comment
        if expires is not None:
            self.expires = expires
        if rules is not None:
            self.rules = rules

    @property
    def access_id(self):
        """Gets the access_id of this GetAccessReplyObj.  # noqa: E501

        Access id.  # noqa: E501

        :return: The access_id of this GetAccessReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._access_id

    @access_id.setter
    def access_id(self, access_id):
        """Sets the access_id of this GetAccessReplyObj.

        Access id.  # noqa: E501

        :param access_id: The access_id of this GetAccessReplyObj.  # noqa: E501
        :type: str
        """

        self._access_id = access_id

    @property
    def access_rules_type(self):
        """Gets the access_rules_type of this GetAccessReplyObj.  # noqa: E501


        :return: The access_rules_type of this GetAccessReplyObj.  # noqa: E501
        :rtype: AccessRulesType
        """
        return self._access_rules_type

    @access_rules_type.setter
    def access_rules_type(self, access_rules_type):
        """Sets the access_rules_type of this GetAccessReplyObj.


        :param access_rules_type: The access_rules_type of this GetAccessReplyObj.  # noqa: E501
        :type: AccessRulesType
        """

        self._access_rules_type = access_rules_type

    @property
    def access_type(self):
        """Gets the access_type of this GetAccessReplyObj.  # noqa: E501


        :return: The access_type of this GetAccessReplyObj.  # noqa: E501
        :rtype: AccessType
        """
        return self._access_type

    @access_type.setter
    def access_type(self, access_type):
        """Sets the access_type of this GetAccessReplyObj.


        :param access_type: The access_type of this GetAccessReplyObj.  # noqa: E501
        :type: AccessType
        """

        self._access_type = access_type

    @property
    def account_id(self):
        """Gets the account_id of this GetAccessReplyObj.  # noqa: E501

        Account id.  # noqa: E501

        :return: The account_id of this GetAccessReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this GetAccessReplyObj.

        Account id.  # noqa: E501

        :param account_id: The account_id of this GetAccessReplyObj.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def attaches(self):
        """Gets the attaches of this GetAccessReplyObj.  # noqa: E501

        Access attaches  # noqa: E501

        :return: The attaches of this GetAccessReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._attaches

    @attaches.setter
    def attaches(self, attaches):
        """Sets the attaches of this GetAccessReplyObj.

        Access attaches  # noqa: E501

        :param attaches: The attaches of this GetAccessReplyObj.  # noqa: E501
        :type: str
        """

        self._attaches = attaches

    @property
    def comment(self):
        """Gets the comment of this GetAccessReplyObj.  # noqa: E501

        Comments  # noqa: E501

        :return: The comment of this GetAccessReplyObj.  # noqa: E501
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this GetAccessReplyObj.

        Comments  # noqa: E501

        :param comment: The comment of this GetAccessReplyObj.  # noqa: E501
        :type: str
        """

        self._comment = comment

    @property
    def expires(self):
        """Gets the expires of this GetAccessReplyObj.  # noqa: E501

        Access expiration date.  # noqa: E501

        :return: The expires of this GetAccessReplyObj.  # noqa: E501
        :rtype: int
        """
        return self._expires

    @expires.setter
    def expires(self, expires):
        """Sets the expires of this GetAccessReplyObj.

        Access expiration date.  # noqa: E501

        :param expires: The expires of this GetAccessReplyObj.  # noqa: E501
        :type: int
        """

        self._expires = expires

    @property
    def rules(self):
        """Gets the rules of this GetAccessReplyObj.  # noqa: E501


        :return: The rules of this GetAccessReplyObj.  # noqa: E501
        :rtype: AccessRules
        """
        return self._rules

    @rules.setter
    def rules(self, rules):
        """Sets the rules of this GetAccessReplyObj.


        :param rules: The rules of this GetAccessReplyObj.  # noqa: E501
        :type: AccessRules
        """

        self._rules = rules

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(GetAccessReplyObj, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, GetAccessReplyObj):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
