# akeyless-kfm-api
KFM manages and stores key fragments. The core operations of each KFM instance are as follows: Creating secure random encryption keys which will be used as an encryption key fragment. Managing data storage for key fragments. Performing a key fragment derivation function, which generates a derived fragment from the original key fragment.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0.1.0
- Package version: 0.1.1
- Build package: io.swagger.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.akeyless-security.com](https://www.akeyless-security.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import akeyless_kfm_api 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import akeyless_kfm_api
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import akeyless_kfm_api
from akeyless_kfm_api.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = akeyless_kfm_api.DefaultApi(akeyless_kfm_api.ApiClient(configuration))
akeyless_kfm_access_creds = 'akeyless_kfm_access_creds_example' # str | Temporary credentials for accessing the endpoint
akeyless_kfm_operation_creds = 'akeyless_kfm_operation_creds_example' # str | Temporary credentials for performing the operation
derivation_data = 'derivation_data_example' # str | The derivation data to be used for the fragment derivation operation
akeyless_request_id = 'akeyless_request_id_example' # str | Request Id for logging (optional)
akeyless_client_id = 'akeyless_client_id_example' # str | Client Id for logging (optional)
double_derivation = true # bool | Indicate if perform a double derivation (optional)

try:
    # Returns a derived fragment from the origin fragment via the supplied derivation data.
    api_response = api_instance.derive_fragment(akeyless_kfm_access_creds, akeyless_kfm_operation_creds, derivation_data, akeyless_request_id=akeyless_request_id, akeyless_client_id=akeyless_client_id, double_derivation=double_derivation)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->derive_fragment: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://$HOST*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**derive_fragment**](docs/DefaultApi.md#derive_fragment) | **POST** /derive-fragment | Returns a derived fragment from the origin fragment via the supplied derivation data.
*DefaultApi* | [**generate_aes_key_fragment**](docs/DefaultApi.md#generate_aes_key_fragment) | **POST** /generate-aes-key-fragment | Generate a new key fragment.
*DefaultApi* | [**get_fragment_details**](docs/DefaultApi.md#get_fragment_details) | **POST** /get-fragment-details | 
*DefaultApi* | [**get_status**](docs/DefaultApi.md#get_status) | **GET** /status | 
*DefaultApi* | [**get_time**](docs/DefaultApi.md#get_time) | **GET** /time | 
*DefaultApi* | [**rsa_fragment_decrypt**](docs/DefaultApi.md#rsa_fragment_decrypt) | **POST** /rsa-fragment-decrypt | Returns a fragmented decryption result on an RSA fragment.
*DefaultApi* | [**upload_rsa_fragment**](docs/DefaultApi.md#upload_rsa_fragment) | **POST** /upload-rsa-fragment | 


## Documentation For Models

 - [APIKeyAccessRules](docs/APIKeyAccessRules.md)
 - [AccessParams](docs/AccessParams.md)
 - [AccessRules](docs/AccessRules.md)
 - [AccessRulesType](docs/AccessRulesType.md)
 - [AccessType](docs/AccessType.md)
 - [AccountReplyObj](docs/AccountReplyObj.md)
 - [AccountStatus](docs/AccountStatus.md)
 - [Algorithm](docs/Algorithm.md)
 - [AuthMethodAccessInfo](docs/AuthMethodAccessInfo.md)
 - [AuthMethodRoleAssociation](docs/AuthMethodRoleAssociation.md)
 - [AuthStatusReplyObj](docs/AuthStatusReplyObj.md)
 - [AzureADAccessRules](docs/AzureADAccessRules.md)
 - [CreateAccessReplyObj](docs/CreateAccessReplyObj.md)
 - [CreateAccountCredsParams](docs/CreateAccountCredsParams.md)
 - [CreateAuthMethodReplyObj](docs/CreateAuthMethodReplyObj.md)
 - [CreateRoleAuthMethodAssocReplyObj](docs/CreateRoleAuthMethodAssocReplyObj.md)
 - [CredentialsReplyObj](docs/CredentialsReplyObj.md)
 - [DerivationCredsReplyObj](docs/DerivationCredsReplyObj.md)
 - [DerivedFragmentReplyObj](docs/DerivedFragmentReplyObj.md)
 - [DynamicSecretMQAccessReplyObj](docs/DynamicSecretMQAccessReplyObj.md)
 - [DynamicSecretMessageQueueInfo](docs/DynamicSecretMessageQueueInfo.md)
 - [DynamicSecretProducerCredsReplyObj](docs/DynamicSecretProducerCredsReplyObj.md)
 - [ErrorReplyObj](docs/ErrorReplyObj.md)
 - [FragmentType](docs/FragmentType.md)
 - [FragmentsDerivationsCreds](docs/FragmentsDerivationsCreds.md)
 - [GetAccessReplyObj](docs/GetAccessReplyObj.md)
 - [GetAccessesReplyObj](docs/GetAccessesReplyObj.md)
 - [GetAccountAuthMethodsReplyObj](docs/GetAccountAuthMethodsReplyObj.md)
 - [GetAccountDetailsReplyObj](docs/GetAccountDetailsReplyObj.md)
 - [GetAccountRolesReplyObj](docs/GetAccountRolesReplyObj.md)
 - [GetAuthMethodReplyObj](docs/GetAuthMethodReplyObj.md)
 - [GetFragmentDetailsReplyObj](docs/GetFragmentDetailsReplyObj.md)
 - [GetItemReplyObj](docs/GetItemReplyObj.md)
 - [GetRoleReplyObj](docs/GetRoleReplyObj.md)
 - [KFMStatusReplyObj](docs/KFMStatusReplyObj.md)
 - [LdapAccessRules](docs/LdapAccessRules.md)
 - [ListItemsInPathReplyObj](docs/ListItemsInPathReplyObj.md)
 - [ListItemsReplyObj](docs/ListItemsReplyObj.md)
 - [OAuth2AccessRules](docs/OAuth2AccessRules.md)
 - [OAuth2CustomClaim](docs/OAuth2CustomClaim.md)
 - [PathRule](docs/PathRule.md)
 - [PrepareDynamicSecretValueReplyObj](docs/PrepareDynamicSecretValueReplyObj.md)
 - [PublicSigningKeyReplyObj](docs/PublicSigningKeyReplyObj.md)
 - [PullDynamicSecretValueReplyObj](docs/PullDynamicSecretValueReplyObj.md)
 - [RSADecryptCreds](docs/RSADecryptCreds.md)
 - [RSADecryptCredsReplyObj](docs/RSADecryptCredsReplyObj.md)
 - [RSAFragmentDecryptReplyObj](docs/RSAFragmentDecryptReplyObj.md)
 - [RoleAuthMethodAssociation](docs/RoleAuthMethodAssociation.md)
 - [Rules](docs/Rules.md)
 - [SSHCertIssuerAccessCredsReplyObj](docs/SSHCertIssuerAccessCredsReplyObj.md)
 - [SSHCertificateIssueDetails](docs/SSHCertificateIssueDetails.md)
 - [SSHCertificateParams](docs/SSHCertificateParams.md)
 - [SSHCertificateType](docs/SSHCertificateType.md)
 - [SamlAccessRules](docs/SamlAccessRules.md)
 - [SamlAttribute](docs/SamlAttribute.md)
 - [SecretAccessCredsReplyObj](docs/SecretAccessCredsReplyObj.md)
 - [SetItemRequestBodyParams](docs/SetItemRequestBodyParams.md)
 - [SetRoleRequestParams](docs/SetRoleRequestParams.md)
 - [SetUAMAccessCredsParams](docs/SetUAMAccessCredsParams.md)
 - [SystemAccessCredentialsReplyObj](docs/SystemAccessCredentialsReplyObj.md)
 - [TimeReplyObj](docs/TimeReplyObj.md)
 - [UAMStatusReplyObj](docs/UAMStatusReplyObj.md)
 - [UpdateAccessMode](docs/UpdateAccessMode.md)
 - [UploadRSAFragmentReplyObj](docs/UploadRSAFragmentReplyObj.md)
 - [UploadRSAKeyCredsReplyObj](docs/UploadRSAKeyCredsReplyObj.md)
 - [ValidateClientCredsReplyObj](docs/ValidateClientCredsReplyObj.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author

refael@akeyless-security.com

