import enum


@enum.unique
class AGICommand(str, enum.Enum):
    ANSWER = 'ANSWER'
    CHANNEL_STATUS = 'CHANNEL STATUS'
    CONTROL_STREAM_FILE = 'CONTROL STREAM FILE'
    DATABASE_GET = 'DATABASE GET'
    DATABASE_PUT = 'DATABASE PUT'
    DATABASE_DEL = 'DATABASE DEL'
    DATABASE_DELTREE = 'DATABASE DELTREE'
    EXEC = 'EXEC'
    GET_DATA = 'GET DATA'
    GET_FULL_VARIABLE = 'GET FULL VARIABLE'
    GET_OPTION = 'GET OPTION'
    GET_VARIABLE = 'GET VARIABLE'
    GOSUB = 'GOSUB'
    HANGUP = 'HANGUP'
    NOOP = 'NOOP'
    RECEIVE_CHAR = 'RECEIVE CHAR'
    RECEIVE_TEXT = 'RECEIVE TEXT'
    RECORD_FILE = 'RECORD FILE'
    SAY_ALPHA = 'SAY ALPHA'
    SAY_DATE = 'SAY DATE'
    SAY_DATETIME = 'SAY DATETIME'
    SAY_DIGITS = 'SAY DIGITS'
    SAY_NUMBER = 'SAY NUMBER'
    SAY_PHONETIC = 'SAY PHONETIC'
    SAY_TIME = 'SAY TIME'
    SEND_IMAGE = 'SEND IMAGE'
    SEND_TEXT = 'SEND TEXT'
    SET_AUTOHANGUP = 'SET AUTOHANGUP'
    SET_CALLERID = 'SET CALLERID'
    SET_CONTEXT = 'SET CONTEXT'
    SET_MUSIC = 'SET MUSIC'
    SET_EXTENSION = 'SET EXTENSION'
    SET_PRIORITY = 'SET PRIORITY'
    SET_VARIABLE = 'SET VARIABLE'
    STREAM_FILE = 'STREAM FILE'
    TDD_MODE = 'TDD MODE'
    VERBOSE = 'VERBOSE'
    WAIT_FOR_DIGIT = 'WAIT FOR DIGIT'
