# mypy-boto3-codedeploy

[![PyPI - mypy-boto3-codedeploy](https://img.shields.io/pypi/v/mypy-boto3-codedeploy.svg?color=blue)](https://pypi.org/project/mypy-boto3-codedeploy)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codedeploy.svg?color=blue)](https://pypi.org/project/mypy-boto3-codedeploy)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CodeDeploy 1.12.47](https://boto3.amazonaws.com/v1/documentation/api/1.12.47/reference/services/codedeploy.html#CodeDeploy) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.7](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-codedeploy](#mypy-boto3-codedeploy)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `CodeDeploy` service.

```bash
python -m pip install boto3-stubs[codedeploy]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import codedeploy
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_codedeploy as codedeploy

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("codedeploy")
client: codedeploy.CodeDeployClient = boto3.client("codedeploy")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: codedeploy.CodeDeployClient = session.client("codedeploy")


# Waiters need type annotation on creation
deployment_successful_waiter: codedeploy.DeploymentSuccessfulWaiter = client.get_waiter("deployment_successful")

# Paginators need type annotation on creation
list_application_revisions_paginator: codedeploy.ListApplicationRevisionsPaginator = client.get_paginator("list_application_revisions")
list_applications_paginator: codedeploy.ListApplicationsPaginator = client.get_paginator("list_applications")
list_deployment_configs_paginator: codedeploy.ListDeploymentConfigsPaginator = client.get_paginator("list_deployment_configs")
list_deployment_groups_paginator: codedeploy.ListDeploymentGroupsPaginator = client.get_paginator("list_deployment_groups")
list_deployment_instances_paginator: codedeploy.ListDeploymentInstancesPaginator = client.get_paginator("list_deployment_instances")
list_deployment_targets_paginator: codedeploy.ListDeploymentTargetsPaginator = client.get_paginator("list_deployment_targets")
list_deployments_paginator: codedeploy.ListDeploymentsPaginator = client.get_paginator("list_deployments")
list_git_hub_account_token_names_paginator: codedeploy.ListGitHubAccountTokenNamesPaginator = client.get_paginator("list_git_hub_account_token_names")
list_on_premises_instances_paginator: codedeploy.ListOnPremisesInstancesPaginator = client.get_paginator("list_on_premises_instances")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.