import sys
from typing import (
    Any,
    AnyStr,
    Callable,
    Container,
    Generic,
    Iterable,
    Mapping,
    MutableMapping,
    MutableSequence,
    Sequence,
    SupportsAbs,
    Tuple,
    TypeVar,
    overload,
)
from typing_extensions import ParamSpec, SupportsIndex, final

_R = TypeVar("_R")
_T = TypeVar("_T")
_T_co = TypeVar("_T_co", covariant=True)
_K = TypeVar("_K")
_V = TypeVar("_V")
_P = ParamSpec("_P")

def lt(__a: Any, __b: Any) -> Any: ...
def le(__a: Any, __b: Any) -> Any: ...
def eq(__a: Any, __b: Any) -> Any: ...
def ne(__a: Any, __b: Any) -> Any: ...
def ge(__a: Any, __b: Any) -> Any: ...
def gt(__a: Any, __b: Any) -> Any: ...
def not_(__a: Any) -> bool: ...
def truth(__a: Any) -> bool: ...
def is_(__a: Any, __b: Any) -> bool: ...
def is_not(__a: Any, __b: Any) -> bool: ...
def abs(__a: SupportsAbs[_T]) -> _T: ...
def add(__a: Any, __b: Any) -> Any: ...
def and_(__a: Any, __b: Any) -> Any: ...
def floordiv(__a: Any, __b: Any) -> Any: ...
def index(__a: Any) -> int: ...
def inv(__a: Any) -> Any: ...
def invert(__a: Any) -> Any: ...
def lshift(__a: Any, __b: Any) -> Any: ...
def mod(__a: Any, __b: Any) -> Any: ...
def mul(__a: Any, __b: Any) -> Any: ...
def matmul(__a: Any, __b: Any) -> Any: ...
def neg(__a: Any) -> Any: ...
def or_(__a: Any, __b: Any) -> Any: ...
def pos(__a: Any) -> Any: ...
def pow(__a: Any, __b: Any) -> Any: ...
def rshift(__a: Any, __b: Any) -> Any: ...
def sub(__a: Any, __b: Any) -> Any: ...
def truediv(__a: Any, __b: Any) -> Any: ...
def xor(__a: Any, __b: Any) -> Any: ...
def concat(__a: Sequence[_T], __b: Sequence[_T]) -> Sequence[_T]: ...
def contains(__a: Container[Any], __b: Any) -> bool: ...
def countOf(__a: Iterable[Any], __b: Any) -> int: ...
@overload
def delitem(__a: MutableSequence[Any], __b: SupportsIndex) -> None: ...
@overload
def delitem(__a: MutableSequence[Any], __b: slice) -> None: ...
@overload
def delitem(__a: MutableMapping[_K, Any], __b: _K) -> None: ...
@overload
def getitem(__a: Sequence[_T], __b: SupportsIndex) -> _T: ...
@overload
def getitem(__a: Sequence[_T], __b: slice) -> Sequence[_T]: ...
@overload
def getitem(__a: Mapping[_K, _V], __b: _K) -> _V: ...
def indexOf(__a: Iterable[_T], __b: _T) -> int: ...
@overload
def setitem(__a: MutableSequence[_T], __b: SupportsIndex, __c: _T) -> None: ...
@overload
def setitem(__a: MutableSequence[_T], __b: slice, __c: Sequence[_T]) -> None: ...
@overload
def setitem(__a: MutableMapping[_K, _V], __b: _K, __c: _V) -> None: ...
def length_hint(__obj: Any, __default: int = ...) -> int: ...
@final
class attrgetter(Generic[_T_co]):
    @overload
    def __new__(cls, attr: str) -> attrgetter[Any]: ...
    @overload
    def __new__(cls, attr: str, __attr2: str) -> attrgetter[tuple[Any, Any]]: ...
    @overload
    def __new__(cls, attr: str, __attr2: str, __attr3: str) -> attrgetter[tuple[Any, Any, Any]]: ...
    @overload
    def __new__(cls, attr: str, __attr2: str, __attr3: str, __attr4: str) -> attrgetter[tuple[Any, Any, Any, Any]]: ...
    @overload
    def __new__(cls, attr: str, *attrs: str) -> attrgetter[Tuple[Any, ...]]: ...
    def __call__(self, obj: Any) -> _T_co: ...

@final
class itemgetter(Generic[_T_co]):
    @overload
    def __new__(cls, item: Any) -> itemgetter[Any]: ...
    @overload
    def __new__(cls, item: Any, __item2: Any) -> itemgetter[tuple[Any, Any]]: ...
    @overload
    def __new__(cls, item: Any, __item2: Any, __item3: Any) -> itemgetter[tuple[Any, Any, Any]]: ...
    @overload
    def __new__(cls, item: Any, __item2: Any, __item3: Any, __item4: Any) -> itemgetter[tuple[Any, Any, Any, Any]]: ...
    @overload
    def __new__(cls, item: Any, *items: Any) -> itemgetter[Tuple[Any, ...]]: ...
    def __call__(self, obj: Any) -> _T_co: ...

@final
class methodcaller:
    def __init__(self, __name: str, *args: Any, **kwargs: Any) -> None: ...
    def __call__(self, obj: Any) -> Any: ...

def iadd(__a: Any, __b: Any) -> Any: ...
def iand(__a: Any, __b: Any) -> Any: ...
def iconcat(__a: Any, __b: Any) -> Any: ...
def ifloordiv(__a: Any, __b: Any) -> Any: ...
def ilshift(__a: Any, __b: Any) -> Any: ...
def imod(__a: Any, __b: Any) -> Any: ...
def imul(__a: Any, __b: Any) -> Any: ...
def imatmul(__a: Any, __b: Any) -> Any: ...
def ior(__a: Any, __b: Any) -> Any: ...
def ipow(__a: Any, __b: Any) -> Any: ...
def irshift(__a: Any, __b: Any) -> Any: ...
def isub(__a: Any, __b: Any) -> Any: ...
def itruediv(__a: Any, __b: Any) -> Any: ...
def ixor(__a: Any, __b: Any) -> Any: ...

if sys.version_info >= (3, 11):
    def call(__obj: Callable[_P, _R], *args: _P.args, **kwargs: _P.kwargs) -> _R: ...  # type: ignore

def _compare_digest(__a: AnyStr, __b: AnyStr) -> bool: ...
