"""
    NLP Sandbox Data Node API

    # Overview  The NLP Sandbox Data Node is a repository of data used to benchmark NLP Tools like the NLP Sandbox Date Annotator and Person Name Annotator.  The resources that can be stored in this Data Node and the operations supported are listed below:  - Create and manage datasets - Create and manage FHIR stores   - Store and retrieve FHIR patient profiles   - Store and retrieve clinical   notes - Create and manage annotation stores   - Store and retrieve text annotations   # noqa: E501

    The version of the OpenAPI document: 1.0.2
    Contact: thomas.schaffter@sagebionetworks.org
    Generated by: https://openapi-generator.tech
"""


import unittest
from unittest.mock import patch

import nlpsandbox
from nlpsandbox.api.note_api import NoteApi  # noqa: E501


class TestNoteApi(unittest.TestCase):
    """NoteApi unit test stubs"""

    def setUp(self):
        self.api = NoteApi()  # noqa: E501
        self.patcher = patch('nlpsandbox.api_client.ApiClient.call_api')
        self.mock_foo = self.patcher.start()

    def tearDown(self):
        self.patcher.stop()

    def test_create_note(self):
        """Test case for create_note

        Create a note  # noqa: E501
        """
        self.api.create_note(
            dataset_id="awesome-dataset",
            fhir_store_id="awesome-fhir-store",
            note_id="awesome-note",
            note_create_request={
                "text": "texting foo",
                "type": "loinc:LP29684-5",
                "patient_id": "awesome-patient"
            }
        )

    def test_delete_note(self):
        """Test case for delete_note

        Delete a note  # noqa: E501
        """
        self.api.delete_note(
            dataset_id="awesome-dataset",
            fhir_store_id="awesome-fhir-store",
            note_id="awesome-note"
        )

    def test_get_note(self):
        """Test case for get_note

        Get a note  # noqa: E501
        """
        self.api.get_note(
            dataset_id="awesome-dataset",
            fhir_store_id="awesome-fhir-store",
            note_id="awesome-note"
        )

    def test_list_notes(self):
        """Test case for list_notes

        List notes  # noqa: E501
        """
        self.api.list_notes(
            dataset_id="awesome-dataset",
            fhir_store_id="awesome-fhir-store"
        )


if __name__ == '__main__':
    unittest.main()
