#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#  This source code is licensed under the MIT license. See LICENSE in the repository root directory.
#  Copyright (c) 2022. Metku team.
#  All rights reserved.
profiles = """
HEM100	dxf	120	106	12.0	20.0	12	41.8	0.619	5324	1804	4240	11.43	46.3	190.4	235.8	3.992	27.4	75.31	116.3	672.8	56.07	9430	3640	1251.05	244.71	575.27	44.75	55.42	17.70	27.33	b	c	1	1	1
HEM120	dxf	140	126	12.5	21.0	12	52.1	0.738	6641	2115	5292	20.18	55.1	288.2	350.6	7.028	32.5	111.6	171.6	905.3	72.42	23887	6477	1560.54	286.97	718.00	67.73	82.39	26.21	40.33	b	c	1	1	1
HEM140	dxf	160	146	13.0	22.0	12	63.2	0.857	8056	2446	6424	32.91	63.9	411.4	493.8	11.44	37.7	156.8	240.5	1186	91.23	52826	10620	1893.07	331.81	871.59	96.68	116.05	36.84	56.52	b	c	1	1	1
HEM160	dxf	180	166	14.0	23.0	15	76.2	0.970	9705	3081	7636	50.98	72.5	566.5	674.6	17.59	42.6	211.9	325.5	1608	114.9	104700	16290	2280.71	418.04	1036.03	133.12	158.52	49.80	76.48	b	c	1	1	1
HEM180	dxf	200	186	14.5	24.0	15	88.9	1.089	11325	3465	8928	74.83	81.3	748.3	883.4	25.80	47.7	277.4	425.2	2014	138.9	194300	24010	2661.41	470.14	1211.33	175.85	207.61	65.20	99.92	b	c	1	1	1
HEM200	dxf	220	206	15.0	25.0	18	103.1	1.203	13128	4103	10300	106.4	90.0	967.4	1135	36.51	52.7	354.5	543.2	2581	172.1	336870	33930	3085.11	556.70	1397.48	227.35	266.76	83.30	127.66	b	c	1	1	1
HEM220	dxf	240	226	15.5	26.0	18	117.3	1.322	14944	4531	11752	146.0	98.9	1217	1419	50.12	57.9	443.5	678.6	3136	202.3	559550	46750	3511.87	614.77	1594.48	286.01	333.57	104.23	159.46	b	c	1	1	1
HEM240	dxf	270	248	18.0	32.0	21	156.7	1.460	19959	6007	15872	242.9	110.3	1799	2117	81.53	63.9	657.5	1006	6272	348.4	1123500	76950	4690.26	814.95	2153.47	422.82	497.48	154.51	236.39	b	c	1	1	1
HEM260	dxf	290	268	18.0	32.5	24	172.4	1.575	21964	6689	17420	313.1	119.4	2159	2524	104.5	69.0	779.7	1192	7223	401.3	1684000	98650	5161.64	907.61	2363.50	507.39	593.05	183.24	280.23	b	c	1	1	1
HEM280	dxf	310	288	18.5	33.0	24	188.5	1.694	24016	7203	19008	395.5	128.3	2551	2966	131.6	74.0	914.1	1397	8094	437.5	2463000	124700	5643.86	977.28	2578.95	599.59	696.92	214.81	328.22	b	c	1	1	1
HEM300	dxf	340	310	21.0	39.0	27	237.9	1.832	30308	9053	24180	592.0	139.8	3482	4078	194.0	80.0	1252	1913	14150	673.8	4280100	185400	7122.33	1228.26	3280.68	818.37	958.25	294.18	449.60	b	c	1	1	1
HEM320	dxf	359	309	21.0	40.0	27	245.0	1.866	31205	9485	24720	681.3	147.8	3796	4435	197.1	79.5	1276	1951	15100	719.0	4890000	200400	7333.12	1286.87	3353.94	892.02	1042.23	299.79	458.42	b	c	1	1	1
HEM340	dxf	377	309	21.0	40.0	27	247.9	1.902	31583	9863	24720	763.7	155.5	4052	4718	197.1	79.0	1276	1953	15160	721.9	5463300	211800	7421.95	1338.16	3353.94	952.11	1108.63	299.81	458.89	a	b	1	1	1
HEM360	dxf	395	308	21.0	40.0	27	250.3	1.934	31881	10241	24640	848.7	163.2	4297	4989	195.2	78.3	1268	1942	15170	722.4	6009300	221800	7491.98	1389.44	3343.09	1009.81	1172.49	297.90	456.45	a	b	1	1	1
HEM400	dxf	432	307	21.0	40.0	27	255.7	2.004	32578	11018	24560	1041	178.8	4820	5571	193.4	77.0	1260	1934	15240	725.7	7268800	243500	7655.78	1494.86	3332.23	1132.78	1309.10	296.02	454.52	a	b	1	1	1
HEM450	dxf	478	307	21.0	40.0	27	263.3	2.096	33544	11984	24560	1315	198.0	5501	6331	193.4	75.9	1260	1939	15380	732.4	9092300	272400	7882.79	1625.93	3332.23	1292.84	1487.79	296.07	455.71	a	b	1	1	1
HEM500	dxf	524	306	21.0	40.0	27	270.3	2.184	34430	12950	24480	1619	216.9	6180	7094	191.5	74.6	1252	1932	15480	737.1	11012000	299300	8091.00	1756.99	3321.38	1452.42	1667.15	294.21	454.02	a	b	1	1	1
HEM550	dxf	572	306	21.0	40.0	27	278.2	2.280	35438	13958	24480	1980	236.4	6923	7933	191.6	73.5	1252	1937	15630	744.3	13323000	329300	8327.88	1893.75	3321.38	1626.79	1864.18	294.26	455.27	a	b	1	1	1
HEM600	dxf	620	305	21.0	40.0	27	285.5	2.372	36366	14966	24400	2374	255.5	7660	8772	189.8	72.2	1244	1930	15740	749.5	15700000	357000	8545.96	2030.52	3310.53	1800.01	2061.44	292.41	453.64	a	b	1	1	1
HEM650	dxf	668	305	21.0	40.0	27	293.4	2.468	37374	15974	24400	2817	274.5	8433	9657	189.8	71.3	1245	1936	15880	756.2	18427000	386800	8782.84	2167.28	3310.53	1981.79	2269.39	292.47	454.88	a	b	1	1	1
HEM700	dxf	716	304	21.0	40.0	27	300.7	2.560	38302	16982	24320	3293	293.2	9198	10540	188.0	70.1	1237	1929	15990	761.4	21161000	413800	9000.92	2304.04	3299.67	2161.46	2476.66	290.62	453.26	a	b	1	1	1
HEM800	dxf	814	303	21.0	40.0	30	317.3	2.746	40427	19427	24240	4426	330.9	10870	12490	186.3	67.9	1230	1930	16630	791.9	27472000	470800	9500.24	2635.74	3288.82	2555.54	2934.61	288.94	453.64	a	b	1	1	1
HEM900	dxf	910	302	21.0	40.0	30	332.5	2.934	42363	21443	24160	5704	367.0	12540	14440	184.5	66.0	1222	1929	16890	804.3	34419000	526200	9955.20	2909.27	3277.96	2946.20	3393.81	287.16	453.29	a	b	1	2	1
HEM1000	dxf	1008	302	21.0	40.0	30	348.7	3.130	44421	23501	24160	7223	403.2	14330	16570	184.6	64.5	1222	1940	17190	818.6	42665000	586000	10438.83	3188.49	3277.96	3367.86	3893.47	287.28	455.83	a	b	1	3	1"""
for prof in profiles.split("\n"):
    if len(prof):
        prof = prof.split("\t")
        name, _, h, b, tw, tf, r = prof[:7]
        print(f"{name}: ISection = ISection(name=\"{name}\","
              f" h={float(h)},"
              f" b={float(b)},"
              f" tw={float(tw)},"
              f"tf={float(tf)},"
              f"r={float(r)})")
