# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pypette']

package_data = \
{'': ['*']}

install_requires = \
['Sphinx>=4.1.2,<5.0.0',
 'crayons>=0.4.0,<0.5.0',
 'sphinx-autobuild>=2021.3.14,<2022.0.0']

setup_kwargs = {
    'name': 'pypette',
    'version': '0.0.11',
    'description': 'pypette (to be read as pipette) is a module which makes building pipelines ridiculously simple, allowing users to control the flow with minimal instructions.',
    'long_description': '|Logo|\n\n|pypiv| |pyv| |Build| |Licence|\n\n--------------\n\npypette (to be read as pipette) is a module which makes building pipelines\nridiculously simple, allowing users to control the flow with minimal\ninstructions.\n\nFeatures\n--------\n\n* Ridiculously simple interface.\n* Ability to view pipeline structure within the comfort of a terminal.\n* Run pipeline in exception resilient way if needed.\n* Create dependencies on pipelines easily.\n* Generate a easy to view/understand report within the comfort of a terminal.\n\nSetup\n-----\n\nUsing pip\n~~~~~~~~~\n\n.. code:: bash\n\n    pip install pypette\n\nDirectly from the repository\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n.. code:: bash\n\n    git clone https://github.com/csurfer/pypette.git\n    python pypette/setup.py install\n\nDocumentation\n--------------\n\nDetailed documentation can be found at https://csurfer.github.io/pypette\n\nStructures\n----------\n\nJob\n~~~\n\nThe basic unit of execution, say a python method or a callable.\n\n.. code:: python\n\n    from pypette import Job\n\n    def print_hello():\n        print("Hello!")\n\n    def print_hello_msg(msg):\n        print("Hello " + msg + "!")\n\n    # Job without arguments\n    j1 = Job(print_hello)\n\n    # Job with arguments specified as argument list\n    j2 = Job(print_hello_msg, args=("pypette is simple",))\n\n    # Job with arguments specified as key word arguments\n    j3 = Job(print_hello_msg, kwargs={"msg":"pypette is simple"})\n\nBashJob\n~~~~~~~\n\nThe basic unit of execution, which runs a bash command.\n\n.. code:: python\n\n    from pypette import BashJob\n\n    # Job with bash commands\n    b1 = BashJob([\'ls\', \'-l\'])\n    b2 = BashJob([\'pwd\'])\n\nPipe\n~~~~\n\nStructure to specify the flow in which the jobs need to be executed. The whole\ninterface consists of only 4 methods.\n\n.. code:: python\n\n    from pypette import Pipe\n\n    # 1. Create a new Pipe\n    p = Pipe(\'TestPipe\')\n\n    # 2. Add jobs to execute. (Assuming job_list is a list of python/bash jobs)\n\n    # To run the jobs in job_list in order one after the other where each job\n    # waits for the job before it to finish.\n    p.add_jobs(job_list)\n\n    # To run the jobs in job_list parallelly and run the next step only after\n    # all jobs in job list finish.\n    p.add_jobs(job_list, run_in_parallel=True)\n\n    # Add jobs in a builder format.\n    p.add_stage(job1).add_stage(job2) # To add jobs in series.\n    p.add_stage(job1, job2) # To add jobs in parallel.\n\nBuilding complex pipelines\n~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nJobs submitted to pipeline should be callables i.e. structures which can be\nrun. This means python methods, lambdas etc qualify.\n\nWhat about Pipe itself?\n\nOf course, it is a callable and you can submit a pipe object to be run along\nwith regular jobs. This way you can build small pipelines which achieve a\nspecific task and then combine them to create more complex pipelines.\n\n.. code:: python\n\n    from pypette import BashJob, Job, Pipe\n\n    def welcome():\n        print("Welcome user!")\n\n    def havefun():\n        print("Have fun!")\n\n    def goodbye():\n        print("Goodbye!")\n\n    # Build a simple pipeline\n    p1 = Pipe(\'Fun\')\n    p1.add_jobs([\n        Job(havefun),\n    ])\n\n    # Include simple pipeline into a complicated pipeline\n    p2 = Pipe(\'Overall\')\n    p2.add_jobs([\n        Job(welcome),\n        p1,\n        Job(goodbye),\n        BashJob([\'ls\', \'-l\']),\n        BashJob([\'pwd\'])\n    ])\n\n    p2.run() # This first runs welcome, then runs p1 pipeline then runs goodbye.\n\nExample pipeline\n~~~~~~~~~~~~~~~~\n\nAn example pipeline and its code are included in `examples`_ folder.\n\nVisualizing the pipeline using graph()\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nPipeline objects have a method called ``graph()`` which helps visualize the\npipeline within the comfort of your terminal. The graph is recursive in nature\nand it visualizes everything that will be run if we call ``run()`` on the pipe\nobject.\n\nVisualizing the top-level pipeline in `examples/basic.py`_ led to the\nfollowing visualization.\n\n|Viz|\n\nRunning the entire pipeline.\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nThe only thing you need to do at this point to run the entire pipeline is to\ncall ``run()`` on your pipeline object.\n\nReporting the entire pipeline.\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nThe only thing you need to do at this point to get the report of entire\npipeline is to call `report()` on your pipeline object.\n\nContributing\n------------\n\nBug Reports and Feature Requests\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nPlease use `issue tracker`_ for reporting bugs or feature requests.\n\nDevelopment\n~~~~~~~~~~~\n\nPull requests are most welcome. Kindly follow the steps suggested below:\n\n1. Checkout the repository.\n2. Make your changes and add/update relavent tests.\n3. Install **`poetry`** using **`pip install poetry`**.\n4. Run **`poetry install`** to create project\'s virtual environment.\n5. Run tests using **`poetry run tox`** (Any python versions which you don\'t have checked out will fail this). Fix failing tests and repeat.\n6. Make documentation changes that are relavant.\n7. Install **`pre-commit`** using **`pip install pre-commit`** and run **`pre-commit run --all-files`** to do lint checks.\n8. Generate documentation using **`poetry run sphinx-build -b html docs/ docs/_build/html`**.\n9. Generate **`requirements.txt`** for automated testing using **`poetry export --dev --without-hashes -f requirements.txt > requirements.txt`**.\n10. Commit the changes and raise a pull request.\n\n\nBuy the developer a cup of coffee!\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\nIf you found the utility helpful you can buy me a cup of coffee using\n\n|Donate|\n\n.. |Logo| image:: https://i.imgur.com/MBu5x0h.png\n   :width: 60%\n   :target: https://pypi.python.org/pypi/pypette\n\n.. |Donate| image:: https://www.paypalobjects.com/webstatic/en_US/i/btn/png/silver-pill-paypal-44px.png\n   :target: https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=3BSBW7D45C4YN&lc=US&currency_code=USD&bn=PP%2dDonationsBF%3abtn_donate_SM%2egif%3aNonHosted\n\n.. _issue tracker: https://github.com/csurfer/pypette/issues\n.. _examples/basic.py: https://github.com/csurfer/pypette/examples/basic.py\n.. _examples: https://github.com/csurfer/pypette/examples\n\n.. |Viz| image:: https://i.imgur.com/1PaPlD3.png\n   :width: 200px\n\n.. |Licence| image:: https://img.shields.io/badge/license-MIT-blue.svg\n   :target: https://raw.githubusercontent.com/csurfer/pypette/master/LICENSE\n\n.. |Build| image:: https://github.com/csurfer/pypette/actions/workflows/pytest.yml/badge.svg?branch=master\n   :target: https://github.com/csurfer/pypette/actions/workflows/pytest.yml/badge.svg?branch=master\n\n.. |pypiv| image:: https://img.shields.io/pypi/v/pypette.svg\n   :target: https://pypi.python.org/pypi/pypette\n\n.. |pyv| image:: https://img.shields.io/pypi/pyversions/pypette.svg\n   :target: https://pypi.python.org/pypi/pypette\n',
    'author': 'csurfer',
    'author_email': 'sharma.vishwas88@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://csurfer.github.io/pypette',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
